/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.client;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.util.CryptoUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.toolset.bean.EASTool;
import com.kingdee.eas.toolset.bean.FileBean;
import com.kingdee.eas.toolset.bean.ServerPlugin;
import com.kingdee.eas.toolset.bean.ToolBean;
import com.kingdee.eas.toolset.bean.ToolFilterBean;
import com.kingdee.eas.toolset.bean.ToolList;
import com.kingdee.eas.toolset.client.DetailInfoUI;
import com.kingdee.eas.toolset.client.IToolsetUI;
import com.kingdee.eas.toolset.util.BackgroundPanel;
import com.kingdee.eas.toolset.util.ClassUtil;
import com.kingdee.eas.toolset.util.ETSCloudUtil;
import com.kingdee.eas.toolset.util.ETSContext;
import com.kingdee.eas.toolset.util.ETSUtil;
import com.kingdee.eas.toolset.util.EncodeUtil;
import com.kingdee.eas.toolset.util.FileUtil;
import com.kingdee.eas.toolset.util.FrameUtil;
import com.kingdee.eas.toolset.util.HttpUtil;
import com.kingdee.eas.toolset.util.MapDBUtil;
import com.kingdee.eas.toolset.util.ResourceUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class UIHelper {
    private static ImageIcon infoIcon = ResourceUtil.getImageRes(String.valueOf(ETSContext.getETSHome()) + "/images/", "info.png");
    private static ImageIcon installIcon = ResourceUtil.getImageRes(String.valueOf(ETSContext.getETSHome()) + "/images/", "install.png");
    private static ImageIcon launchIcon = ResourceUtil.getImageRes(String.valueOf(ETSContext.getETSHome()) + "/images/", "launch.png");
    private static ImageIcon uninstallIcon = ResourceUtil.getImageRes(String.valueOf(ETSContext.getETSHome()) + "/images/", "uninstall.png");
    private static ImageIcon commentIcon = ResourceUtil.getImageRes(String.valueOf(ETSContext.getETSHome()) + "/images/", "comment.png");
    private static ImageIcon addFavIcon = ResourceUtil.getImageRes(String.valueOf(ETSContext.getETSHome()) + "/images/", "addfav.png");
    private static ImageIcon deleteIcon = ResourceUtil.getImageRes(String.valueOf(ETSContext.getETSHome()) + "/images/", "delete.png");
    private static GridBagLayout layout = new GridBagLayout();
    private static GridBagConstraints gc = new GridBagConstraints();

    public static void getShortcuts(final IToolsetUI ui, final ToolFilterBean filter) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                UIHelper.getShortcutsFromDB(ui, filter);
            }
        });
        t.start();
    }

    private static synchronized void getShortcutsFromDB(final IToolsetUI ui, ToolFilterBean filter) {
        ui.getPanelDown().removeAll();
        ui.getPanelDown().add(ui.getBtnAdd());
        ArrayList list = MapDBUtil.getInstalledTools(filter);
        if (list != null && list.size() > 0) {
            Dimension innerPanelSize = new Dimension(105, 105);
            Dimension iconPanelSize = new Dimension(75, 75);
            Dimension underTextPanelSize = new Dimension(105, 26);
            Dimension nameSize = new Dimension(105, 25);
            int i = 0;
            while (i < list.size()) {
                final KDPanel innerPanel = new KDPanel((LayoutManager)new BorderLayout());
                innerPanel.setPreferredSize(innerPanelSize);
                final ToolBean tool = (ToolBean)list.get(i);
                innerPanel.setName(tool.getName());
                innerPanel.setBorder((Border)BorderFactory.createTitledBorder(""));
                String iconPath = String.valueOf(ETSContext.getETSHome()) + "/tools/" + tool.getNumber() + "/icon.png";
                File f = new File(iconPath);
                ImageIcon img = null;
                img = !f.exists() ? ResourceUtil.getImageRes(String.valueOf(ETSContext.getETSHome()) + "/images/", "defaulticon.png") : new ImageIcon(iconPath);
                JButton iconPanel = new JButton();
                if (img != null) {
                    iconPanel.setIcon(img);
                }
                iconPanel.setPreferredSize(iconPanelSize);
                iconPanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder()));
                innerPanel.add((Component)iconPanel, (Object)"Center");
                KDLabel NameLabel = new KDLabel(tool.getName());
                NameLabel.setHorizontalAlignment(0);
                NameLabel.setFont(new Font("Microsoft YaHei", 1, 13));
                NameLabel.setPreferredSize(nameSize);
                KDPanel underTextPanel = new KDPanel((LayoutManager)new BorderLayout());
                underTextPanel.add((Component)NameLabel, (Object)"Center");
                underTextPanel.setPreferredSize(underTextPanelSize);
                innerPanel.add((Component)underTextPanel, (Object)"South");
                ui.getPanelDown().add((Component)innerPanel);
                iconPanel.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        UIHelper.launchTool(ui, tool);
                    }
                });
                final KDPopupMenu menu = new KDPopupMenu();
                MouseAdapter ml = new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if (e.getButton() == 3) {
                            menu.show((Component)innerPanel, 90, 5);
                        }
                    }
                };
                NameLabel.addMouseListener((MouseListener)ml);
                iconPanel.addMouseListener(ml);
                innerPanel.addMouseListener((MouseListener)ml);
                KDMenuItem item = new KDMenuItem("\u8fd0\u884c");
                item.setIcon((Icon)launchIcon);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        UIHelper.launchTool(ui, tool);
                    }
                });
                menu.add((JMenuItem)item);
                item = new KDMenuItem("\u6dfb\u52a0\u5e38\u7528");
                item.setIcon((Icon)addFavIcon);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        boolean b = MapDBUtil.addFavTool(tool);
                        if (b) {
                            ui.refreshFavTools();
                        }
                    }
                });
                menu.add((JMenuItem)item);
                item = new KDMenuItem("\u5de5\u5177\u4fe1\u606f");
                item.setIcon((Icon)commentIcon);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        DetailInfoUI.init(ui, tool, 1);
                    }
                });
                menu.add((JMenuItem)item);
                item = new KDMenuItem("\u5378\u8f7d");
                item.setIcon((Icon)uninstallIcon);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        int n = JOptionPane.showConfirmDialog(null, "\u786e\u8ba4\u5378\u8f7d\uff1f", "\u786e\u8ba4\u4fe1\u606f", 0, 1);
                        if (n == 0) {
                            UIHelper.uninstallTool(tool.getNumber(), tool.getName());
                            ui.removeLaunchedTool(tool.getNumber());
                            ui.refreshFavTools();
                            ui.getPanelDown().remove((Component)innerPanel);
                            ui.getPanelDown().updateUI();
                        }
                    }
                });
                menu.add((JMenuItem)item);
                ++i;
            }
        }
        int cnt = ui.getPanelDown().getComponentCount();
        int col = ui.getPanelDown().getSize().width / 120;
        cnt = (int)Math.ceil((double)cnt / (double)col);
        int cmpHeight = cnt * 105;
        int space = (cnt + 1) * 15;
        ui.getPanelDown().setPreferredSize(new Dimension(670, cmpHeight + space));
        ui.getPanelDown().updateUI();
    }

    public static void launchTool(IToolsetUI ui, ToolBean tool) {
        String url = tool.getUrl();
        if (url != null && url.trim().length() > 0) {
            Desktop dtp = Desktop.getDesktop();
            try {
                if (Desktop.isDesktopSupported() && dtp.isSupported(Desktop.Action.BROWSE)) {
                    URI uri = new URI(url.trim());
                    dtp.browse(uri);
                } else {
                    KDOptionPane.showMessageDialog((Component)((Component)((Object)ui)), (Object)"\u65e0\u6cd5\u8c03\u7528\u64cd\u4f5c\u7cfb\u7edf\u6d4f\u89c8\u5668\u7ec4\u4ef6");
                }
            }
            catch (Exception e) {
                KDOptionPane.showMessageDialog((Component)((Component)((Object)ui)), (Object)"\u8c03\u7528\u64cd\u4f5c\u7cfb\u7edf\u6d4f\u89c8\u5668\u7ec4\u4ef6\u5931\u8d25");
                e.printStackTrace();
            }
            return;
        }
        if ("1".equals(tool.getLicenseType()) && !ETSUtil.isOnService()) {
            KDOptionPane.showMessageDialog((Component)((Component)((Object)ui)), (Object)"\u6b64\u5de5\u5177\u9700\u5904\u4e8eEAS\u6807\u51c6\u670d\u52a1\u671f\u5185\u65b9\u53ef\u4f7f\u7528");
            return;
        }
        boolean isCache = false;
        try {
            EASTool t = ui.getLaunchedTool(tool.getNumber());
            if (t != null) {
                isCache = true;
            } else {
                if (tool.getServerPlugins() != null) {
                    UIHelper.uploadServerPlugins(tool);
                } else {
                    System.out.println(String.valueOf(tool.getNumber()) + "\u65e0\u63d2\u4ef6\u5217\u8868");
                }
                t = ClassUtil.getEASToolInstanceDyn(tool);
                if (t == null) {
                    ETSUtil.userBehaviorLog(tool.getNumber(), tool.getName(), "\u542f\u52a8", "\u5931\u8d25", "\u521d\u59cb\u5316\u5165\u53e3\u7c7b\u5931\u8d25");
                    JOptionPane.showMessageDialog((Component)((Object)ui), "\u5de5\u5177\u521d\u59cb\u5316\u5931\u8d25\uff0c\u65e0\u6cd5\u542f\u52a8");
                    return;
                }
                if (t.getTitle() == null || t.getTitle().isEmpty()) {
                    t.setTitle(tool.getName());
                }
                if (t.getNumber() == null) {
                    t.setNumber(tool.getNumber());
                }
                if (t.needCache()) {
                    ui.addLaunchedTool(t);
                }
                FrameUtil.onCenter((Component)t);
            }
            if (t.needAdminAccess() && !t.isAdminAccess()) {
                UserInfo userInfo = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
                JPasswordField pwd = new JPasswordField();
                Object[] message = new Object[]{"\u8bf7\u8f93\u5165administrator\u5bc6\u7801", pwd};
                int res = JOptionPane.showConfirmDialog((Component)((Object)ui), message, " ", 2, 3);
                if (res != 0) {
                    return;
                }
                String logonPassword = new String(pwd.getPassword());
                if (UIHelper.matchPassword(userInfo, logonPassword)) {
                    t.setAdminAccess(true);
                }
            }
            if (!t.needAdminAccess() || t.isAdminAccess()) {
                if (isCache) {
                    t.setState(0);
                } else {
                    MapDBUtil.updateToolUsageTimes(tool.getNumber());
                    ETSUtil.userBehaviorLog(tool.getNumber(), tool.getName(), "\u542f\u52a8", null, null);
                }
                t.setVisible(true);
            }
        }
        catch (RPCException e) {
            if (e.getMessage() != null && e.getMessage().indexOf("Cannot found session info") >= 0) {
                try {
                    SystemEntry.instance.innerReLogin();
                    JOptionPane.showMessageDialog((Component)((Object)ui), "\u4f1a\u8bdd\u5931\u6548\uff0c\u5df2\u81ea\u52a8\u91cd\u8fde\uff01");
                }
                catch (Exception ee) {
                    JOptionPane.showMessageDialog((Component)((Object)ui), "\u4f1a\u8bdd\u5931\u6548\uff0c\u5c1d\u8bd5\u91cd\u8fde\u5931\u8d25\uff01");
                }
            } else {
                JOptionPane.showMessageDialog((Component)((Object)ui), "\u542f\u52a8\u5931\u8d25:" + e.getMessage());
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            ETSUtil.userBehaviorLog(tool.getNumber(), tool.getName(), "\u542f\u52a8", "\u5931\u8d25", e.getMessage());
            JOptionPane.showMessageDialog((Component)((Object)ui), "\u542f\u52a8\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
        }
    }

    private static boolean matchPassword(UserInfo userInfo, String password) throws Exception {
        if (StringUtils.isEmpty((String)password)) {
            return StringUtils.isEmpty((String)userInfo.getPassword());
        }
        return UIHelper.encrypt(userInfo.getId().toString(), password).equals(userInfo.getPassword());
    }

    private static String encrypt(String userID, String password) throws Exception {
        return CryptoUtil.encrypt((String)(String.valueOf(userID) + password.trim()));
    }

    private static void uploadServerPlugins(ToolBean tool) {
        String toolNumber = tool.getNumber();
        String path = String.valueOf(ETSUtil.getToolPath(toolNumber)) + "/serverPlugin";
        List serverPlugins = tool.getServerPlugins();
        if (serverPlugins != null && serverPlugins.size() > 0) {
            List lst = ETSUtil.getFileInfoList("/server/eastoolset/lib/", true);
            HashMap<String, String> map = null;
            if (lst != null && lst.size() > 0) {
                map = new HashMap<String, String>();
                int i = 0;
                while (i < lst.size()) {
                    FileBean fb = (FileBean)lst.get(i);
                    if (!fb.isDir()) {
                        map.put(fb.getName(), fb.getMd5());
                    }
                    ++i;
                }
            }
            System.out.println("\u63d2\u4ef6\u5904\u7406:" + tool.getNumber());
            HashMap<String, File> fileMap = new HashMap<String, File>();
            int i = 0;
            while (i < serverPlugins.size()) {
                ServerPlugin serverPlugin = (ServerPlugin)serverPlugins.get(i);
                File f = new File(String.valueOf(path) + "/" + serverPlugin.getName());
                if (!f.exists()) {
                    System.out.println("\u63d2\u4ef6\u4e0d\u5b58\u5728:" + f.getName());
                } else {
                    String md5 = DigestUtils.md5Hex((byte[])FileUtil.fileToByte(f));
                    if (!md5.equals(serverPlugin.getMd5())) {
                        System.out.println("\u975e\u6cd5\u63d2\u4ef6:" + f.getName());
                    } else {
                        boolean needUpload = false;
                        if (map == null || map.get(f.getName()) == null) {
                            needUpload = true;
                        } else {
                            String m5 = (String)map.get(f.getName());
                            if (!md5.equals(m5)) {
                                needUpload = true;
                            } else {
                                System.out.println("\u670d\u52a1\u7aef\u63d2\u4ef6\u5df2\u5b58\u5728:" + f.getName());
                            }
                        }
                        if (needUpload) {
                            fileMap.put(String.valueOf(f.getName()) + "@/server/eastoolset/lib/", f);
                        }
                    }
                }
                ++i;
            }
            if (fileMap.size() > 0) {
                boolean b = ETSUtil.uploadToEASServer(fileMap);
                if (!b) {
                    System.out.println("\u4e0a\u4f20\u63d2\u4ef6\u5931\u8d25:" + fileMap);
                }
            } else {
                System.out.println("\u65e0\u9700\u4e0a\u4f20");
            }
        }
    }

    private static void uploadServerPluginsForDev(ToolBean tool) {
        File[] listFiles;
        String toolNumber = tool.getNumber();
        String path = String.valueOf(ETSUtil.getToolPath(toolNumber)) + "/serverPlugin";
        List serverPlugins = tool.getServerPlugins();
        File f = new File(path);
        if (f.exists() && (listFiles = f.listFiles()) != null && listFiles.length > 0) {
            List lst = ETSUtil.getFileInfoList("/server/eastoolset/lib/", true);
            HashMap<String, String> map = null;
            if (lst != null && lst.size() > 0) {
                map = new HashMap<String, String>();
                int i = 0;
                while (i < lst.size()) {
                    FileBean fb = (FileBean)lst.get(i);
                    if (!fb.isDir()) {
                        map.put(fb.getName(), fb.getMd5());
                    }
                    ++i;
                }
            }
            System.out.println("\u63d2\u4ef6\u5904\u7406:" + tool.getNumber());
            HashMap<String, File> fileMap = new HashMap<String, File>();
            int i = 0;
            while (i < listFiles.length) {
                f = listFiles[i];
                if (!f.exists()) {
                    System.out.println("\u63d2\u4ef6\u4e0d\u5b58\u5728:" + f.getName());
                } else {
                    String md5 = DigestUtils.md5Hex((byte[])FileUtil.fileToByte(f));
                    boolean needUpload = false;
                    if (map == null || map.get(f.getName()) == null) {
                        needUpload = true;
                    } else {
                        String m5 = (String)map.get(f.getName());
                        if (!md5.equals(m5)) {
                            needUpload = true;
                        } else {
                            System.out.println("\u670d\u52a1\u7aef\u63d2\u4ef6\u5df2\u5b58\u5728:" + f.getName());
                        }
                    }
                    if (needUpload) {
                        fileMap.put(String.valueOf(f.getName()) + "@/server/eastoolset/lib/", f);
                    }
                }
                ++i;
            }
            if (fileMap.size() > 0) {
                boolean b = ETSUtil.uploadToEASServer(fileMap);
                if (!b) {
                    System.out.println("\u4e0a\u4f20\u63d2\u4ef6\u5931\u8d25:" + fileMap);
                }
            } else {
                System.out.println("\u65e0\u9700\u4e0a\u4f20");
            }
        }
    }

    public static void getToolList(final IToolsetUI ui, final ToolFilterBean filter) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                UIHelper.getToolListFromCloud(ui, filter);
            }
        });
        t.start();
    }

    private static synchronized void getToolListFromCloud(final IToolsetUI ui, ToolFilterBean filter) {
        ui.getPanelCloud().removeAll();
        Object[] numbers = MapDBUtil.getInstalledToolNumbers();
        StringBuffer params = new StringBuffer();
        if (numbers != null && numbers.length > 0) {
            int i = 0;
            while (i < numbers.length) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(numbers[i]);
                params.append("'");
                ++i;
            }
        }
        if (params.length() > 0) {
            filter.setInstalledNumbers(params.toString());
        }
        filter.setPlatVersion(ETSContext.getPlatVersion());
        ToolList lst = (ToolList)ETSUtil.getToolListFromCloud(filter);
        if (lst == null || lst.size() == 0) {
            ui.getPanelCloud().updateUI();
            return;
        }
        ui.setTotalPage(lst.getTotalPage());
        ui.setCurPage(lst.getCurPage());
        ui.setPageInfo(lst.getPageSize(), lst.getTotalCount());
        if (lst != null && lst.size() > 0) {
            Dimension innerPanelSize = new Dimension(150, 110);
            Dimension iconPanelSize = new Dimension(50, 50);
            Dimension textPanelSize = new Dimension(90, 60);
            Dimension underTextPanelSize = new Dimension(150, 28);
            Dimension nameSize = new Dimension(150, 24);
            Dimension btnSize = new Dimension(25, 25);
            GridBagConstraints cs = new GridBagConstraints();
            int i = 0;
            while (i < lst.size()) {
                ImageIcon img;
                final KDPanel innerPanel = new KDPanel((LayoutManager)new BorderLayout());
                innerPanel.setPreferredSize(innerPanelSize);
                final ToolBean tool = (ToolBean)lst.get(i);
                innerPanel.setName(tool.getName());
                innerPanel.setBorder((Border)BorderFactory.createTitledBorder(""));
                Image image = null;
                if (tool.getIcon() != null) {
                    try {
                        byte[] data = HttpUtil.getImageBytes(tool.getIcon());
                        if (data != null) {
                            image = new ImageIcon(data).getImage();
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                if (image == null && (img = ResourceUtil.getImageRes(String.valueOf(ETSContext.getETSHome()) + "/images/", "defaulticon.png")) != null) {
                    image = img.getImage();
                }
                BackgroundPanel iconPanel = new BackgroundPanel(image);
                iconPanel.setPreferredSize(iconPanelSize);
                iconPanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder()));
                innerPanel.add((Component)((Object)iconPanel), (Object)"West");
                KDPanel textPanel = new KDPanel((LayoutManager)new GridLayout(2, 1));
                textPanel.setBorder((Border)new TitledBorder(BorderFactory.createEmptyBorder()));
                textPanel.setPreferredSize(textPanelSize);
                KDLabel NameLabel = new KDLabel(tool.getName());
                NameLabel.setHorizontalAlignment(0);
                NameLabel.setFont(new Font("Microsoft YaHei", 1, 13));
                NameLabel.setPreferredSize(nameSize);
                NameLabel.setBorder((Border)BorderFactory.createTitledBorder(""));
                innerPanel.add((Component)NameLabel, (Object)"North");
                KDLabel toolTypeLabel = new KDLabel("\u7c7b\u578b:" + UIHelper.getToolTypeAlias(tool.getToolGroup()));
                toolTypeLabel.setFont(NameLabel.getFont().deriveFont(1, 11.0f));
                toolTypeLabel.setForeground(Color.gray);
                KDLabel licenseTypeLabel = new KDLabel("\u8bb8\u53ef:" + UIHelper.getLicenseTypeAlias(tool.getLicenseType()));
                licenseTypeLabel.setFont(NameLabel.getFont().deriveFont(1, 11.0f));
                licenseTypeLabel.setForeground(Color.gray);
                textPanel.add((Component)toolTypeLabel);
                textPanel.add((Component)licenseTypeLabel);
                innerPanel.add((Component)textPanel, (Object)"East");
                KDPanel underTextPanel = new KDPanel((LayoutManager)layout);
                underTextPanel.setPreferredSize(underTextPanelSize);
                KDLabel downloadTimeLabel = new KDLabel("\u4e0b\u8f7d:" + Integer.toString(tool.getDownloadTimes()));
                downloadTimeLabel.setForeground(Color.blue);
                cs.gridx = 0;
                cs.gridy = 0;
                cs.gridwidth = 2;
                cs.fill = 2;
                cs.weightx = 0.6;
                cs.insets = new Insets(0, 2, 0, 2);
                underTextPanel.add((Component)downloadTimeLabel, (Object)cs);
                JButton btnInfoButton = new JButton();
                btnInfoButton.setPreferredSize(btnSize);
                if (infoIcon != null) {
                    btnInfoButton.setIcon(infoIcon);
                }
                cs.gridx = 2;
                cs.gridy = 0;
                cs.gridwidth = 1;
                cs.fill = 0;
                cs.weightx = 0.1;
                cs.insets = new Insets(0, 2, 0, 2);
                underTextPanel.add((Component)btnInfoButton, (Object)cs);
                btnInfoButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        DetailInfoUI.init(ui, tool, 0);
                    }
                });
                JButton btnInstallButton = new JButton();
                btnInstallButton.setPreferredSize(btnSize);
                if (installIcon != null) {
                    btnInstallButton.setIcon(installIcon);
                }
                cs.gridx = 3;
                cs.gridy = 0;
                cs.gridwidth = 1;
                cs.fill = 0;
                cs.weightx = 0.1;
                cs.insets = new Insets(0, 0, 0, 2);
                underTextPanel.add((Component)btnInstallButton, (Object)cs);
                btnInstallButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        String number = tool.getNumber();
                        try {
                            byte[] bytes;
                            String path = String.valueOf(ETSContext.getETSHome()) + "/tools/" + number;
                            File f = new File(path);
                            if (!f.exists()) {
                                f.mkdirs();
                            }
                            if (tool.getUrl() == null || tool.getUrl().trim().length() == 0) {
                                ETSUtil.downloadTool(number, tool.getMd5(), String.valueOf(ETSContext.getETSHome()) + "/installpacks/");
                                String installPack = String.valueOf(ETSContext.getETSHome()) + "/installpacks/" + number + ".zip";
                                boolean b = FileUtil.unzip(installPack, path);
                                FileUtil.deleteFile(installPack);
                                if (!b) {
                                    JOptionPane.showMessageDialog(ui.getPanelCloud(), "\u5b89\u88c5\u5931\u8d25");
                                    ETSUtil.userBehaviorLog(tool.getNumber(), tool.getName(), "\u5b89\u88c5", "\u5931\u8d25", null);
                                    return;
                                }
                            }
                            if (tool.getIcon() != null && (bytes = HttpUtil.getImageBytes(tool.getIcon())) != null) {
                                FileUtil.byteToFile(bytes, "icon.png", ETSUtil.getToolPath(number));
                            }
                            if (tool.getPicture() != null && (bytes = HttpUtil.getImageBytes(tool.getPicture())) != null) {
                                FileUtil.byteToFile(bytes, "image.jpg", ETSUtil.getToolPath(number));
                            }
                            JSONObject o = null;
                            try {
                                String s = FileUtil.loadStrFromFile(String.valueOf(path) + "/tool.info", false);
                                if (s != null) {
                                    s = EncodeUtil.decrypt(s);
                                    o = JSONObject.fromObject((Object)s);
                                    HashMap<String, Class<ServerPlugin>> classMap = new HashMap<String, Class<ServerPlugin>>();
                                    classMap.put("serverPlugins", ServerPlugin.class);
                                    ToolBean t = (ToolBean)JSONObject.toBean((JSONObject)o, ToolBean.class, classMap);
                                    MapDBUtil.addInstalledTool(t);
                                } else {
                                    MapDBUtil.addInstalledTool(tool);
                                }
                            }
                            catch (Exception ee) {
                                ee.printStackTrace();
                            }
                            JOptionPane.showMessageDialog(ui.getPanelCloud(), "\u5b89\u88c5\u6210\u529f");
                            ETSUtil.userBehaviorLog(number, tool.getName(), "\u5b89\u88c5", "\u6210\u529f", null);
                            ui.refreshInstalledTools();
                            ui.getPanelCloud().remove((Component)innerPanel);
                            ui.getPanelCloud().updateUI();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            ETSUtil.userBehaviorLog(tool.getNumber(), tool.getName(), "\u5b89\u88c5", "\u51fa\u9519", e1.getMessage());
                            JOptionPane.showMessageDialog(ui.getPanelCloud(), "\u5b89\u88c5\u51fa\u9519:" + e1.getMessage());
                        }
                    }
                });
                innerPanel.add((Component)underTextPanel, (Object)"South");
                ui.getPanelCloud().add((Component)innerPanel);
                ++i;
            }
        }
        int cnt = ui.getPanelCloud().getComponentCount();
        int col = ui.getPanelCloud().getSize().width / 165;
        cnt = (int)Math.ceil((double)cnt / (double)col);
        int cmpHeight = cnt * 110;
        int space = (cnt + 1) * 15;
        ui.getPanelCloud().setPreferredSize(new Dimension(0, cmpHeight + space));
        ui.getPanelCloud().updateUI();
    }

    public static void uninstallTool(String number, String name) {
        MapDBUtil.uninstallTool(number);
        String installPack = String.valueOf(ETSContext.getETSHome()) + "/installpacks/" + number + ".zip";
        FileUtil.deleteFile(installPack);
        FileUtil.deleteFile(ETSUtil.getToolPath(number));
        ETSUtil.userBehaviorLog(number, name, "\u5378\u8f7d", null, null);
    }

    public static String getTerritoryAlias(String territory) {
        if ("-1".equals(territory)) {
            return "\u4e0d\u9650";
        }
        if ("0".equals(territory)) {
            return "\u8d22\u52a1\u4f1a\u8ba1";
        }
        if ("1".equals(territory)) {
            return "\u4f9b\u5e94\u94fe";
        }
        if ("2".equals(territory)) {
            return "\u57fa\u7840\u6570\u636e";
        }
        if ("3".equals(territory)) {
            return "\u751f\u4ea7\u5236\u9020";
        }
        return null;
    }

    public static String getLicenseTypeAlias(String licenseType) {
        if ("0".equals(licenseType)) {
            return "\u65e0\u63a7\u5236";
        }
        if ("1".equals(licenseType)) {
            return "\u670d\u52a1\u671f\u53ef\u7528";
        }
        if ("2".equals(licenseType)) {
            return "\u72ec\u7acb\u8bb8\u53ef";
        }
        return "\u670d\u52a1\u671f\u53ef\u7528";
    }

    public static String getToolTypeAlias(String toolType) {
        if ("0".equals(toolType)) {
            return "\u7cfb\u7edf\u73af\u5883";
        }
        if ("1".equals(toolType)) {
            return "\u8f85\u52a9\u5de5\u5177";
        }
        if ("2".equals(toolType)) {
            return "\u6570\u636e\u5904\u7406";
        }
        if ("3".equals(toolType)) {
            return "\u670d\u52a1\u4ea7\u54c1";
        }
        return "\u672a\u77e5\u7c7b\u578b";
    }

    public static void doUpdate() {
        if (ETSContext.getClientNetworkMode() == 0) {
            return;
        }
        final KDDialog d = new KDDialog();
        d.setModal(true);
        d.setTitle("\u63d0\u793a");
        d.setResizable(false);
        final JLabel msgLabel = new JLabel("  \u6b63\u5728\u66f4\u65b0\u5e73\u53f0\uff0c\u8bf7\u7a0d\u5019...");
        d.add((Component)msgLabel);
        d.setDefaultCloseOperation(0);
        FrameUtil.onCenter((Component)d, 200, 100);
        Thread t = new Thread(new Runnable(){
            private KDTextPane txtChangeLog;

            public void run() {
                block25: {
                    if (!ETSContext.isUpdated()) {
                        try {
                            String version = ETSContext.getPlatVersion();
                            if (version != null && version.trim().length() > 0) {
                                String path = String.valueOf(ETSContext.getETSHome()) + "/config/";
                                String uiVersion = FileUtil.loadStrFromFile(String.valueOf(path) + "etsui.version", true);
                                System.out.println("localUIVersion:" + uiVersion);
                                uiVersion = ETSCloudUtil.checkUIUpdate(version, uiVersion);
                                System.out.println("remoteUIVersion:" + uiVersion);
                                if (uiVersion != null && uiVersion.trim().length() > 0) {
                                    ETSUtil.downloadTool("EASToolsetUI", "", String.valueOf(ETSContext.getETSHome()) + "/installpacks/");
                                    String unPackPath = String.valueOf(ETSContext.getEasClientHome()) + "/lib/client/eas";
                                    boolean b = FileUtil.unzip(String.valueOf(ETSContext.getETSHome()) + "/installpacks/EASToolsetUI.zip", unPackPath);
                                    FileUtil.deleteFile(String.valueOf(ETSContext.getETSHome()) + "/installpacks/EASToolsetUI.zip");
                                    if (b) {
                                        ETSContext.setNeedReboot(true);
                                        FileUtil.saveStringToFile(uiVersion, String.valueOf(path) + "etsui.version");
                                        if (ETSContext.getRunMode() == 0) {
                                            JOptionPane.showMessageDialog((Component)d, "\u5de5\u5177\u5e73\u53f0\u5df2\u66f4\u65b0\uff0c\u5b8c\u5168\u9000\u51faEAS\u5ba2\u6237\u7aef\u540e\u91cd\u65b0\u767b\u5f55\u65b9\u53ef\u751f\u6548!");
                                            SysUtil.abort();
                                        } else {
                                            JOptionPane.showMessageDialog((Component)d, "\u5de5\u5177\u5e73\u53f0\u5df2\u66f4\u65b0\uff0c\u91cd\u65b0\u767b\u5f55\u65b9\u53ef\u751f\u6548!");
                                        }
                                        d.dispose();
                                        return;
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        ETSContext.setUpdated(true);
                    }
                    msgLabel.setText("  \u6b63\u5728\u66f4\u65b0\u5e94\u7528\uff0c\u8bf7\u7a0d\u5019...");
                    try {
                        try {
                            ArrayList tools = MapDBUtil.getInstalledTools(null);
                            HashMap<String, String> map = null;
                            Map retMap = null;
                            HashMap<String, ToolBean> infoMap = null;
                            if (tools != null && tools.size() > 0) {
                                map = new HashMap<String, String>();
                                infoMap = new HashMap<String, ToolBean>();
                                int i = 0;
                                while (i < tools.size()) {
                                    ToolBean tb = (ToolBean)tools.get(i);
                                    map.put("'" + tb.getNumber() + "'", "'" + tb.getMd5() + "'");
                                    infoMap.put(tb.getNumber(), tb);
                                    ++i;
                                }
                                retMap = ETSUtil.checkToolUpdate(map);
                            }
                            this.txtChangeLog = new KDTextPane();
                            this.txtChangeLog.setEditable(false);
                            if (retMap == null) break block25;
                            Set set = retMap.keySet();
                            for (String key : set) {
                                String desc = (String)retMap.get(key);
                                if (desc == null) continue;
                                ToolBean tb = (ToolBean)infoMap.get(key);
                                boolean b = true;
                                if (tb.getUrl() == null || tb.getUrl().trim().length() == 0) {
                                    ETSUtil.downloadTool(key, (String)map.get(key), String.valueOf(ETSContext.getETSHome()) + "/installpacks/");
                                    String path = String.valueOf(ETSContext.getETSHome()) + "/installpacks/" + key + ".zip";
                                    b = FileUtil.unzip(path, String.valueOf(ETSContext.getETSHome()) + "/tools/" + key);
                                    JSONObject o = null;
                                    try {
                                        String s = FileUtil.loadStrFromFile(String.valueOf(ETSContext.getETSHome()) + "/tools/" + key + "/tool.info", false);
                                        if (s != null) {
                                            s = EncodeUtil.decrypt(s);
                                            o = JSONObject.fromObject((Object)s);
                                            HashMap<String, Class<ServerPlugin>> classMap = new HashMap<String, Class<ServerPlugin>>();
                                            classMap.put("serverPlugins", ServerPlugin.class);
                                            tb = (ToolBean)JSONObject.toBean((JSONObject)o, ToolBean.class, classMap);
                                        }
                                    }
                                    catch (Exception ee) {
                                        ee.printStackTrace();
                                    }
                                    FileUtil.deleteFile(path);
                                }
                                if (!b) continue;
                                MapDBUtil.addInstalledTool(tb);
                                if (this.txtChangeLog.getText() == null || this.txtChangeLog.getText().trim().length() == 0) {
                                    FrameUtil.appendStyledText(this.txtChangeLog, "\u4e0b\u5217\u5de5\u5177\u5df2\u5b8c\u6210\u66f4\u65b0\uff1a\n", Color.orange, 15, true, false, true);
                                }
                                FrameUtil.appendStyledText(this.txtChangeLog, "\n" + tb.getName(), Color.blue, 15, true, false, true);
                                FrameUtil.appendStyledText(this.txtChangeLog, "\t\u66f4\u65b0\u53d1\u5e03\u4e8e:", Color.gray, 14, false, true, true);
                                FrameUtil.appendStyledText(this.txtChangeLog, String.valueOf(tb.getUpdateTime()) + "\n", Color.magenta, 14, false, true, true);
                                if (desc.length() > 0) {
                                    FrameUtil.appendStyledText(this.txtChangeLog, "\u66f4\u65b0\u8bf4\u660e:\n", Color.gray, 14, true, false, true);
                                    FrameUtil.appendStyledText(this.txtChangeLog, String.valueOf(desc) + "\n", Color.black, 14, false, true, true);
                                }
                                ETSUtil.userBehaviorLog(key, tb.getName(), "\u66f4\u65b0", null, null);
                            }
                            if (this.txtChangeLog.getText() != null && this.txtChangeLog.getText().trim().length() > 0) {
                                final KDDialog dd = new KDDialog();
                                dd.setSize(600, 480);
                                dd.setTitle("\u66f4\u65b0\u5b8c\u6bd5");
                                FrameUtil.onCenter((Component)dd);
                                dd.setPreferredSize(new Dimension(600, 480));
                                dd.setModal(true);
                                KDScrollPane scr = new KDScrollPane();
                                scr.setSize(600, 430);
                                scr.setPreferredSize(new Dimension(600, 430));
                                scr.setViewportView((Component)this.txtChangeLog);
                                dd.setLayout((LayoutManager)new BorderLayout());
                                dd.add((Component)scr, (Object)"Center");
                                KDButton btn = new KDButton("\u786e\u5b9a");
                                btn.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        dd.dispose();
                                    }
                                });
                                KDPanel p = new KDPanel();
                                p.setLayout((LayoutManager)new FlowLayout(2, 40, 5));
                                p.add((Component)btn);
                                dd.add((Component)p, (Object)"South");
                                dd.setVisible(true);
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            if (d != null) {
                                System.out.println(d);
                                d.setVisible(false);
                                d.dispose();
                            }
                        }
                    }
                    finally {
                        if (d != null) {
                            System.out.println(d);
                            d.setVisible(false);
                            d.dispose();
                        }
                    }
                }
            }
        });
        t.start();
        d.setVisible(true);
    }

    public static void doInstall1() {
    }

    public static void feedBack(Component parent) {
        final KDDialog dl = new KDDialog();
        dl.setTitle("\u670d\u52a1\u5de5\u5177\u5e73\u53f0\u7528\u6237\u53cd\u9988");
        dl.setModal(true);
        FrameUtil.onCenter((Component)dl, 400, 320);
        KDPanel d = new KDPanel();
        d.setSize(400, 320);
        dl.setContentPane((Container)d);
        d.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        Insets ls = new Insets(10, 15, 0, 0);
        Insets ts = new Insets(10, 5, 0, 10);
        KDLabel lbl = new KDLabel("\u60a8\u7684\u59d3\u540d:");
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.insets = ls;
        gc.gridy = 0;
        gc.fill = 0;
        d.add((Component)lbl, (Object)gc);
        final KDTextField txtName = new KDTextField();
        txtName.setColumns(20);
        gc.insets = ts;
        gc.gridwidth = 0;
        gc.gridx = 1;
        gc.fill = 2;
        d.add((Component)txtName, (Object)gc);
        lbl = new KDLabel("\u60a8\u7684\u7535\u8bdd:");
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.insets = ls;
        gc.gridy = 1;
        gc.fill = 0;
        d.add((Component)lbl, (Object)gc);
        final KDTextField txtMobile = new KDTextField();
        txtMobile.setColumns(20);
        gc.insets = ts;
        gc.gridx = 1;
        gc.gridwidth = 0;
        gc.fill = 2;
        d.add((Component)txtMobile, (Object)gc);
        lbl = new KDLabel("\u60a8\u7684\u90ae\u7bb1:");
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.insets = ls;
        gc.fill = 0;
        d.add((Component)lbl, (Object)gc);
        final KDTextField txtMail = new KDTextField();
        txtMail.setColumns(20);
        gc.gridwidth = 0;
        gc.gridx = 1;
        gc.insets = ts;
        gc.fill = 2;
        d.add((Component)txtMail, (Object)gc);
        lbl = new KDLabel("\u53cd\u9988\u4e3b\u9898:");
        gc.gridy = 3;
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.insets = ls;
        gc.fill = 0;
        d.add((Component)lbl, (Object)gc);
        final KDTextField txtTitle = new KDTextField();
        txtTitle.setColumns(20);
        gc.insets = ts;
        gc.gridwidth = 0;
        gc.gridx = 1;
        gc.fill = 2;
        d.add((Component)txtTitle, (Object)gc);
        lbl = new KDLabel("\u53cd\u9988\u5185\u5bb9:");
        gc.gridy = 4;
        gc.insets = ls;
        gc.gridwidth = 1;
        gc.gridheight = 2;
        gc.weighty = 1.0;
        gc.anchor = 11;
        gc.gridx = 0;
        gc.fill = 2;
        d.add((Component)lbl, (Object)gc);
        final KDTextArea ta = new KDTextArea();
        ta.setSize(400, 250);
        JScrollPane scr = new JScrollPane((Component)ta);
        scr.setSize(400, 250);
        gc.gridx = 1;
        gc.gridwidth = 0;
        gc.insets = ts;
        gc.weighty = 1.0;
        gc.anchor = 11;
        gc.fill = 1;
        gc.gridheight = 2;
        d.add((Component)scr, (Object)gc);
        KDButton btn = new KDButton("\u63d0\u4ea4");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HashMap<String, String> map = new HashMap<String, String>();
                String value = txtName.getText();
                if (value == null || value.trim().length() == 0) {
                    KDOptionPane.showMessageDialog((Component)dl, (Object)"\u8bf7\u8f93\u5165\u60a8\u7684\u59d3\u540d");
                    txtName.requestFocus();
                    return;
                }
                map.put("name", value.trim());
                value = txtMobile.getText();
                if (value == null || value.trim().length() == 0) {
                    KDOptionPane.showMessageDialog((Component)dl, (Object)"\u8bf7\u8f93\u5165\u60a8\u7684\u8054\u7cfb\u7535\u8bdd");
                    txtMobile.requestFocus();
                    return;
                }
                map.put("mobile", value);
                value = txtMail.getText();
                if (value != null || value.trim().length() > 0) {
                    map.put("mail", value);
                }
                if ((value = txtTitle.getText()) == null || value.trim().length() == 0) {
                    KDOptionPane.showMessageDialog((Component)dl, (Object)"\u8bf7\u8f93\u5165\u53cd\u9988\u6807\u9898");
                    txtTitle.requestFocus();
                    return;
                }
                map.put("title", value);
                value = ta.getText();
                if (value == null || value.trim().length() == 0) {
                    JOptionPane.showMessageDialog((Component)dl, "\u8bf7\u8f93\u5165\u53cd\u9988\u5185\u5bb9");
                    ta.requestFocus();
                    return;
                }
                map.put("content", value);
                boolean b = ETSUtil.feedback(map);
                if (b) {
                    ETSUtil.userBehaviorLog("EASToolset", "\u670d\u52a1\u5de5\u5177\u5e73\u53f0", "\u7528\u6237\u53cd\u9988", "\u6210\u529f", null);
                    KDOptionPane.showMessageDialog((Component)dl, (Object)"\u63d0\u4ea4\u53cd\u9988\u6210\u529f");
                    dl.dispose();
                } else {
                    ETSUtil.userBehaviorLog("EASToolset", "\u670d\u52a1\u5de5\u5177\u5e73\u53f0", "\u7528\u6237\u53cd\u9988", "\u5931\u8d25", null);
                    KDOptionPane.showMessageDialog((Component)dl, (Object)"\u63d0\u4ea4\u53cd\u9988\u5931\u8d25");
                }
            }
        });
        gc.gridy = 6;
        gc.gridwidth = 0;
        gc.weighty = 0.0;
        gc.insets = new Insets(15, 0, 20, 10);
        gc.gridheight = 1;
        gc.anchor = 13;
        gc.fill = 0;
        d.add((Component)btn, (Object)gc);
        dl.setVisible(true);
    }

    public static void getFavTools(final IToolsetUI ui) {
        ui.getPanelUp().removeAll();
        ArrayList list = MapDBUtil.getFavTools();
        if (list != null && list.size() > 0) {
            Dimension innerPanelSize = new Dimension(105, 105);
            Dimension iconPanelSize = new Dimension(75, 75);
            Dimension underTextPanelSize = new Dimension(105, 26);
            Dimension nameSize = new Dimension(105, 25);
            int i = 0;
            while (i < list.size()) {
                final KDPanel innerPanel = new KDPanel((LayoutManager)new BorderLayout());
                innerPanel.setPreferredSize(innerPanelSize);
                final ToolBean tool = (ToolBean)list.get(i);
                innerPanel.setName(tool.getName());
                innerPanel.setBorder((Border)BorderFactory.createTitledBorder(""));
                String iconPath = String.valueOf(ETSContext.getETSHome()) + "/tools/" + tool.getNumber() + "/icon.png";
                File f = new File(iconPath);
                ImageIcon img = null;
                img = !f.exists() ? ResourceUtil.getImageRes(String.valueOf(ETSContext.getETSHome()) + "/images/", "defaulticon.png") : new ImageIcon(iconPath);
                JButton iconPanel = new JButton();
                if (img != null) {
                    iconPanel.setIcon(img);
                }
                iconPanel.setPreferredSize(iconPanelSize);
                iconPanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder()));
                innerPanel.add((Component)iconPanel, (Object)"Center");
                KDLabel NameLabel = new KDLabel(tool.getName());
                NameLabel.setHorizontalAlignment(0);
                NameLabel.setFont(new Font("Microsoft YaHei", 1, 13));
                NameLabel.setPreferredSize(nameSize);
                KDPanel underTextPanel = new KDPanel((LayoutManager)new BorderLayout());
                underTextPanel.add((Component)NameLabel, (Object)"Center");
                underTextPanel.setPreferredSize(underTextPanelSize);
                innerPanel.add((Component)underTextPanel, (Object)"South");
                iconPanel.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        UIHelper.launchTool(ui, tool);
                    }
                });
                final KDPopupMenu menu = new KDPopupMenu();
                MouseAdapter ml = new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if (e.getButton() == 3) {
                            menu.show((Component)innerPanel, 90, 5);
                        }
                    }
                };
                NameLabel.addMouseListener((MouseListener)ml);
                iconPanel.addMouseListener(ml);
                innerPanel.addMouseListener((MouseListener)ml);
                KDMenuItem item = new KDMenuItem("\u8fd0\u884c");
                item.setIcon((Icon)launchIcon);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        UIHelper.launchTool(ui, tool);
                    }
                });
                menu.add((JMenuItem)item);
                item = new KDMenuItem("\u79fb\u9664\u5e38\u7528");
                item.setIcon((Icon)deleteIcon);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        MapDBUtil.removeFavTool(tool.getNumber());
                        ui.refreshFavTools();
                    }
                });
                menu.add((JMenuItem)item);
                ui.getPanelUp().add((Component)innerPanel);
                ++i;
            }
        }
        int cnt = ui.getPanelUp().getComponentCount();
        int col = ui.getPanelUp().getSize().width / 120;
        cnt = (int)Math.ceil((double)cnt / (double)col);
        int cmpHeight = cnt * 105;
        int space = (cnt + 1) * 15;
        ui.getPanelUp().setPreferredSize(new Dimension(670, cmpHeight + space));
        ui.getPanelUp().updateUI();
    }

    public static void installLocal(IToolsetUI ui) {
        JFileChooser fd = new JFileChooser();
        fd.setDialogTitle("\u8bf7\u9009\u62e9\u5de5\u5177\u79bb\u7ebf\u5b89\u88c5\u5305");
        fd.removeChoosableFileFilter(fd.getAcceptAllFileFilter());
        fd.addChoosableFileFilter(new FileFilter(){

            public String getDescription() {
                return "*.zip";
            }

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String fileName = file.getName();
                return fileName.toLowerCase().endsWith(".zip");
            }
        });
        int option = fd.showOpenDialog(null);
        if (option != 0) {
            return;
        }
        File f = fd.getSelectedFile();
        if (f == null) {
            return;
        }
        if (!f.getName().toLowerCase().endsWith(".zip")) {
            JOptionPane.showMessageDialog((Component)((Object)ui), "\u65e0\u6548\u7684\u5b89\u88c5\u5305");
            return;
        }
        try {
            ZipFile zip = new ZipFile(f);
            ZipEntry entry = zip.getEntry("tool.info");
            if (entry == null) {
                JOptionPane.showMessageDialog((Component)((Object)ui), "\u65e0\u6548\u7684\u5b89\u88c5\u5305");
                return;
            }
            JSONObject o = null;
            try {
                InputStream inp = zip.getInputStream(entry);
                InputStreamReader isr = new InputStreamReader(inp);
                BufferedReader reader = new BufferedReader(isr);
                String s = reader.readLine();
                reader.close();
                isr.close();
                inp.close();
                s = EncodeUtil.decrypt(s);
                o = JSONObject.fromObject((Object)s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (o == null) {
                JOptionPane.showMessageDialog((Component)((Object)ui), "\u65e0\u6548\u7684\u5b89\u88c5\u5305");
                return;
            }
            ToolBean t = (ToolBean)JSONObject.toBean(o, ToolBean.class);
            boolean b = FileUtil.unzip(zip, String.valueOf(ETSContext.getETSHome()) + "/tools/" + t.getNumber());
            if (b) {
                MapDBUtil.addInstalledTool(t);
                if (ETSContext.getClientNetworkMode() != 0) {
                    byte[] bytes;
                    File img;
                    if (t.getIcon() != null && t.getIcon().length() > 0 && !(img = new File(String.valueOf(ETSUtil.getToolPath(t.getNumber())) + "/icon.png")).exists() && (bytes = HttpUtil.getImageBytes(t.getIcon())) != null) {
                        FileUtil.byteToFile(bytes, "icon.png", ETSUtil.getToolPath(t.getNumber()));
                    }
                    if (t.getPicture() != null && t.getPicture().length() > 0 && !(img = new File(String.valueOf(ETSUtil.getToolPath(t.getNumber())) + "/image.png")).exists() && (bytes = HttpUtil.getImageBytes(t.getPicture())) != null) {
                        FileUtil.byteToFile(bytes, "image.jpg", ETSUtil.getToolPath(t.getNumber()));
                    }
                }
                JOptionPane.showMessageDialog((Component)((Object)ui), "\u5b89\u88c5\u6210\u529f");
                ui.refreshInstalledTools();
                ETSUtil.userBehaviorLog(t.getNumber(), t.getName(), "\u79bb\u7ebf\u5b89\u88c5", "\u6210\u529f", null);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)ui), "\u5b89\u88c5\u5931\u8d25");
                ETSUtil.userBehaviorLog(t.getNumber(), t.getName(), "\u79bb\u7ebf\u5b89\u88c5", "\u5931\u8d25", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)((Object)ui), "\u5b89\u88c5\u51fa\u9519");
        }
    }
}

