/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.help.msgHelp.client;

import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDEditorPane;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JScrollBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TMTextAreaCtrl
extends KDScrollPane
implements IKDComponent {
    public static final String SEARCHURLHEAD = "https://vip.kingdee.com/search?productLineId=8&searchText=";
    public static final String REQUESTHEAD = "https://vip.kingdee.com";
    private static final long serialVersionUID = -3074674137433184026L;
    protected static final Insets MARGIN = new Insets(2, 5, 2, 5);
    protected static final int DEFAULTHEIGHT = 82;
    protected static final int DEFAULTWIDTH = 170;
    public static final int STYLE_VSCROLLBAR_AS_NEEDED = 1;
    public static final int STYLE_VSCROLLBAR_NEVER = 2;
    public static final int STYLE_VSCROLLBAR_ALWAYS = 4;
    public static final int STYLE_HSCROLLBAR_AS_NEEDED = 16;
    public static final int STYLE_HSCROLLBAR_NEVER = 32;
    public static final int STYLE_HSCROLLBAR_ALWAYS = 64;
    protected KDEditorPane detailMsgPane;
    protected Map<String, String> msgURL = new HashMap<String, String>();
    protected TextAreaCtrlFocusHandler listener = new TextAreaCtrlFocusHandler(this);
    protected String detail;
    protected String handledDetail;
    protected Object userObject = null;

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    private int getVerticalScrollBarPolicy(int style) {
        if ((style & 1) != 0) {
            return 20;
        }
        if ((style & 2) != 0) {
            return 21;
        }
        if ((style & 4) != 0) {
            return 22;
        }
        return 20;
    }

    private int getHorizontalScrollBarPolicy(int style) {
        if ((style & 0x10) != 0) {
            return 30;
        }
        if ((style & 0x20) != 0) {
            return 31;
        }
        if ((style & 0x40) != 0) {
            return 32;
        }
        return 30;
    }

    protected void init(int style) {
        this.detailMsgPane = new KDEditorPane();
        this.detailMsgPane.setMargin(MARGIN);
        this.detailMsgPane.addFocusListener((FocusListener)this.listener);
        this.detailMsgPane.setForeground(new Color(119, 119, 119));
        this.detailMsgPane.setSelectedTextColor(Color.white);
        this.detailMsgPane.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.detailMsgPane.setBackground(new Color(231, 237, 242));
        this.detailMsgPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && e.getURL() != null && !StringUtils.isEmpty((String)e.getURL().toString())) {
                    TMTextAreaCtrl.this.openByDefaultBrowser(e.getURL().toString());
                }
            }
        });
        this.addFocusListener(this.listener);
        this.setViewportView((Component)this.detailMsgPane);
        this.setVerticalScrollBarPolicy(this.getVerticalScrollBarPolicy(style));
        this.setHorizontalScrollBarPolicy(this.getHorizontalScrollBarPolicy(style));
        this.setBorder(KingdeeBorders.createEditorBorder());
        JScrollBar bar = this.getHorizontalScrollBar();
        if (bar != null) {
            bar.setFocusable(false);
        }
        if ((bar = this.getVerticalScrollBar()) != null) {
            bar.setFocusable(false);
        }
    }

    public TMTextAreaCtrl(Map<String, String> msgURL) {
        this.msgURL = msgURL;
        this.init(0);
    }

    public TMTextAreaCtrl(int style) {
        this.init(style);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        JScrollBar bar = this.getHorizontalScrollBar();
        if (bar != null) {
            bar.setEnabled(enabled);
        }
        if ((bar = this.getVerticalScrollBar()) != null) {
            bar.setEnabled(enabled);
        }
        this.detailMsgPane.setEnabled(enabled);
    }

    public boolean hasFocus() {
        boolean br = super.hasFocus();
        if (!br) {
            br = this.detailMsgPane.hasFocus();
        }
        return br;
    }

    public TMTextAreaCtrl() {
        this.init(0);
    }

    public Dimension getPreferredSize() {
        Dimension d = new Dimension(170, 82);
        return d;
    }

    public KDEditorPane getTextComponent() {
        return this.detailMsgPane;
    }

    public void setDocument(Document doc) {
        this.detailMsgPane.setDocument(doc);
    }

    public Document getDocument() {
        return this.detailMsgPane.getDocument();
    }

    public void replaceSelection(String content) {
        this.detailMsgPane.replaceSelection(content);
    }

    public String getText(int offs, int len) throws BadLocationException {
        return this.detailMsgPane.getText(offs, len);
    }

    public void cut() {
        this.detailMsgPane.cut();
    }

    public void copy() {
        this.detailMsgPane.copy();
    }

    public void paste() {
        this.detailMsgPane.paste();
    }

    public void moveCaretPosition(int pos) {
        this.detailMsgPane.moveCaretPosition(pos);
    }

    public void setCaretPosition(int position) {
        this.detailMsgPane.setCaretPosition(position);
    }

    public int getCaretPosition() {
        return this.detailMsgPane.getCaretPosition();
    }

    public void setText(String t) {
        this.detail = t;
        this.handledDetail = t;
        this.handleDetailToHTML();
        this.detailMsgPane.setContentType("text/html");
        this.detailMsgPane.setText(this.handledDetail);
    }

    protected void handleDetailToHTML() {
        int i;
        if (StringUtils.isEmpty((String)this.handledDetail)) {
            return;
        }
        ArrayList<StringBuffer> htmlLineSB = new ArrayList<StringBuffer>();
        String[] detailArr = this.handledDetail.split("\r\n");
        boolean[] addHTML = new boolean[detailArr.length];
        HashMap<String, String> matchedMsgURL = new HashMap<String, String>();
        String msg2 = null;
        if (this.msgURL != null && !this.msgURL.isEmpty()) {
            String function = this.msgURL.get("function");
            for (String msg2 : this.msgURL.keySet()) {
                if (StringUtils.isEmpty((String)msg2) || this.handledDetail.indexOf(msg2) <= -1) continue;
                matchedMsgURL.put(msg2, this.msgURL.get(msg2));
                if (StringUtils.isEmpty((String)function) || !this.msgURL.containsKey(msg2 + ";;" + function)) continue;
                matchedMsgURL.put(msg2, this.msgURL.get(msg2 + ";;" + function));
            }
        }
        int length = detailArr.length;
        for (int i2 = 0; i2 < length; ++i2) {
            StringBuffer htmlSB = new StringBuffer();
            if (!StringUtils.isEmpty((String)detailArr[i2])) {
                detailArr[i2] = this.handleSpecailChar(detailArr[i2]);
                detailArr[i2] = detailArr[i2].replaceAll("\n", "<br/>");
                htmlSB.append("<a style = \"font-family:\u5b8b\u4f53;color:gray;font-size:10px;\">" + detailArr[i2] + "</a>");
            }
            htmlLineSB.add(htmlSB);
        }
        for (String msg2 : matchedMsgURL.keySet()) {
            int length2 = detailArr.length;
            for (i = 0; i < length2; ++i) {
                if (StringUtils.isEmpty((String)detailArr[i]) || detailArr[i].endsWith(":") || detailArr[i].endsWith("\uff1a") || addHTML[i] || detailArr[i].indexOf(msg2) <= -1) continue;
                addHTML[i] = true;
                ((StringBuffer)htmlLineSB.get(i)).append("<a style = \"text-decoration:none;font-family:\u5b8b\u4f53;font-size:10px;color:#1E73EB\";href=\"" + (String)matchedMsgURL.get(msg2) + "\">&nbsp;&nbsp\u63d0\u793a\u8be6\u89e3</a>");
            }
        }
        int length3 = detailArr.length;
        for (i = 0; i < length3; ++i) {
            detailArr[i] = detailArr[i].trim();
            if (StringUtils.isEmpty((String)detailArr[i]) || detailArr[i].endsWith(":") || detailArr[i].endsWith("\uff1a") || detailArr[i].endsWith("<br/>")) continue;
            ((StringBuffer)htmlLineSB.get(i)).append("<a style = \"text-decoration:none;font-family:\u5b8b\u4f53;font-size:10px;color:#1E73EB\";href=\"https://vip.kingdee.com/search?productLineId=8&searchText=" + this.handleGetMoreString(detailArr[i]) + "\">&nbsp;&nbsp\u83b7\u53d6\u66f4\u591a\u77e5\u8bc6</a>");
        }
        StringBuffer newDetail = new StringBuffer();
        newDetail.append("<html><body>");
        int length4 = detailArr.length;
        for (int i3 = 0; i3 < length4; ++i3) {
            newDetail.append((StringBuffer)htmlLineSB.get(i3)).append("<br/>");
        }
        newDetail.append("</body></html>");
        this.handledDetail = newDetail.toString();
    }

    protected String handleSpecailChar(String str) {
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        return str;
    }

    protected String handleGetMoreString(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        String[] strArr = str.split("<br/>");
        if (strArr == null || strArr.length == 1) {
            return str;
        }
        return strArr[strArr.length - 1];
    }

    public String getText() {
        return this.detail;
    }

    public String getSelectedText() {
        return this.detailMsgPane.getSelectedText();
    }

    public int getSelectionStart() {
        return this.detailMsgPane.getSelectionStart();
    }

    public void setSelectionStart(int selectionStart) {
        this.detailMsgPane.setSelectionStart(selectionStart);
    }

    public int getSelectionEnd() {
        return this.detailMsgPane.getSelectionEnd();
    }

    public void setSelectionEnd(int selectionEnd) {
        this.detailMsgPane.setSelectionEnd(selectionEnd);
    }

    public void select(int selectionStart, int selectionEnd) {
        this.detailMsgPane.select(selectionStart, selectionEnd);
    }

    public void selectAll() {
        this.detailMsgPane.selectAll();
    }

    public boolean isEditable() {
        return this.detailMsgPane.isEditable();
    }

    public void setEditable(boolean b) {
        this.detailMsgPane.setEditable(b);
    }

    protected void openByDefaultBrowser(String url) {
        if (!StringUtils.isEmpty((String)url) && url.startsWith(REQUESTHEAD)) {
            FrameWorkUtils.openByDefaultBrowser((String)url);
        }
    }

    protected static class TextAreaCtrlFocusHandler
    implements FocusListener {
        protected TMTextAreaCtrl tac;

        public TextAreaCtrlFocusHandler(TMTextAreaCtrl comp) {
            this.tac = comp;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.tac.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.tac.repaint();
        }
    }
}

