/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.help.pwt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.tm.common.help.pwt.AbstractPlayWithTaxArticleInfo;
import com.kingdee.eas.tm.common.help.pwt.IPlayWithTaxFacade;
import com.kingdee.eas.tm.common.help.pwt.PlayWithTaxArticleCollection;
import com.kingdee.eas.tm.common.help.pwt.PlayWithTaxArticleInfo;
import com.kingdee.eas.tm.common.help.pwt.PlayWithTaxFacadeFactory;
import com.kingdee.eas.tm.common.help.pwt.PlayWithTaxRequestCollection;
import com.kingdee.eas.tm.common.help.pwt.PlayWithTaxRequestInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class PlayWithTax {
    private static final Logger logger = Logger.getLogger(PlayWithTax.class);
    public static final String EASVERSION = "8.8.0";
    public static final String REQUESTHEAD = "https://vip.kingdee.com";
    public static final String MAKEINVOICEMODULE = "IMK";
    public static final String INCOMEINVOICEMODULE = "IMS";
    public JPanel playWithTaxWindow;
    public KDScrollPane mainScrollPanel;
    private KDPanel[] childrenPanels;
    private String module;

    public void addPlayWithTaxWindow(JComponent parentUI, String module) {
        try {
            this.module = module;
            this.updateArticle();
            this.initPlayWithTaxWindow(parentUI);
            this.reLocationPlayWithTaxWindow(parentUI);
            this.playWithTaxWindow.setVisible(false);
            parentUI.add((Component)this.playWithTaxWindow, 1);
            parentUI.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    PlayWithTax.this.reLocationPlayWithTaxWindow((JComponent)e.getComponent());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)("PlayWithTaxWindow init failed" + e.getMessage()), e);
        }
    }

    public void initPlayWithTaxWindow(JComponent parentUI) {
        this.playWithTaxWindow = new JPanel(null);
        this.playWithTaxWindow.setBounds(0, 0, 335, 570);
        this.playWithTaxWindow.setBackground(Color.WHITE);
        this.playWithTaxWindow.setOpaque(true);
        this.playWithTaxWindow.setVisible(false);
        this.setMainPaneTitle(this.playWithTaxWindow, 0, 0, 320, 28);
        this.initMainScrollPanel();
        this.playWithTaxWindow.add((Component)this.mainScrollPanel);
    }

    public void initMainScrollPanel() {
        this.mainScrollPanel = new KDScrollPane();
        this.mainScrollPanel.setBounds(0, 28, 325, 542);
        this.mainScrollPanel.setVisible(true);
        this.mainScrollPanel.setVerticalScrollBarPolicy(20);
        this.mainScrollPanel.setHorizontalScrollBarPolicy(31);
        KDPanel mainPanel = new KDPanel();
        mainPanel.setLayout(null);
        mainPanel.setBounds(0, 0, 325, 542);
        mainPanel.setBackground(new Color(239, 242, 244));
        mainPanel.setPreferredSize(new Dimension(320, 542));
        String[] childrenTitles = new String[]{"dtygg", "czzy", "zbtx", "cjwt"};
        this.childrenPanels = new KDPanel[childrenTitles.length];
        int[] marginAndSize = new int[]{6, 304, 125, 24};
        this.initChildrenPanels((JComponent)mainPanel, childrenTitles, marginAndSize);
        this.mainScrollPanel.setViewportView((Component)mainPanel);
    }

    private void initChildrenPanels(JComponent parentui, String[] childrenTitles, int[] marginAndSize) {
        int i;
        int margin = marginAndSize[0];
        int width = marginAndSize[1];
        int height = marginAndSize[2];
        int x = margin;
        int y = margin;
        Map<String, PlayWithTaxArticleCollection> articleData = this.getChidrenPaneData(childrenTitles);
        int length = this.childrenPanels.length;
        for (i = 0; i < length; ++i) {
            this.childrenPanels[i] = new KDPanel();
            this.childrenPanels[i].setBounds(x, y, width, height);
            y += height + margin;
            this.childrenPanels[i].setLayout(null);
            this.childrenPanels[i].setName(childrenTitles[i] + "_open");
            this.childrenPanels[i].setBackground(Color.white);
            this.setChildrenPaneTitle(childrenTitles[i], this.childrenPanels[i], marginAndSize, articleData);
            this.setChildrenPaneContent(childrenTitles[i], this.childrenPanels[i], articleData);
        }
        length = this.childrenPanels.length;
        for (i = 0; i < length; ++i) {
            parentui.add((Component)this.childrenPanels[i], 0);
        }
    }

    private void setMainPaneTitle(JComponent parentui, int x, int y, int width, int height) {
        KDLabel title = new KDLabel();
        KDLabel titleBackground = new KDLabel();
        KDLabel close = new KDLabel();
        ImageIcon titlePng = this.getHalfSizeIconByPath("image/wzsw_title_" + this.getUserColorName() + ".png");
        title.setIcon((Icon)titlePng);
        title.setBounds(x, y, width, height);
        titleBackground.setIcon((Icon)this.getHalfSizeIconByPath("image/wzsw_" + this.getUserColorName() + ".png"));
        titleBackground.setOpaque(true);
        titleBackground.setBounds(x, y, width, height);
        close.setText("\u00d7");
        close.setToolTipText(null);
        close.setBounds(width - 20, 8, 10, 10);
        close.setForeground(Color.white);
        close.setCursor(new Cursor(12));
        close.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PlayWithTax.this.playWithTaxWindow.setVisible(false);
            }
        });
        parentui.add((Component)titleBackground, 0);
        parentui.add((Component)title, 0);
        parentui.add((Component)close, 0);
    }

    private void setChildrenPaneTitle(String childrenTitle, KDPanel childrenPanel, int[] marginAndSize, Map<String, PlayWithTaxArticleCollection> articleData) {
        int width = marginAndSize[1];
        int titleHeight = marginAndSize[3];
        KDLabel title = new KDLabel();
        KDLabel titleBackground = new KDLabel();
        KDLabel more = new KDLabel();
        ImageIcon titlePng = this.getHalfSizeIconByPath("image/" + childrenPanel.getName() + "_" + this.getUserColorName() + ".png");
        title.setIcon((Icon)titlePng);
        title.setCursor(new Cursor(12));
        title.setBounds(0, 0, titlePng.getIconWidth(), titlePng.getIconHeight() + 1);
        this.addChildrenTitleClickAction(title, marginAndSize);
        titleBackground.setIcon((Icon)this.getHalfSizeIconByPath("image/wzsw_child_" + this.getUserColorName() + ".png"));
        titleBackground.setOpaque(true);
        titleBackground.setBounds(0, 0, width, titleHeight);
        ImageIcon morePng = this.getHalfSizeIconByPath("image/gd_" + this.getUserColorName() + ".png");
        more.setIcon((Icon)morePng);
        more.setCursor(new Cursor(12));
        more.setBounds(childrenPanel.getWidth() - morePng.getIconWidth() - 6, 1, morePng.getIconWidth(), morePng.getIconHeight() - 1);
        PlayWithTaxArticleCollection articleColl = articleData.get(childrenTitle);
        AbstractPlayWithTaxArticleInfo moreLink = null;
        String articleID = null;
        articleID = childrenTitle + "_" + this.module + "_gd";
        if ("zbtx".equals(childrenTitle)) {
            articleID = articleID + "_" + EASVERSION;
        }
        int size = articleColl.size();
        for (int i = 0; i < size; ++i) {
            if (!articleID.equals(articleColl.get(i).getArticleid())) continue;
            moreLink = articleColl.get(i);
            break;
        }
        if (moreLink != null) {
            final String moreURL = moreLink.getUrl();
            more.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!StringUtils.isEmpty((String)moreURL)) {
                        PlayWithTax.this.openByDefaultBrowser(moreURL);
                    }
                }
            });
        }
        childrenPanel.add((Component)titleBackground, 0);
        childrenPanel.add((Component)title, 0);
        childrenPanel.add((Component)more, 0);
    }

    private void addChildrenTitleClickAction(KDLabel childrenTitle, int[] marginAndSize) {
        final int margin = marginAndSize[0];
        final int width = marginAndSize[1];
        final int height = marginAndSize[2];
        final int titleHeight = marginAndSize[3];
        childrenTitle.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                KDPanel childrenPanel = (KDPanel)e.getComponent().getParent();
                if (childrenPanel.getName().endsWith("_open")) {
                    childrenPanel.setSize(width, titleHeight);
                    childrenPanel.setName(childrenPanel.getName().split("_open")[0] + "_close");
                } else {
                    childrenPanel.setSize(width, height);
                    childrenPanel.setName(childrenPanel.getName().split("_close")[0] + "_open");
                }
                ((KDLabel)e.getComponent()).setIcon((Icon)PlayWithTax.this.getHalfSizeIconByPath("image/" + childrenPanel.getName() + "_" + PlayWithTax.this.getUserColorName() + ".png"));
                PlayWithTax.this.relocateChildrenPanels(margin);
            }
        });
    }

    private void relocateChildrenPanels(int margin) {
        int x = margin;
        int y = margin;
        int length = this.childrenPanels.length;
        for (int i = 0; i < length; ++i) {
            this.childrenPanels[i].setLocation(x, y);
            y += this.childrenPanels[i].getHeight() + margin;
        }
    }

    private void setChildrenPaneContent(String childrenTitle, KDPanel childrenPanel, Map<String, PlayWithTaxArticleCollection> articleData) {
        int[] linkMairginAndSize = new int[]{10, 195, 15};
        int[] pointMarginAndSize = new int[]{4, 18, 18};
        int dateWidth = 62;
        if (articleData == null) {
            return;
        }
        PlayWithTaxArticleCollection articleColl = articleData.get(childrenTitle);
        KDLabel point = null;
        KDLabel link = null;
        KDLabel date = null;
        KDLabel isNew = null;
        int linkMargin = linkMairginAndSize[0];
        int pointMargin = pointMarginAndSize[0];
        int pointX = 10 + pointMargin;
        int linkX = pointX + pointMargin + 10;
        int pointY = linkMargin + 16;
        int linkY = linkMargin + 20;
        int linkWidth = linkMairginAndSize[1];
        int linkHeight = linkMairginAndSize[2];
        int pointWidth = pointMarginAndSize[1];
        int pointHeight = pointMarginAndSize[2];
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        int size = articleColl.size();
        for (int i = 0; i < size; ++i) {
            final PlayWithTaxArticleInfo article = articleColl.get(i);
            if (article.getArticleid().endsWith("_gd") || article.getArticleid().contains("_gd_")) continue;
            point = new KDLabel();
            point.setBounds(pointX, pointY, pointWidth, pointHeight);
            point.setForeground(PlayWithTax.getUserColor());
            point.setText("\u25cf");
            point.setFont(new Font("Segoe UI", 0, 14));
            point.setToolTipText(null);
            link = new KDLabel();
            link.setBounds(linkX, linkY, linkWidth, linkHeight);
            link.setForeground(new Color(119, 119, 119));
            link.setText(article.getTitle());
            link.setFont(new Font("\u5b8b\u4f53", 0, 12));
            link.setCursor(new Cursor(12));
            link.setName(article.getArticleid());
            link.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!StringUtils.isEmpty((String)article.getUrl())) {
                        PlayWithTax.this.openByDefaultBrowser(article.getUrl());
                        try {
                            boolean isNeedUpdateIsNew = true;
                            String isNewLabelName = article.getArticleid() + "_new";
                            Component[] components = e.getComponent().getParent().getComponents();
                            int length = components.length;
                            for (int i = 0; i < length; ++i) {
                                if (!isNewLabelName.equals(components[i].getName())) continue;
                                if (!components[i].isVisible()) {
                                    isNeedUpdateIsNew = false;
                                }
                                components[i].setVisible(false);
                                break;
                            }
                            if (isNeedUpdateIsNew) {
                                PlayWithTaxFacadeFactory.getRemoteInstance().updateIsNew(article.getArticleid());
                            }
                        }
                        catch (Throwable e1) {
                            logger.error((Object)e1.getMessage(), e1);
                        }
                    }
                }
            });
            date = new KDLabel();
            date.setBounds(childrenPanel.getWidth() - 5 - dateWidth, linkY, dateWidth, linkHeight);
            date.setForeground(new Color(119, 119, 119));
            date.setText(formatter.format(article.getUpdateTime()));
            date.setFont(new Font("\u5b8b\u4f53", 0, 12));
            date.setToolTipText(null);
            childrenPanel.add((Component)point, 0);
            childrenPanel.add((Component)link, 0);
            childrenPanel.add((Component)date, 0);
            if (article.isIsNew()) {
                isNew = new KDLabel();
                isNew.setBounds(childrenPanel.getWidth() - 5 - dateWidth - 3 - 24, linkY, 24, 12);
                ImageIcon icon = this.findIconByPath("image/new.png");
                icon.setImage(icon.getImage().getScaledInstance(24, 12, 1));
                isNew.setIcon((Icon)icon);
                isNew.setName(article.getArticleid() + "_new");
                childrenPanel.add((Component)isNew, 0);
            }
            pointY += linkHeight + linkMargin;
            linkY += linkHeight + linkMargin;
        }
    }

    private void setChildrenPaneTitleAndIcon(String childrenTitle, KDPanel childrenPanel, int width, int height) {
        KDLabel title = new KDLabel();
        KDLabel titleIcon = new KDLabel();
        title.setText(childrenTitle);
        title.setFont((Font)new KDFont("\u5fae\u8f6f\u96c5\u9ed1", 0, 9));
        title.setOpaque(false);
        title.setForeground(Color.black);
        titleIcon.setIcon((Icon)this.findIconByPath("image/wzswChildBackGround.png"));
        titleIcon.setOpaque(true);
        title.setBounds(22, 0, width, height);
        titleIcon.setBounds(0, 0, width, height);
        childrenPanel.add((Component)titleIcon, 0);
        childrenPanel.add((Component)title, 0);
    }

    private void setMainPaneTitleAndIcon(String text, JComponent parentui, String backGroundName, int x, int y, int width, int height) {
        KDLabel title = new KDLabel();
        KDLabel titleIcon = new KDLabel();
        title.setText(text);
        title.setFont((Font)new KDFont("\u5fae\u8f6f\u96c5\u9ed1", 0, 11));
        title.setOpaque(false);
        title.setForeground(Color.white);
        titleIcon.setIcon((Icon)this.findIconByPath(backGroundName));
        titleIcon.setOpaque(true);
        title.setBounds(x + 12, y, width, height);
        titleIcon.setBounds(x, y, width, height);
        parentui.add((Component)titleIcon, 0);
        parentui.add((Component)title, 0);
    }

    private void setPanelBorder(JPanel panel) {
        panel.setBorder(BorderFactory.createLineBorder(Color.gray));
    }

    private static Color getUserColor() {
        int colorStyle = UIConfig.getUiColorStyle();
        Color color = new Color(85, 142, 194);
        switch (colorStyle) {
            case 2: {
                color = new Color(208, 150, 81);
                break;
            }
            case 0: {
                color = new Color(54, 138, 60);
                break;
            }
            case 4: {
                color = new Color(162, 83, 84);
            }
        }
        return color;
    }

    private String getUserColorName() {
        int colorStyle = UIConfig.getUiColorStyle();
        String color = "blue";
        switch (colorStyle) {
            case 2: {
                color = "orange";
                break;
            }
            case 0: {
                color = "green";
                break;
            }
            case 4: {
                color = "red";
            }
        }
        return color;
    }

    private String getUserColorCode() {
        int colorStyle = UIConfig.getUiColorStyle();
        String color = "#558EC2";
        switch (colorStyle) {
            case 2: {
                color = "#D09651";
                break;
            }
            case 0: {
                color = "#368A3C";
                break;
            }
            case 4: {
                color = "#A25354";
            }
        }
        return color;
    }

    private ImageIcon findIconByPath(String relativePath) {
        ImageIcon icon = null;
        URL url = PlayWithTax.class.getResource(relativePath);
        icon = url != null ? new ImageIcon(url) : (ImageIcon)EASResource.getIcon((String)"Missing Resource");
        return icon;
    }

    private ImageIcon getHalfSizeIconByPath(String relativePath) {
        ImageIcon icon = null;
        URL url = PlayWithTax.class.getResource(relativePath);
        if (url != null) {
            icon = new ImageIcon(url);
            icon.setImage(icon.getImage().getScaledInstance(icon.getIconWidth() / 2, icon.getIconHeight() / 2, 1));
        } else {
            icon = (ImageIcon)EASResource.getIcon((String)"Missing Resource");
        }
        return icon;
    }

    private void reLocationPlayWithTaxWindow(JComponent parentUI) {
        int frameWidth = parentUI.getWidth();
        int frameHeight = parentUI.getHeight();
        this.playWithTaxWindow.setLocation(frameWidth - 320, 35);
        if (frameHeight - 35 - 20 < 570) {
            this.playWithTaxWindow.setSize(335, frameHeight - 35 - 20);
            this.mainScrollPanel.setSize(325, frameHeight - 35 - 48);
        } else {
            this.playWithTaxWindow.setSize(335, 570);
            this.mainScrollPanel.setSize(325, 600);
        }
        this.playWithTaxWindow.revalidate();
        this.playWithTaxWindow.repaint();
    }

    protected void openByDefaultBrowser(String url) {
        if (!StringUtils.isEmpty((String)url) && url.startsWith(REQUESTHEAD)) {
            FrameWorkUtils.openByDefaultBrowser((String)url);
        }
    }

    private Map<String, PlayWithTaxArticleCollection> getChidrenPaneData(String[] childrenTitles) {
        try {
            return PlayWithTaxFacadeFactory.getRemoteInstance().getArticleData(childrenTitles, this.module);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateArticle() throws BOSException, EASBizException {
        ExecutorService service = null;
        IPlayWithTaxFacade iPlayWithTaxFacade = PlayWithTaxFacadeFactory.getRemoteInstance();
        boolean isNeedUpdateArticle = iPlayWithTaxFacade.isNeedUpdateArticle();
        if (isNeedUpdateArticle) {
            boolean isUpdatedTime = false;
            try {
                PlayWithTaxRequestCollection requestColl = (PlayWithTaxRequestCollection)iPlayWithTaxFacade.getRequestData();
                if (requestColl == null || requestColl.isEmpty()) {
                    return;
                }
                int defaultThreadPoolSize = 8;
                int requestSize = requestColl.size();
                int threadPoolsize = requestSize > defaultThreadPoolSize ? defaultThreadPoolSize : requestSize;
                service = Executors.newFixedThreadPool(threadPoolsize);
                CountDownLatch latch = new CountDownLatch(requestSize);
                int size = requestColl.size();
                for (int i = 0; i < size; ++i) {
                    GetNewArticleTask task = new GetNewArticleTask(requestColl.get(i), latch);
                    service.execute(task);
                }
                iPlayWithTaxFacade.updateLastUpdateTime();
                isUpdatedTime = true;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (service != null) {
                    service.shutdown();
                }
                try {
                    if (!isUpdatedTime) {
                        iPlayWithTaxFacade.updateLastUpdateTime();
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)("updateLastUpdateTime error:" + e.getMessage()), e);
                }
            }
        }
    }

    protected void getNewArticle(PlayWithTaxRequestInfo requestInfo) {
        String responseString = null;
        responseString = this.requestCloudCommun(requestInfo);
        if (StringUtils.isEmpty((String)responseString)) {
            logger.error((Object)"getNewArticle responseString is null");
            return;
        }
        this.parseArticleData(requestInfo, responseString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String requestCloudCommun(PlayWithTaxRequestInfo requestInfo) {
        String responseString = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = null;
        try {
            httpGet = new HttpGet(requestInfo.getUrl());
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(8000).setConnectionRequestTimeout(8000).setSocketTimeout(8000).build();
            httpGet.setConfig(requestConfig);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                logger.error((Object)("requestCloudCommun fail:" + responseString));
                String string = null;
                return string;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
        return responseString;
    }

    protected void parseArticleData(PlayWithTaxRequestInfo requestInfo, String responseString) {
        try {
            JSONObject responJson = new JSONObject(responseString);
            JSONArray jsonArray = responJson.getJSONArray("content");
            JSONObject articleObject = null;
            PlayWithTaxArticleInfo articleInfo = null;
            ArrayList<PlayWithTaxArticleInfo> articleList = new ArrayList<PlayWithTaxArticleInfo>();
            int length = jsonArray.length();
            for (int i = 0; i < length; ++i) {
                articleObject = (JSONObject)jsonArray.get(i);
                articleInfo = new PlayWithTaxArticleInfo();
                articleInfo.setArticleid(articleObject.getString("id"));
                articleInfo.setPane(requestInfo.getPane());
                articleInfo.setModule(requestInfo.getModule());
                articleInfo.setTitle(articleObject.getString("title"));
                articleInfo.setUrl(articleObject.getString("entityUrl"));
                articleInfo.setUpdateTime(this.getTimestamp(articleObject));
                articleInfo.setIsNew(true);
                articleList.add(articleInfo);
            }
            if (!articleList.isEmpty()) {
                PlayWithTaxFacadeFactory.getRemoteInstance().stroreArticleData(articleList);
            }
        }
        catch (Exception e) {
            logger.error((Object)responseString);
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Timestamp getTimestamp(JSONObject articleObject) {
        try {
            String entity_type = articleObject.getString("entity-type");
            String time = null;
            try {
                if ("Article".equals(entity_type)) {
                    time = articleObject.getString("knowledgeUpdatedAt");
                    return new Timestamp(Long.valueOf(time));
                }
                if ("Question".equals(entity_type)) {
                    JSONObject answer = articleObject.getJSONObject("answer");
                    time = answer.getString("knowledgeUpdatedAt");
                    return new Timestamp(Long.valueOf(time));
                }
            }
            catch (Throwable e) {
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    return new Timestamp(format.parse(time).getTime());
                }
                catch (Throwable e1) {
                    logger.error((Object)e.getMessage(), e);
                    return new Timestamp(System.currentTimeMillis());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)(" getTimestamp" + e.getMessage()), (Throwable)e);
            return null;
        }
        return new Timestamp(System.currentTimeMillis());
    }

    public class GetNewArticleTask
    implements Runnable {
        private PlayWithTaxRequestInfo requestInfo = null;
        private CountDownLatch latch = null;

        public GetNewArticleTask(PlayWithTaxRequestInfo requestInfo, CountDownLatch latch) {
            this.requestInfo = requestInfo;
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                PlayWithTax.this.getNewArticle(this.requestInfo);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

