/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.help.tipHelp.client;

import com.kingdee.bos.ctrl.common.util.FontUtil;
import com.kingdee.bos.ctrl.kdf.util.render.AbstractBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.CellIconRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTip;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class TMCellTextIconRender
extends AbstractBasicRender {
    protected int spacing = 6;
    protected ImageIcon helpIcon = null;
    private static CellIconRender iconRender = new CellIconRender();
    private Rectangle rView = new Rectangle();
    private Rectangle rText = new Rectangle(0, 0, 0, 0);

    private Font readyFont(Graphics2D g, String text, Style style) {
        Font font = FontUtil.getDefaultFont();
        if (font == null) {
            font = style.getKDFont();
            font = FontUtil.validateFont((String)text, (Font)font);
        }
        Color fontColor = style.getFontColor();
        if (!this.isBlackWhite() || fontColor.getBlue() == fontColor.getRed() && fontColor.getBlue() == fontColor.getGreen()) {
            g.setColor(fontColor);
        } else {
            g.setColor(Color.BLACK);
        }
        g.setFont(font);
        return font;
    }

    public void draw(Graphics g, Shape clip, Object value, Style style) {
        if (this.helpIcon == null) {
            String path = "image/" + this.getUserColorName() + "/Table_Help.png";
            URL url = TMToolTip.class.getResource(path);
            this.helpIcon = new ImageIcon(url);
            this.helpIcon.setImage(this.helpIcon.getImage().getScaledInstance(23, 15, 4));
        }
        if (!(clip instanceof Rectangle2D)) {
            return;
        }
        Rectangle2D rect = clip.getBounds2D();
        double rx = rect.getX();
        double ry = rect.getY();
        double rw = rect.getWidth();
        double rh = rect.getHeight();
        String text = String.valueOf(value);
        Graphics2D g2d = (Graphics2D)g;
        Font font = this.readyFont(g2d, text, style);
        g2d.setColor(style.getFontColor());
        g2d.setFont(font);
        LineMetrics lm = font.getLineMetrics(text, g2d.getFontRenderContext());
        float fontHeight = lm.getAscent() + lm.getDescent();
        Rectangle2D fontRect = font.getStringBounds(text, g2d.getFontRenderContext());
        double fontWidth = fontRect.getWidth();
        this.rView.x = (int)rx;
        this.rView.y = (int)ry;
        this.rView.width = (int)rw;
        this.rView.height = (int)rh;
        text = SwingUtilities.layoutCompoundLabel(g.getFontMetrics(), text, null, 0, 0, 0, 0, this.rView, this.rText, this.rText, 0);
        double x = 0.0;
        double y = 0.0;
        Styles.HorizontalAlignment hAlign = style.getHorizontalAlign();
        Styles.VerticalAlignment vAlign = style.getVerticalAlign();
        if (vAlign == Styles.VerticalAlignment.TOP) {
            y = ry + (double)lm.getAscent();
        } else if (vAlign == Styles.VerticalAlignment.BOTTOM) {
            y = ry + rh - 1.0 - (double)lm.getDescent();
        } else {
            float clipCenter = (float)rh / 2.0f;
            float fontCenter = fontHeight / 2.0f;
            y = ry + (double)(clipCenter - fontCenter) + (double)lm.getAscent() - 1.0;
        }
        if (hAlign == Styles.HorizontalAlignment.LEFT) {
            x = rx;
        } else if (hAlign == Styles.HorizontalAlignment.RIGHT) {
            x = rx + rw - 1.0 - fontWidth;
        } else {
            double clipCenter = rw / 2.0;
            double fontCenter = fontWidth / 2.0;
            x = rx + (clipCenter - fontCenter);
        }
        Shape oldClip = g2d.getClip();
        g2d.setClip(clip);
        g2d.drawString(text, (float)x, (float)y);
        if (rw > fontWidth + (double)this.spacing + (double)this.helpIcon.getIconWidth()) {
            this.rView.x = (int)(x + fontWidth + (double)this.spacing);
            this.rView.y = (int)ry;
            this.rView.width = this.helpIcon.getIconWidth();
            this.rView.height = (int)rh;
            iconRender.draw(g, (Shape)this.rView, (Object)this.helpIcon, style);
        }
        g2d.setClip(oldClip);
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    private String getUserColorName() {
        int colorStyle = UIConfig.getUiColorStyle();
        String color = "blue";
        switch (colorStyle) {
            case 2: {
                color = "orange";
                break;
            }
            case 0: {
                color = "green";
                break;
            }
            case 4: {
                color = "red";
            }
        }
        return color;
    }
}

