/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.help.tipHelp.client;

import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDEditorPane;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TMToolTipAreaCtrl
extends KDScrollPane
implements IKDComponent {
    private static final long serialVersionUID = -3074674137433184026L;
    protected static final Insets MARGIN = new Insets(2, 5, 2, 5);
    protected static final int DEFAULTHEIGHT = 82;
    protected static final int DEFAULTWIDTH = 170;
    public static final int STYLE_VSCROLLBAR_AS_NEEDED = 1;
    public static final int STYLE_VSCROLLBAR_NEVER = 2;
    public static final int STYLE_VSCROLLBAR_ALWAYS = 4;
    public static final int STYLE_HSCROLLBAR_AS_NEEDED = 16;
    public static final int STYLE_HSCROLLBAR_NEVER = 32;
    public static final int STYLE_HSCROLLBAR_ALWAYS = 64;
    protected KDEditorPane ta;
    protected TextAreaCtrlFocusHandler listener = new TextAreaCtrlFocusHandler(this);
    protected String toolTipTxt;
    protected Object userObject = null;

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    private int getVerticalScrollBarPolicy(int style) {
        if ((style & 1) != 0) {
            return 20;
        }
        if ((style & 2) != 0) {
            return 21;
        }
        if ((style & 4) != 0) {
            return 22;
        }
        return 20;
    }

    private int getHorizontalScrollBarPolicy(int style) {
        if ((style & 0x10) != 0) {
            return 30;
        }
        if ((style & 0x20) != 0) {
            return 31;
        }
        if ((style & 0x40) != 0) {
            return 32;
        }
        return 30;
    }

    protected void init(int style) {
        this.ta = new KDEditorPane();
        this.ta.setMargin(MARGIN);
        this.ta.addFocusListener((FocusListener)this.listener);
        this.ta.setForeground(new Color(119, 119, 119));
        this.ta.setSelectedTextColor(Color.white);
        this.ta.setBackground(new Color(252, 251, 223));
        this.ta.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.ta.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && e.getURL() != null && !StringUtils.isEmpty((String)e.getURL().toString())) {
                    FrameWorkUtils.openByDefaultBrowser((String)e.getURL().toString());
                }
            }
        });
        this.addFocusListener(this.listener);
        this.setViewportView((Component)this.ta);
        this.setVerticalScrollBarPolicy(this.getVerticalScrollBarPolicy(style));
        this.setHorizontalScrollBarPolicy(this.getHorizontalScrollBarPolicy(style));
        this.setBorder(KingdeeBorders.createEditorBorder());
        JScrollBar bar = this.getHorizontalScrollBar();
        if (bar != null) {
            bar.setFocusable(false);
        }
        if ((bar = this.getVerticalScrollBar()) != null) {
            bar.setFocusable(false);
        }
    }

    public TMToolTipAreaCtrl(int style) {
        this.init(style);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        JScrollBar bar = this.getHorizontalScrollBar();
        if (bar != null) {
            bar.setEnabled(enabled);
        }
        if ((bar = this.getVerticalScrollBar()) != null) {
            bar.setEnabled(enabled);
        }
        this.ta.setEnabled(enabled);
    }

    public boolean hasFocus() {
        boolean br = super.hasFocus();
        if (!br) {
            br = this.ta.hasFocus();
        }
        return br;
    }

    public TMToolTipAreaCtrl() {
        this.init(0);
    }

    public Dimension getPreferredSize() {
        Dimension d = new Dimension(170, 82);
        return d;
    }

    public KDEditorPane getTextComponent() {
        return this.ta;
    }

    public void setDocument(Document doc) {
        this.ta.setDocument(doc);
    }

    public Document getDocument() {
        return this.ta.getDocument();
    }

    public void replaceSelection(String content) {
        this.ta.replaceSelection(content);
    }

    public String getText(int offs, int len) throws BadLocationException {
        return this.ta.getText(offs, len);
    }

    public void cut() {
        this.ta.cut();
    }

    public void copy() {
        this.ta.copy();
    }

    public void paste() {
        this.ta.paste();
    }

    public void moveCaretPosition(int pos) {
        this.ta.moveCaretPosition(pos);
    }

    public void setCaretPosition(int position) {
        this.ta.setCaretPosition(position);
    }

    public int getCaretPosition() {
        return this.ta.getCaretPosition();
    }

    public void setText(String toolTipTxt, String url) {
        StringBuffer newToolTip = new StringBuffer();
        newToolTip.append("<html><body>");
        newToolTip.append("<font style = \"font-family:\u5b8b\u4f53;font-size:10px\">" + toolTipTxt);
        if (!TMCommonUtil.isEmpty(url)) {
            newToolTip.append(" ");
            String[] urls = url.split(";");
            newToolTip.append("<a style = \"font-family:\u5b8b\u4f53;font-size:10px;color:#1E73EB\";href=\"" + urls[1] + "\">" + urls[0] + "</a>");
        }
        newToolTip.append("</body></html>");
        this.ta.setContentType("text/html");
        this.ta.setText(newToolTip.toString());
        this.ta.setEditable(false);
        this.ta.setCaretPosition(0);
    }

    public String getSelectedText() {
        return this.ta.getSelectedText();
    }

    public int getSelectionStart() {
        return this.ta.getSelectionStart();
    }

    public void setSelectionStart(int selectionStart) {
        this.ta.setSelectionStart(selectionStart);
    }

    public int getSelectionEnd() {
        return this.ta.getSelectionEnd();
    }

    public void setSelectionEnd(int selectionEnd) {
        this.ta.setSelectionEnd(selectionEnd);
    }

    public void select(int selectionStart, int selectionEnd) {
        this.ta.select(selectionStart, selectionEnd);
    }

    public void selectAll() {
        this.ta.selectAll();
    }

    public boolean isEditable() {
        return this.ta.isEditable();
    }

    public void setEditable(boolean b) {
        this.ta.setEditable(b);
    }

    protected static class TextAreaCtrlFocusHandler
    implements FocusListener {
        protected TMToolTipAreaCtrl tac;

        public TextAreaCtrlFocusHandler(TMToolTipAreaCtrl comp) {
            this.tac = comp;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.tac.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.tac.repaint();
        }
    }
}

