/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.help.tipHelp.client.util;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTCellPosition;
import com.kingdee.bos.ctrl.kdf.table.KDTView;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMCellTextIconRender;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTip;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTipInfo;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTipManager;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;

public class TMToolTipUtil {
    public static void setToolTipInfo(JComponent component, TMToolTipInfo info) {
        ArrayList<TMToolTipInfo> infoList = new ArrayList<TMToolTipInfo>();
        infoList.add(info);
        TMToolTipUtil.setToolTipInfo(component, infoList);
    }

    public static JToolTip createToolTip(JComponent component, String toolTipTxt, String url) {
        TMToolTip tip = new TMToolTip(toolTipTxt, url);
        tip.setComponent(component);
        return tip;
    }

    public static void setToolTipInfo(JComponent component, final List<TMToolTipInfo> infoList) {
        if (infoList.size() == 0) {
            return;
        }
        if (component instanceof KDLabelContainer) {
            KDLabelContainer container = (KDLabelContainer)component;
            TMToolTipInfo info = infoList.get(0);
            if (info != null) {
                String text = JSON.toJSONString((Object)info);
                TMToolTipUtil.setToolTipText(container.getBoundLabel(), text);
                JButton btn = TMToolTipUtil.createToolTipButton();
                container.add((Component)btn, (Object)"button");
                if ("contRemark".equals(container.getName())) {
                    btn.setBounds(TMToolTipUtil.getStringlength(container.getBoundLabelText()), container.getBounds().height - 20, 20, 20);
                } else {
                    btn.setBounds(TMToolTipUtil.getStringlength(container.getBoundLabelText()), 0, 20, 20);
                }
                container.repaint();
            } else {
                TMToolTipUtil.setToolTipText(container.getBoundLabel(), null);
            }
        } else if (component instanceof KDTable) {
            final KDTable table = (KDTable)component;
            final KDTView headView = (KDTView)table.getViewManager().getView(2);
            final HashMap<String, TMToolTipInfo> toolTipInfoMap = new HashMap<String, TMToolTipInfo>();
            TMToolTipInfo TMToolTipInfo2 = null;
            KDTCell cell = null;
            int size = infoList.size();
            block0: for (int i = 0; i < size; ++i) {
                TMToolTipInfo2 = infoList.get(i);
                toolTipInfoMap.put(TMToolTipInfo2.getName(), TMToolTipInfo2);
                cell = table.getHead().getRow(0).getCell(table.getColumnIndex(TMToolTipInfo2.getName()));
                if (TMCommonUtil.isEmpty(TMToolTipInfo2.getText())) {
                    cell.setRenderer(null);
                    continue;
                }
                if (cell == null) {
                    ArrayList cells = table.getHead().getRow(0).getCells();
                    for (int j = 0; j < cells.size(); ++j) {
                        if (!(cells.get(j) instanceof KDTCell) || !TMToolTipInfo2.getName().equals(((KDTCell)cells.get(j)).getValue())) continue;
                        ((KDTCell)cells.get(j)).setRenderer((IBasicRender)new TMCellTextIconRender());
                        continue block0;
                    }
                    continue;
                }
                cell.setRenderer((IBasicRender)new TMCellTextIconRender());
            }
            headView.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    TMToolTipInfo info;
                    KDTCellPosition cellPosition = headView.getCellPosition(e.getX(), e.getY());
                    String fieldName = table.getColumnKey(cellPosition.colIndex);
                    if (fieldName == null && cellPosition.colIndex >= 0) {
                        fieldName = (String)table.getHead().getRow(cellPosition.rowIndex).getCell(cellPosition.colIndex).getValue();
                    }
                    if ((info = (TMToolTipInfo)toolTipInfoMap.get(fieldName)) != null) {
                        String text = JSON.toJSONString((Object)info);
                        TMToolTipUtil.setToolTipText((JComponent)headView, text);
                    } else {
                        TMToolTipUtil.setToolTipText((JComponent)headView, null);
                    }
                }
            });
            table.addKDTMouseListener(new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 1 && e.getType() == 0) {
                        TMToolTipInfo TMToolTipInfo2 = null;
                        KDTCell cell = null;
                        int index = -1;
                        int size = infoList.size();
                        for (int i = 0; i < size; ++i) {
                            TMToolTipInfo2 = (TMToolTipInfo)infoList.get(i);
                            toolTipInfoMap.put(TMToolTipInfo2.getName(), TMToolTipInfo2);
                            index = table.getColumnIndex(TMToolTipInfo2.getName());
                            if (table.getColumn(index).isSortable() && index == e.getColIndex()) continue;
                            cell = table.getHead().getRow(0).getCell(table.getColumnIndex(TMToolTipInfo2.getName()));
                            cell.setRenderer((IBasicRender)new TMCellTextIconRender());
                        }
                        table.repaint();
                    }
                }
            });
        } else if (component instanceof KDCheckBox) {
            TMToolTipInfo info = infoList.get(0);
            if (info != null) {
                String text = JSON.toJSONString((Object)info);
                TMToolTipUtil.setToolTipText(component, text);
            } else {
                TMToolTipUtil.setToolTipText(component, null);
            }
        } else if (component instanceof KDButton) {
            TMToolTipInfo info = infoList.get(0);
            if (info != null) {
                String text = JSON.toJSONString((Object)info);
                TMToolTipUtil.setToolTipText(component, text);
            } else {
                TMToolTipUtil.setToolTipText(component, null);
            }
        } else if (component instanceof KDMenuItem) {
            TMToolTipInfo info = infoList.get(0);
            if (info != null) {
                String text = JSON.toJSONString((Object)info);
                TMToolTipUtil.setToolTipText(component, text);
            } else {
                TMToolTipUtil.setToolTipText(component, null);
            }
        } else {
            TMToolTipInfo info = infoList.get(0);
            if (info != null) {
                String text = JSON.toJSONString((Object)info);
                TMToolTipUtil.setToolTipText(component, text);
            } else {
                TMToolTipUtil.setToolTipText(component, null);
            }
        }
    }

    public static JButton createToolTipButton() {
        JButton btn = new JButton();
        Icon icon = TMToolTipUtil.findIconByPath("image/" + TMToolTipUtil.getUserColorName() + "/Help.png");
        btn.setIcon(icon);
        btn.setBorderPainted(false);
        btn.setBounds(0, 0, 30, 30);
        btn.setFocusable(false);
        return btn;
    }

    private static String getUserColorName() {
        int colorStyle = UIConfig.getUiColorStyle();
        String color = "blue";
        switch (colorStyle) {
            case 2: {
                color = "orange";
                break;
            }
            case 0: {
                color = "green";
                break;
            }
            case 4: {
                color = "red";
            }
        }
        return color;
    }

    private static Icon findIconByPath(String relativePath) {
        ImageIcon icon = null;
        URL url = TMToolTip.class.getResource(relativePath);
        if (url != null) {
            icon = new ImageIcon(url);
            icon.setImage(icon.getImage().getScaledInstance(icon.getIconWidth() * 4 / 5, icon.getIconHeight() * 4 / 5, 4));
        } else {
            icon = new ImageIcon(EASResource.getImage((String)"imgTbtn_help").getScaledInstance(15, 15, 4));
        }
        return icon;
    }

    public static void setToolTipText(JComponent component, String text) {
        String oldText = component.getToolTipText();
        component.setToolTipText(null);
        MouseListener[] mouseListeners = component.getMouseListeners();
        int size = mouseListeners.length;
        for (int j = 0; j < size; ++j) {
            if (!(mouseListeners[j] instanceof ToolTipManager)) continue;
            component.removeMouseListener(mouseListeners[j]);
        }
        component.putClientProperty("ToolTipText", text);
        TMToolTipManager toolTipManager = TMToolTipManager.sharedInstance();
        if (text != null) {
            if (oldText == null || !TMToolTipUtil.isCustomToolTip(oldText)) {
                toolTipManager.registerComponent(component);
            }
        } else {
            toolTipManager.unregisterComponent(component);
        }
    }

    public static boolean isCustomToolTip(String text) {
        return TMToolTipUtil.getToolTipInfo(text) != null;
    }

    public static TMToolTipInfo getToolTipInfo(String text) {
        TMToolTipInfo info = null;
        try {
            JSONObject json = new JSONObject(text);
            info = new TMToolTipInfo();
            info.setName(json.getString("name"));
            info.setText(json.getString("text"));
            info.setUrl(json.getString("url"));
        }
        catch (JSONException e) {
            return null;
        }
        return info;
    }

    public static int getStringlength(String value) {
        float valueLength = 5.0f;
        String chinese = "[\u4e00-\u9fa5]|\u3002|\uff1f|\uff01|\u3010|\u3011|\uff0c|\u3001|\uff1b|\uff1a|\u300c|\u300d|\u300e|\u300f|\u2019|\u201c|\u201d|\u2018|\uff08|\uff09|\u3014|\u3015|\u2026|\u2013|\uff0e|\u2014|\u300a|\u300b|\u3008|\u3009";
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                String temp = value.substring(i, i + 1);
                if (temp.matches(chinese)) {
                    valueLength = (float)((double)valueLength + 11.5);
                    continue;
                }
                valueLength += 8.0f;
            }
        }
        return (int)valueLength;
    }
}

