/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseImport;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckPurposeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckWayEnum;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CurrentAccountType;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceEntryCollection;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceEntryFactory;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceEntryInfo;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.IFullElectricInvoiceEntry;
import com.kingdee.eas.tm.common.invoicePool.TMDiscountType;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class FullElecInvoiceDataImport
extends CheckInvoiceBaseImport {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.FullElecInvoiceDataImport");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FullElectricInvoiceFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            logger.error((Object)bex);
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    @Override
    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        FullElectricInvoiceInfo head = (FullElectricInvoiceInfo)super.transmit(hsData, ctx);
        this.parseHead(hsData, ctx, head);
        FullElectricInvoiceEntryInfo entry = this.parseEntry(hsData, ctx, head);
        FullElectricInvoiceEntryCollection coll = head.getEntry();
        int collSize = coll.size();
        if (coll.size() > 0) {
            for (int i = 0; i < collSize; ++i) {
                FullElectricInvoiceEntryInfo entryInfo = coll.get(i);
                if (entryInfo.getSeq() == entry.getSeq()) {
                    coll.set(i, entry);
                } else {
                    if (entry.getSeq() <= collSize) continue;
                    coll.add(entry);
                }
                break;
            }
        } else {
            coll.add(entry);
        }
        return head;
    }

    private FullElectricInvoiceEntryInfo parseEntry(Map hsData, Context ctx, FullElectricInvoiceInfo head) throws TaskExternalException {
        BigDecimal decimalRate;
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        String FEntrySeq = ((DataToken)hsData.get((Object)"FEntry_seq")).data.toString();
        FullElectricInvoiceEntryInfo entry = this.getEntryInfo(ctx, mode, head, FEntrySeq);
        String goodsName = this.getString(hsData, "FEntry_goodsName");
        entry.setGoodsName(goodsName);
        entry.setSpecModel(this.getString(hsData, "FEntry_specModel"));
        entry.setTaxAmount(this.getBigDecimal(ctx, hsData, "FEntry_taxAmount"));
        String taxRate = this.getString(hsData, "FEntry_taxRate");
        if (taxRate != null && taxRate.length() > 0) {
            decimalRate = this.getBigDecimal(ctx, hsData, "FEntry_taxRate");
            if (decimalRate.compareTo(new BigDecimal(0)) <= -1 || decimalRate.compareTo(new BigDecimal(100)) >= 0) {
                throw new TaskExternalException(this.getResource(ctx, "TaxRateNotValid"));
            }
        } else {
            throw new TaskExternalException(this.getResource(ctx, "TaxRateNotNull"));
        }
        entry.setTaxRate(decimalRate.divide(new BigDecimal(100)));
        entry.setDetailAmount(this.getBigDecimal(ctx, hsData, "FEntry_detailAmount"));
        String amount = this.getString(hsData, "FEntry_amount");
        if (StringUtils.isEmpty((String)amount)) {
            throw new TaskExternalException(this.getResource(ctx, "AmountNotNull"));
        }
        entry.setAmount(this.getBigDecimal(ctx, hsData, "FEntry_amount"));
        String tccNum = this.getString(hsData, "FEntry_taxClassificationCode");
        if (StringUtils.isEmpty((String)tccNum)) {
            throw new TaskExternalException(this.getResource(ctx, "TccNotNull"));
        }
        entry.setTaxClassificationCode(this.getTaxClassificationCode(ctx, tccNum));
        entry.setDiscountType(TMDiscountType.NORMALROW);
        return entry;
    }

    private FullElectricInvoiceEntryInfo getEntryInfo(Context ctx, int mode, FullElectricInvoiceInfo head, String FSeq) throws TaskExternalException {
        FullElectricInvoiceEntryInfo info = new FullElectricInvoiceEntryInfo();
        if (mode == 16 || mode == 128) {
            String headId;
            String string = headId = head.getId() == null ? null : head.getId().toString();
            if (headId == null || StringUtils.isEmpty((String)FSeq)) {
                return info;
            }
            try {
                IFullElectricInvoiceEntry iFullElectricInvoiceEntry = FullElectricInvoiceEntryFactory.getLocalInstance(ctx);
                FullElectricInvoiceEntryCollection coll = iFullElectricInvoiceEntry.getFullElectricInvoiceEntryCollection("where parent.id = '" + headId + "' and seq = '" + FSeq + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                info.setSeq(Integer.valueOf(FSeq));
                return info;
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
        }
        if (mode == 8) {
            info.setSeq(head.getEntry().size() + 1);
            return info;
        }
        return new FullElectricInvoiceEntryInfo();
    }

    private String getTaxClassificationCode(Context ctx, String tccNum) throws TaskExternalException {
        String realTccNum = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FNumber FROM T_IM_TaxClassificationCode ");
            sql.append(" WHERE FMergeCode = '").append(tccNum).append("' ");
            sql.append(" AND FSumItem='N'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                realTccNum = tccNum;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        if (StringUtils.isEmpty((String)realTccNum)) {
            throw new TaskExternalException(this.getResource(ctx, "TccNotExist"));
        }
        return tccNum;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"FCompany_number", (Object)rs.getString("company.number"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceNo", (Object)rs.getString("invoiceNo"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceDate", (Object)rs.getString("invoiceDate"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceAmount", (Object)rs.getString("invoiceAmount"));
            DataImportTools.putToHashtable(result, (Object)"FTotalTaxAmount", (Object)rs.getString("totalTaxAmount"));
            DataImportTools.putToHashtable(result, (Object)"FTotalAmount", (Object)rs.getString("totalAmount"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceStatus", (Object)((Object)TMInvoiceStatus.getEnum(rs.getString("invoiceStatus"))));
            CurrentAccountType currentAccountType = CurrentAccountType.getEnum(rs.getString("currentAccountType"));
            DataImportTools.putToHashtable(result, (Object)"FCurrentAccountType", (Object)((Object)currentAccountType));
            DataImportTools.putToHashtable(result, (Object)"FCurrAcctSupplier_number", (Object)rs.getString("currAcctSupplier.number"));
            DataImportTools.putToHashtable(result, (Object)"FEntry_seq", (Object)rs.getString("entry.seq"));
            DataImportTools.putToHashtable(result, (Object)"FEntry_goodsName", (Object)rs.getString("entry.goodsName"));
            DataImportTools.putToHashtable(result, (Object)"FEntry_specModel", (Object)rs.getString("entry.specModel"));
            DataImportTools.putToHashtable(result, (Object)"FEntry_unit", (Object)rs.getString("entry.unit"));
            DataImportTools.putToHashtable(result, (Object)"FEntry_unitPrice", (Object)rs.getString("entry.unitPrice"));
            DataImportTools.putToHashtable(result, (Object)"FEntry_num", (Object)rs.getString("entry.num"));
            if (rs.getBigDecimal("entry.taxRate") != null) {
                DataImportTools.putToHashtable(result, (Object)"FEntry_taxRate", (Object)rs.getBigDecimal("entry.taxRate").multiply(new BigDecimal(100)));
            }
            DataImportTools.putToHashtable(result, (Object)"FEntry_taxAmount", (Object)rs.getString("entry.taxAmount"));
            DataImportTools.putToHashtable(result, (Object)"FEntry_detailAmount", (Object)rs.getString("entry.detailAmount"));
            DataImportTools.putToHashtable(result, (Object)"FEntry_amount", (Object)rs.getString("entry.amount"));
            DataImportTools.putToHashtable(result, (Object)"FEntry_taxClassificationCode", (Object)rs.getString("entry.taxClassificationCode"));
            DataImportTools.putToHashtable(result, (Object)"FBuyerTaxNo", (Object)rs.getString("buyerTaxNo"));
            DataImportTools.putToHashtable(result, (Object)"FSalerName", (Object)rs.getString("salerName"));
            DataImportTools.putToHashtable(result, (Object)"FSalerTaxNo", (Object)rs.getString("salerTaxNo"));
            DataImportTools.putToHashtable(result, (Object)"FProject_number", (Object)rs.getString("project.number"));
            DataImportTools.putToHashtable(result, (Object)"FRemark", (Object)rs.getString("remark"));
            TMInvoiceType invoiceType = TMInvoiceType.getEnum(rs.getString("invoiceType"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceType", (Object)((Object)invoiceType));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_effectiveTaxAmt", (Object)rs.getString("checkAbs.effectiveTaxAmt"));
            CheckStateEnum checkState = CheckStateEnum.getEnum(rs.getString("checkAbs.checkState"));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_checkState", (Object)((Object)checkState));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_checkTime", (Object)rs.getString("checkAbs.checkTime"));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs$checkUser_number", (Object)rs.getString("checkUser.number"));
            CheckPurposeEnum checkPurpose = CheckPurposeEnum.getEnum(rs.getString("checkAbs.checkPurpose"));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_checkPurpose", (Object)((Object)checkPurpose));
            CheckWayEnum checkWay = CheckWayEnum.getEnum(rs.getString("checkAbs.checkWay"));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_checkWay", (Object)((Object)checkWay));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs$taxPeriod_number", (Object)rs.getString("taxPeriod.number"));
            ConfirmStateEnum confirmState = ConfirmStateEnum.getEnum(rs.getString("checkAbs.confirmState"));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_confirmState", (Object)((Object)confirmState));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_confirmTime", (Object)rs.getString("checkAbs.confirmTime"));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs$confirmUser_number", (Object)rs.getString("confirmUser.number"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    private FullElectricInvoiceInfo parseHead(Map hsData, Context ctx, FullElectricInvoiceInfo head) throws TaskExternalException {
        FullElectricInvoiceInfo info = (FullElectricInvoiceInfo)super.parseHead(hsData, ctx, head);
        head.setInvoiceAmount(this.getBigDecimal(ctx, hsData, "FInvoiceAmount"));
        head.setTotalTaxAmount(this.getBigDecimal(ctx, hsData, "FTotalTaxAmount"));
        head.setTotalAmount(this.getBigDecimal(ctx, hsData, "FTotalAmount"));
        head.setBuyerName(this.getString(hsData, "FBuyerName"));
        String buyerTaxNo = this.getString(hsData, "FBuyerTaxNo");
        if (null != buyerTaxNo && buyerTaxNo.length() > 0) {
            head.setBuyerTaxNo(buyerTaxNo);
        }
        return head;
    }

    @Override
    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("checkAbs.effectiveTaxAmt"));
        sic.add(new SelectorItemInfo("checkAbs.checkState"));
        sic.add(new SelectorItemInfo("checkAbs.checkTime"));
        sic.add(new SelectorItemInfo("checkAbs.checkPurpose"));
        sic.add(new SelectorItemInfo("checkAbs.checkWay"));
        sic.add(new SelectorItemInfo("checkAbs.checkUser.number"));
        sic.add(new SelectorItemInfo("checkAbs.taxPeriod.number"));
        sic.add(new SelectorItemInfo("checkAbs.confirmState"));
        sic.add(new SelectorItemInfo("checkAbs.confirmTime"));
        sic.add(new SelectorItemInfo("checkAbs.confirmUser.number"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currAcctSupplier.number"));
        sic.add(new SelectorItemInfo("project.number"));
        return sic;
    }

    @Override
    protected CheckInvoiceBaseInfo createNewData(Context ctx) {
        FullElectricInvoiceInfo info = new FullElectricInvoiceInfo();
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        return info;
    }

    protected void beforeSubmit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        FullElectricInvoiceInfo info = (FullElectricInvoiceInfo)coreBaseInfo;
        this.recalculate(ctx, info);
    }

    private void recalculate(Context ctx, FullElectricInvoiceInfo info) throws TaskExternalException {
        FullElectricInvoiceEntryCollection entries = info.getEntry();
        int size = entries.size();
        if (size == 0) {
            return;
        }
        CompanyOrgUnitInfo company = info.getCompany();
        if (company == null) {
            return;
        }
        for (int idx = 0; idx < size; ++idx) {
            FullElectricInvoiceEntryInfo entry = entries.get(idx);
            BigDecimal taxRate = entry.getTaxRate();
            BigDecimal detailAmount = entry.getDetailAmount();
            BigDecimal taxAmt = entry.getTaxAmount();
            BigDecimal priceTax = entry.getAmount();
            if (taxRate != null && taxRate.compareTo(BigDecimal.ZERO) != 0) {
                if (detailAmount == null && priceTax != null) {
                    detailAmount = priceTax.divide(new BigDecimal(1).add(taxRate), 2, 6);
                    entry.setDetailAmount(detailAmount);
                }
                if (taxAmt == null && detailAmount != null) {
                    taxAmt = detailAmount.multiply(taxRate).setScale(2, 6);
                    entry.setTaxAmount(taxAmt);
                }
                if (detailAmount != null && priceTax == null) {
                    priceTax = detailAmount.multiply(new BigDecimal(1).add(taxRate)).setScale(2, 6);
                    entry.setTaxAmount(priceTax);
                }
            }
            if (detailAmount == null || taxAmt == null || priceTax == null || detailAmount.add(taxAmt).compareTo(priceTax) == 0) continue;
            throw new TaskExternalException(this.getResource(ctx, "FORMULA_CHECK"));
        }
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.common.invoicePool.app.FullElecInvoiceQuery";
    }
}

