/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.tm.common.invoicePool.BizBillTypeInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckTypeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckWayEnum;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.IInvoiceBase;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.TMCheckStatus;
import com.kingdee.eas.tm.common.invoicePool.TMExpendStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.TMSourceType;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.common.utils.CheckAbsUtil;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.common.utils.TMJsonParser;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class AbstractConverter {
    protected TMTraceLogger logger = TMLoggerFactory.getTraceLogger("AbstractConverter");
    protected Context ctx;
    protected CreateInvoiceParams params;
    protected JSONObject jsonObject;
    protected TMJsonParser parser;
    protected InvoiceBaseInfo model;

    public IObjectValue getModel() {
        return this.model;
    }

    public AbstractConverter(Context ctx, CreateInvoiceParams params, JSONObject jsonObject) {
        this.ctx = ctx;
        this.params = params;
        this.jsonObject = jsonObject;
        this.parser = new TMJsonParser(jsonObject);
    }

    public String parseInvoice() {
        String invoiceId = null;
        try {
            this.init();
            this.innerParse();
            this.parse();
            this.writeLog();
            this.defaultValue();
            invoiceId = this.addnew();
        }
        catch (Exception e) {
            this.logger.error(" [parseError] : " + e);
        }
        return invoiceId;
    }

    protected void defaultValue() {
        TMInvoiceType invoiceType;
        String number = this.model.getNumber();
        if (number == null || number.isEmpty()) {
            this.model.setNumber("_");
        }
        if ((invoiceType = this.model.getInvoiceType()) == null) {
            this.model.setInvoiceType(TMInvoiceType.INVOICETYPE_OTHER);
        }
        try {
            this.handleCompany(this.ctx, this.model);
            this.handleSupplier(this.ctx, this.model);
        }
        catch (Exception e) {
            this.logger.error(e);
        }
    }

    protected void init() {
        try {
            String serialNo = this.parser.getString("serialNo");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            TMInvoiceType invoiceType = (TMInvoiceType)this.parser.getEnum(TMInvoiceType.class, "invoiceType");
            String invoiceCode = this.parser.getString("invoiceCode");
            if (invoiceCode != null && (" ".equals(invoiceCode) || invoiceCode.equals(""))) {
                invoiceCode = null;
            }
            String invoiceNo = this.parser.getString("invoiceNo");
            if (invoiceType != TMInvoiceType.INVOICETYPE_OTHER) {
                filter.getFilterItems().add(new FilterItemInfo("serialNo", (Object)serialNo, CompareType.EQUALS));
            } else {
                if (invoiceCode == null) {
                    filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.IS));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
                }
                filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)invoiceNo, CompareType.EQUALS));
            }
            viewInfo.setFilter(filter);
            BOSObjectType bosObjectType = BOSObjectType.create((String)this.getBosType());
            IInvoiceBase iInvoiceBase = (IInvoiceBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosObjectType);
            CoreBaseCollection colls = iInvoiceBase.getCollection(viewInfo);
            if (colls != null && colls.size() > 0) {
                this.model = (InvoiceBaseInfo)colls.get(0);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    protected void innerParse() {
        String invoiceCode;
        String serialNo = this.parser.getString("serialNo");
        if (!this.isCreateFromDownLoad()) {
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            String companyID = null;
            if (this.params.containsKey("entryIDs")) {
                String entryID = (String)((Map)this.params.get("entryIDs")).get(serialNo);
                companyID = (String)((Map)this.params.get("companyIDs")).get(serialNo);
                this.model.setBizBillEntryID(entryID);
            } else {
                companyID = this.params.getCompanyID();
            }
            if (!this.isNotUpdateCompany(this.model)) {
                if (companyID != null && !companyID.isEmpty()) {
                    company.setId(BOSUuid.read((String)companyID));
                }
                this.model.setCompany(company);
            }
            this.model.setBizBillID(this.params.getBizBillID());
            this.model.setBizBillNumber(this.params.getBillNumber());
            if (this.params.getBizBillTypeID() != null && !this.params.getBizBillTypeID().isEmpty()) {
                BizBillTypeInfo bizBill = new BizBillTypeInfo();
                bizBill.setId(BOSUuid.read((String)this.params.getBizBillTypeID()));
                this.model.setBizBillType(bizBill);
            }
            this.model.setSourceType(this.params.getSourceType());
        } else {
            this.model.setSourceType(TMSourceType.PWYDOWNLOAD);
        }
        if (!this.model.isIsBusiness()) {
            this.model.setIsBusiness(false);
        }
        if (!this.model.isIsPayment()) {
            this.model.setIsPayment(false);
        }
        this.model.setInvoiceType((TMInvoiceType)this.parser.getEnum(TMInvoiceType.class, "invoiceType"));
        if (!StringUtils.isEmpty((String)serialNo)) {
            this.model.setSerialNo(serialNo);
        }
        if ((invoiceCode = this.parser.getString("invoiceCode")) != null && " ".equals(invoiceCode)) {
            invoiceCode = null;
        }
        this.model.setInvoiceCode(invoiceCode);
        String invoiceNo = this.parser.getString("invoiceNo");
        this.model.setInvoiceNo(invoiceNo);
        if (StringUtils.isEmpty((String)invoiceCode)) {
            this.model.setNumber(invoiceNo);
        } else {
            this.model.setNumber(invoiceCode + "_" + invoiceNo);
        }
        this.model.setTotalAmount(this.parser.getBigDecimal("totalAmount"));
        this.model.setInvoiceDate(this.parser.getDate("invoiceDate"));
        if (!TMCommonUtil.isEmpty(this.parser.getString("remark"))) {
            this.model.setRemark(this.handleRemark(this.parser.getString("remark")));
        }
        this.model.setExpendStatus((TMExpendStatus)this.parser.getEnum(TMExpendStatus.class, "expendStatus"));
        this.model.setBillCreateTime(this.parser.getDate("billCreateTime"));
        this.model.setCheckStatus((TMCheckStatus)this.parser.getEnum(TMCheckStatus.class, "checkStatus"));
        if (!TMCommonUtil.isEmpty(this.parser.getString("downloadUrl"))) {
            this.model.setDownloadUrl(this.parser.getString("downloadUrl"));
        }
        if (!TMCommonUtil.isEmpty(this.parser.getString("pdfurl"))) {
            this.model.setPdfurl(this.parser.getString("pdfurl"));
        }
        if (!TMCommonUtil.isEmpty(this.parser.getString("kdcloudUrl"))) {
            this.model.setKdcloudUrl(this.parser.getString("kdcloudUrl"));
        }
        if (!TMCommonUtil.isEmpty(this.parser.getString("snapshotUrl"))) {
            this.model.setSnapshotUrl(this.parser.getString("snapshotUrl"));
        }
    }

    private boolean isNotUpdateCompany(InvoiceBaseInfo invoiceInfo) {
        if (invoiceInfo.getBizBillID() != null) {
            return true;
        }
        if (invoiceInfo instanceof CheckInvoiceBaseInfo) {
            CheckInvoiceBaseInfo checkInvoiceBaseInfo = (CheckInvoiceBaseInfo)invoiceInfo;
            if (checkInvoiceBaseInfo.isIsAccept()) {
                return true;
            }
            if (checkInvoiceBaseInfo.isFiVouchered()) {
                return true;
            }
        }
        return false;
    }

    protected boolean isCreateFromDownLoad() {
        return this.params instanceof DownloadInvoiceParams;
    }

    protected void parseCheckAbs(CheckInvoiceBaseInfo invoice) {
        Timestamp selectTime = this.parser.getTimestamp("selectTime");
        String authenticateFlag = this.parser.getString("authenticateFlag");
        Timestamp selectAuthenticateTime = this.parser.getTimestamp("selectAuthenticateTime");
        Timestamp scanAuthenticateTime = this.parser.getTimestamp("scanAuthenticateTime");
        String deductionPurpose = this.parser.getString("deductionPurpose");
        String taxPeriod = this.parser.getString("taxPeriod");
        String salerName = this.parser.getString("salerName");
        String salerTaxNo = this.parser.getString("salerTaxNo");
        BigDecimal effectiveTaxAmount = this.parser.getBigDecimal("effectiveTaxAmount");
        CheckAbsInfo checkAbs = invoice.getCheckAbs();
        if (checkAbs == null) {
            checkAbs = CheckAbsUtil.createCheckAbs(invoice);
            invoice.setCheckAbs(checkAbs);
        }
        CheckStateEnum checkState = "0".equals(authenticateFlag) ? CheckStateEnum.Unchecked : CheckStateEnum.Checked;
        if (effectiveTaxAmount != null) {
            checkAbs.setEffectiveTaxAmt(effectiveTaxAmount);
        }
        checkAbs.setSalerName(salerName);
        checkAbs.setSalerTaxNo(salerTaxNo);
        checkAbs.setCheckState(checkState);
        if (CheckStateEnum.Checked.equals((Object)checkState)) {
            checkAbs.setCheckTime(selectTime);
            if ("3".equals(authenticateFlag)) {
                checkAbs.setCheckWay(CheckWayEnum.Scan);
                checkAbs.setConfirmTime(scanAuthenticateTime);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else if ("2".equals(authenticateFlag)) {
                checkAbs.setCheckWay(CheckWayEnum.Check);
                checkAbs.setConfirmTime(selectAuthenticateTime);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else if ("1".equals(authenticateFlag)) {
                checkAbs.setCheckWay(CheckWayEnum.Check);
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            } else {
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            }
            if (checkAbs.getCheckType() == null) {
                checkAbs.setCheckType(CheckTypeEnum.OFFLINE);
            }
            if (invoice.getCompany() == null) {
                checkAbs.put("taxPeriodStr", taxPeriod);
            } else {
                checkAbs.setTaxPeriod(CheckAbsUtil.getPeriodInfo(this.ctx, taxPeriod, invoice.getCompany()));
            }
            checkAbs.setCheckPurpose(CheckAbsUtil.getPurposeByValue(deductionPurpose));
        } else {
            checkAbs.setCheckTime(null);
            checkAbs.setCheckWay(null);
            checkAbs.setCheckPurpose(null);
            checkAbs.setCheckUser(null);
            checkAbs.setTaxPeriod(null);
            checkAbs.setConfirmTime(null);
            checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            checkAbs.setConfirmUser(null);
            checkAbs.setCheckType(null);
        }
    }

    protected void handleCompany(Context ctx, InvoiceBaseInfo invoiceInfo) throws BOSException, EASBizException {
        CheckInvoiceBaseInfo checkInvoiceBaseInfo;
        if (invoiceInfo.getCompany() != null && !this.isCreateFromDownLoad()) {
            return;
        }
        if (invoiceInfo.getBizBillID() != null) {
            return;
        }
        if (invoiceInfo instanceof CheckInvoiceBaseInfo) {
            checkInvoiceBaseInfo = (CheckInvoiceBaseInfo)invoiceInfo;
            if (checkInvoiceBaseInfo.isIsAccept()) {
                return;
            }
            if (checkInvoiceBaseInfo.isFiVouchered()) {
                return;
            }
        }
        if (this.isCreateFromDownLoad()) {
            DownloadInvoiceParams downloadParams = (DownloadInvoiceParams)this.params;
            String operation = (String)this.params.get("operation");
            if ("download".equals(operation) || "apDownload".equals(operation)) {
                String companyId = downloadParams.getCompanyId();
                if (!StringUtils.isEmpty((String)companyId)) {
                    CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                    invoiceInfo.setCompany(companyInfo);
                }
            } else {
                Map companyMap = downloadParams.getCompanyMap();
                if (companyMap != null) {
                    CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)companyMap.get(invoiceInfo.get("buyerAccount") == null ? "" : invoiceInfo.get("buyerAccount"));
                    if (companyInfo == null) {
                        companyInfo = (CompanyOrgUnitInfo)companyMap.get("");
                    }
                    invoiceInfo.setCompany(companyInfo);
                }
                String buyerTaxNo = invoiceInfo.getString("buyerTaxNo");
                if (invoiceInfo.getCompany() == null && !StringUtils.isEmpty((String)buyerTaxNo)) {
                    CompanyOrgUnitInfo companyInfo = TMCommonUtil.getCompanyOrgUnitByTaxNo(ctx, buyerTaxNo);
                    invoiceInfo.setCompany(companyInfo);
                }
                String companyId = downloadParams.getCompanyId();
                if (invoiceInfo.getCompany() == null && !StringUtils.isEmpty((String)companyId)) {
                    CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                    invoiceInfo.setCompany(companyInfo);
                }
            }
        }
        if (invoiceInfo instanceof CheckInvoiceBaseInfo && invoiceInfo.getCompany() != null && (checkInvoiceBaseInfo = (CheckInvoiceBaseInfo)invoiceInfo).getCheckAbs() != null && checkInvoiceBaseInfo.getCheckAbs().get("taxPeriodStr") != null) {
            checkInvoiceBaseInfo.getCheckAbs().setTaxPeriod(TMCommonUtil.getPeriodInfo(ctx, (String)checkInvoiceBaseInfo.getCheckAbs().get("taxPeriodStr"), invoiceInfo.getCompany()));
        }
    }

    protected void handleSupplier(Context ctx, InvoiceBaseInfo invoiceInfo) {
        if (invoiceInfo.getCompany() == null) {
            return;
        }
        if (invoiceInfo instanceof CheckInvoiceBaseInfo) {
            CheckInvoiceBaseInfo checkInvoiceBaseInfo = (CheckInvoiceBaseInfo)invoiceInfo;
            String taxNumber = checkInvoiceBaseInfo.getString("salerTaxNo");
            String companyId = checkInvoiceBaseInfo.getCompany().getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT SUPPLIER.FID AS id FROM T_BD_Supplier AS SUPPLIER ");
            sql.append(" LEFT OUTER JOIN  T_BD_SupplierCompanyInfo AS SUPCOMPANY ON  SUPPLIER.FID = SUPCOMPANY.FSupplierID ");
            sql.append(" WHERE SUPCOMPANY.FComOrgID = '").append(companyId).append("' ");
            sql.append(" AND SUPPLIER.FTaxRegisterNo = '").append(taxNumber).append("'");
            sql.append(" AND SUPPLIER.FUsedStatus= 1 ");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs.next()) {
                    SupplierInfo supplierInfo = new SupplierInfo();
                    supplierInfo.setId(BOSUuid.read((String)rs.getString("id")));
                    checkInvoiceBaseInfo.setCurrAcctSupplier(supplierInfo);
                } else {
                    checkInvoiceBaseInfo.setCurrAcctSupplier(null);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        }
    }

    public BigDecimal isNullToZero(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return (BigDecimal)value;
    }

    protected abstract void parse();

    public abstract String getBosType();

    protected abstract String addnew();

    protected void writeLog() {
        ArrayList msgList = this.parser.getMsgList();
        if (!msgList.isEmpty()) {
            this.logger.debug(this.jsonObject.toString());
            for (int i = 0; i < msgList.size(); ++i) {
                this.logger.debug(msgList.get(i));
            }
        }
    }

    protected String handleRemark(String remark) {
        if (StringUtils.isEmpty((String)remark)) {
            return null;
        }
        remark = remark.replace("&lt;br/&gt;", "\r\n");
        remark = remark.replace("<br/>", "\r\n");
        remark = remark.replace("&ampamp", "&");
        remark = StringEscapeUtils.unescapeHtml((String)remark);
        remark = StringEscapeUtils.unescapeHtml((String)remark);
        return remark;
    }
}

