/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.PlaneInvoiceEntryInfo;
import com.kingdee.eas.tm.common.invoicePool.PlaneInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.PlaneInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;

public class PlaneInvoiceConverter
extends AbstractConverter {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("PlaneInvoiceConverter");

    public PlaneInvoiceConverter(Context ctx, CreateInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
    }

    @Override
    protected void init() {
        super.init();
        if (this.model == null) {
            this.model = new PlaneInvoiceInfo();
        }
    }

    @Override
    public void parse() {
        PlaneInvoiceInfo invoice = (PlaneInvoiceInfo)this.model;
        invoice.setPrintNum(this.parser.getString("printNum"));
        invoice.setCustomerName(this.parser.getString("customerName"));
        invoice.setCustomerIdentityNum(this.parser.getString("customerIdentityNum"));
        invoice.setAirNum(this.parser.getString("airNum"));
        invoice.setInvoiceAmount(this.parser.getBigDecimal("invoiceAmount"));
        invoice.setTotalTaxAmount(this.parser.getBigDecimal("totalTaxAmount"));
        invoice.setAirportConstructionFee(this.parser.getBigDecimal("airportConstructionFee"));
        invoice.setFuelSurcharge(this.parser.getBigDecimal("fuelSurcharge"));
        invoice.setInsurancePremium(this.parser.getBigDecimal("insurancePremium"));
        invoice.setAirTime(this.parser.getString("airTime"));
        invoice.setFillingUnit(this.parser.getString("fillingUnit"));
        invoice.setElectronicTicketNum(this.parser.getString("electronicTicketNum"));
        invoice.setNumber(this.parser.getString("electronicTicketNum"));
        invoice.setSalesUnitCode(this.parser.getString("salesUnitCode"));
        invoice.setEndorsement(this.parser.getString("endorsement"));
        invoice.setPlaceOfDeparture(this.parser.getString("placeOfDeparture"));
        invoice.setDestination(this.parser.getString("destination"));
        invoice.setCarrier(this.parser.getString("carrier"));
        invoice.setFlightNum(this.parser.getString("flightNum"));
        invoice.setSeatGrade(this.parser.getString("seatGrade"));
        invoice.setCheckCode(this.parser.getString("checkCode"));
        this.parseEntry(invoice);
    }

    private void parseEntry(PlaneInvoiceInfo invoice) {
        try {
            if (invoice.getEntry().size() > 0) {
                return;
            }
            JSONArray items = this.parser.getJSONArray("items");
            if (items != null && items.length() > 0) {
                int size = items.length();
                for (int j = 0; j < size; ++j) {
                    JSONObject entry = items.getJSONObject(j);
                    this.parser.setJsonObject(entry);
                    PlaneInvoiceEntryInfo entryModel = new PlaneInvoiceEntryInfo();
                    entryModel.setPlaceOfDeparture(this.parser.getString("placeOfDeparture"));
                    entryModel.setDestination(this.parser.getString("destination"));
                    entryModel.setInvoiceDate(this.parser.getDate("invoiceDate"));
                    entryModel.setTakePlaneTime(this.parser.getString("takePlaneTime"));
                    entryModel.setCarrier(this.parser.getString("carrier"));
                    entryModel.setFlightNum(this.parser.getString("flightNum"));
                    entryModel.setSeatGrade(this.parser.getString("seatGrade"));
                    invoice.getEntry().add(entryModel);
                }
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    @Override
    protected String addnew() {
        String id = null;
        try {
            IObjectPK pk = PlaneInvoiceFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.model);
            id = pk.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return id;
    }

    @Override
    public String getBosType() {
        return "D8100831";
    }
}

