/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.TMAuthenticateFlag;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.VehicleInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.VehicleInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractDiskConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import java.math.BigDecimal;

public class VehicleInvoiceDiskConverter
extends AbstractDiskConverter {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("VehicleInvoiceDiskConverter");

    public VehicleInvoiceDiskConverter(Context ctx, DownloadInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
    }

    @Override
    protected void init() {
        super.init();
        if (this.model == null) {
            this.model = new VehicleInvoiceInfo();
        }
    }

    @Override
    protected void parse() {
        String salerName = this.parser.getString("salerName");
        String salerTaxNo = this.parser.getString("salerTaxNo");
        BigDecimal invoiceAmount = this.parser.getBigDecimal("invoiceAmount");
        BigDecimal taxAmount = this.parser.getBigDecimal("totalTaxAmount");
        String checkFlag = this.parser.getString("checkFlag");
        String selectTime = this.parser.getString("selectTime");
        Boolean checkAuthenticateFlag = this.parser.getBoolean("checkAuthenticateFlag");
        String selectAuthenticateTime = this.parser.getString("selectAuthenticateTime");
        Boolean scanAuthenticateFlag = this.parser.getBoolean("scanAuthenticateFlag");
        String scanAuthenticateTime = this.parser.getString("scanAuthenticateTime");
        VehicleInvoiceInfo invoice = (VehicleInvoiceInfo)this.model;
        invoice.setSalerName(salerName);
        invoice.setSalerTaxNo(salerTaxNo);
        invoice.setInvoiceMoney(invoiceAmount);
        invoice.setTotalTaxAmount(taxAmount);
        invoice.setTotalAmount(this.isNullToZero(invoice.getInvoiceMoney()).add(this.isNullToZero(invoice.getTotalTaxAmount())));
        TMInvoiceStatus tmInvoiceStatus = (TMInvoiceStatus)this.parser.getEnum(TMInvoiceStatus.class, "invoiceStatus");
        if (invoice.getInvoiceStatus() != null && !invoice.getInvoiceStatus().equals((Object)tmInvoiceStatus)) {
            invoice.put("statusChaged", true);
            invoice.put("oldStatus", invoice.getInvoiceStatus().getAlias());
            invoice.put("CurStatus", tmInvoiceStatus.getAlias());
        }
        invoice.setInvoiceStatus(tmInvoiceStatus);
        CheckAbsInfo checkAbs = invoice.getCheckAbs();
        checkAbs.setAmount(invoice.getInvoiceMoney());
        checkAbs.setTaxAmt(invoice.getTotalTaxAmount());
        checkAbs.setEffectiveTaxAmt(invoice.getTotalTaxAmount());
        CheckStateEnum checkState = this.getCheckStateEnum(checkFlag);
        if (CheckStateEnum.Checked.equals((Object)checkState)) {
            invoice.setSelectTime(selectTime);
            if (scanAuthenticateFlag.booleanValue()) {
                invoice.setScanAuthenticateTime(scanAuthenticateTime);
                invoice.setAuthenticateFlag(TMAuthenticateFlag.SCANAUTHENTICATE);
            } else if (checkAuthenticateFlag.booleanValue()) {
                invoice.setSelectAuthenticateTime(selectAuthenticateTime);
                invoice.setAuthenticateFlag(TMAuthenticateFlag.CHECKAUTHENTICATE);
            } else {
                invoice.setAuthenticateFlag(TMAuthenticateFlag.CHECK);
            }
        } else {
            invoice.setSelectTime(null);
            invoice.setAuthenticateFlag(TMAuthenticateFlag.UNCHECK);
            invoice.setSelectAuthenticateTime(null);
            invoice.setScanAuthenticateTime(null);
        }
    }

    @Override
    protected String addnew() {
        String id = null;
        try {
            this.ctx.put((Object)"disablePermissionForKScript", (Object)true);
            IObjectPK pk = VehicleInvoiceFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.model);
            id = pk.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            this.ctx.remove((Object)"disablePermissionForKScript");
        }
        return id;
    }

    @Override
    public String getBosType() {
        return "8F9D8961";
    }
}

