/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckPurposeEnum;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;

public class CheckAbsUtil {
    public static CheckAbsInfo createCheckAbs(Object invoice) {
        CheckAbsInfo checkAbs = new CheckAbsInfo();
        if (invoice instanceof CheckInvoiceBaseInfo) {
            CheckInvoiceBaseInfo info = (CheckInvoiceBaseInfo)invoice;
            BOSUuid bosid = BOSUuid.create((BOSObjectType)checkAbs.getBOSType());
            checkAbs.setId(bosid);
            checkAbs.setCompany(info.getCompany());
            if (info.getId() == null) {
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            }
            checkAbs.setInvoiceID(info.getId().toString());
            checkAbs.setInvoiceCode(info.getInvoiceCode());
            checkAbs.setInvoiceNo(info.getInvoiceNo());
            checkAbs.setInvoiceDate(info.getBizDate());
            checkAbs.setInvoiceState(TMInvoiceStatus.getEnum(info.getString("invoiceStatus")));
            if (checkAbs.getInvoiceType() == null) {
                checkAbs.setInvoiceType(TMInvoiceType.INVOICETYPE_SPECIAL_PAPER);
            }
        }
        return checkAbs;
    }

    public static CheckPurposeEnum getPurposeByValue(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        if ("1".equals(value)) {
            return CheckPurposeEnum.Deduct;
        }
        if ("2".equals(value)) {
            return CheckPurposeEnum.NonDeduct;
        }
        return CheckPurposeEnum.getEnum(value);
    }

    public static PeriodInfo getPeriodInfo(Context ctx, String value, CompanyOrgUnitInfo company) {
        try {
            if (value == null || value.trim().isEmpty()) {
                return null;
            }
            int period = Integer.valueOf(value);
            if (ctx == null) {
                return PeriodUtils.getPeriodInfo((int)(period / 100), (int)(period % 100), (CompanyOrgUnitInfo)company);
            }
            return PeriodUtils.getPeriodInfo((Context)ctx, (int)(period / 100), (int)(period % 100), (CompanyOrgUnitInfo)company);
        }
        catch (Exception e) {
            return null;
        }
    }
}

