/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMKBizTypeEnum;
import com.kingdee.eas.tm.im.IMakeInvoice;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.ProductCodeCollection;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.RowType;
import com.kingdee.eas.tm.im.RushRedReasonEnum;
import com.kingdee.eas.tm.im.SpecificInformationFactory;
import com.kingdee.eas.tm.im.SpecificInformationInfo;
import com.kingdee.eas.tm.im.SpecificServiceEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.ICustomerMailing;
import com.kingdee.eas.tm.im.common.billimport.IMBillImportBase;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MakeInvoiceDataImport
extends IMBillImportBase {
    private MakeInvoiceInfo makeInvoiceInfo = null;
    private int addressMaxLength = 100;
    private int remarkMaxLength = 230;
    private Pattern p = null;
    private static final int AMT_PRECISION = 2;
    private static final int PRICE_PRECISION = 10;
    private static final String resClassName = "com.kingdee.eas.tm.im.app.IMImportResource";
    private Hashtable firstData = null;

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MakeInvoiceFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    protected BigDecimal getValue(Context ctx, String key, Object data) throws TaskExternalException {
        String valStr = data.toString().trim();
        valStr = valStr.replaceAll("[\uff0c,]", "");
        String reg = "(^-?\\d+(\\.\\d+)?$)";
        if (data != null && valStr.length() > 0) {
            if (valStr.matches(reg)) {
                return new BigDecimal(valStr);
            }
            throw new TaskExternalException(IMUtils.getResource(resClassName, key, ctx));
        }
        return null;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String msg;
        int entrySize;
        this.makeInvoiceInfo = null;
        int k = 0;
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (k == 0) {
                try {
                    this.makeInvoiceInfo = this.transmitHead(lineData, ctx);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                if (this.makeInvoiceInfo == null) {
                    return null;
                }
            }
            MakeInvoiceEntryInfo entryInfo = null;
            try {
                entryInfo = this.transmitEntry(lineData, ctx);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            this.afterBuildEntry(entryInfo);
            ++k;
        }
        if (!this.makeInvoiceInfo.isIsList()) {
            try {
                entrySize = this.getEntrySize(ctx, this.makeInvoiceInfo.getInvoiceType().getValue(), this.makeInvoiceInfo.getCompany().getId().toString());
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            if (this.makeInvoiceInfo.getEntries().size() > entrySize) {
                msg = IMUtils.getResource(resClassName, "MAX_LISTSIZE", ctx);
                throw new TaskExternalException(MessageFormat.format(msg, entrySize));
            }
        } else {
            try {
                entrySize = this.getListMaxLineNo(ctx, this.makeInvoiceInfo, this.makeInvoiceInfo.getCompany().getId().toString());
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            if (this.makeInvoiceInfo.getEntries().size() > entrySize) {
                msg = IMUtils.getIMResource(ctx, "LISTLINENOOVERAGE", this.makeInvoiceInfo.getInvoiceType().getAlias(), String.valueOf(entrySize));
                throw new TaskExternalException(MessageFormat.format(msg, entrySize));
            }
        }
        MakeInvoiceEntryInfo mkEntryInfoCurr = null;
        MakeInvoiceEntryInfo mkEntryInfoMatch = null;
        MakeInvoiceEntryCollection entryColl = this.makeInvoiceInfo.getEntries();
        entryColl.sort();
        BigDecimal totalTaxAmt = BigDecimal.ZERO;
        for (int j = 0; j < entryColl.size(); ++j) {
            mkEntryInfoCurr = entryColl.get(j);
            totalTaxAmt = totalTaxAmt.add(mkEntryInfoCurr.getPriceTax());
        }
        if (totalTaxAmt.compareTo(BigDecimal.ZERO) < 0) {
            this.makeInvoiceInfo.setIsRedVoice(true);
            this.makeInvoiceInfo.setBlueInvoiceType(this.makeInvoiceInfo.getInvoiceType());
        } else {
            this.makeInvoiceInfo.setString("rushRedReason", null);
        }
        if (this.makeInvoiceInfo.isIsDiffTax()) {
            boolean isOneLine = true;
            if (entryColl.size() > 2 || entryColl.size() == 0) {
                isOneLine = false;
            } else if (entryColl.size() == 1) {
                isOneLine = true;
            } else if (entryColl.size() == 2 && RowType.NORMAL_ROW.equals((Object)entryColl.get(1).getBillRowType())) {
                isOneLine = false;
            }
            if (!isOneLine) {
                throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "DiffTaxOnlyOneLine", ctx.getOriginLocale()));
            }
            this.checkRemark(ctx);
        }
        for (int i = 0; i < entryColl.size(); ++i) {
            mkEntryInfoCurr = entryColl.get(i);
            if (RowType.NORMAL_ROW.equals((Object)mkEntryInfoCurr.getBillRowType())) continue;
            if (this.makeInvoiceInfo.isIsRedVoice()) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "BILLROWTYPEERROR_NOT_REDVOICE", ctx.getOriginLocale(), new Object[]{this.makeInvoiceInfo.getNumber(), mkEntryInfoCurr.getSeq()}));
            }
            if (RowType.DISCOUNTED_ROW.equals((Object)mkEntryInfoCurr.getBillRowType())) {
                if (i + 1 > entryColl.size() - 1) {
                    throw new TaskExternalException(IMUtils.getString(resClassName, "BILLROWTYPE_ERROR", ctx.getOriginLocale(), new Object[]{this.makeInvoiceInfo.getNumber(), mkEntryInfoCurr.getSeq()}));
                }
                mkEntryInfoMatch = entryColl.get(i + 1);
                if (RowType.DISCOUNT_ROW.equals((Object)mkEntryInfoMatch.getBillRowType())) continue;
                throw new TaskExternalException(IMUtils.getString(resClassName, "BILLROWTYPE_ERROR", ctx.getOriginLocale(), new Object[]{this.makeInvoiceInfo.getNumber(), mkEntryInfoCurr.getSeq()}));
            }
            if (!RowType.DISCOUNT_ROW.equals((Object)mkEntryInfoCurr.getBillRowType())) continue;
            if (i == 0) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "BILLROWTYPE_ERROR", ctx.getOriginLocale(), new Object[]{this.makeInvoiceInfo.getNumber(), mkEntryInfoCurr.getSeq()}));
            }
            mkEntryInfoMatch = entryColl.get(i - 1);
            if (!RowType.DISCOUNTED_ROW.equals((Object)mkEntryInfoMatch.getBillRowType())) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "BILLROWTYPE_ERROR", ctx.getOriginLocale(), new Object[]{this.makeInvoiceInfo.getNumber(), mkEntryInfoCurr.getSeq()}));
            }
            mkEntryInfoCurr.setSourceBillEntryId(mkEntryInfoMatch.getId().toString());
            mkEntryInfoCurr.setSpecs(null);
            mkEntryInfoCurr.setMeasureUnit(null);
            mkEntryInfoCurr.setMakeInvoiceUnit(null);
            mkEntryInfoCurr.setQuantity(null);
            mkEntryInfoCurr.setNoTaxPrice(null);
            mkEntryInfoCurr.setPrice(null);
            if (mkEntryInfoCurr.getNoTaxAmt().signum() != -1 || mkEntryInfoCurr.getTaxAmt().signum() == 1 || mkEntryInfoCurr.getPriceTax().signum() != -1) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "AMT_NOT_NEGATIVE", ctx.getOriginLocale(), new Object[]{this.makeInvoiceInfo.getNumber(), mkEntryInfoCurr.getSeq()}));
            }
            if (mkEntryInfoCurr.getNoTaxAmt().abs().compareTo(mkEntryInfoMatch.getNoTaxAmt()) > 0 || mkEntryInfoCurr.getTaxAmt().abs().compareTo(mkEntryInfoMatch.getTaxAmt()) > 0 || mkEntryInfoCurr.getPriceTax().abs().compareTo(mkEntryInfoMatch.getPriceTax()) > 0) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "DISCOUNTROWAMT_ERROR", ctx.getOriginLocale(), new Object[]{this.makeInvoiceInfo.getNumber(), mkEntryInfoCurr.getSeq()}));
            }
            if (!mkEntryInfoCurr.getProduceName().equals(mkEntryInfoMatch.getProduceName())) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "DISCOUNTROWPRODUCENAME_ERROR", ctx.getOriginLocale(), new Object[]{this.makeInvoiceInfo.getNumber(), mkEntryInfoCurr.getSeq()}));
            }
            if (!this.checkEntryProductName(mkEntryInfoCurr, mkEntryInfoMatch)) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "DISCOUNTROWENTRYNAME_ERROR", ctx.getOriginLocale(), new Object[]{this.makeInvoiceInfo.getNumber(), mkEntryInfoCurr.getSeq()}));
            }
            if (mkEntryInfoCurr.getTaxRate().compareTo(mkEntryInfoMatch.getTaxRate()) != 0) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "DISCOUNTROWTAXRATE_ERROR", ctx.getOriginLocale(), new Object[]{this.makeInvoiceInfo.getNumber(), mkEntryInfoCurr.getSeq()}));
            }
            if (mkEntryInfoCurr.getTaxClassificationCode().equals(mkEntryInfoMatch.getTaxClassificationCode())) continue;
            throw new TaskExternalException(IMUtils.getString(resClassName, "DISCOUNTROWTCC_ERROR", ctx.getOriginLocale(), new Object[]{this.makeInvoiceInfo.getNumber(), mkEntryInfoCurr.getSeq()}));
        }
        return this.makeInvoiceInfo;
    }

    private boolean checkEntryProductName(MakeInvoiceEntryInfo mkEntryInfoCurr, MakeInvoiceEntryInfo mkEntryInfoMatch) {
        if (mkEntryInfoCurr.getEntryName() == null && mkEntryInfoMatch.getEntryName() == null) {
            return true;
        }
        if (mkEntryInfoCurr.getEntryName() == null && mkEntryInfoMatch.getEntryName() != null) {
            return false;
        }
        if (mkEntryInfoCurr.getEntryName() != null && mkEntryInfoMatch.getEntryName() == null) {
            return false;
        }
        return mkEntryInfoCurr.getEntryName().getId().toString().equals(mkEntryInfoMatch.getEntryName().getId().toString());
    }

    protected void checkRemark(Context ctx) throws TaskExternalException {
        if (this.makeInvoiceInfo.isIsDiffTax()) {
            String remark = this.makeInvoiceInfo.getRemark();
            BigDecimal deductAmt = this.makeInvoiceInfo.getEntries().get(0).getDeductAmt();
            if (BigDecimal.ZERO.compareTo(deductAmt) <= 0) {
                Matcher m;
                if (this.p == null) {
                    this.p = Pattern.compile("^(\u5dee\u989d\u5f81\u7a0e\uff1a)[0-9]+(\\.)?([0-9])*\u3002");
                }
                String matchedString = null;
                if (!StringUtils.isEmpty((String)remark) && (m = this.p.matcher(remark)).find()) {
                    matchedString = m.group();
                }
                if (StringUtils.isEmpty(matchedString)) {
                    deductAmt = deductAmt.setScale(2, 4);
                    String lockRemarkString = EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"DiffTaxRemark", (Object[])new Object[]{deductAmt.toString()});
                    this.makeInvoiceInfo.setRemark(lockRemarkString + remark);
                } else {
                    String[] strArr = matchedString.split("\uff1a");
                    String deductAmtString = strArr[1];
                    String[] deductArr = (deductAmtString = deductAmtString.substring(0, deductAmtString.length() - 1)).split("\\.");
                    if (deductArr.length > 1 && deductArr[1] != null && deductArr[1].length() > 2) {
                        throw new TaskExternalException(IMUtils.getString(resClassName, "ImportRemarkDeductAmtError2", ctx.getOriginLocale()));
                    }
                    BigDecimal remarkDeductAmt = new BigDecimal(deductAmtString);
                    if (deductAmt.compareTo(remarkDeductAmt = remarkDeductAmt.setScale(2, 4)) != 0) {
                        throw new TaskExternalException(IMUtils.getString(resClassName, "ImportRemarkDeductAmtError1", ctx.getOriginLocale(), new Object[]{remarkDeductAmt.toString(), deductAmt.toString()}));
                    }
                    remark = remark.substring(matchedString.length(), remark.length());
                    String lockRemarkString = EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"DiffTaxRemark", (Object[])new Object[]{deductAmt.toString()});
                    this.makeInvoiceInfo.setRemark(lockRemarkString + remark);
                }
            } else {
                String lockRemarkString = EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"RedDiffTaxRemark");
                if (!remark.startsWith(lockRemarkString)) {
                    this.makeInvoiceInfo.setRemark(lockRemarkString + remark);
                }
            }
        }
    }

    private MakeInvoiceInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        String remark;
        String bankAccount;
        PersonInfo payPerson;
        String receiveCompany;
        this.makeInvoiceInfo = new MakeInvoiceInfo();
        this.makeInvoiceInfo.setFiVouchered(false);
        this.makeInvoiceInfo.setIsRedVoice(false);
        this.makeInvoiceInfo.setSrcSystem(InvoiceSrcSystem.EXCEL);
        this.makeInvoiceInfo.setBizType(IMKBizTypeEnum.EAS);
        this.makeInvoiceInfo.setCompany(this.getCompany(ctx, lineData));
        this.makeInvoiceInfo.setIsContainTax(false);
        this.makeInvoiceInfo.setIsRedVoicedBill(false);
        this.doNumber(ctx, lineData);
        this.makeInvoiceInfo.setInvoiceType(this.getInvoiceType(ctx, lineData));
        if (this.makeInvoiceInfo.getSpecificService() != null && !this.makeInvoiceInfo.getSpecificService().equals((Object)this.getSpecificService(ctx, lineData))) {
            SpecificInformationInfo specInfo = this.makeInvoiceInfo.getSpecificInformation();
            if (specInfo != null && specInfo.getId() != null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("specificInformation.id", (Object)specInfo.getId().toString(), CompareType.EQUALS));
                boolean isExist = MakeInvoiceFactory.getLocalInstance(ctx).exists(filter);
                if (isExist) {
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)specInfo.getId().toString(), CompareType.EQUALS));
                    SpecificInformationFactory.getLocalInstance(ctx).delete(filter);
                }
            }
            this.makeInvoiceInfo.setSpecificInformation(null);
        }
        this.makeInvoiceInfo.setSpecificService(this.getSpecificService(ctx, lineData));
        boolean isPurchaseInvoice = this.getBoolean(ctx, "ISPurchaseInvoice_ERROR", this.getString(lineData, "FIsPurchaseInvoice"));
        this.makeInvoiceInfo.setIsPurchaseInvoice(isPurchaseInvoice);
        if (isPurchaseInvoice && !PayInvoiceTypeEnum.COMMONINVOICE.equals((Object)this.makeInvoiceInfo.getInvoiceType()) && !PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)this.makeInvoiceInfo.getInvoiceType())) {
            throw new TaskExternalException(IMUtils.getIMResource(ctx, "INVOICETYPE_ERROR", new String[0]));
        }
        this.makeInvoiceInfo.setIsVehicle(this.getBoolean(ctx, "ISVehicle_ERROR", this.getString(lineData, "FIsVehicle")));
        if (this.makeInvoiceInfo.isIsPurchaseInvoice() && this.makeInvoiceInfo.isIsVehicle()) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "SGFP_REPEAT", ctx.getLocale()));
        }
        this.doCurrentAccountType(lineData, ctx);
        boolean hasCustomer = false;
        boolean hasSupplier = false;
        if (CurrentAccountType.CUSTOMER.equals((Object)this.makeInvoiceInfo.getCurrentAccountType())) {
            hasCustomer = this.setCustomer(lineData, ctx, this.makeInvoiceInfo);
        } else if (CurrentAccountType.SUPPLIER.equals((Object)this.makeInvoiceInfo.getCurrentAccountType())) {
            hasSupplier = this.setSupplier(lineData, ctx, this.makeInvoiceInfo);
        }
        boolean setCustTax = hasCustomer;
        boolean setSuppler = hasSupplier;
        boolean isValueAddedTaxinv = this.makeInvoiceInfo.getInvoiceType().getValue().equals("1") || this.makeInvoiceInfo.getInvoiceType().getValue().equals("3");
        String TaxNumber = this.getTaxNumber(ctx, lineData, isValueAddedTaxinv);
        if (!TaxNumber.isEmpty()) {
            this.makeInvoiceInfo.setTaxNumber(TaxNumber);
            setCustTax = false;
            setSuppler = false;
        }
        if (!(receiveCompany = this.getReceiveCompany(lineData)).isEmpty()) {
            this.makeInvoiceInfo.setReceiveCompany(receiveCompany);
            setCustTax = false;
            setSuppler = false;
        }
        this.makeInvoiceInfo.setApplicateDate(this.getDate(ctx, lineData, "FApplicateDate"));
        if (this.makeInvoiceInfo.getApplicateDate() == null) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "APPLICATEDATE_NOT_NULL", ctx));
        }
        this.makeInvoiceInfo.setInvoiceDate(this.getDate(ctx, lineData, "FInvoiceDate"));
        UserInfo drawerInfo = this.getUserFromNumber(ctx, this.getString(lineData, "FDrawertxt"));
        if (drawerInfo == null) {
            this.makeInvoiceInfo.setDrawertxt(this.getString(lineData, "FDrawertxt"));
        } else {
            this.makeInvoiceInfo.setDrawertxt(drawerInfo.getName());
        }
        UserInfo checkerInfo = this.getUserFromNumber(ctx, this.getString(lineData, "FChecktxt"));
        if (checkerInfo == null) {
            this.makeInvoiceInfo.setChecktxt(this.getString(lineData, "FChecktxt"));
        } else {
            this.makeInvoiceInfo.setChecktxt(checkerInfo.getName());
        }
        UserInfo auditInfo = this.getUserFromNumber(ctx, this.getString(lineData, "FAuditor_number"));
        if (auditInfo != null) {
            this.makeInvoiceInfo.setAuditor(auditInfo);
        }
        if ((payPerson = this.getPersonFromNumber(ctx, this.getString(lineData, "FPayeetxt"))) == null) {
            this.makeInvoiceInfo.setPayeetxt(this.getString(lineData, "FPayeetxt"));
        } else {
            this.makeInvoiceInfo.setPayeetxt(payPerson.getName());
        }
        String address = this.getString(lineData, "FAddress");
        if (address != null && !address.isEmpty()) {
            if (IMUtils.getStringlength(address) > this.addressMaxLength) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "ADDRESS_OVERLENGTH", ctx));
            }
            this.makeInvoiceInfo.setAddress(address);
            setCustTax = false;
            setSuppler = false;
        }
        if ((bankAccount = this.getString(lineData, "FBankAccount")) != null && !bankAccount.isEmpty()) {
            this.makeInvoiceInfo.setBankAccount(bankAccount);
            setCustTax = false;
            setSuppler = false;
        }
        if (IMUtils.getStringlength(remark = this.getString(lineData, "FRemark")) > this.remarkMaxLength) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "REMARK_OVERLENGTH", ctx));
        }
        this.makeInvoiceInfo.setRemark(this.getString(lineData, "FRemark"));
        if (this.getRushRedReason(ctx, lineData) == null) {
            this.makeInvoiceInfo.setString("rushRedReason", null);
        } else {
            this.makeInvoiceInfo.setRushRedReason(this.getRushRedReason(ctx, lineData));
        }
        this.makeInvoiceInfo.setIsList(this.getBoolean(ctx, "ISLIST_ERROR", this.getString(lineData, "FIsList")));
        if (PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)this.makeInvoiceInfo.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)this.makeInvoiceInfo.getInvoiceType())) {
            this.makeInvoiceInfo.setIsList(false);
        }
        boolean isDelete = this.getBoolean(ctx, "ISDELETE_ERROR", this.getString(lineData, "FIsDelete"));
        this.makeInvoiceInfo.setIsDelete(isDelete);
        if (isDelete) {
            this.makeInvoiceInfo.setDeleteDate(this.getDate(ctx, lineData, "FDeleteDate"));
            this.makeInvoiceInfo.setDeleteUser(this.getUserFromNumber(ctx, this.getString(lineData, "FDeleteUser_number")));
        }
        this.makeInvoiceInfo.setPlateNo(this.getString(lineData, "FPlateNo"));
        this.makeInvoiceInfo.setExtensionNo(this.getString(lineData, "FExtensionNo"));
        String status = this.getString(lineData, "FStatus");
        if (StringUtils.isEmpty((String)status)) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "STATUS_ERROR", ctx));
        }
        this.makeInvoiceInfo.setStatus(InvoiceBillStatus.getEnum(status));
        Iterator ite = InvoiceBillStatus.iterator();
        while (ite.hasNext()) {
            InvoiceBillStatus val = (InvoiceBillStatus)((Object)ite.next());
            if (!val.getAlias().equals(this.getString(lineData, "FStatus"))) continue;
            this.makeInvoiceInfo.setStatus(val);
            break;
        }
        if (this.makeInvoiceInfo.getStatus() == null) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "STATUS_ERROR", ctx));
        }
        if (this.makeInvoiceInfo.getStatus() != InvoiceBillStatus.TEMPSTROE && this.makeInvoiceInfo.getStatus() != InvoiceBillStatus.MAKED && this.makeInvoiceInfo.getStatus() != InvoiceBillStatus.DELETED) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "IMPORT_STATUS_ERROR", ctx));
        }
        if ((this.makeInvoiceInfo.getStatus() == InvoiceBillStatus.MAKED || this.makeInvoiceInfo.getStatus() == InvoiceBillStatus.DELETED) && this.makeInvoiceInfo.getInvoiceDate() == null) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "INVOICEDATE_ERROR", ctx));
        }
        String invoiceNumber = this.getString(lineData, "FInvoiceNumber");
        if (PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)this.makeInvoiceInfo.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)this.makeInvoiceInfo.getInvoiceType())) {
            invoiceNumber = "0";
        }
        this.makeInvoiceInfo.setInvoiceNumber(invoiceNumber);
        this.makeInvoiceInfo.setInvoiceNo(this.getString(lineData, "FInvoiceNo"));
        if (this.makeInvoiceInfo.getStatus() == InvoiceBillStatus.MAKED || this.makeInvoiceInfo.getStatus() == InvoiceBillStatus.DELETED) {
            if (StringUtils.isEmpty((String)this.makeInvoiceInfo.getInvoiceNo()) || StringUtils.isEmpty((String)this.makeInvoiceInfo.getInvoiceNumber())) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "INVOICENO_NOTNULL", ctx));
            }
        } else {
            this.makeInvoiceInfo.setInvoiceNumber(null);
            this.makeInvoiceInfo.setInvoiceNo(null);
            this.makeInvoiceInfo.setInvoiceDate(null);
            this.makeInvoiceInfo.setPlateNo(null);
            this.makeInvoiceInfo.setExtensionNo(null);
            this.makeInvoiceInfo.setAuditor(null);
        }
        if (!PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)this.makeInvoiceInfo.getInvoiceType()) && !PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)this.makeInvoiceInfo.getInvoiceType())) {
            if (this.makeInvoiceInfo.getInvoiceNumber() != null && this.makeInvoiceInfo.getInvoiceNumber().length() != 10 && this.makeInvoiceInfo.getInvoiceNumber().length() != 12) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "INVOICENUMBER_LENGTHERROR", ctx));
            }
            if (this.makeInvoiceInfo.getInvoiceNo() != null && this.makeInvoiceInfo.getInvoiceNo().length() != 8) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "INVOICENO_LENGTHERROR", ctx));
            }
        }
        if (this.makeInvoiceInfo.getStatus() != InvoiceBillStatus.DELETED && this.makeInvoiceInfo.isIsDelete() || this.makeInvoiceInfo.getStatus() == InvoiceBillStatus.DELETED && !this.makeInvoiceInfo.isIsDelete()) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "ISDELETE_ERROR", ctx));
        }
        if (setCustTax || setSuppler) {
            Map ret;
            IObjectValue customerTaxInfo;
            HashMap<String, String> params = new HashMap<String, String>();
            if (setSuppler) {
                params.put("customerId", this.makeInvoiceInfo.getCurrAcctSupplier().getId().toString());
            } else {
                params.put("customerId", this.makeInvoiceInfo.getCurrAcctCustomer().getId().toString());
            }
            params.put("currentAccountType", this.makeInvoiceInfo.getCurrentAccountType().getValue());
            params.put("invoiceType", this.makeInvoiceInfo.getInvoiceType().getValue());
            if (this.makeInvoiceInfo.getCompany() != null) {
                params.put("companyId", this.makeInvoiceInfo.getCompany().getId().toString());
            }
            if ((customerTaxInfo = (IObjectValue)(ret = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxInfo(params)).get("value")) != null) {
                this.makeInvoiceInfo.setReceiveCompany((String)customerTaxInfo.get("recCompanyName"));
                this.makeInvoiceInfo.setTaxNumber((String)customerTaxInfo.get("taxNumber"));
                this.makeInvoiceInfo.setAddress((String)customerTaxInfo.get("addressTel"));
                this.makeInvoiceInfo.setBankAccount((String)customerTaxInfo.get("bankAccount"));
            } else if (setSuppler) {
                SupplierInfo supplierInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(this.makeInvoiceInfo.getCurrAcctSupplier().getId()));
                this.makeInvoiceInfo.setTaxNumber(supplierInfo.getTaxRegisterNo());
                this.makeInvoiceInfo.setReceiveCompany(this.makeInvoiceInfo.getCurrAcctSupplier().getName());
            }
        } else if (this.makeInvoiceInfo.getReceiveCompany() == null || this.makeInvoiceInfo.getReceiveCompany().trim().isEmpty()) {
            IMException ex = new IMException(IMException.RECEIVECOMPANYISNULL);
            throw new TaskExternalException(ex.getMessage(), (Throwable)((Object)ex));
        }
        hasCustomer = this.handleRecInfo(lineData, ctx, hasCustomer);
        if (hasCustomer) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("comOrgUnitId", this.makeInvoiceInfo.getCompany() == null ? null : this.makeInvoiceInfo.getCompany().getId().toString());
            param.put("customerId", this.makeInvoiceInfo.getCurrAcctCustomer().getId().toString());
            ICustomerMailing iCustomerMailing = CustomerMailingFactory.getLocalInstance(ctx);
            Map entryMap = iCustomerMailing.getDefaultCustomerMailInfo(param);
            CustomerMailingEntryInfo cmEntryInfo = (CustomerMailingEntryInfo)entryMap.get("defaultEntry");
            if (cmEntryInfo != null) {
                this.makeInvoiceInfo.setDisInvoicer(cmEntryInfo.getContacts());
                this.makeInvoiceInfo.setCellphone(cmEntryInfo.getTelephone());
                this.makeInvoiceInfo.setMailNumber(cmEntryInfo.getPostalcode());
                this.makeInvoiceInfo.setRecBillComName(cmEntryInfo.getCompanyName());
                this.makeInvoiceInfo.setRecBillAdress(cmEntryInfo.getAddress());
                this.makeInvoiceInfo.setRecBillEmail(cmEntryInfo.getMailbox());
            }
        }
        return this.makeInvoiceInfo;
    }

    private boolean handleRecInfo(Hashtable lineData, Context ctx, boolean hasCustomer) throws TaskExternalException {
        String disInvoicer = this.getString(lineData, "FDisInvoicer");
        String cellphone = this.getString(lineData, "FCellphone");
        String mailNumber = this.getString(lineData, "FMailNumber");
        String recBillComName = this.getString(lineData, "FRecBillComName");
        String recBillAdress = this.getString(lineData, "FRecBillAdress");
        String recBillEmail = this.getString(lineData, "FRecBillEmail");
        if (!StringUtils.isEmpty((String)disInvoicer)) {
            hasCustomer = false;
            if (disInvoicer.length() > 128) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "FDisInvoicer_Error", ctx));
            }
        }
        if (!StringUtils.isEmpty((String)cellphone)) {
            hasCustomer = false;
            if (cellphone.length() > 16) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "FCellphone_Error", ctx));
            }
        }
        if (!StringUtils.isEmpty((String)mailNumber)) {
            hasCustomer = false;
            if (mailNumber.length() > 44) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "FMailNumber_Error", ctx));
            }
        }
        if (!StringUtils.isEmpty((String)recBillComName)) {
            hasCustomer = false;
            if (recBillComName.length() > 255) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "FRecBillComName_Error", ctx));
            }
        }
        if (!StringUtils.isEmpty((String)recBillAdress)) {
            hasCustomer = false;
            if (recBillAdress.length() > 255) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "FRecBillAdress_Error", ctx));
            }
        }
        if (!StringUtils.isEmpty((String)recBillEmail)) {
            hasCustomer = false;
            if (recBillEmail.length() > 60) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "FRecBillEmail_Error", ctx));
            }
        }
        this.makeInvoiceInfo.setDisInvoicer(disInvoicer);
        this.makeInvoiceInfo.setCellphone(cellphone);
        this.makeInvoiceInfo.setMailNumber(mailNumber);
        this.makeInvoiceInfo.setRecBillComName(recBillComName);
        this.makeInvoiceInfo.setRecBillAdress(recBillAdress);
        this.makeInvoiceInfo.setRecBillEmail(recBillEmail);
        return hasCustomer;
    }

    private void doCurrentAccountType(Hashtable lineData, Context ctx) throws TaskExternalException {
        String currentAccountType = this.getString(lineData, "FCurrentAccountType");
        if ("1".equals(currentAccountType) || CurrentAccountType.CUSTOMER.getAlias().equals(currentAccountType)) {
            currentAccountType = "1";
        } else if ("2".equals(currentAccountType) || CurrentAccountType.SUPPLIER.getAlias().equals(currentAccountType)) {
            currentAccountType = "2";
        } else {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "CurrentAccountType_Error", ctx));
        }
        this.makeInvoiceInfo.setCurrentAccountType(CurrentAccountType.getEnum(currentAccountType));
    }

    private MakeInvoiceEntryInfo transmitEntry(Hashtable lineData, Context ctx) throws TaskExternalException, EASBizException, BOSException {
        MakeInvoiceEntryInfo entryInfo = new MakeInvoiceEntryInfo();
        this.handleEntry(entryInfo, lineData, ctx);
        if (entryInfo.getId() == null) {
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
        }
        return entryInfo;
    }

    private void afterBuildEntry(MakeInvoiceEntryInfo entryInfo) {
        entryInfo.setMakeInvoice(this.makeInvoiceInfo);
        this.makeInvoiceInfo.getEntries().add(entryInfo);
    }

    private void doNumber(Context ctx, Hashtable lineData) throws TaskExternalException, EASBizException, BOSException {
        String str;
        Object number = ((DataToken)lineData.get((Object)"FNumber")).data;
        Map billMap = new HashMap();
        boolean isSupporNumberRule = IMUtils.getImportParam(ctx);
        boolean isAddNewImp = !this.isSltImportUpdate();
        boolean numberIsNull = false;
        if (number != null && number.toString().trim().length() > 0) {
            billMap = this.isNumberExist(ctx, number.toString().trim());
            if (this.isSltImportUpdate() && billMap.size() > 0) {
                String status = (String)billMap.get("status");
                if (!"1".equals(status) && !"2".equals(status)) {
                    String str2 = IMUtils.getResource(resClassName, "BILLSTATUS_ERROR", ctx);
                    throw new TaskExternalException(number.toString().trim() + "  " + str2);
                }
                String id = (String)billMap.get("id");
                this.makeInvoiceInfo = (MakeInvoiceInfo)this.getController(ctx).getValue((IObjectPK)new ObjectUuidPK(id), MakeInvoiceInfo.getMakeSelector());
                if (!InvoiceSrcSystem.EXCEL.equals((Object)this.makeInvoiceInfo.getSrcSystem())) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "IMPORTUPDATE_ERROR", ctx));
                }
            } else if (isAddNewImp && billMap.size() > 0) {
                String str3 = IMUtils.getResource(resClassName, "EXIST_SAME_NUMBER", ctx);
                throw new TaskExternalException(number.toString().trim() + "  " + str3);
            }
        } else {
            numberIsNull = true;
        }
        if (isAddNewImp && isSupporNumberRule && numberIsNull) {
            String mainOrgId = null;
            CompanyOrgUnitInfo mainOrg = this.makeInvoiceInfo.getCompany();
            if (mainOrg == null) {
                return;
            }
            mainOrgId = mainOrg.getString("id");
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (iCodingRuleManager.isExist((IObjectValue)this.makeInvoiceInfo, mainOrgId)) {
                number = iCodingRuleManager.getNumber((IObjectValue)this.makeInvoiceInfo, mainOrgId, "");
            }
        }
        if (number == null || "".equals(number)) {
            str = IMUtils.getResource(resClassName, "NUMBER_IS_ISNULL", ctx);
            throw new TaskExternalException(str);
        }
        if (isAddNewImp && number.equals(billMap.get("number"))) {
            str = IMUtils.getResource(resClassName, "EXIST_SAME_NUMBER", ctx);
            throw new TaskExternalException(number.toString().trim() + "  " + str);
        }
        this.makeInvoiceInfo.setNumber(number.toString().trim());
    }

    private Map isNumberExist(Context ctx, String number) throws EASBizException, BOSException {
        HashMap<String, String> billMap = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select fid, fnumber, fstatus,fsrcsystem from t_im_makeinvoice where fnumber = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{number});
        try {
            while (rs.next()) {
                billMap.put("id", rs.getString("fid"));
                billMap.put("status", rs.getString("fstatus"));
                billMap.put("srcsystem", rs.getString("fsrcsystem"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return billMap;
    }

    private PayInvoiceTypeEnum getInvoiceType(Context ctx, Hashtable hsData) throws TaskExternalException {
        String invoiceType = ((DataToken)hsData.get((Object)"FInvoiceType")).data.toString();
        String commonInv = IMUtils.getResource(resClassName, "COMMONINVOICE", ctx);
        String valueInv = IMUtils.getResource(resClassName, "VALUEADDEDTAXINV", ctx);
        String electInv = IMUtils.getResource(resClassName, "ELECTRONICINVOICE", ctx);
        String eleInv = IMUtils.getResource(resClassName, "ELEINVOICE", ctx);
        String eleSpeInv = IMUtils.getResource(resClassName, "ELECTRONICSPECIALINVOICE", ctx);
        String digElec = IMUtils.getResource(resClassName, "DIGITALELECTRICITYINVOICE", ctx);
        String digElecSpe = IMUtils.getResource(resClassName, "DIGITALELECTRICITYSPECIALINVOICE", ctx);
        PayInvoiceTypeEnum invoiceTypeEnum = null;
        if (commonInv.equals(invoiceType)) {
            invoiceTypeEnum = PayInvoiceTypeEnum.COMMONINVOICE;
        } else if (valueInv.equals(invoiceType)) {
            invoiceTypeEnum = PayInvoiceTypeEnum.VALUEADDEDTAXINV;
        } else if (electInv.equals(invoiceType) || eleInv.equals(invoiceType)) {
            invoiceTypeEnum = PayInvoiceTypeEnum.ELECTRONICINVOICE;
        } else if (eleSpeInv.equals(invoiceType)) {
            invoiceTypeEnum = PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE;
        } else if (digElec.equals(invoiceType)) {
            invoiceTypeEnum = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE;
        } else if (digElecSpe.equals(invoiceType)) {
            invoiceTypeEnum = PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE;
        } else {
            try {
                invoiceTypeEnum = PayInvoiceTypeEnum.getEnum((String)invoiceType);
                if (invoiceTypeEnum == null || invoiceTypeEnum.equals((Object)PayInvoiceTypeEnum.DEFAULTTYPE)) {
                    throw new IMException(IMException.INVOICETYPEERROR);
                }
            }
            catch (IMException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        return invoiceTypeEnum;
    }

    private SpecificServiceEnum getSpecificService(Context ctx, Hashtable hsData) throws TaskExternalException {
        String specificService = this.getString(hsData, "FSpecificService");
        SpecificServiceEnum specServiceEnum = null;
        List enums = SpecificServiceEnum.getEnumList();
        for (SpecificServiceEnum enumItem : enums) {
            if (!enumItem.getAlias().equals(specificService)) continue;
            specServiceEnum = enumItem;
            break;
        }
        if (specServiceEnum == null && (specServiceEnum = SpecificServiceEnum.getEnum(specificService)) == null) {
            specServiceEnum = SpecificServiceEnum.Normal;
        }
        return specServiceEnum;
    }

    private RushRedReasonEnum getRushRedReason(Context ctx, Hashtable hsData) throws TaskExternalException {
        String rushRedReason = ((DataToken)hsData.get((Object)"FRushRedReason")).data.toString();
        RushRedReasonEnum rushRedReasonEnum = null;
        if (!IMUtils.isEmpty(rushRedReason)) {
            if (RushRedReasonEnum.SalesReturn.getAlias().equals(rushRedReason)) {
                rushRedReasonEnum = RushRedReasonEnum.SalesReturn;
            } else if (RushRedReasonEnum.MakeInvWrong.getAlias().equals(rushRedReason)) {
                rushRedReasonEnum = RushRedReasonEnum.MakeInvWrong;
            } else if (RushRedReasonEnum.ServiceTermination.getAlias().equals(rushRedReason)) {
                rushRedReasonEnum = RushRedReasonEnum.ServiceTermination;
            } else if (RushRedReasonEnum.SalesDiscount.getAlias().equals(rushRedReason)) {
                rushRedReasonEnum = RushRedReasonEnum.SalesDiscount;
            } else {
                try {
                    rushRedReasonEnum = RushRedReasonEnum.getEnum(rushRedReason);
                    if (rushRedReasonEnum == null) {
                        throw new IMException(IMException.RUSHREDREASONERROR);
                    }
                }
                catch (IMException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            }
        }
        return rushRedReasonEnum;
    }

    private boolean setCustomer(Hashtable hsData, Context ctx, MakeInvoiceInfo makeInvoiceInfo) throws TaskExternalException {
        String FCustomerNumber = this.getString(hsData, "FCurrAcctCompany_number");
        if (FCustomerNumber != null && FCustomerNumber.length() > 0) {
            makeInvoiceInfo.setCurrAcctCustomer(this.getCustomer(ctx, hsData));
            return true;
        }
        return false;
    }

    private boolean setSupplier(Hashtable hsData, Context ctx, MakeInvoiceInfo makeInvoiceInfo) throws TaskExternalException {
        String FSupplierNumber = this.getString(hsData, "FCurrAcctCompany_number");
        if (FSupplierNumber != null && FSupplierNumber.length() > 0) {
            makeInvoiceInfo.setCurrAcctSupplier(this.getSupplier(ctx, hsData));
            return true;
        }
        return false;
    }

    private String getReceiveCompany(Hashtable hsData) throws TaskExternalException {
        String receiveCompany = ((DataToken)hsData.get((Object)"FReceiveCompany")).data.toString();
        return receiveCompany;
    }

    private Date getDate(Context ctx, Hashtable hsData, String fieldName) throws TaskExternalException {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o != null && o.toString().length() > 0) {
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "DATE_ERROR", ctx));
            }
        }
        if (o != null && o instanceof Date) {
            date = (Date)o;
        }
        return date;
    }

    private String getTaxNumber(Context ctx, Hashtable hsData, boolean isValueAddedTaxinv) throws TaskExternalException {
        String taxNumber = ((DataToken)hsData.get((Object)"FTaxNumber")).data.toString();
        return taxNumber;
    }

    private boolean getBoolean(Context ctx, String key, String booleanVal) throws TaskExternalException {
        String yes = IMUtils.getResource(resClassName, "YES", ctx);
        String no = IMUtils.getResource(resClassName, "NO", ctx);
        boolean retVal = false;
        if (!IMUtils.isEmpty(booleanVal)) {
            if (yes.equals(booleanVal) || "TRUE".equalsIgnoreCase(booleanVal) || "T".equalsIgnoreCase(booleanVal)) {
                retVal = true;
            } else if (no.equals(booleanVal) || "FALSE".equalsIgnoreCase(booleanVal) || "F".equalsIgnoreCase(booleanVal)) {
                retVal = false;
            } else {
                throw new TaskExternalException(IMUtils.getResource(resClassName, key, ctx));
            }
        }
        return retVal;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.im.app.MakeInvoiceImportQuery";
    }

    private CompanyOrgUnitInfo getCompany(Context ctx, Hashtable hsData) throws TaskExternalException {
        CompanyOrgUnitInfo comOrgUnitInfo = null;
        String FCompanyNumber = ((DataToken)hsData.get((Object)"FCompanyNumber")).data.toString();
        String sql = "select top 1 fid, fnumber, fname_l2, fisbizunit from T_ORG_COMPANY where fnumber = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{FCompanyNumber});
            if (rs != null && rs.next()) {
                if (!rs.getString("fisbizunit").equals("1")) {
                    throw new IMException(IMException.NOTBIZCOMPANY);
                }
            } else {
                throw new IMException(IMException.COMPANYERROR);
            }
            comOrgUnitInfo = new CompanyOrgUnitInfo();
            comOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("fid")));
            comOrgUnitInfo.setName(rs.getString("fname_l2"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return comOrgUnitInfo;
    }

    private CustomerInfo getCustomer(Context ctx, Hashtable hsData) throws TaskExternalException {
        CustomerInfo customerInfo = null;
        String FCustomerNumber = ((DataToken)hsData.get((Object)"FCurrAcctCompany_number")).data.toString();
        String sql = "select top 1 fid, fnumber, fname_l2 from T_BD_Customer where fnumber = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{FCustomerNumber});
            if (rs == null || !rs.next()) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "CUSTOMER_ERROR", ctx));
            }
            customerInfo = new CustomerInfo();
            customerInfo.setId(BOSUuid.read((String)rs.getString("fid")));
            customerInfo.setName(rs.getString("fname_l2"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return customerInfo;
    }

    private SupplierInfo getSupplier(Context ctx, Hashtable hsData) throws TaskExternalException {
        SupplierInfo supplierInfo = null;
        String FSupplierNumber = ((DataToken)hsData.get((Object)"FCurrAcctCompany_number")).data.toString();
        String sql = "select top 1 fid, fnumber, fname_l2 from T_BD_Supplier where fnumber = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{FSupplierNumber});
            if (rs == null || !rs.next()) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "SUPPLIER_ERROR", ctx));
            }
            supplierInfo = new SupplierInfo();
            supplierInfo.setId(BOSUuid.read((String)rs.getString("fid")));
            supplierInfo.setName(rs.getString("fname_l2"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return supplierInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof MakeInvoiceInfo)) {
            return;
        }
        try {
            MakeInvoiceInfo bill = (MakeInvoiceInfo)coreBaseInfo;
            String id = this.getIdFromNumber(ctx, bill.getNumber());
            IMakeInvoice iMakeInvoice = (IMakeInvoice)this.getController(ctx);
            if (StringUtil.isEmptyString((String)id)) {
                iMakeInvoice.impSubmit(coreBaseInfo);
            } else {
                iMakeInvoice.delete((IObjectPK)new ObjectUuidPK(id));
                iMakeInvoice.impSubmit(coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private String getIdFromNumber(Context ctx, String number) throws TaskExternalException {
        MakeInvoiceCollection collection;
        try {
            collection = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection("where number='" + number + "'");
        }
        catch (BOSException e) {
            return null;
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0).getId().toString();
        }
        return null;
    }

    private void doEntryMaterial(MakeInvoiceEntryInfo makeInvoiceEntryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        String productName = ((DataToken)hsData.get((Object)"FEntries$entryName_name_l2")).data.toString();
        String productNum = ((DataToken)hsData.get((Object)"FEntries$entryName_number")).data.toString();
        String entryProductName = ((DataToken)hsData.get((Object)"FEntries_produceName")).data.toString();
        try {
            if (IMUtils.isEmpty(entryProductName) && IMUtils.isEmpty(productName) && IMUtils.isEmpty(productNum)) {
                throw new IMException(IMException.PRODUCT_MUST_UNIQUE);
            }
            makeInvoiceEntryInfo.setProduceName(productName);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (!IMUtils.isEmpty(productNum)) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)productNum, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("taxClassificationCode.*"));
                view.setSelector(sic);
                ProductCodeCollection collection = ProductCodeFactory.getLocalInstance(ctx).getProductCodeCollection(view);
                ProductCodeInfo productInfo = collection.get(0);
                if (productInfo == null && IMUtils.isEmpty(productName)) {
                    throw new IMException(IMException.PRODUCT_MUST_UNIQUE);
                }
                makeInvoiceEntryInfo.setEntryName(productInfo);
                if (productInfo != null) {
                    makeInvoiceEntryInfo.setTaxClassificationCode(productInfo.getTaxClassificationCode().getMergeCode());
                }
                if (IMUtils.isEmpty(productName) && productInfo != null) {
                    makeInvoiceEntryInfo.setProduceName(productInfo.getName());
                }
            }
            if (!IMUtils.isEmpty(entryProductName)) {
                makeInvoiceEntryInfo.setProduceName(entryProductName);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (IMException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleEntry(MakeInvoiceEntryInfo makeInvoiceEntryInfo, Hashtable hsData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        String billRowType;
        String FEntries_makeInvoiceUnit;
        MeasureUnitInfo unit;
        MakeInvoiceEntryCollection entries = this.makeInvoiceInfo.getEntries();
        String FEntrySeq = ((DataToken)hsData.get((Object)"FEntrySeq")).data.toString();
        if (FEntrySeq == null || FEntrySeq.equals("")) throw new TaskExternalException(IMUtils.getResource(resClassName, "SEQ_ERROR", ctx));
        try {
            makeInvoiceEntryInfo.setSeq(Integer.valueOf(FEntrySeq));
            if (this.isSltImportUpdate()) {
                for (int i = 0; i < entries.size(); ++i) {
                    if (entries.get(i).getSeq() != Integer.valueOf(FEntrySeq).intValue()) continue;
                    entries.remove(entries.get(i));
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "SEQ_ERROR", ctx));
        }
        this.doEntryMaterial(makeInvoiceEntryInfo, hsData, ctx);
        String FEntrySpecs = ((DataToken)hsData.get((Object)"FEntrySpecs")).data.toString();
        if (FEntrySpecs != null && !FEntrySpecs.equals("")) {
            makeInvoiceEntryInfo.setSpecs(FEntrySpecs);
        }
        if ((unit = this.getUnit(ctx, hsData)) != null) {
            makeInvoiceEntryInfo.setMeasureUnit(unit);
        }
        if (!StringUtils.isEmpty((String)(FEntries_makeInvoiceUnit = ((DataToken)hsData.get((Object)"FEntries_makeInvoiceUnit")).data.toString()))) {
            makeInvoiceEntryInfo.setMakeInvoiceUnit(FEntries_makeInvoiceUnit);
        } else if (unit != null) {
            makeInvoiceEntryInfo.setMakeInvoiceUnit(unit.getName());
        }
        BigDecimal quantity = BigDecimal.ZERO;
        String FEntryQuantity = ((DataToken)hsData.get((Object)"FEntryQuantity")).data.toString();
        if (FEntryQuantity != null && !FEntryQuantity.equals("")) {
            quantity = this.getValue(ctx, "QUANTITY_ERROR", hsData.get("FEntryQuantity"));
            makeInvoiceEntryInfo.setQuantity(quantity);
        }
        BigDecimal noTaxPrice = BigDecimal.ZERO;
        String FEntryNoTaxPrice = ((DataToken)hsData.get((Object)"FEntryNoTaxPrice")).data.toString();
        if (FEntryNoTaxPrice != null && !FEntryNoTaxPrice.equals("")) {
            noTaxPrice = this.getValue(ctx, "NOTAXPRICE_ERROR", hsData.get("FEntryNoTaxPrice"));
            makeInvoiceEntryInfo.setNoTaxPrice(noTaxPrice);
        }
        BigDecimal noTaxAmt = BigDecimal.ZERO;
        String FEntryNoTaxAmt = ((DataToken)hsData.get((Object)"FEntryNoTaxAmt")).data.toString();
        if (FEntryNoTaxAmt == null || FEntryNoTaxAmt.equals("")) throw new TaskExternalException(IMUtils.getResource(resClassName, "AMOUNT_NOT_NULL", ctx));
        noTaxAmt = this.getValue(ctx, "NOTAXAMT_ERROR", hsData.get("FEntryNoTaxAmt")).setScale(2, RoundingMode.HALF_UP);
        if (noTaxAmt.compareTo(BigDecimal.ZERO) == 0) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "AMOUNT_NOT_ZERO", ctx));
        }
        makeInvoiceEntryInfo.setNoTaxAmt(noTaxAmt);
        BigDecimal taxAmt = BigDecimal.ZERO;
        String FEntryTaxAmt = ((DataToken)hsData.get((Object)"FEntryTaxAmt")).data.toString();
        if (FEntryTaxAmt == null || FEntryTaxAmt.equals("")) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXAMT_NOT_NULL", ctx));
        }
        taxAmt = this.getValue(ctx, "TAXAMT_ERROR", hsData.get("FEntryTaxAmt")).setScale(2, RoundingMode.HALF_UP);
        makeInvoiceEntryInfo.setTaxAmt(taxAmt);
        BigDecimal priceTax = BigDecimal.ZERO;
        String FEntryPriceTax = ((DataToken)hsData.get((Object)"FEntryPriceTax")).data.toString();
        if (FEntryPriceTax == null || FEntryPriceTax.equals("")) throw new TaskExternalException(IMUtils.getResource(resClassName, "PRICETAX_NOT_NULL", ctx));
        priceTax = this.getValue(ctx, "PRICETAX_ERROR", hsData.get("FEntryPriceTax")).setScale(2, RoundingMode.HALF_UP);
        if (priceTax.compareTo(BigDecimal.ZERO) == 0) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "PRICETAX_NOT_ZERO", ctx));
        }
        makeInvoiceEntryInfo.setPriceTax(priceTax);
        if (noTaxAmt.add(taxAmt).compareTo(priceTax) != 0) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "PRICETAX_NOTEQUALS", ctx));
        }
        if (!(noTaxAmt.compareTo(BigDecimal.ZERO) <= 0 && taxAmt.compareTo(BigDecimal.ZERO) <= 0 && priceTax.compareTo(BigDecimal.ZERO) < 0 || noTaxAmt.compareTo(BigDecimal.ZERO) >= 0 && taxAmt.compareTo(BigDecimal.ZERO) >= 0 && priceTax.compareTo(BigDecimal.ZERO) > 0)) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "AMT_NOTEQUALS", ctx));
        }
        BigDecimal taxRate = BigDecimal.ZERO;
        String ftax = ((DataToken)hsData.get((Object)"FEntries_taxRate")).data.toString();
        if (ftax == null || ftax.equals("")) throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXRATE_NOT_NULL", ctx));
        taxRate = this.getValue(ctx, "TAXRATE_ERROR", hsData.get("FEntries_taxRate"));
        if (taxRate == null || taxRate.compareTo(BigDecimal.ZERO) < 0 || taxRate.compareTo(BigDecimal.ONE) > 0) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXRATERANGE_ERROR", ctx));
        }
        makeInvoiceEntryInfo.setTaxRate(taxRate);
        String taxTypeNum = ((DataToken)hsData.get((Object)"FEntryTaxTypeNum")).data.toString();
        if (taxTypeNum != null && !taxTypeNum.equals("")) {
            TaxClassificationCodeCollection taxClassCode;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)taxTypeNum, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("sumItem", (Object)"N", CompareType.EQUALS));
            ev.setFilter(filter);
            try {
                taxClassCode = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(ev);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
            if (taxClassCode == null || taxClassCode.size() == 0) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)taxTypeNum, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("sumItem", (Object)"N", CompareType.EQUALS));
                ev.setFilter(filter);
                try {
                    taxClassCode = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(ev);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage());
                }
                if (taxClassCode == null || taxClassCode.size() == 0) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXCLASS_ERROR", ctx));
                }
                TaxClassificationCodeInfo taxclassInfo = taxClassCode.get(0);
                taxTypeNum = taxclassInfo.getMergeCode();
            }
            makeInvoiceEntryInfo.setTaxClassificationCode(taxTypeNum);
        }
        if (IMUtils.isEmpty(billRowType = ((DataToken)hsData.get((Object)"FEntries_billRowType")).data.toString())) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "BILLROWTYPE_NOT_NULL", ctx));
        }
        List rowTypeEnums = RowType.getEnumList();
        RowType rowTypeEnum = null;
        for (int i = 0; !(i >= rowTypeEnums.size() || (rowTypeEnum = (RowType)((Object)rowTypeEnums.get(i))).getAlias().equals(billRowType) || billRowType.toString().matches("\\d+") && rowTypeEnum.getValue() == Integer.parseInt(billRowType)); ++i) {
            rowTypeEnum = null;
        }
        if (rowTypeEnum == null) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "BILLROWTYPEERROR", ctx));
        }
        makeInvoiceEntryInfo.setBillRowType(rowTypeEnum);
        BigDecimal deductAmt = null;
        String fdeductAmt = ((DataToken)hsData.get((Object)"FEntries_deductAmt")).data.toString();
        if (!StringUtils.isEmpty((String)fdeductAmt)) {
            if (RowType.DISCOUNT_ROW == makeInvoiceEntryInfo.getBillRowType()) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "DiscountRow_NotDeductAmt", ctx));
            }
            deductAmt = this.getValue(ctx, "DEDUCTAMT_ERROR", hsData.get("FEntries_deductAmt"));
            if ((deductAmt = deductAmt.setScale(2, 4)) != null) {
                if (makeInvoiceEntryInfo.getPriceTax().signum() != deductAmt.signum() && BigDecimal.ZERO.compareTo(deductAmt) != 0) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "DeductAmt_SignError", ctx));
                }
                boolean isInTax = false;
                if (this.isSltImportUpdate()) {
                    BigDecimal calTaxAmt;
                    MakeInvoiceCollection collection = null;
                    collection = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection("where number='" + this.makeInvoiceInfo.getNumber() + "'");
                    if (collection != null && collection.size() > 0) {
                        MakeInvoiceInfo oldInfo = collection.get(0);
                        isInTax = oldInfo.isIsContainTax();
                    }
                    if (isInTax) {
                        if (deductAmt.abs().compareTo(makeInvoiceEntryInfo.getPriceTax().abs()) > 0 && BigDecimal.ZERO.compareTo(taxAmt) != 0) {
                            throw new TaskExternalException(IMUtils.getResource(resClassName, "DeductAmtImport_CalError1", ctx));
                        }
                        if (deductAmt.abs().compareTo(makeInvoiceEntryInfo.getPriceTax().abs()) <= 0 && taxAmt.compareTo(calTaxAmt = makeInvoiceEntryInfo.getPriceTax().subtract(deductAmt).divide(BigDecimal.ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
                            throw new TaskExternalException(IMUtils.getResource(resClassName, "DeductAmtImport_CalError2", ctx));
                        }
                    } else {
                        if (deductAmt.abs().compareTo(makeInvoiceEntryInfo.getNoTaxAmt().abs()) > 0 && BigDecimal.ZERO.compareTo(taxAmt) != 0) {
                            throw new TaskExternalException(IMUtils.getResource(resClassName, "DeductAmtImport_CalError3", ctx));
                        }
                        if (deductAmt.abs().compareTo(makeInvoiceEntryInfo.getNoTaxAmt().abs()) <= 0 && taxAmt.compareTo(calTaxAmt = makeInvoiceEntryInfo.getNoTaxAmt().subtract(deductAmt).multiply(taxRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
                            throw new TaskExternalException(IMUtils.getResource(resClassName, "DeductAmtImport_CalError4", ctx));
                        }
                    }
                } else {
                    boolean isInTaxPassed = true;
                    if (deductAmt.abs().compareTo(makeInvoiceEntryInfo.getPriceTax().abs()) > 0 && BigDecimal.ZERO.compareTo(taxAmt) != 0) {
                        throw new TaskExternalException(IMUtils.getResource(resClassName, "DeductAmtImport_CalError5", ctx));
                    }
                    BigDecimal calTaxAmt = makeInvoiceEntryInfo.getPriceTax().subtract(deductAmt).divide(BigDecimal.ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
                    if (taxAmt.compareTo(calTaxAmt) != 0) {
                        isInTaxPassed = false;
                    }
                    if (!isInTaxPassed) {
                        if (deductAmt.abs().compareTo(makeInvoiceEntryInfo.getPriceTax().abs()) < 0 && deductAmt.abs().compareTo(makeInvoiceEntryInfo.getNoTaxAmt().abs()) >= 0 && BigDecimal.ZERO.compareTo(taxAmt) != 0) {
                            throw new TaskExternalException(IMUtils.getResource(resClassName, "DeductAmtImport_CalError6", ctx));
                        }
                        if (deductAmt.abs().compareTo(makeInvoiceEntryInfo.getNoTaxAmt().abs()) < 0 && taxAmt.compareTo(calTaxAmt = makeInvoiceEntryInfo.getNoTaxAmt().subtract(deductAmt).multiply(taxRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
                            throw new TaskExternalException(IMUtils.getResource(resClassName, "DeductAmtImport_CalError7", ctx));
                        }
                    }
                }
                makeInvoiceEntryInfo.setDeductAmt(deductAmt);
                this.makeInvoiceInfo.setIsDiffTax(true);
                this.makeInvoiceInfo.setIsList(false);
            }
        }
        if (this.makeInvoiceInfo.isIsPurchaseInvoice() && this.makeInvoiceInfo.isIsDiffTax()) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "PurchaseImport_DiffTaxError", ctx));
        }
        this.checkVehicleVolid(ctx, makeInvoiceEntryInfo);
    }

    private void checkVehicleVolid(Context ctx, MakeInvoiceEntryInfo entry) throws BOSException, EASBizException, TaskExternalException {
        if (this.makeInvoiceInfo.isIsVehicle()) {
            TaxClassificationCodeInfo tccInfo;
            String billMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "VEHICLE_BILL", ctx.getLocale());
            if (entry.getNoTaxPrice() == null || entry.getQuantity() == null || BigDecimal.ZERO.compareTo(entry.getNoTaxPrice()) == 0 || BigDecimal.ZERO.compareTo(entry.getQuantity()) == 0) {
                throw new TaskExternalException(billMsg + IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_PRICEANDQTY_NOTNULL", ctx.getLocale()));
            }
            if (!StringUtils.isEmpty((String)entry.getTaxClassificationCode()) && (tccInfo = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeInfo("where mergeCode = '" + entry.getTaxClassificationCode() + "'")) != null && !"\u673a\u52a8\u8f66".equals(tccInfo.getSimpleName())) {
                throw new TaskExternalException(billMsg + IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_TAXCLASSIFICATIONCODE_NOTVOLID", ctx.getLocale()));
            }
        }
    }

    private UserInfo getUserFromNumber(Context ctx, String number) throws TaskExternalException {
        UserInfo userInfo = null;
        if (number != null && number.trim().length() > 0) {
            try {
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where number='" + number + "'");
                if (users != null && users.size() > 0) {
                    userInfo = users.get(0);
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        return userInfo;
    }

    private PersonInfo getPersonFromNumber(Context ctx, String number) throws TaskExternalException {
        PersonInfo personInfo = null;
        if (number != null && number.trim().length() > 0) {
            try {
                PersonCollection users = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("where number ='" + number + "'");
                if (users != null && users.size() > 0) {
                    personInfo = users.get(0);
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        return personInfo;
    }

    private MeasureUnitInfo getUnit(Context ctx, Hashtable hsData) throws TaskExternalException {
        MeasureUnitInfo unitInfo = null;
        String FUnitNumber = ((DataToken)hsData.get((Object)"FEntryMeasureUnitNumber")).data.toString();
        String sqlToGetUnit = "select top 1 fid, fname_l2, fnumber from T_BD_MEASUREUNIT where fnumber = ?";
        if (null != FUnitNumber && FUnitNumber.length() > 0) {
            try {
                IRowSet rsToGetUnit = DbUtil.executeQuery((Context)ctx, (String)sqlToGetUnit, (Object[])new Object[]{FUnitNumber});
                if (rsToGetUnit == null || !rsToGetUnit.next()) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "UNIT_ERROR", ctx));
                }
                unitInfo = new MeasureUnitInfo();
                unitInfo.setId(BOSUuid.read((String)rsToGetUnit.getString("fid")));
                unitInfo.setName(rsToGetUnit.getString("fname_l2"));
                unitInfo.setNumber(FUnitNumber);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }
        return unitInfo;
    }

    private int getListMaxLineNo(Context ctx, MakeInvoiceInfo mkInvoice, String companyId) throws EASBizException, BOSException {
        String paramNumber = "VATM012";
        if ("0".equals(mkInvoice.getInvoiceType().getValue())) {
            paramNumber = "VATM013";
        } else if ("2".equals(mkInvoice.getInvoiceType().getValue())) {
            paramNumber = "VATM014";
        } else if ("3".equals(mkInvoice.getInvoiceType().getValue())) {
            paramNumber = "VATM017";
        }
        return IMUtils.getDecimalParam(ctx, companyId, new String[]{paramNumber}).intValue();
    }

    private int getEntrySize(Context ctx, String invoiceType, String companyId) throws EASBizException, BOSException {
        String paramNumber = "VATM005";
        if ("4".equals(invoiceType) || "5".equals(invoiceType)) {
            paramNumber = "VATM024";
        }
        int limit = IMUtils.getDecimalParam(ctx, companyId, new String[]{paramNumber}).intValue();
        if (("4".equals(invoiceType) || "5".equals(invoiceType)) && limit == 0) {
            limit = IMConstant.DIGELECLIMIT;
        }
        return limit;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        String yes = IMUtils.getResource(resClassName, "YES", ctx);
        String no = IMUtils.getResource(resClassName, "NO", ctx);
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FInvoiceType", PayInvoiceTypeEnum.getEnum((String)rs.getString("invoiceType")));
            this.putTable(result, "FSpecificService", (Object)SpecificServiceEnum.getEnum(rs.getString("specificService")));
            this.putTable(result, "FCurrentAccountType", (Object)CurrentAccountType.getEnum(rs.getString("currentAccountType")));
            this.putTable(result, "FCurrAcctCompany_number", rs.getString("currentAccount.number"));
            this.putTable(result, "FReceiveCompany", rs.getString("receiveCompany"));
            this.putTable(result, "FTaxNumber", rs.getString("taxNumber"));
            this.putTable(result, "FAddress", rs.getString("address"));
            this.putTable(result, "FEntries_produceName", rs.getString("entry.produceName"));
            this.putTable(result, "FBankAccount", rs.getString("bankAccount"));
            this.putTable(result, "FEntrySeq", rs.getString("entry.seq"));
            this.putTable(result, "FEntrySpecs", rs.getString("entry.specs"));
            this.putTable(result, "FEntryMeasureUnitNumber", rs.getString("entry.measureUnit.number"));
            this.putTable(result, "FEntries_makeInvoiceUnit", rs.getString("entry.makeInvoiceUnit"));
            this.putTable(result, "FEntries_taxRate", rs.getBigDecimal("entry.taxRate"));
            this.putTable(result, "FEntryQuantity", rs.getBigDecimal("entry.quantity"));
            this.putTable(result, "FEntryNoTaxPrice", rs.getBigDecimal("entry.noTaxPrice"));
            this.putTable(result, "FEntryNoTaxAmt", rs.getBigDecimal("entry.noTaxAmt"));
            this.putTable(result, "FEntryTaxAmt", rs.getBigDecimal("entry.taxAmt"));
            this.putTable(result, "FEntries_deductAmt", rs.getBigDecimal("entry.deductAmt"));
            this.putTable(result, "FEntryPriceTax", rs.getBigDecimal("entry.priceTax"));
            this.putTable(result, "FRemark", rs.getString("remark"));
            this.putTable(result, "FRushRedReason", (Object)RushRedReasonEnum.getEnum(rs.getString("rushRedReason")));
            this.putTable(result, "FApplicateDate", rs.getString("applicateDate"));
            this.putTable(result, "FDrawertxt", rs.getString("drawertxt"));
            this.putTable(result, "FPayeetxt", rs.getString("payeetxt"));
            this.putTable(result, "FChecktxt", rs.getString("checktxt"));
            this.putTable(result, "FIsList", Boolean.parseBoolean(rs.getString("isList")) ? yes : no);
            this.putTable(result, "FIsPurchaseInvoice", Boolean.parseBoolean(rs.getString("isPurchaseInvoice")) ? yes : no);
            this.putTable(result, "FIsVehicle", Boolean.parseBoolean(rs.getString("isVehicle")) ? yes : no);
            this.putTable(result, "FCompanyNumber", rs.getString("company.number"));
            this.putTable(result, "FIsDelete", Boolean.parseBoolean(rs.getString("isDelete")) ? yes : no);
            this.putTable(result, "FDeleteDate", rs.getString("deleteDate"));
            this.putTable(result, "FDeleteUser_number", rs.getString("deleteUser.number"));
            this.putTable(result, "FStatus", (Object)InvoiceBillStatus.getEnum(rs.getString("status")));
            this.putTable(result, "FEntries$entryName_number", rs.getString("entry.entryName.number"));
            this.putTable(result, "FEntries$entryName_name_l2", rs.getString("entry.entryName.name"));
            this.putTable(result, "FInvoiceNumber", rs.getString("invoiceNumber"));
            this.putTable(result, "FInvoiceNo", rs.getString("invoiceNo"));
            this.putTable(result, "FInvoiceDate", rs.getString("invoiceDate"));
            this.putTable(result, "FAuditor_number", rs.getString("auditor.number"));
            this.putTable(result, "FAuditor_name_l2", rs.getString("auditor.name"));
            this.putTable(result, "FCompany_name_l2", rs.getString("company.name"));
            this.putTable(result, "FEntryTaxTypeNum", rs.getString("entry.taxClassificationCode"));
            this.putTable(result, "FEntries_taxClassName", rs.getString("entry.taxClassName"));
            this.putTable(result, "FEntries_billRowType", (Object)RowType.getEnum(Integer.parseInt(rs.getString("entry.billRowType"))));
            this.putTable(result, "FPlateNo", rs.getString("plateNo"));
            this.putTable(result, "FExtensionNo", rs.getString("extensionNo"));
            this.putTable(result, "FDisInvoicer", rs.getString("disInvoicer"));
            this.putTable(result, "FCellphone", rs.getString("cellphone"));
            this.putTable(result, "FMailNumber", rs.getString("mailNumber"));
            this.putTable(result, "FRecBillComName", rs.getString("recBillComName"));
            this.putTable(result, "FRecBillAdress", rs.getString("recBillAdress"));
            this.putTable(result, "FRecBillEmail", rs.getString("recBillEmail"));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        if (this.getContextParameter().get("isConverParams") != null && "true".equals(this.getContextParameter().get("isConverParams"))) {
            Hashtable temp = firstData;
            firstData = currentData;
            currentData = temp;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        if (this.firstData != null) {
            firstNumber = (DataToken)this.firstData.get(this.getMainField());
        }
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        this.firstData = currentData;
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }
}

