/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IncomeInvoiceActionEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceActionTypeEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.param.ActionParam;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;

public class ReceiveInvoiceImport
extends AbstractDataTransmission {
    private Map infoMap = new HashMap();
    private Map seqMap = new HashMap();
    String curKey = null;
    IncomeInvoiceInfo head = null;

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null) {
            return;
        }
        IncomeInvoiceInfo invInfo = (IncomeInvoiceInfo)coreBaseInfo;
        try {
            this.preHandlerInvoice(ctx, (IncomeInvoiceInfo)coreBaseInfo);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        try {
            HashSet<String> ids = new HashSet<String>();
            ids.add(invInfo.getId().toString());
            ActionParam actionParam = new ActionParam();
            actionParam.setIds(ids);
            actionParam.setAction(IncomeInvoiceActionEnum.RECEIVEINVOICE);
            actionParam.setActiontype(IncomeInvoiceActionTypeEnum.SAME);
            actionParam.setInvoiceCode(invInfo.getInvoiceCode());
            actionParam.setInvoiceNumber(invInfo.getInvoiceNumber());
            actionParam.put("isThrowException", true);
            IncomeInvoiceFacadeFactory.getLocalInstance(ctx).doOperation(actionParam);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        IncomeInvoiceInfo head = new IncomeInvoiceInfo();
        String invoiceCode = ((DataToken)hsData.get((Object)"FInvoiceCode")).data.toString();
        String invoiceNumber = ((DataToken)hsData.get((Object)"FInvoiceNumber")).data.toString();
        this.curKey = invoiceCode.concat(invoiceNumber);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (this.infoMap.containsKey(this.curKey)) {
            head = (IncomeInvoiceInfo)this.infoMap.get(this.curKey);
        } else {
            try {
                head = this.getHeadInfo(ctx, mode, invoiceCode, invoiceNumber);
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
            try {
                head = this.parseHead(hsData, ctx, head);
            }
            catch (IMException e) {
                try {
                    throw e;
                }
                catch (IMException ex) {
                    throw new TaskExternalException(ex.getMessage(), ex.getCause());
                }
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
            this.infoMap.put(this.curKey, head);
        }
        return head;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"FInvoiceCode", (Object)rs.getString("invoiceCode"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceNumber", (Object)rs.getString("invoiceNumber"));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        if (this.getContextParameter().get("companyId") != null) {
            String companyID = this.getContextParameter().get("companyId").toString();
            companyID = companyID.replace("$", "'");
            try {
                filter = new FilterInfo(companyID);
            }
            catch (ParserException e) {
                Logger.error((Throwable)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.im.app.IncomeInvoiceQuery";
    }

    private IncomeInvoiceInfo getHeadInfo(Context ctx, int mode, String invoiceCode, String invoiceNumber) throws BOSException, EASBizException, TaskExternalException {
        IncomeInvoiceInfo incomeInvoiceInfo = new IncomeInvoiceInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceNumber, CompareType.EQUALS));
        view.setFilter(filter);
        IncomeInvoiceCollection coll = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "InvoiceNotExists", ctx.getLocale()));
        }
        incomeInvoiceInfo = coll.get(0);
        return incomeInvoiceInfo;
    }

    private IncomeInvoiceInfo parseHead(Hashtable hsData, Context ctx, IncomeInvoiceInfo head) throws TaskExternalException, IMException, BOSException, SQLException {
        String invoiceCode = ((DataToken)hsData.get((Object)"FInvoiceCode")).data.toString();
        String invoiceNumber = ((DataToken)hsData.get((Object)"FInvoiceNumber")).data.toString();
        return head;
    }

    private void preHandlerInvoice(Context ctx, IncomeInvoiceInfo incomeInvoice) throws EASBizException, BOSException {
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }
}

