/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class RemarkDocumentFilter
extends DocumentFilter {
    private int staticTextLength = 0;
    private int maxLength = 255;

    public RemarkDocumentFilter(int staticTextLength, int maxLength) {
        this.staticTextLength = staticTextLength;
        this.maxLength = maxLength;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        if (offset >= this.staticTextLength) {
            super.insertString(fb, offset, string, attr);
        }
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        if (offset >= this.staticTextLength) {
            super.remove(fb, offset, length);
        }
        if (this.staticTextLength > 0 && offset < this.staticTextLength) {
            super.remove(fb, this.staticTextLength, offset + length - this.staticTextLength);
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (offset >= this.staticTextLength && offset + text.length() <= this.maxLength) {
            super.replace(fb, offset, length, text, attrs);
        }
        if (offset >= this.staticTextLength && offset + text.length() > this.maxLength) {
            int subStrLength = 0;
            String subStr = "";
            subStrLength = this.maxLength - offset;
            subStr = text.substring(0, subStrLength);
            super.replace(fb, offset, length, subStr, attrs);
        }
    }
}

