/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.ITaxClassificationCode;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.TaxClassificationCodeSourceType;
import com.kingdee.eas.tm.im.common.billimport.IMBillImportBase;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.task.SuccessInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TaxClassificationCodeImport
extends IMBillImportBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.TaxClassificationCodeImport");
    private TaxClassificationCodeInfo taxClassificationCodeInfo = null;
    private static final String resClassName = "com.kingdee.eas.tm.im.app.IMImportResource";

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return TaxClassificationCodeFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    protected BigDecimal getValue(Context ctx, String key, Object data) throws TaskExternalException {
        String valStr = data.toString().trim();
        DecimalFormat format = new DecimalFormat();
        try {
            Number val = format.parse(valStr);
            return new BigDecimal(val.toString());
        }
        catch (ParseException e) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, key, ctx));
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.taxClassificationCodeInfo = null;
        int k = 0;
        Boolean isUpdate = this.isSltImportUpdate();
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (k == 0) {
                try {
                    this.taxClassificationCodeInfo = this.transmitHead(lineData, isUpdate, ctx);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                if (this.taxClassificationCodeInfo == null) {
                    return null;
                }
            }
            ++k;
        }
        return this.taxClassificationCodeInfo;
    }

    private TaxClassificationCodeInfo transmitHead(Hashtable lineData, boolean isUpdate, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        this.taxClassificationCodeInfo = new TaxClassificationCodeInfo();
        this.doNumber(lineData, isUpdate, ctx);
        Object value = null;
        String name = this.getString(lineData, "FName_l2");
        if (StringUtils.isEmpty((String)name)) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "TCCNameNotNull", ctx));
        }
        this.taxClassificationCodeInfo.setName(name);
        String mergeCode = this.getString(lineData, "FMergeCode");
        if (StringUtils.isEmpty((String)mergeCode)) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "TCCMergeCodeNotNull", ctx));
        }
        this.taxClassificationCodeInfo.setMergeCode(mergeCode);
        String simpleName = this.getString(lineData, "FSimpleName");
        if (StringUtils.isEmpty((String)simpleName)) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "TCCSimpleNameNotNull", ctx));
        }
        this.taxClassificationCodeInfo.setSimpleName(simpleName);
        value = ((DataToken)lineData.get((Object)"FTaxRate")).data;
        this.taxClassificationCodeInfo.setTaxRate(this.getBigDecimalValue("FTaxRate", value, 2, ctx));
        value = ((DataToken)lineData.get((Object)"FKey")).data;
        this.taxClassificationCodeInfo.setKey(value != null ? value.toString() : null);
        value = ((DataToken)lineData.get((Object)"FSumItem")).data;
        this.taxClassificationCodeInfo.setSumItem(this.getSumItemValue("FSumItem", value, ctx));
        value = ((DataToken)lineData.get((Object)"FOfficeCode")).data;
        this.taxClassificationCodeInfo.setOfficeCode(value != null ? value.toString() : null);
        value = ((DataToken)lineData.get((Object)"FIsHidden")).data;
        this.taxClassificationCodeInfo.setIsHidden(this.getBooleanValue("FIsHidden", value, ctx));
        value = ((DataToken)lineData.get((Object)"FDescription_l2")).data;
        this.taxClassificationCodeInfo.setDescription(value != null ? value.toString() : null);
        value = ((DataToken)lineData.get((Object)"FVATSpecialManagement")).data;
        this.taxClassificationCodeInfo.setVATSpecialManagement(value != null ? value.toString() : null);
        value = ((DataToken)lineData.get((Object)"FVATSpecialContent")).data;
        this.taxClassificationCodeInfo.setVATSpecialContent(value != null ? value.toString() : null);
        value = ((DataToken)lineData.get((Object)"FVATSpecialNum")).data;
        this.taxClassificationCodeInfo.setVATSpecialNum(value != null ? value.toString() : null);
        value = ((DataToken)lineData.get((Object)"FExciseManagement")).data;
        this.taxClassificationCodeInfo.setExciseManagement(value != null ? value.toString() : null);
        value = ((DataToken)lineData.get((Object)"FExcisePolicy")).data;
        this.taxClassificationCodeInfo.setExcisePolicy(value != null ? value.toString() : null);
        value = ((DataToken)lineData.get((Object)"FExciseSpecialContentNum")).data;
        this.taxClassificationCodeInfo.setExciseSpecialContentNum(value != null ? value.toString() : null);
        value = ((DataToken)lineData.get((Object)"FParentNum")).data;
        this.taxClassificationCodeInfo.setParentNum(value != null ? value.toString() : null);
        String version = this.getString(lineData, "FVersion");
        if (StringUtils.isEmpty((String)version)) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "TCCVersionNotNull", ctx));
        }
        this.taxClassificationCodeInfo.setVersion(version);
        String codeTableVersion = this.getString(lineData, "FCodeTableVersion");
        if (StringUtils.isEmpty((String)codeTableVersion)) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "TCCCodeTableVersionNotNull", ctx));
        }
        this.taxClassificationCodeInfo.setCodeTableVersion(codeTableVersion);
        this.taxClassificationCodeInfo.setLongNumber(this.taxClassificationCodeInfo.getNumber());
        this.taxClassificationCodeInfo.setSourceType(TaxClassificationCodeSourceType.ExcelImport);
        try {
            this.taxClassificationCodeInfo.setCU(CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4")));
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        return this.taxClassificationCodeInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doNumber(Hashtable lineData, boolean isUpdate, Context ctx) throws TaskExternalException, BOSException {
        String number = ((DataToken)lineData.get((Object)"FNumber")).data.toString();
        if (null == number || number.length() == 0) {
            throw new TaskExternalException(IMUtils.getString(resClassName, "TaxClassificationCodeNotNull", ctx.getLocale()));
        }
        this.taxClassificationCodeInfo.setNumber(number);
        String id = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_IM_TaxClassificationCode where FNumber=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{number});
        try {
            if (rs.next()) {
                id = rs.getString("FID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (isUpdate) {
            try {
                if (StringUtils.isEmpty((String)id)) return;
                this.taxClassificationCodeInfo.setId(BOSUuid.read((String)id));
                return;
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
        } else {
            if (StringUtils.isEmpty((String)id)) return;
            throw new TaskExternalException(IMUtils.getString(resClassName, "TaxClassificationCodeHasExists", ctx.getLocale()));
        }
    }

    private BigDecimal getBigDecimalValue(String colName, Object value, int precision, Context ctx) throws TaskExternalException {
        try {
            if (value != null && !value.equals("")) {
                if (colName.equals("FTaxRate")) {
                    BigDecimal valueObject = null;
                    valueObject = value.toString().indexOf("%") > 0 ? new BigDecimal(value.toString().substring(0, value.toString().length() - 1)).divide(new BigDecimal(100)).setScale(precision) : new BigDecimal(value.toString());
                    if (valueObject.compareTo(new BigDecimal(1)) > 0 || valueObject.compareTo(new BigDecimal(0)) < 0) {
                        throw new TaskExternalException(IMUtils.getString(resClassName, "TaxRateRangeError", ctx.getLocale()));
                    }
                    return valueObject;
                }
                return new BigDecimal(value.toString()).setScale(precision);
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof TaskExternalException) {
                throw (TaskExternalException)((Object)e);
            }
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "ColumnFormatError", ctx.getLocale(), new Object[]{colName}));
        }
    }

    private boolean getBooleanValue(String colName, Object value, Context ctx) throws TaskExternalException {
        try {
            if (value != null && !value.equals("")) {
                return value.equals("\u662f") || value.equals("1") || value.equals("true");
            }
            return false;
        }
        catch (Exception e) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "ColumnFormatError", ctx.getLocale(), new Object[]{colName}));
        }
    }

    private String getSumItemValue(String colName, Object value, Context ctx) throws TaskExternalException {
        try {
            if (value != null && !value.equals("")) {
                if (value.equals("\u662f") || value.equals("1") || value.equals("true") || value.equals("Y")) {
                    return "Y";
                }
                return "N";
            }
            return "N";
        }
        catch (Exception e) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "ColumnFormatError", ctx.getLocale(), new Object[]{colName}));
        }
    }

    private String formatSumItemValue(String colName, Object value, Context ctx) throws TaskExternalException {
        try {
            if (value != null && !value.equals("")) {
                if (value.equals("\u662f") || value.equals("1") || value.equals("true") || value.equals("Y")) {
                    return IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_true", ctx.getLocale());
                }
                return IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_false", ctx.getLocale());
            }
            return IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_false", ctx.getLocale());
        }
        catch (Exception e) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "ColumnFormatError", ctx.getLocale(), new Object[]{colName}));
        }
    }

    private String formatTaxRateValue(String colName, BigDecimal value, Context ctx) throws TaskExternalException {
        try {
            if (value != null) {
                return value.toString();
            }
            return null;
        }
        catch (Exception e) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "ColumnFormatError", ctx.getLocale(), new Object[]{colName}));
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof TaxClassificationCodeInfo)) {
            return;
        }
        try {
            TaxClassificationCodeInfo bill = (TaxClassificationCodeInfo)coreBaseInfo;
            ITaxClassificationCode iTaxClassificationCode = (ITaxClassificationCode)this.getController(ctx);
            if (bill.getId() == null) {
                iTaxClassificationCode.addnew(coreBaseInfo);
            } else {
                iTaxClassificationCode.update((IObjectPK)new ObjectUuidPK(bill.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private String getIdFromNumber(Context ctx, String number) throws TaskExternalException {
        TaxClassificationCodeCollection collection;
        try {
            collection = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection("where number='" + number + "'");
        }
        catch (BOSException e) {
            return null;
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0).getId().toString();
        }
        return null;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"FNumber", (Object)rs.getString("number"));
            DataImportTools.putToHashtable(result, (Object)"FName_l2", (Object)rs.getString("name"));
            DataImportTools.putToHashtable(result, (Object)"FMergeCode", (Object)rs.getString("mergeCode"));
            DataImportTools.putToHashtable(result, (Object)"FSimpleName", (Object)rs.getString("simpleName"));
            DataImportTools.putToHashtable(result, (Object)"FTaxRate", (Object)this.formatTaxRateValue("FTaxRate", rs.getBigDecimal("taxRate"), ctx));
            DataImportTools.putToHashtable(result, (Object)"FKey", (Object)rs.getString("key"));
            DataImportTools.putToHashtable(result, (Object)"FSumItem", (Object)this.formatSumItemValue("FSumItem", rs.getString("sumItem"), ctx));
            DataImportTools.putToHashtable(result, (Object)"FOfficeCode", (Object)rs.getString("officeCode"));
            DataImportTools.putToHashtable(result, (Object)"FIsHidden", (Object)(rs.getBoolean("isHidden") ? IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_true", ctx.getLocale()) : IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_false", ctx.getLocale())));
            DataImportTools.putToHashtable(result, (Object)"FDescription_l2", (Object)rs.getString("description"));
            DataImportTools.putToHashtable(result, (Object)"FVATSpecialManagement", (Object)rs.getString("VATSpecialManagement"));
            DataImportTools.putToHashtable(result, (Object)"FVATSpecialContent", (Object)rs.getString("VATSpecialContent"));
            DataImportTools.putToHashtable(result, (Object)"FVATSpecialNum", (Object)rs.getString("VATSpecialNum"));
            DataImportTools.putToHashtable(result, (Object)"FExciseManagement", (Object)rs.getString("exciseManagement"));
            DataImportTools.putToHashtable(result, (Object)"FExcisePolicy", (Object)rs.getString("excisePolicy"));
            DataImportTools.putToHashtable(result, (Object)"FExciseSpecialContentNum", (Object)rs.getString("exciseSpecialContentNum"));
            DataImportTools.putToHashtable(result, (Object)"FParentNum", (Object)rs.getString("parentNum"));
            DataImportTools.putToHashtable(result, (Object)"FVersion", (Object)rs.getString("version"));
            DataImportTools.putToHashtable(result, (Object)"FCodeTableVersion", (Object)rs.getString("codeTableVersion"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    public int getSubmitType() {
        return 1;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.im.app.TaxClassificationCodeImportQuery";
    }

    public void solutionOnFinished(Context ctx) throws TaskExternalException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" update T_IM_TaxClassificationCode set flongnumber = fnumber where FSourceType = 'ExcelImport'");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        sql.setLength(0);
        sql.append(" update T_IM_TaxClassificationCode code set fparentid = ");
        sql.append(" (select parentcode.fid from T_IM_TaxClassificationCode parentcode ");
        sql.append(" inner join T_IM_TaxClassificationCode  childcode on parentcode.fnumber = childcode.fparentnum ");
        sql.append(" where code.FSourceType = 'ExcelImport' and code.fid = childcode.fid) ");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        sql.setLength(0);
        sql.append(" update T_IM_TaxClassificationCode code set FIsLeaf = 0");
        sql.append(" where exists(select 1 from T_IM_TaxClassificationCode parentcode ");
        sql.append(" inner join T_IM_TaxClassificationCode  childcode on parentcode.fnumber = childcode.fparentnum ");
        sql.append(" where code.FSourceType = 'ExcelImport' and code.fid = parentcode.fid) ");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        sql.setLength(0);
        sql.append("update T_IM_TaxClassificationCode code set flevel = 0 where FSourceType = 'ExcelImport' and (flevel = 1 or flevel is null)");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        sql.setLength(0);
        sql.append("update T_IM_TaxClassificationCode code set flevel = 1 where (fparentnum is null or fparentnum='') and FSourceType = 'ExcelImport'");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        StringBuilder ids = null;
        HashSet idSet = null;
        for (int i = 1; i <= 10; ++i) {
            sql.setLength(0);
            sql.append(" select parentcode.fnumber from T_IM_TaxClassificationCode parentcode ");
            sql.append(" inner join T_IM_TaxClassificationCode childcode on parentcode.fnumber = childcode.fparentnum and childcode.flevel = 0");
            sql.append(" where parentcode.flevel = ").append(i);
            List coll = null;
            try {
                coll = (List)DbUtil.executeQuery((Context)ctx, (String)sql.toString()).toCollection();
            }
            catch (SQLException e) {
                throw new TaskExternalException(e.getMessage());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
            if (null == coll || coll.size() == 0) continue;
            ids = new StringBuilder();
            idSet = new HashSet();
            for (Vector idVector : coll) {
                idSet.add(idVector.get(0));
            }
            for (String id : idSet) {
                ids.append("'").append(id).append("',");
            }
            sql.setLength(0);
            sql.append(" update T_IM_TaxClassificationCode set flevel = ").append(i + 1);
            sql.append(" where FSourceType = 'ExcelImport' and FParentNum in (").append(ids.substring(0, ids.length() - 1)).append(") and flevel = 0");
            try {
                DbUtil.execute((Context)ctx, (String)sql.toString());
                continue;
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
    }

    public void writeLog(RecordCollection col, List<SuccessInfo> successList) {
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return false;
    }
}

