/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonEntityFilterPanel;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTipInfo;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipResourceUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipUtil;
import com.kingdee.eas.tm.im.basedata.BDSyncMappingFactory;
import com.kingdee.eas.tm.im.basedata.BDSyncMappingInfo;
import com.kingdee.eas.tm.im.basedata.BDSyncPropertyCollection;
import com.kingdee.eas.tm.im.basedata.BDSyncPropertyFactory;
import com.kingdee.eas.tm.im.basedata.BDSyncPropertyInfo;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleFactory;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleInfo;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleSegmentCollection;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleSegmentInfo;
import com.kingdee.eas.tm.im.basedata.BaseDataStatusEnum;
import com.kingdee.eas.tm.im.basedata.client.AbstractBDSyncRuleEditUI;
import com.kingdee.eas.tm.im.client.util.IMClientCache;
import com.kingdee.eas.tm.im.common.formula.client.comp.BDSyncRuleSegDefSelector;
import com.kingdee.eas.tm.im.common.formula.model.RuleSegementInfo;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.im.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BDSyncRuleEditUI
extends AbstractBDSyncRuleEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(BDSyncRuleEditUI.class);
    private static final String TB_DESTPROPERTY_ALIAS = "destPropertyAlias";
    private static final String TB_SRCPROPERTY_ALIAS = "srcPropertyAlias";
    private EditUIHelper uiHelper = null;
    private String currentCUID = null;
    private CommonEntityFilterPanel commonFilterPanel = null;
    private DataChangeListener mappingChangeListener = null;
    private KDTEditAdapter entryTableChange = null;
    private ChangeListener tabChangeListener = null;
    private Map<String, BDSyncPropertyInfo> propertyFieldMap = new HashMap<String, BDSyncPropertyInfo>();

    public BDSyncRuleEditUI() throws Exception {
        this.uiHelper = new EditUIHelper(this);
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    public void onLoad() throws Exception {
        this.kdtRuleSegments.checkParsed();
        super.onLoad();
    }

    protected void addCustomerToolTip() {
        ArrayList<TMToolTipInfo> infoList = new ArrayList<TMToolTipInfo>();
        infoList.add(new TMToolTipInfo(TB_SRCPROPERTY_ALIAS, (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("BDSYNRULE_PropertyAlias"), (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("FIELDTITLE") + ";" + "https://vip.kingdee.com/article/256785309931769088?productLineId=8"));
        TMToolTipUtil.setToolTipInfo((JComponent)this.getDetailTable(), infoList);
        ArrayList<TMToolTipInfo> infoList2 = new ArrayList<TMToolTipInfo>();
        infoList2.add(new TMToolTipInfo(TMToolTipResourceUtil.BDSYNRULE_condition, (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get(TMToolTipResourceUtil.BDSYNRULE_condition), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.commonFilterPanel.getKdtTable(), infoList2);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        try {
            this.initNumber();
            this.initComponents();
            this.addCustomerToolTip();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.innerLoadFields();
        this.initListeners();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    private void initNumber() throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)this.editData, this.currentCUID);
        boolean isNumberEditable = false;
        if (codingRule == null) {
            isNumberEditable = true;
        } else {
            if (codingRule.isIsAddView() && this.txtNumber.getText().trim().isEmpty()) {
                this.txtNumber.setText(iCodingRuleManager.getNumber((IObjectValue)this.editData, this.currentCUID));
            }
            isNumberEditable = codingRule.isIsModifiable();
        }
        this.txtNumber.setEnabled(isNumberEditable);
        this.txtNumber.setEditable(isNumberEditable);
    }

    private void initCommonFilterPanel() throws Exception {
        BDSyncMappingInfo mappingInfo = null;
        if (this.prmtMapping.getValue() instanceof BDSyncMappingInfo) {
            mappingInfo = (BDSyncMappingInfo)this.prmtMapping.getValue();
        }
        if (mappingInfo == null) {
            return;
        }
        if (this.commonFilterPanel != null) {
            ControlUtilities.checkFocusAndCommit();
            this.filterPanel.remove((Component)this.commonFilterPanel);
            this.commonFilterPanel = null;
        }
        int width = 550;
        int height = 340;
        int defaultRows = 10;
        EntityObjectInfo srcEntity = IMClientCache.getEntity(mappingInfo.getSrcBosType());
        MetaDataPK entityPK = new MetaDataPK(srcEntity.getFullName());
        this.commonFilterPanel = new CommonEntityFilterPanel((IMetaDataPK)entityPK, this.editData.getFilterInfo(), null, null, false, true);
        this.filterPanel.add((Component)this.commonFilterPanel);
        this.commonFilterPanel.setBounds(0, 0, width, height);
        boolean canEditFilterPanel = "EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState());
        this.commonFilterPanel.getKdtTable().setEditable(canEditFilterPanel);
        this.commonFilterPanel.getAddRowButton().setEnabled(canEditFilterPanel);
        this.commonFilterPanel.getDelRowButton().setEnabled(canEditFilterPanel);
        this.commonFilterPanel.getClearButton().setEnabled(canEditFilterPanel);
        this.commonFilterPanel.getInsRowButton().setEnabled(canEditFilterPanel);
        this.commonFilterPanel.getMoveUpRowButton().setEnabled(canEditFilterPanel);
        this.validate();
    }

    protected FilterInfo buildFilterInfo(BDSyncRuleInfo info) {
        FilterInfo filterInfo = new FilterInfo();
        if (StringUtils.isEmpty((String)info.getDataFilter())) {
            return filterInfo;
        }
        try {
            filterInfo = new FilterInfo(info.getDataFilter());
            filterInfo.setMaskString(info.getDataFilterMask());
        }
        catch (ParserException e) {
            this.handleException((Exception)((Object)e));
        }
        return filterInfo;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setDataFilter(this.getFilterInfo().toString());
        this.editData.setDataFilterMask(this.getFilterInfo().getMaskString());
    }

    protected FilterInfo getFilterInfo() {
        return this.commonFilterPanel == null ? new FilterInfo() : this.commonFilterPanel.getFilterInfo();
    }

    private void initListeners() {
        if (this.mappingChangeListener == null) {
            this.mappingChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    if (IMUtils.isEqual(e.getOldValue(), e.getNewValue())) {
                        return;
                    }
                    try {
                        BDSyncRuleEditUI.this.mapping_dataChanged(e);
                    }
                    catch (Exception ex) {
                        BDSyncRuleEditUI.this.handleException(ex);
                    }
                }
            };
        }
        this.prmtMapping.addDataChangeListener(this.mappingChangeListener);
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    if (IMUtils.objectEquals(e.getOldValue(), e.getValue())) {
                        return;
                    }
                    try {
                        BDSyncRuleEditUI.this.kdtEntries_editStopped(e);
                    }
                    catch (Exception ex) {
                        BDSyncRuleEditUI.this.handUIException(ex);
                    }
                }

                public void editStarting(KDTEditEvent e) {
                    try {
                        BDSyncRuleEditUI.this.kdtEntries_editStarting(e);
                    }
                    catch (Exception ex) {
                        BDSyncRuleEditUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.getDetailTable().addKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.tabChangeListener == null) {
            this.tabChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    BDSyncRuleEditUI.this.tabbedPane_stateChange(changeEvent);
                }
            };
        }
        this.tabbedPane.addChangeListener(this.tabChangeListener);
    }

    private void removeListener() {
        if (this.mappingChangeListener != null) {
            this.prmtMapping.removeDataChangeListener(this.mappingChangeListener);
        }
        if (this.entryTableChange != null) {
            this.getDetailTable().removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
        if (this.tabChangeListener != null) {
            this.tabbedPane.removeChangeListener(this.tabChangeListener);
        }
    }

    private void tabbedPane_stateChange(ChangeEvent e) {
        KDTabbedPane tabbedPane = (KDTabbedPane)e.getSource();
        int currentSelectedIndex = tabbedPane.getSelectedIndex();
        if (currentSelectedIndex == 1 && !this.isAllowTabChange()) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.basedata.BDSyncRuleResource", "MSG_MAPPING_SELECT_FIRST"));
            tabbedPane.setSelectedIndex(0);
            this.prmtMapping.requestFocus();
        }
    }

    private boolean isAllowTabChange() {
        return this.prmtMapping.getValue() != null;
    }

    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.getDetailTable().getColumnKey(colIndex);
        IRow row = this.getDetailTable().getRow(rowIndex);
        if (TB_SRCPROPERTY_ALIAS.equalsIgnoreCase(fieldName)) {
            RuleSegementInfo obj = (RuleSegementInfo)row.getCell(fieldName).getValue();
            BDSyncRuleSegmentInfo entry = (BDSyncRuleSegmentInfo)row.getUserObject();
            if (obj != null) {
                entry.setSrcPropertyAlias(obj.getExpressionAlias());
                if (obj.isProperty()) {
                    entry.setSrcPropertyName(obj.getExpression());
                    entry.setExpression(null);
                } else {
                    entry.setSrcPropertyName(null);
                    entry.setExpression(obj.getExpression());
                }
            } else {
                entry.setSrcPropertyName(null);
                entry.setSrcPropertyAlias(null);
                entry.setExpression(null);
            }
        }
    }

    protected void kdtEntries_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.getDetailTable().getColumnKey(colIndex);
        IRow row = this.getDetailTable().getRow(rowIndex);
        if (TB_SRCPROPERTY_ALIAS.equalsIgnoreCase(fieldName) && this.prmtMapping.getValue() == null) {
            e.setCancel(true);
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.basedata.BDSyncRuleResource", "MSG_MAPPING_SELECT_FIRST"));
            this.prmtMapping.requestFocus();
        }
    }

    private void mapping_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null || e.getNewValue() instanceof Object[] && ((Object[])e.getNewValue()).length == 0) {
            this.prmtMapping.setDataNoNotify(e.getOldValue());
            this.prmtMapping.requestFocus();
            return;
        }
        if (e.getOldValue() != null && e.getNewValue() != null) {
            int flag = MsgBox.showConfirm2((String)IMUtils.getString("com.kingdee.eas.tm.im.basedata.BDSyncRuleResource", "MSG_MAPPING_CHANGE_CONFIRM"));
            if (flag == 0) {
                this.mappingChanged(e);
            } else {
                this.prmtMapping.setDataNoNotify(e.getOldValue());
            }
        } else {
            this.mappingChanged(e);
        }
    }

    protected void mappingChanged(DataChangeEvent e) throws Exception {
        this.editData.setDataFilter(null);
        this.editData.setDataFilterMask(null);
        this.initComponents();
        this.loadEntries(this.editData, e.getNewValue(), true);
        this.innerLoadFields();
    }

    private void loadEntries(BDSyncRuleInfo info, Object objInfo, boolean isDefault) {
        info.getRuleSegments().clear();
        BDSyncMappingInfo mappingInfo = null;
        if (objInfo == null || !(objInfo instanceof BDSyncMappingInfo)) {
            return;
        }
        mappingInfo = (BDSyncMappingInfo)objInfo;
        List ignoreFieldList = this.getPropertyFieldList(mappingInfo, "ignoreField");
        List defaultFieldList = this.getPropertyFieldList(mappingInfo, "defaultField");
        String billBosType = mappingInfo.getDestBosType();
        EntityObjectInfo entity = IMClientCache.getEntity(billBosType);
        PropertyCollection properties = entity.getEntityProperties();
        PropertyInfo propertyInfo = null;
        BDSyncRuleSegmentInfo entryInfo = null;
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            propertyInfo = properties.get(i);
            if (ignoreFieldList != null && ignoreFieldList.contains(propertyInfo.getName()) || isDefault && defaultFieldList != null && !defaultFieldList.contains(propertyInfo.getName())) continue;
            entryInfo = new BDSyncRuleSegmentInfo();
            entryInfo.setSeq(i + 1);
            entryInfo.setDestPropertyName(propertyInfo.getName());
            entryInfo.setDestPropertyAlias(propertyInfo.getAlias());
            info.getRuleSegments().add(entryInfo);
        }
    }

    private List getPropertyFieldList(BDSyncMappingInfo mapping, String field) {
        if (mapping == null) {
            return null;
        }
        BDSyncPropertyInfo propertyInfo = this.getPropertyFieldMap().get(mapping.getDestBosType());
        if (propertyInfo == null) {
            return null;
        }
        String propertyField = propertyInfo.getString(field);
        if (StringUtils.isEmpty((String)propertyField)) {
            return null;
        }
        return Arrays.asList(propertyField.split(","));
    }

    private Map<String, BDSyncPropertyInfo> getPropertyFieldMap() {
        if (this.propertyFieldMap.size() == 0) {
            this.propertyFieldMap.put("EMPTY_KEY", null);
            BDSyncPropertyCollection coll = null;
            try {
                coll = BDSyncPropertyFactory.getRemoteInstance().getBDSyncPropertyCollection();
                BDSyncPropertyInfo propertyInfo = null;
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    propertyInfo = coll.get(i);
                    this.propertyFieldMap.put(propertyInfo.getBillBosType(), propertyInfo);
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.propertyFieldMap;
    }

    protected void innerLoadFields() {
        this.getDetailTable().removeRows();
        BDSyncRuleSegmentCollection coll = this.editData.getRuleSegments();
        coll.sort("seq");
        for (int i = 0; i < coll.size(); ++i) {
            this.appendNewLine(coll.get(i));
        }
    }

    private void appendNewLine(BDSyncRuleSegmentInfo entryInfo) {
        if (entryInfo == null) {
            return;
        }
        IRow row = this.getDetailTable().addRow();
        this.updateLineData(entryInfo, row);
    }

    private void updateLineData(BDSyncRuleSegmentInfo entryInfo, IRow row) {
        if (entryInfo == null || row == null) {
            return;
        }
        row.getCell(TB_DESTPROPERTY_ALIAS).setValue((Object)entryInfo.getDestPropertyAlias());
        row.getCell(TB_SRCPROPERTY_ALIAS).setValue((Object)RuleSegementInfo.build(entryInfo));
        row.setUserObject((Object)entryInfo);
        List requiredFieldList = this.getPropertyFieldList(this.editData.getMapping(), "requiredField");
        if (requiredFieldList != null && requiredFieldList.contains(entryInfo.getDestPropertyName())) {
            row.getStyleAttributes().setBackground(new Color(255, 255, 153));
        }
    }

    private void initComponents() throws Exception {
        this.initCommonFilterPanel();
        this.initHead();
        this.initEntries();
        this.initBtnStatus();
    }

    private void initHead() {
        if (this.editData == null) {
            return;
        }
        this.prmtMapping.setEnabled(!this.editData.isIsScheduled());
    }

    private void initEntries() {
        this.getDetailTable().getColumn(TB_DESTPROPERTY_ALIAS).getStyleAttributes().setLocked(true);
        this.initRuleSegColumn();
    }

    private void initRuleSegColumn() {
        BDSyncMappingInfo mappingInfo = null;
        if (this.prmtMapping.getValue() instanceof BDSyncMappingInfo) {
            mappingInfo = (BDSyncMappingInfo)this.prmtMapping.getValue();
        }
        if (mappingInfo == null) {
            return;
        }
        this.getDetailTable().getColumn(TB_SRCPROPERTY_ALIAS).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.buildRuleSegEditor(mappingInfo)));
    }

    private KDPromptBox buildRuleSegEditor(final BDSyncMappingInfo mappingInfo) {
        BDSyncRuleEditUI owner = this;
        KDPromptBox f7 = new KDPromptBox();
        f7.setEditable(false);
        f7.setHistoryRecordEnabled(false);
        f7.addSelectorListener(new SelectorListener((IUIObject)owner){
            final /* synthetic */ IUIObject val$owner;
            {
                this.val$owner = iUIObject;
            }

            public void willShow(SelectorEvent e) {
                EntityObjectInfo srcEntity = IMClientCache.getEntity(mappingInfo.getSrcBosType());
                EntityObjectInfo destEntity = IMClientCache.getEntity(mappingInfo.getDestBosType());
                KDPromptBox thisF7 = (KDPromptBox)e.getSource();
                int rowIndex = BDSyncRuleEditUI.this.getDetailTable().getEditManager().getEditRowIndex();
                IRow row = BDSyncRuleEditUI.this.getDetailTable().getRow(rowIndex);
                BDSyncRuleSegmentInfo entryInfo = (BDSyncRuleSegmentInfo)row.getUserObject();
                BDSyncRuleSegDefSelector selector = new BDSyncRuleSegDefSelector(this.val$owner.getUIWindow(), srcEntity, destEntity, (IObjectValue)entryInfo);
                thisF7.setSelector((KDPromptSelector)selector);
            }
        });
        return f7;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSave.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
        this.loadFields();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        if (BaseDataStatusEnum.USING.equals((Object)this.editData.getState())) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.basedata.BDSyncRuleResource", "MSG_CANNOT_EDIT"));
            return;
        }
        super.actionEdit_actionPerformed(e);
        this.loadFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.commonFilterPanel != null && !this.commonFilterPanel.verify()) {
            SysUtil.abort();
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (pk != null && !this.uiHelper.isAddNew(action)) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            return new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
        }
        return super.getOrgPK(action);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            BDSyncRuleInfo info = (BDSyncRuleInfo)this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            if (BaseDataStatusEnum.USING.equals((Object)info.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        super.actionCancelCancel_actionPerformed(e);
        if (BaseDataStatusEnum.FORBIDDEN.equals((Object)this.editData.getState())) {
            this.setOprtState("EDIT");
        } else {
            this.setOprtState("VIEW");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        super.actionCancel_actionPerformed(e);
        this.setOprtState("VIEW");
        this.loadFields();
    }

    private void initBtnStatus() {
        if (this.editData == null) {
            return;
        }
        HashMap<String, Object> btnMap = new HashMap<String, Object>();
        btnMap.put("actionRemove", this.actionRemove);
        btnMap.put("actionCancel", this.actionCancel);
        btnMap.put("actionCancelCancel", this.actionCancelCancel);
        btnMap.put("actionEdit", this.actionEdit);
        btnMap.put("actionSave", this.actionSubmit);
        btnMap.put("actionCopy", this.actionCopy);
        boolean isLight = !BaseDataStatusEnum.USING.equals((Object)this.editData.getState());
        this.uiHelper.initBtnStatus(btnMap, isLight);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        BDSyncRuleInfo head = (BDSyncRuleInfo)newData;
        head.setNumber(null);
        head.setState(BaseDataStatusEnum.USING);
        head.setIsScheduled(false);
        head.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        head.setCreator(null);
        head.setCreateTime(null);
        head.setLastUpdateUser(null);
        head.setLastUpdateTime(null);
        String cuID = head.getCU().getId().toString();
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)this.editData, cuID);
            String number = null;
            if (codingRule != null && codingRule.isIsAddView()) {
                number = iCodingRuleManager.getNumber((IObjectValue)this.editData, cuID);
            }
            this.editData.setNumber(number);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        super.actionRemove_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        BDSyncRuleInfo head = new BDSyncRuleInfo();
        head.setState(BaseDataStatusEnum.USING);
        head.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        head.setIsScheduled(false);
        BDSyncMappingInfo mappingInfo = this.getDefaultMappingInfo();
        head.setMapping(mappingInfo);
        this.loadEntries(head, mappingInfo, true);
        return head;
    }

    private BDSyncMappingInfo getDefaultMappingInfo() {
        BDSyncMappingInfo mapping = null;
        try {
            mapping = BDSyncMappingFactory.getRemoteInstance().getBDSyncMappingInfo((IObjectPK)new ObjectUuidPK("2dSOwViQWBPgU5cHEawc6amDM2s="));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return mapping;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BDSyncRuleSegmentInfo entryInfo = new BDSyncRuleSegmentInfo();
        return entryInfo;
    }

    protected KDTable getDetailTable() {
        return this.kdtRuleSegments;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BDSyncRuleFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("ruleSegments.*"));
        return sic;
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }
}

