/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleFactory;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleInfo;
import com.kingdee.eas.tm.im.basedata.BaseDataStatusEnum;
import com.kingdee.eas.tm.im.basedata.client.AbstractBDSyncRuleListUI;
import com.kingdee.eas.tm.im.basedata.client.BDSyncRuleEditUI;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.im.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BDSyncRuleListUI
extends AbstractBDSyncRuleListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(BDSyncRuleListUI.class);
    private ListUIHelper uiHelper = null;
    private String currentCUID = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public BDSyncRuleListUI() throws Exception {
        this.uiHelper = new ListUIHelper(this);
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCancel.setVisible(true);
        this.actionCancel.setEnabled(true);
        this.actionCancelCancel.setVisible(true);
        this.actionCancelCancel.setEnabled(true);
        this.menuBiz.setVisible(true);
        this.menuBiz.setEnabled(true);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
            this.refreshList();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        super.actionCancel_actionPerformed(e);
        this.refreshList();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        String billId = this.getSelectedKeyValue();
        if (this.isSupportedBatchActions() && !this.uiHelper.isAddNew(action)) {
            BDSyncRuleInfo info = null;
            try {
                if (!StringUtils.isEmpty((String)billId) && this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(billId)) && (info = (BDSyncRuleInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(billId))) != null && info.getCU() != null) {
                    pk = new ObjectUuidPK(info.getCU().getId().toString());
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            if (pk != null) {
                return pk;
            }
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            return new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
        }
        return super.getOrgPK(action);
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void cancel() throws Exception {
        this.uiHelper.batchOperation("cancel", this.tblMain, this.getKeyFieldName(), "number", "4B34C97F");
    }

    protected void cancelCancel() throws Exception {
        this.uiHelper.batchOperation("cancelCancel", this.tblMain, this.getKeyFieldName(), "number", "4B34C97F");
    }

    protected void Remove() throws Exception {
        this.uiHelper.batchOperation("delete", this.tblMain, this.getKeyFieldName(), "number", "4B34C97F");
    }

    protected String getEditUIName() {
        return BDSyncRuleEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BDSyncRuleFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    protected void checkStateEnableEdit() throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        BDSyncRuleInfo bdSyncRuleInfo = BDSyncRuleFactory.getRemoteInstance().getBDSyncRuleInfo((IObjectPK)new ObjectUuidPK(billId));
        if (BaseDataStatusEnum.USING.equals((Object)bdSyncRuleInfo.getState())) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.basedata.BDSyncRuleResource", "MSG_CANNOT_EDIT"));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanRemove(this.currentCUID, this.getSelectedIdValues());
        super.actionRemove_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    protected String getOnloadPermItemName() {
        return null;
    }
}

