/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTipInfo;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipResourceUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipUtil;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxEntryCollection;
import com.kingdee.eas.tm.im.basedata.CustomerTaxEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.basedata.CustomerTaxSourceTypeEnum;
import com.kingdee.eas.tm.im.basedata.CustomerTaxStatusEnum;
import com.kingdee.eas.tm.im.basedata.DiscountTypeEnum;
import com.kingdee.eas.tm.im.basedata.IsPrintListEnum;
import com.kingdee.eas.tm.im.basedata.client.AbstractCustomerTaxEditUI;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.im.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CustomerTaxEditUI
extends AbstractCustomerTaxEditUI
implements IPermSupport4EditUI {
    private static final String IS_DEFAULT = "isDefault";
    private static final Logger logger = CoreUIObject.getLogger(CustomerTaxEditUI.class);
    private static final String DISCOUNTTYPE_ENUM = "com.kingdee.eas.tm.im.basedata.DiscountTypeEnum";
    private static final String ISPRINTLIST_ENUM = "com.kingdee.eas.tm.im.basedata.IsPrintListEnum";
    private static final String INVOICETYPE_ENUM = "com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum";
    private static final String TD_INVOICETYPE = "invoiceType";
    private static final String TD_LIMITAMT = "limitAmt";
    private static final String NUMFORMAT = "###,##0.##########";
    private static final String TD_DISCOUNTTYPE = "discountType";
    private static final String TD_ISPRINTLIST = "isPrintList";
    private static final String ORGCODE = "orgCode";
    private ChangeListener isValueAddedChange = null;
    private ChangeListener isVehicleChange = null;
    private DataChangeListener prmtCustomerChange = null;
    private DataChangeListener prmtSupplierChange = null;
    private boolean isNumberEditable = false;
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private String currentCUID;
    private Map btnMap;
    private KDTEditAdapter entryTableChange = null;
    private ItemListener comboAssActTypeChange = null;

    public CustomerTaxEditUI() throws Exception {
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMap = new HashMap();
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
    }

    protected IObjectValue createNewData() {
        CustomerTaxInfo taxInfo = new CustomerTaxInfo();
        taxInfo.setCurrentAccountType(CurrentAccountType.CUSTOMER);
        taxInfo.setStatus(CustomerTaxStatusEnum.USING);
        taxInfo.getEntries().addCollection(this.createNewDetailData(this.kdtEntries));
        taxInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        taxInfo.setIsDefault(true);
        taxInfo.setIsValueAdded(false);
        taxInfo.setIsVehicle(false);
        taxInfo.setSourceType(CustomerTaxSourceTypeEnum.ADDNEW);
        return taxInfo;
    }

    protected CustomerTaxEntryCollection createNewDetailData(KDTable table) {
        CustomerTaxEntryCollection coll = new CustomerTaxEntryCollection();
        Iterator invoiceTypes = PayInvoiceTypeEnum.iterator();
        while (invoiceTypes.hasNext()) {
            PayInvoiceTypeEnum invoiceType = (PayInvoiceTypeEnum)invoiceTypes.next();
            if (invoiceType == PayInvoiceTypeEnum.DEFAULTTYPE) continue;
            CustomerTaxEntryInfo entryInfo = new CustomerTaxEntryInfo();
            entryInfo.setInvoiceType(invoiceType);
            entryInfo.setLimitAmt(BigDecimal.ZERO);
            entryInfo.setDiscountType(DiscountTypeEnum.NULL);
            entryInfo.setIsPrintList(IsPrintListEnum.NULL);
            entryInfo.setIsDefault(false);
            if (invoiceType.equals((Object)PayInvoiceTypeEnum.VALUEADDEDTAXINV)) {
                coll.insertObject(-1, (IObjectValue)entryInfo);
                continue;
            }
            coll.add(entryInfo);
        }
        return coll;
    }

    public void onLoad() throws Exception {
        this.kdtEntries.checkParsed();
        super.onLoad();
        this.initEntryEditor();
        this.initCompanyF7();
        this.initAssActType();
        this.initVehicleManageF7();
        this.btnPrint.setEnabled(false);
        this.btnPrintPreview.setEnabled(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.menuItemPrint.setEnabled(false);
        this.menuItemPrintPreview.setEnabled(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.addCustomerToolTip();
    }

    protected void addCustomerToolTip() {
        TMToolTipUtil.setToolTipInfo((JComponent)this.contCompany, (TMToolTipInfo)new TMToolTipInfo("contCompany", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("CUSTOMERTAX_Company"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.chkIsValueAdded, (TMToolTipInfo)new TMToolTipInfo("chkIsValueAdded", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("CUSTOMERTAX_IsValueAdded"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.chkIsDefault, (TMToolTipInfo)new TMToolTipInfo("chkIsDefault", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("CUSTOMERTAX_IsDefault"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.chkIsVehicle, (TMToolTipInfo)new TMToolTipInfo("chkIsVehicle", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("CUSTOMERTAX_IsVehicle"), ""));
        ArrayList<TMToolTipInfo> infoList = new ArrayList<TMToolTipInfo>();
        infoList.add(new TMToolTipInfo(TD_LIMITAMT, (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("CUSTOMERTAX_limitAmt"), ""));
        infoList.add(new TMToolTipInfo(TD_DISCOUNTTYPE, (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("CUSTOMERTAX_discountType"), ""));
        infoList.add(new TMToolTipInfo(TD_ISPRINTLIST, (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("CUSTOMERTAX_isPrintList"), ""));
        infoList.add(new TMToolTipInfo(IS_DEFAULT, (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("CUSTOMERTAX_isDefault2"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.getDetailTable(), infoList);
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.uiHelper.lockUIForViewStatus();
    }

    protected void unLockUI() {
        super.unLockUI();
        this.uiHelper.unLockUI();
    }

    private void setIsDefaultStatus() {
        Map map = null;
        try {
            String cusOrSupId = null;
            String currentAccountType = null;
            if (CurrentAccountType.CUSTOMER.equals(this.kdComAssActType.getSelectedItem())) {
                cusOrSupId = (CustomerInfo)this.prmtCustomer.getValue() != null ? ((CustomerInfo)this.prmtCustomer.getValue()).getId().toString() : null;
                currentAccountType = "1";
            } else if (CurrentAccountType.SUPPLIER.equals(this.kdComAssActType.getSelectedItem())) {
                cusOrSupId = (SupplierInfo)this.prmtSupplier.getValue() != null ? ((SupplierInfo)this.prmtSupplier.getValue()).getId().toString() : null;
                currentAccountType = "2";
            }
            String customerTaxId = this.editData.getId() != null ? this.editData.getId().toString() : null;
            String companyId = this.prmtCompany.getValue() != null ? ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString() : null;
            map = CustomerTaxFactory.getRemoteInstance().isHasDefault(cusOrSupId, customerTaxId, companyId, currentAccountType);
            boolean hasDefault = (Boolean)map.get("result");
            this.chkIsDefault.setSelected(!hasDefault);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CustomerTaxFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        this.checkIsValueAdded();
        this.checkEntryUnique();
        this.checkIsDefault();
        super.actionSubmit_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getStatus() != null && CustomerTaxStatusEnum.USING.equals((Object)this.editData.getStatus())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    private void checkEntryUnique() {
        if (this.getDetailTable() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"EntryIsDefaultValid"));
            SysUtil.abort();
        }
        int isOneCom = 0;
        int isOneEle = 0;
        int isOneEleSpe = 0;
        int isOneVal = 0;
        int isOneDigElec = 0;
        int isOneDigElecSpe = 0;
        boolean isEmpty = false;
        int size = this.getDetailTable().getRowCount();
        if (size == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"AtLeastOneEntry"));
            SysUtil.abort();
        }
        for (int i = 0; i < size; ++i) {
            CustomerTaxEntryInfo info = (CustomerTaxEntryInfo)this.getDetailTable().getRow(i).getUserObject();
            if (info == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"EntryIsDefaultValid"));
                SysUtil.abort();
            }
            if (PayInvoiceTypeEnum.COMMONINVOICE.equals((Object)info.getInvoiceType())) {
                ++isOneCom;
            }
            if (PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)info.getInvoiceType())) {
                ++isOneEle;
            }
            if (PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)info.getInvoiceType())) {
                ++isOneVal;
            }
            if (PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)info.getInvoiceType())) {
                ++isOneEleSpe;
            }
            if (PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)info.getInvoiceType())) {
                ++isOneDigElec;
            }
            if (PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)info.getInvoiceType())) {
                ++isOneDigElecSpe;
            }
            if (info.getInvoiceType() != null && !PayInvoiceTypeEnum.DEFAULTTYPE.equals((Object)info.getInvoiceType())) continue;
            isEmpty = true;
        }
        if (isOneCom >= 2 || isOneEle >= 2 || isOneVal >= 2 || isOneEleSpe >= 2 || isOneDigElec >= 2 || isOneDigElecSpe >= 2 || isEmpty) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"EntryIsDefaultValid"));
            SysUtil.abort();
        }
    }

    private void checkIsDefault() {
        Map map = null;
        try {
            String cusOrSupId = "";
            String customerTaxId = this.editData.getId() != null ? this.editData.getId().toString() : "";
            String companyId = this.prmtCompany.getValue() != null ? ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString() : null;
            String currentAccountType = "";
            if (CurrentAccountType.CUSTOMER.equals(this.kdComAssActType.getSelectedItem())) {
                cusOrSupId = (CustomerInfo)this.prmtCustomer.getValue() != null ? ((CustomerInfo)this.prmtCustomer.getValue()).getId().toString() : null;
                currentAccountType = "1";
            } else if (CurrentAccountType.SUPPLIER.equals(this.kdComAssActType.getSelectedItem())) {
                cusOrSupId = (SupplierInfo)this.prmtSupplier.getValue() != null ? ((SupplierInfo)this.prmtSupplier.getValue()).getId().toString() : null;
                currentAccountType = "2";
            }
            map = CustomerTaxFactory.getRemoteInstance().isHasDefault(cusOrSupId, customerTaxId, companyId, currentAccountType);
            boolean hasDefault = (Boolean)map.get("result");
            if (this.chkIsDefault.isSelected() && CustomerTaxStatusEnum.USING.equals((Object)this.editData.getStatus()) && hasDefault) {
                if (MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"HASDEFAULT")))) {
                    CustomerTaxFactory.getRemoteInstance().updateDefaultStatus((List)map.get("ids"));
                } else {
                    SysUtil.abort();
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void checkIsValueAdded() {
        if (this.chkIsValueAdded.isSelected()) {
            StringBuffer sb = new StringBuffer();
            if (this.txtTaxNumber.getText() == null || this.txtTaxNumber.getText().trim().isEmpty()) {
                sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"TAXNUMBER"));
            }
            if (this.txtAddressTel.getText() == null || this.txtAddressTel.getText().trim().isEmpty()) {
                sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"ADDRESSTEL"));
            }
            if (this.txtBankAccount.getText() == null || this.txtBankAccount.getText().trim().isEmpty()) {
                sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"BANKACCOUNT"));
            }
            if (sb.length() > 0) {
                sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"NOTNULL"));
                MsgBox.showWarning((String)sb.substring(1));
                SysUtil.abort();
            }
        }
        String reg = "[a-zA-Z0-9]*";
        if (!this.txtTaxNumber.getText().matches(reg)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"TAXNUMBERFORMATERROR"));
            SysUtil.abort();
        }
    }

    private void initEntryEditor() {
        this.setEnumEditor(this.kdtEntries, TD_INVOICETYPE, INVOICETYPE_ENUM);
        this.setEnumEditor(this.kdtEntries, TD_DISCOUNTTYPE, DISCOUNTTYPE_ENUM);
        this.setEnumEditor(this.kdtEntries, TD_ISPRINTLIST, ISPRINTLIST_ENUM);
        this.setBigDecimalEditor(this.kdtEntries, TD_LIMITAMT, 3);
        KDCheckBox checkBox = new KDCheckBox();
        this.kdtEntries.getColumn(IS_DEFAULT).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)checkBox));
    }

    private void setEnumEditor(KDTable table, String columeName, String enumClazz) {
        KDComboBox enumEditor = new KDComboBox();
        Object[] objs = EnumUtils.getEnumList((String)enumClazz).toArray();
        if (columeName.equals(TD_INVOICETYPE) && objs.length > 0) {
            objs = EnumUtils.getEnumList((String)enumClazz).subList(1, objs.length).toArray();
        }
        enumEditor.addItems(objs);
        table.getColumn(columeName).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)enumEditor));
    }

    private void setBigDecimalEditor(KDTable table, String column, int precision) {
        KDFormattedTextField formattedField = new KDFormattedTextField();
        formattedField.setDataType(1);
        formattedField.setPrecision(precision);
        formattedField.setNegatived(false);
        formattedField.setRemoveingZeroInEdit(true);
        formattedField.setRemoveingZeroInDispaly(true);
        formattedField.setMaximumValue((Comparable)Integer.valueOf(100000000));
        formattedField.setHorizontalAlignment(4);
        table.getColumn(column).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedField));
        table.getColumn(column).getStyleAttributes().setNumberFormat(NUMFORMAT);
        table.getColumn(column).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void checkRequiredFields() {
        StringBuffer sb = new StringBuffer();
        if (this.txtRecCompanyName.getText() == null || this.txtRecCompanyName.getText().trim().isEmpty()) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"RECCOMPANYNAME"));
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"NOTNULL"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initNumber();
        this.initListeners();
        this.initBtnStatus();
        this.initComponents();
        this.comboAssActType_dataChanged(null);
        this.uiHelper.reloadPrivateFields();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    private void initComponents() {
        this.initInvoiceTypeRelateControl();
        this.initIsVehicle();
        this.initRowsLockState();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    private void initNumber() {
        try {
            String cuID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)this.editData, cuID);
            if (codingRule == null) {
                this.isNumberEditable = true;
                return;
            }
            if (codingRule.isIsModifiable()) {
                this.isNumberEditable = true;
            }
            if (codingRule.isIsAddView() && this.txtNumber.getText().trim().isEmpty()) {
                this.txtNumber.setText(CustomerTaxFactory.getRemoteInstance().getNewNumber(this.editData, cuID));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.handleException(e);
        }
    }

    private void initBtnStatus() {
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.txtNumber.setEditable(this.isNumberEditable);
        CustomerTaxStatusEnum status = this.editData.getStatus();
        boolean isLight = false;
        if (CustomerTaxStatusEnum.FORBIDDEN.equals((Object)status)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionAddLine.setEnabled(false);
            this.actionDelLine.setEnabled(false);
            this.actionMoveDown.setEnabled(false);
            this.actionMoveUp.setEnabled(false);
            this.kdtEntries.setEnabled(false);
        } else {
            this.actionAddLine.setEnabled(true);
            this.actionDelLine.setEnabled(true);
            this.actionMoveDown.setEnabled(true);
            this.actionMoveUp.setEnabled(true);
            this.kdtEntries.setEnabled(true);
        }
    }

    private void removeListener() {
        if (this.prmtCustomerChange != null) {
            this.prmtCustomer.removeDataChangeListener(this.prmtCustomerChange);
        }
        if (this.prmtSupplierChange != null) {
            this.prmtSupplier.removeDataChangeListener(this.prmtSupplierChange);
        }
        if (this.isValueAddedChange != null) {
            this.chkIsValueAdded.removeChangeListener(this.isValueAddedChange);
        }
        if (this.isVehicleChange != null) {
            this.chkIsVehicle.removeChangeListener(this.isVehicleChange);
        }
        if (this.entryTableChange != null) {
            this.kdtEntries.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
        if (this.comboAssActTypeChange != null) {
            this.kdComAssActType.removeItemListener(this.comboAssActTypeChange);
        }
    }

    private void initListeners() {
        if (this.prmtCustomerChange == null) {
            this.prmtCustomerChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    CustomerTaxEditUI.this.prmtCustomer_dataChanged(e);
                }
            };
        }
        this.prmtCustomer.addDataChangeListener(this.prmtCustomerChange);
        if (this.prmtSupplierChange == null) {
            this.prmtSupplierChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    CustomerTaxEditUI.this.prmtSupplier_dataChanged(e);
                }
            };
        }
        this.prmtSupplier.addDataChangeListener(this.prmtSupplierChange);
        if (this.isValueAddedChange == null) {
            this.isValueAddedChange = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    CustomerTaxEditUI.this.initIsValueAdded();
                }
            };
        }
        this.chkIsValueAdded.addChangeListener(this.isValueAddedChange);
        if (this.isVehicleChange == null) {
            this.isVehicleChange = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    CustomerTaxEditUI.this.initIsVehicle();
                }
            };
        }
        this.chkIsVehicle.addChangeListener(this.isVehicleChange);
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStarted(KDTEditEvent e) {
                    try {
                        CustomerTaxEditUI.this.kdtEntries_ChangedChanged(e);
                    }
                    catch (Exception exc) {
                        CustomerTaxEditUI.this.handUIException(exc);
                    }
                }

                public void editStopped(KDTEditEvent e) {
                    try {
                        if (IMUtils.objectEquals(e.getOldValue(), e.getValue())) {
                            return;
                        }
                        CustomerTaxEditUI.this.kdtEntries_ChangedStopped(e);
                    }
                    catch (Exception exc) {
                        CustomerTaxEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtEntries.addKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.comboAssActTypeChange == null) {
            this.comboAssActTypeChange = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CustomerTaxEditUI.this.comboAssActType_dataChanged(e);
                }
            };
        }
        this.kdComAssActType.addItemListener(this.comboAssActTypeChange);
    }

    protected void comboAssActType_dataChanged(ItemEvent e) {
        if (CurrentAccountType.CUSTOMER.equals(this.kdComAssActType.getSelectedItem())) {
            this.prmtCustomer.setEnabled(true);
            this.prmtCustomer.setVisible(true);
            this.prmtSupplier.setEnabled(false);
            this.prmtSupplier.setVisible(false);
            this.prmtSupplier.setDataNoNotify(null);
        } else if (CurrentAccountType.SUPPLIER.equals(this.kdComAssActType.getSelectedItem())) {
            this.prmtCustomer.setEnabled(false);
            this.prmtCustomer.setVisible(false);
            this.prmtSupplier.setEnabled(true);
            this.prmtSupplier.setVisible(true);
            this.prmtCustomer.setDataNoNotify(null);
        }
    }

    private void kdtEntries_ChangedChanged(KDTEditEvent e) throws BOSException {
        int rowIndex = e.getRowIndex();
        String colName = this.kdtEntries.getColumnKey(e.getColIndex());
        if (IS_DEFAULT.equals(colName)) {
            Boolean isDefault = (Boolean)e.getOldValue();
            if (isDefault != null && isDefault.booleanValue()) {
                return;
            }
            for (int i = 0; i < this.kdtEntries.getRowCount3(); ++i) {
                if (i == rowIndex) continue;
                this.kdtEntries.getRow(i).getCell(IS_DEFAULT).setValue((Object)false);
            }
        }
    }

    private void kdtEntries_ChangedStopped(KDTEditEvent e) throws Exception {
        String colName = this.kdtEntries.getColumnKey(e.getColIndex());
        if (TD_INVOICETYPE.equals(colName)) {
            IRow row = this.kdtEntries.getRow(e.getRowIndex());
            Object invoiceType = row.getCell(TD_INVOICETYPE).getValue();
            if (PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals(invoiceType) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals(invoiceType)) {
                row.getCell(TD_ISPRINTLIST).setValue((Object)IsPrintListEnum.NULL);
                row.getCell(TD_ISPRINTLIST).getStyleAttributes().setLocked(true);
            } else {
                row.getCell(TD_ISPRINTLIST).getStyleAttributes().setLocked(false);
            }
        }
    }

    protected void initIsValueAdded() {
        boolean isValueAdded = this.chkIsValueAdded.isSelected();
        this.txtTaxNumber.setRequired(isValueAdded);
        this.txtAddressTel.setRequired(isValueAdded);
        this.txtBankAccount.setRequired(isValueAdded);
        this.txtTaxNumber.repaint();
        this.txtAddressTel.repaint();
        this.txtBankAccount.repaint();
    }

    protected void initInvoiceTypeRelateControl() {
        boolean isValueAdded = this.chkIsValueAdded.isSelected();
        this.txtTaxNumber.setRequired(isValueAdded);
        this.txtAddressTel.setRequired(isValueAdded);
        this.txtBankAccount.setRequired(isValueAdded);
        this.txtTaxNumber.repaint();
        this.txtAddressTel.repaint();
        this.txtBankAccount.repaint();
    }

    protected void initIsVehicle() {
        boolean isVehicle = this.chkIsVehicle.isSelected();
        this.prmtVehicleManage.setEnabled(isVehicle);
        this.uiHelper.getTextField(ORGCODE).setEditable(isVehicle);
        if (!isVehicle) {
            this.prmtVehicleManage.setValue(null);
            this.uiHelper.getTextField(ORGCODE).setText(null);
        }
    }

    protected void initRowsLockState() {
        for (int i = 0; i < this.kdtEntries.getRowCount3(); ++i) {
            IRow curRow = this.kdtEntries.getRow2(i);
            Object invoiceType = curRow.getCell(TD_INVOICETYPE).getValue();
            if (!PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals(invoiceType) && !PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals(invoiceType)) continue;
            curRow.getCell(TD_ISPRINTLIST).getStyleAttributes().setLocked(true);
        }
    }

    protected void prmtSupplier_dataChanged(DataChangeEvent e) {
        if (e.getNewValue() != null && e.getNewValue() instanceof SupplierInfo) {
            SupplierInfo suppiler = (SupplierInfo)e.getNewValue();
            this.txtRecCompanyName.setText(suppiler.getName().toString());
            this.txtTaxNumber.setText(suppiler.getTaxRegisterNo());
            this.setIsDefaultStatus();
        }
    }

    protected void prmtCustomer_dataChanged(DataChangeEvent e) {
        if (e.getNewValue() != null && e.getNewValue() instanceof CustomerInfo) {
            CustomerInfo customer = (CustomerInfo)e.getNewValue();
            this.txtRecCompanyName.setText(customer.getName().toString());
            this.txtTaxNumber.setText(customer.getTaxRegisterNo());
            this.setIsDefaultStatus();
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        CustomerTaxInfo info = (CustomerTaxInfo)newData;
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setCompany(null);
        info.setNumber(null);
        info.setStatus(CustomerTaxStatusEnum.USING);
        info.setSourceType(CustomerTaxSourceTypeEnum.ADDNEW);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        if (CustomerTaxStatusEnum.USING.equals((Object)this.editData.getStatus())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"CANNOTREMOVE"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        if (CustomerTaxStatusEnum.USING.equals((Object)this.editData.getStatus())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"CANNOTEDIT"));
            return;
        }
        super.actionEdit_actionPerformed(e);
        this.initBtnStatus();
        this.initComponents();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        ArrayList<BOSUuid> ids = new ArrayList<BOSUuid>();
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ids.add(this.editData.getId());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        ArrayList errorList = CustomerTaxFactory.getRemoteInstance().inActive(ids);
        if (errorList.size() > 0) {
            MsgBox.showInfo((String)errorList.get(0).toString());
            SysUtil.abort();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
        }
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.setSaved(true);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable());
        }
    }

    @Override
    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.removeLine(this.getDetailTable());
            this.actionDelLine.setEnabled(this.getDetailTable().getRowCount() != 0);
        }
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable().getRowCount() == 0 || this.getDetailTable().getSelectManager().size() == 0) {
            return;
        }
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == 0) {
            return;
        }
        int toRowIndex = rowIndex - 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable().getRowCount() == 0 || this.getDetailTable().getSelectManager().size() == 0) {
            return;
        }
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == this.getDetailTable().getRowCount() - 1) {
            return;
        }
        int toRowIndex = rowIndex + 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    private void reLoadFields() {
        IObjectCollection collection = (IObjectCollection)this.getDetailTable().getUserObject();
        collection.clear();
        for (int i = 0; i < this.getDetailTable().getRowCount(); ++i) {
            IRow row1 = this.getDetailTable().getRow(i);
            this.loadLineFields(this.getDetailTable(), row1, (IObjectValue)((CustomerTaxEntryInfo)row1.getUserObject()));
        }
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    private void addLine(KDTable detailTable) {
        IRow row;
        KDTable kdTable = this.getDetailTable();
        if (kdTable.getSelectManager().size() > 0) {
            int top = kdTable.getSelectManager().get().getTop();
            row = kdTable.addRow(top + 1);
        } else {
            row = kdTable.addRow();
        }
        row.getCell(IS_DEFAULT).setValue((Object)false);
        this.actionDelLine.setEnabled(kdTable.getRowCount() != 0);
    }

    private void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            int top = table.getSelectManager().get().getBeginRow();
            int bottom = table.getSelectManager().get().getEndRow();
            for (int i = top; i <= bottom; ++i) {
                int index;
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                CustomerTaxEntryInfo selectRow = (CustomerTaxEntryInfo)table.getRow(top).getUserObject();
                table.removeRow(top);
                CustomerTaxEntryCollection coll = (CustomerTaxEntryCollection)((Object)this.getDetailTable().getUserObject());
                if (coll == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (selectRow == null || (index = this.getCollectionIndex(coll, selectRow)) < 0 || coll.size() <= index) continue;
                coll.removeObject(index);
            }
        }
    }

    private int getCollectionIndex(CustomerTaxEntryCollection coll, CustomerTaxEntryInfo selectRow) {
        int index = -1;
        if (coll == null) {
            return index;
        }
        for (int i = coll.size() - 1; i >= 0; --i) {
            if (selectRow != coll.getObject(i)) continue;
            index = i;
            return index;
        }
        return 0;
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<BOSUuid> ids = new ArrayList<BOSUuid>();
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ids.add(this.editData.getId());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        this.verify(e);
        ArrayList errorList = new ArrayList();
        if (this.editData.isIsDefault()) {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"checkDefault")))) {
                try {
                    errorList = CustomerTaxFactory.getRemoteInstance().active(ids);
                }
                catch (Exception ec) {
                    this.handleException(ec);
                }
            } else {
                SysUtil.abort();
            }
        } else {
            errorList = CustomerTaxFactory.getRemoteInstance().active(ids);
        }
        if (errorList.size() > 0) {
            MsgBox.showInfo((String)errorList.get(0).toString());
            SysUtil.abort();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
        }
        this.setDataObject(this.getValue((IObjectPK)pk));
        if (this.editData.getStatus() != null && CustomerTaxStatusEnum.USING.equals((Object)this.editData.getStatus())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (pk != null && !this.uiHelper.isAddNew(action)) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    private void initCompanyF7() throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> idset = new HashSet<String>();
        OrgUnitCollection authorizedMainOrgs = IMFacadeFactory.getRemoteInstance().getAuthOrgsByType(this.getMainType(), "bd_customerTax_new");
        if (authorizedMainOrgs != null && authorizedMainOrgs.size() > 0) {
            for (int i = 0; i < authorizedMainOrgs.size(); ++i) {
                OrgUnitInfo orgInfo = authorizedMainOrgs.get(i);
                idset.add(orgInfo.getId().toString());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", idset, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true, CompareType.EQUALS));
        ev.setFilter(filterInfo);
        this.prmtCompany.setEntityViewInfo(ev);
    }

    private void initVehicleManageF7() throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> idset = new HashSet<String>();
        OrgUnitCollection authorizedMainOrgs = IMFacadeFactory.getRemoteInstance().getAuthOrgsByType(this.getMainType(), "im_vehiclemanage_view");
        if (authorizedMainOrgs != null && authorizedMainOrgs.size() > 0) {
            for (int i = 0; i < authorizedMainOrgs.size(); ++i) {
                OrgUnitInfo orgInfo = authorizedMainOrgs.get(i);
                idset.add(orgInfo.getId().toString());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", idset, CompareType.INCLUDE));
        }
        ev.setFilter(filterInfo);
        this.prmtVehicleManage.setEntityViewInfo(ev);
    }

    private void initAssActType() {
        this.kdComAssActType.removeItem((Object)CurrentAccountType.COMPANY);
    }
}

