/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.basedata.CustomerTaxStatusEnum;
import com.kingdee.eas.tm.im.basedata.client.AbstractCustomerTaxListUI;
import com.kingdee.eas.tm.im.common.IMCommonProcessor;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.im.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class CustomerTaxListUI
extends AbstractCustomerTaxListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(CustomerTaxListUI.class);
    private ListUIHelper uiHelper = null;
    private CommonQueryDialog commonQueryDialog = null;
    private String currentCUID;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public CustomerTaxListUI() throws Exception {
        this.uiHelper = new ListUIHelper(this);
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        this.getQuickFilteringSupport();
        super.onLoad();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.getMainTable().getColumn("limitAmt").getStyleAttributes().setNumberFormat("#,##0.00");
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.tm.im.basedata.client.CustomerTaxEditUI";
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            if (this.getUIContext().get("OwnerWindow") == null) {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            try {
                this.commonQueryDialog.setProcessor((IProcessor)new IMCommonProcessor());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            this.commonQueryDialog.setWidth(510);
            this.commonQueryDialog.setHeight(300);
        }
        return this.commonQueryDialog;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CustomerTaxFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tblMain.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"number", "company.number", "company", "currentAccountType", "customer.number", "customer.name", "status", "recCompanyName", "TaxNumber", "addressTel", "bankAccount", "isValueAdded", "isDefault", "createTime", "lastUpdateTime", "id", "cu", "sourceType", "isVehicle", "orgCode", "vehicleManage.name"};
        return columns;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        String id = this.getSelectedKeyValue();
        CustomerTaxInfo info = CustomerTaxFactory.getRemoteInstance().getCustomerTaxInfo((IObjectPK)new ObjectUuidPK(id));
        if (CustomerTaxStatusEnum.USING.equals((Object)info.getStatus())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"CANNOTEDIT"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int billCount = ids.size();
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        if (!this.confirmRemove()) {
            return;
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            mutexServiceControl.batchRequestObjIDForUpdate((List)ids);
            ArrayList result = CustomerTaxFactory.getRemoteInstance().batchDelete(ids);
            String error = "";
            String errorDetail = "";
            if (result != null && !result.isEmpty()) {
                error = EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"REMOVE_ERROR");
                errorDetail = IMUtils.buildErrorMsg(result);
                int errorCount = result.size();
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_DeleteError", IMUtils.getLocale(), new Object[]{String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
                MsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorDetail.toString(), (int)1);
            } else {
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_DeleteSuccess", IMUtils.getLocale());
                MsgBox.showInfo((String)summaryMsg);
            }
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)this.getSelectedIdValues());
        }
        this.refreshList();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int billCount = ids.size();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (this.confirmDialog(cancelMsg)) {
            ArrayList errorList;
            if (UtilRequest.isPrepare((String)"ActionCancel", (CoreUIObject)this)) {
                this.prepareCancel(null).callHandler();
            }
            if ((errorList = CustomerTaxFactory.getRemoteInstance().inActive(ids)).size() > 0) {
                StringBuffer errorDetailMSG = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorDetailMSG.append(errorList.get(i)).append("\n");
                }
                int errorCount = errorList.size();
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelError", IMUtils.getLocale(), new Object[]{String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
                MsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorDetailMSG.toString(), (int)1);
            } else {
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelSuccess", IMUtils.getLocale());
                MsgBox.showInfo((String)summaryMsg);
            }
            this.refreshList();
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int billCount = ids.size();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        ArrayList errorList = new ArrayList();
        String[] isDefaults = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"isDefault");
        boolean isconfirm = false;
        for (int i = 0; i < isDefaults.length; ++i) {
            if (!"true".equals(isDefaults[i])) continue;
            isconfirm = true;
            break;
        }
        if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
            this.prepareCancelCancel(null).callHandler();
        }
        if (isconfirm) {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"checkDefault")))) {
                try {
                    errorList = CustomerTaxFactory.getRemoteInstance().active(ids);
                }
                catch (Exception ec) {
                    this.handleException(ec);
                }
            } else {
                SysUtil.abort();
            }
        } else {
            errorList = CustomerTaxFactory.getRemoteInstance().active(ids);
        }
        String cancelCancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelCancelError");
        if (errorList.size() > 0) {
            StringBuffer errorDetailMSG = new StringBuffer();
            for (int i = 0; i < errorList.size(); ++i) {
                errorDetailMSG.append(errorList.get(i)).append("\n");
            }
            int errorCount = errorList.size();
            String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelCancelError", IMUtils.getLocale(), new Object[]{String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
            MsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorDetailMSG.toString(), (int)1);
        } else {
            String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelCancelSuccess", IMUtils.getLocale());
            MsgBox.showInfo((String)summaryMsg);
        }
        this.refreshList();
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi;
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "customerTax";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionImportData_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "customerTax";
        param.datataskMode = 1;
        param.alias = EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"EXPORTEXCELNAME");
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        HashSet selectIds = new HashSet(this.getSelectedIdValues());
        try {
            if (selectIds.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.INCLUDE));
                hashtable.put("filter", filter);
            } else if (this.mainQuery != null) {
                hashtable.put("filter", this.mainQuery.getFilter());
            }
        }
        catch (Exception filter) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        if (this.isSupportedBatchActions() && !this.uiHelper.isAddNew(action)) {
            CustomerTaxInfo info = null;
            try {
                if (!StringUtils.isEmpty((String)this.getSelectedKeyValue()) && (info = CustomerTaxFactory.getRemoteInstance().getCustomerTaxInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))) != null && info.getCU() != null) {
                    pk = new ObjectUuidPK(info.getCU().getId().toString());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (pk != null) {
                return pk;
            }
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            this.initPermActions();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    public void refreshList() throws Exception {
        this.saveCurrentLocation();
        super.refreshList();
        this.restoreCurrentLocation();
    }
}

