/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeCollection;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.tm.im.basedata.IncomeTypeEntryCollection;
import com.kingdee.eas.tm.im.basedata.IncomeTypeEntryInfo;
import com.kingdee.eas.tm.im.basedata.IncomeTypeFactory;
import com.kingdee.eas.tm.im.basedata.IncomeTypeInfo;
import com.kingdee.eas.tm.im.basedata.IncomeTypeStatusEnum;
import com.kingdee.eas.tm.im.basedata.TypeEnum;
import com.kingdee.eas.tm.im.basedata.client.AbstractIncomeTypeEditUI;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.im.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class IncomeTypeEditUI
extends AbstractIncomeTypeEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(IncomeTypeEditUI.class);
    private static final String F7ExpenseType = "com.kingdee.eas.tm.im.app.F7IncomeTypeExpenseTypeQuery";
    private static final String F7RowType = "com.kingdee.eas.basedata.scm.common.app.RowTypeQuery";
    public static final String TB_ID = "typeId";
    public static final String TB_NUMBER = "number";
    public static final String TB_NAME = "name";
    private KDTEditAdapter entryTableChange = null;
    private DataChangeListener numberListener = null;
    private static Set<String> typeIDs;
    private EditUIHelper uiHelper = new EditUIHelper((EditUI)this);
    private String currentCUID;
    private Map btnMap = new HashMap();

    public IncomeTypeEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
        this.btnMap.put("actionAddLine", this.actionAddLine);
        this.btnMap.put("actionInsertLine", this.actionInsertLine);
        this.btnMap.put("actionRemoveLine", this.actionRemoveLine);
    }

    @Override
    public void loadFields() {
        this.removeEventLisener();
        super.loadFields();
        this.initBtnStatus();
        this.initEntryTypeF7();
        typeIDs = new HashSet<String>();
        try {
            this.innerLoadFields();
            typeIDs = IncomeTypeFactory.getRemoteInstance().getTypeId(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.addEventLisener();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    private void initBtnStatus() {
        this.actionCancelCancel.setVisible(true);
        this.actionCancel.setVisible(true);
        this.actionCopyLine.setVisible(false);
        this.actionCopy.setVisible(true);
        if (this.editData != null) {
            String type = "";
            if (TypeEnum.ExpenseType.equals((Object)this.editData.getType())) {
                type = F7ExpenseType;
            } else if (TypeEnum.RowType.equals((Object)this.editData.getType())) {
                type = F7RowType;
            }
            if ("".equalsIgnoreCase(type)) {
                this.actionAddLine.setEnabled(false);
                this.actionInsertLine.setEnabled(false);
                this.actionRemoveLine.setEnabled(false);
            } else {
                this.actionAddLine.setEnabled(true);
                this.actionInsertLine.setEnabled(true);
                this.actionRemoveLine.setEnabled(true);
            }
            IncomeTypeStatusEnum status = this.editData.getStatus();
            boolean isLight = false;
            if (IncomeTypeStatusEnum.UnActive.equals((Object)status)) {
                isLight = true;
            }
            this.uiHelper.initBtnStatus(this.btnMap, isLight);
        }
        AbstractAction actionTable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IncomeTypeEditUI.this.getDetailTable() != null) {
                    IncomeTypeEditUI.this.getDetailTable().removeRow(IncomeTypeEditUI.this.getDetailTable().getRowCount() - 1);
                    IncomeTypeEditUI.this.addLine(IncomeTypeEditUI.this.getDetailTable());
                }
            }
        };
        boolean tableKeyEnabled = this.actionCancelCancel.isEnabled() && !OprtState.VIEW.equals(this.getOprtState());
        this.uiHelper.initTableKeyStroke(this.getDetailTable(), tableKeyEnabled, actionTable);
    }

    private void innerLoadFields() throws EASBizException, BOSException {
        IncomeTypeEntryInfo entryInfo;
        IncomeTypeInfo info = (IncomeTypeInfo)IncomeTypeFactory.getRemoteInstance().getRealValue((IObjectValue)this.editData);
        if (info == null) {
            return;
        }
        IncomeTypeEntryCollection coll = info.getEntries();
        HashMap<String, IncomeTypeEntryInfo> entryMap = new HashMap<String, IncomeTypeEntryInfo>();
        HashSet<String> entryIds = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = coll.get(i);
            if (entryInfo.getTypeId() == null) continue;
            entryMap.put(entryInfo.getTypeId().toString(), entryInfo);
            entryIds.add(entryInfo.getTypeId().toString());
        }
        HashMap<String, Object> rowColl = new HashMap<String, Object>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", entryIds, CompareType.INCLUDE));
        view.setFilter(filter);
        if (entryIds.size() > 0) {
            int i;
            int size2;
            if (info.getType().equals((Object)TypeEnum.RowType)) {
                RowTypeCollection rowTypeCollection = RowTypeFactory.getRemoteInstance().getRowTypeCollection(view);
                RowTypeInfo rowTypeInfo = null;
                size2 = rowTypeCollection.size();
                for (i = 0; i < size2; ++i) {
                    rowTypeInfo = rowTypeCollection.get(i);
                    if (rowTypeInfo.getId() == null) continue;
                    rowColl.put(rowTypeInfo.getId().toString(), rowTypeInfo);
                }
            } else if (info.getType().equals((Object)TypeEnum.ExpenseType)) {
                ExpenseTypeCollection expenseTypeCollection = ExpenseTypeFactory.getRemoteInstance().getExpenseTypeCollection(view);
                ExpenseTypeInfo expenseTypeInfo = null;
                size2 = expenseTypeCollection.size();
                for (i = 0; i < size2; ++i) {
                    expenseTypeInfo = expenseTypeCollection.get(i);
                    if (expenseTypeInfo.getId() == null) continue;
                    rowColl.put(expenseTypeInfo.getId().toString(), expenseTypeInfo);
                }
            }
        }
        int rowCount = this.getDetailTable().getRowCount();
        String rowId = null;
        IObjectValue typeInfo = null;
        for (int i = 0; i < rowCount; ++i) {
            rowId = (String)this.getDetailTable().getRow(i).getCell(TB_ID).getValue();
            if (rowId == null) continue;
            entryInfo = (IncomeTypeEntryInfo)entryMap.get(rowId);
            typeInfo = (IObjectValue)rowColl.get(rowId);
            this.setEntryTypeValue(i, typeInfo);
        }
    }

    private void setEntryTypeValue(int rowIndex, IObjectValue value) {
        RowTypeInfo typeInfo;
        if (value instanceof ExpenseTypeInfo) {
            ExpenseTypeInfo typeInfo2 = (ExpenseTypeInfo)value;
            if (typeInfo2 != null) {
                this.kdtEntries.getRow(rowIndex).getCell(TB_NUMBER).setValue((Object)value);
                this.kdtEntries.getRow(rowIndex).getCell(TB_NAME).setValue((Object)typeInfo2.getName());
            }
        } else if (value instanceof RowTypeInfo && (typeInfo = (RowTypeInfo)value) != null) {
            this.kdtEntries.getRow(rowIndex).getCell(TB_NUMBER).setValue((Object)value);
            this.kdtEntries.getRow(rowIndex).getCell(TB_NAME).setValue((Object)typeInfo.getName());
        }
    }

    private void addEventLisener() {
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStarting(KDTEditEvent e) {
                    IncomeTypeEditUI.this.kdtEntries_editStarting(e);
                }
            };
        }
        this.getDetailTable().addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    protected void registerDealMultiProductInfo(KDBizPromptBox promptBox) {
        this.numberListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                IncomeTypeEditUI.this.numberChanged(e);
            }
        };
        promptBox.addDataChangeListener(this.numberListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void numberChanged(DataChangeEvent e) {
        try {
            Object[] objects;
            if (IMUtils.isEqual(e.getNewValue(), e.getOldValue())) {
                return;
            }
            KDBizPromptBox bizExpenseItemBox = (KDBizPromptBox)e.getSource();
            KDTable tb = this.getDetailTable();
            KDTSelectBlock selected = tb.getSelectManager().get();
            if (selected == null) {
                return;
            }
            int selectedRow = selected.getBeginRow();
            if (bizExpenseItemBox.getValue() == null) {
                this.getDetailTable().getRow(selectedRow).getCell(TB_ID).setValue(null);
                this.getDetailTable().getRow(selectedRow).getCell(TB_NUMBER).setValue(null);
                this.getDetailTable().getRow(selectedRow).getCell(TB_NAME).setValue(null);
                return;
            }
            Object[] typeObj = null;
            if (bizExpenseItemBox.getValue() instanceof Object[]) {
                objects = (Object[])bizExpenseItemBox.getValue();
                if (objects.length == 0) {
                    return;
                }
            } else {
                return;
            }
            typeObj = new Object[objects.length];
            System.arraycopy(objects, 0, typeObj, 0, objects.length);
            this.doNumberChanged(bizExpenseItemBox, typeObj, selectedRow);
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doNumberChanged(KDBizPromptBox bizItemBox, Object[] typeObj, int selectedRow) throws Exception {
        if (typeObj == null || typeObj.length == 0) {
            bizItemBox.setValue(null);
            return;
        }
        KDTable table = this.getDetailTable();
        HashMap<Object, Exception> beforeExceptionMap = new HashMap<Object, Exception>();
        HashMap afterExceptionMap = new HashMap();
        KDTSelectBlock ksb = table.getSelectManager().get();
        int beginRow = ksb.getBeginRow();
        IRow curRow = table.getRow(beginRow);
        int curCol = table.getColumnIndex(TB_NUMBER);
        bizItemBox.removeDataChangeListener(this.numberListener);
        Object etInfo = null;
        int length = typeObj.length;
        if (length > 0) {
            IRow curRow2 = null;
            boolean needInsert = false;
            int insertedRowCount = 0;
            for (int i = 0; i < length; ++i) {
                if (needInsert) {
                    this.insertLine(beginRow + insertedRowCount);
                    needInsert = false;
                }
                etInfo = typeObj[i];
                curRow2 = table.getRow(beginRow + insertedRowCount);
                if (typeObj[i] == null) {
                    curRow2.getCell(curCol).setValue(null);
                    return;
                }
                curRow2.getCell(curCol).setValue(null);
                try {
                    if (etInfo instanceof ExpenseTypeInfo) {
                        ExpenseTypeInfo exInfo = (ExpenseTypeInfo)etInfo;
                        curRow2.getCell(curCol).setValue((Object)exInfo);
                        curRow2.getCell(TB_ID).setValue((Object)exInfo.getId());
                        curRow2.getCell(TB_NAME).setValue((Object)exInfo.getName());
                    } else if (etInfo instanceof RowTypeInfo) {
                        RowTypeInfo rowInfo = (RowTypeInfo)etInfo;
                        curRow2.getCell(curCol).setValue((Object)rowInfo);
                        curRow2.getCell(TB_ID).setValue((Object)rowInfo.getId());
                        curRow2.getCell(TB_NAME).setValue((Object)rowInfo.getName());
                    }
                }
                catch (Exception ex) {
                    curRow2.getCell(curCol).setValue(etInfo);
                    curRow2.getCell(curCol).setValue(null);
                    beforeExceptionMap.put(etInfo, ex);
                    continue;
                }
                needInsert = true;
                ++insertedRowCount;
            }
            if (!needInsert && insertedRowCount > 0) {
                this.removeLine(table, beginRow + insertedRowCount);
            }
        } else {
            curRow.getCell(curCol).setValue((Object)new MaterialInfo());
            curRow.getCell(curCol).setValue(null);
        }
        bizItemBox.addDataChangeListener(this.numberListener);
    }

    protected void insertLine(int row) {
        IRow irow = this.getDetailTable().addRow(row);
    }

    protected void removeLine(KDTable table, int rowIndex) {
        if (table == null) {
            return;
        }
        if (table.getRow(rowIndex) != null) {
            table.getSelectManager().select(rowIndex, 0, rowIndex, 0, 2);
            IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
            table.removeRow(rowIndex);
            IObjectCollection collection = (IObjectCollection)table.getUserObject();
            if (collection == null) {
                logger.error((Object)"collection not be binded to table");
            } else if (detailData != null) {
                collection.removeObject(detailData);
            }
        }
    }

    private void removeEventLisener() {
        this.getDetailTable().removeKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    private void kdtEntries_editStarting(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        if (TB_NUMBER.equalsIgnoreCase(fieldName)) {
            try {
                this.setTypeFilter();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    public void onLoad() throws Exception {
        this.kdtEntries.checkParsed();
        super.onLoad();
        this.MenuItemAttachment.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.initBtnStatus();
        this.initEntry();
    }

    protected void initEntry() {
        if (this.getDetailTable() != null) {
            this.getDetailTable().getActionMap().remove("AddRow");
            this.getDetailTable().getActionMap().remove("RemoveRow");
            this.getDetailTable().getActionMap().remove("Delete");
            this.getDetailTable().getActionMap().remove("Paste");
        }
        this.initEntryTypeF7();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        IncomeTypeInfo editData = (IncomeTypeInfo)newData;
        editData.setNumber(null);
        editData.setName(null);
        editData.setType(TypeEnum.NULL);
        editData.setStatus(IncomeTypeStatusEnum.UnActive);
        editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date date = new Date();
        editData.setCreateTime(new Timestamp(date.getTime()));
        editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
    }

    private void initEntryTypeF7() {
        String type = "";
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            this.actionAddLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
        }
        if (TypeEnum.ExpenseType.equals(this.comboType.getSelectedItem())) {
            type = F7ExpenseType;
        } else if (TypeEnum.RowType.equals(this.comboType.getSelectedItem())) {
            type = F7RowType;
        } else {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        }
        if ("".equalsIgnoreCase(type)) {
            this.removeNullRow(this.kdtEntries, new String[]{TB_NUMBER});
        } else {
            IncomeTypeInfo info = new IncomeTypeInfo();
            info.getEntries().add((IncomeTypeEntryInfo)this.createNewDetailData(this.kdtEntries));
        }
        KDBizPromptBox kdBizPromptBox = new KDBizPromptBox();
        kdBizPromptBox.setEditFormat("$number$");
        kdBizPromptBox.setDisplayFormat("$number$");
        kdBizPromptBox.setCommitFormat("$number$");
        kdBizPromptBox.setEditable(true);
        kdBizPromptBox.setQueryInfo(type);
        kdBizPromptBox.setEnabledMultiSelection(true);
        this.registerDealMultiProductInfo(kdBizPromptBox);
        this.getDetailTable().getColumn(TB_NUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kdBizPromptBox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn(TB_NUMBER).setRenderer((IBasicRender)avr);
    }

    protected void setTypeFilter() throws EASBizException, BOSException {
        KDBizPromptBox component = (KDBizPromptBox)this.getDetailTable().getColumn(TB_NUMBER).getEditor().getComponent();
        if (component == null) {
            return;
        }
        EntityViewInfo view = component.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        Set<Object> typeIds = new HashSet();
        typeIds = typeIDs;
        Object id = null;
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            id = this.kdtEntries.getRow(i).getCell(TB_ID).getValue();
            if (id == null) continue;
            typeIds.add(id.toString());
        }
        if (typeIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", typeIds, CompareType.NOTINCLUDE));
        }
        view.setFilter(filter);
        component.setEntityViewInfo(view);
        component.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    public void comboType_itemStateChanged(ItemEvent e) {
        this.initEntryTypeF7();
        this.kdtEntries.removeRows();
        if (this.getDetailTable() != null && !TypeEnum.NULL.equals(this.comboType.getSelectedItem())) {
            this.addLine(this.getDetailTable());
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.actionAddLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionInsertLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_insert"));
        this.actionRemoveLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionAddLine.setEnabled(false);
        this.actionInsertLine.setEnabled(false);
        this.actionRemoveLine.setEnabled(false);
        ArrayList<JButton> btnList = new ArrayList<JButton>();
        btnList.add(this.tableContainer.add((Action)this.actionAddLine));
        btnList.add(this.tableContainer.add((Action)this.actionInsertLine));
        btnList.add(this.tableContainer.add((Action)this.actionRemoveLine));
        for (int i = 0; i < btnList.size(); ++i) {
            KDWorkButton btn = (KDWorkButton)btnList.get(i);
            btn.setText(null);
            btn.setSize(new Dimension(22, 19));
            btn.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        IncomeTypeInfo info = new IncomeTypeInfo();
        info.setType(TypeEnum.NULL);
        info.setStatus(IncomeTypeStatusEnum.Active);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date date = new Date();
        info.setCreateTime(new Timestamp(date.getTime()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        IncomeTypeEntryInfo entryInfo = new IncomeTypeEntryInfo();
        return entryInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return IncomeTypeFactory.getRemoteInstance();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequired();
        this.removeNullRow(this.kdtEntries, new String[]{TB_NUMBER});
        if (this.kdtEntries.getRowCount() == 0) {
            this.comboType.setSelectedItem((Object)TypeEnum.NULL);
        }
        this.editData.setNumber(this.txtNumber.getText().trim());
        super.actionSubmit_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getStatus() != null && IncomeTypeStatusEnum.Active.equals((Object)this.editData.getStatus())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    private void checkRequired() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().trim().isEmpty()) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.IncomeTypeResource", (String)"NUMBER"));
        }
        if (this.txtName.getText().trim().isEmpty() && !this.txtNumber.getText().isEmpty()) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.IncomeTypeResource", (String)"NAME"));
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.IncomeTypeResource", (String)"NOTNULL"));
            MsgBox.showWarning((String)sb.substring(0));
            SysUtil.abort();
        }
    }

    private void removeNullRow(KDTable table, String[] colNames) {
        int rowCount = table.getRowCount();
        int colCount = table.getColumnCount();
        if (colNames == null) {
            for (int i = 0; i < rowCount; ++i) {
                boolean isNullRow = true;
                IRow row = table.getRow(i);
                for (int colIndex = 0; isNullRow && colIndex < colCount; ++colIndex) {
                    isNullRow = row.getCell(colIndex).getValue() == null;
                }
                if (!isNullRow) continue;
                table.removeRow(i);
                --i;
                --rowCount;
            }
        } else {
            int colCounts = colNames.length;
            for (int i = 0; i < rowCount; ++i) {
                boolean isNullRow = false;
                IRow row = table.getRow(i);
                for (int colIndex = 0; !isNullRow && colIndex < colCounts; ++colIndex) {
                    isNullRow = row.getCell(colNames[colIndex]).getValue() == null;
                }
                if (!isNullRow) continue;
                table.removeRow(i);
                --i;
                --rowCount;
            }
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        ArrayList<BOSUuid> ids = new ArrayList<BOSUuid>();
        ids.add(this.editData.getId());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>();
        pks.add(pk);
        ArrayList result = IncomeTypeFactory.getRemoteInstance().setUnActive(pks);
        if (result.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
        } else {
            MsgBox.showInfo((String)result.get(0).toString());
        }
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        ArrayList<BOSUuid> ids = new ArrayList<BOSUuid>();
        ids.add(this.editData.getId());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>();
        pks.add(pk);
        ArrayList result = IncomeTypeFactory.getRemoteInstance().setActive(pks);
        if (result.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
        } else {
            MsgBox.showInfo((String)result.get(0).toString());
        }
        this.setDataObject(this.getValue((IObjectPK)pk));
        if (this.editData.getStatus() != null && IncomeTypeStatusEnum.Active.equals((Object)this.editData.getStatus())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        if (IncomeTypeStatusEnum.Active.equals((Object)this.editData.getStatus())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.IncomeTypeResource", (String)"CANNOTEDIT"));
            return;
        }
        super.actionEdit_actionPerformed(e);
        this.initBtnStatus();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        if (IncomeTypeStatusEnum.Active.equals((Object)this.editData.getStatus())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.IncomeTypeResource", (String)"CANNOTREMOVE"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (pk != null && !this.uiHelper.isAddNew(action)) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }
}

