/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.basedata.client.AbstractProductBatchEditTCCUI;
import com.kingdee.eas.tm.im.basedata.client.TreeTaxClassificationCodeF7PromptDialog;
import com.kingdee.eas.tm.im.basedata.client.util.TCCClientUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ProductBatchEditTCCUI
extends AbstractProductBatchEditTCCUI {
    private DataChangeListener prmtTaxClassificationCodeChange = null;
    private DataChangeListener txtTaxRateChange = null;
    private ItemListener chkHasPreferentialChange = null;
    private ItemListener comboPreferentialPoliciesChange = null;
    private static TreeTaxClassificationCodeF7PromptDialog defaultTreeTCCF7PromptDialog;
    private static TreeTaxClassificationCodeF7PromptDialog filterTreeTCCF7PromptDialog;

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.initTCC();
        TCCClientUtil.initTaxRate(this.txtTaxRate);
        this.initListeners();
    }

    protected void initTCC() {
        Map uiContext = this.getUIContext();
        boolean isSelectVehicle = false;
        if (uiContext.get("isSelectVehicle") != null) {
            isSelectVehicle = (Boolean)uiContext.get("isSelectVehicle");
        }
        if (isSelectVehicle) {
            if (filterTreeTCCF7PromptDialog == null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("simpleName", (Object)"\u673a\u52a8\u8f66", CompareType.EQUALS));
                filterTreeTCCF7PromptDialog = new TreeTaxClassificationCodeF7PromptDialog((IUIObject)this, filter);
            }
            this.prmtTaxClassificationCode.setSelector((KDPromptSelector)filterTreeTCCF7PromptDialog);
        } else {
            if (defaultTreeTCCF7PromptDialog == null) {
                defaultTreeTCCF7PromptDialog = new TreeTaxClassificationCodeF7PromptDialog((IUIObject)this);
            }
            this.prmtTaxClassificationCode.setSelector((KDPromptSelector)defaultTreeTCCF7PromptDialog);
        }
    }

    private void removeListener() {
        if (this.prmtTaxClassificationCodeChange != null) {
            this.prmtTaxClassificationCode.removeDataChangeListener(this.prmtTaxClassificationCodeChange);
        }
        if (this.txtTaxRateChange != null) {
            this.txtTaxRate.removeDataChangeListener(this.txtTaxRateChange);
        }
        if (this.chkHasPreferentialChange != null) {
            this.chkHasPreferential.removeItemListener(this.chkHasPreferentialChange);
        }
        if (this.comboPreferentialPoliciesChange != null) {
            this.comboPreferentialPolicies.removeItemListener(this.comboPreferentialPoliciesChange);
        }
    }

    private void initListeners() {
        if (this.prmtTaxClassificationCodeChange == null) {
            this.prmtTaxClassificationCodeChange = TCCClientUtil.getTaxClassificationCodeChange(this.prmtTaxClassificationCode, this.prmtTaxClass, this.comboPreferentialPolicies, this.chkHasPreferential, this.txtTaxRate);
        }
        this.prmtTaxClassificationCode.addDataChangeListener(this.prmtTaxClassificationCodeChange);
        if (this.txtTaxRateChange == null) {
            this.txtTaxRateChange = TCCClientUtil.getTaxRateChange(this.comboPreferentialPolicies, this.chkHasPreferential, this.txtTaxRate);
        }
        this.txtTaxRate.addDataChangeListener(this.txtTaxRateChange);
        if (this.chkHasPreferentialChange == null) {
            this.chkHasPreferentialChange = TCCClientUtil.getHasPreferentialChange(this.comboPreferentialPolicies);
        }
        this.chkHasPreferential.addItemListener(this.chkHasPreferentialChange);
        if (this.comboPreferentialPoliciesChange == null) {
            this.comboPreferentialPoliciesChange = TCCClientUtil.getPreferentialPoliciesChange(this.prmtTaxClassificationCode, this.comboPreferentialPolicies, this.chkHasPreferential, this.txtTaxRate);
        }
        this.comboPreferentialPolicies.addItemListener(this.comboPreferentialPoliciesChange);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        Map uiContext = this.getUIContext();
        Set idSet = (Set)uiContext.get("idSet");
        StringBuffer sb = new StringBuffer();
        if (this.prmtTaxClassificationCode.getValue() == null) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"TAXCLASSIFICATIONCODE"));
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"NOTNULL"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("taxClassificationCode", (TaxClassificationCodeInfo)this.prmtTaxClassificationCode.getValue());
        param.put("taxClass", (TaxClassificationCodeInfo)this.prmtTaxClass.getValue());
        param.put("taxRate", this.txtTaxRate.getBigDecimalValue());
        param.put("hasPreferential", this.chkHasPreferential.isSelected());
        param.put("preferentialPolicies", (Object)((PreferentialPoliciesEnum)((Object)this.comboPreferentialPolicies.getSelectedItem())));
        String result = ProductCodeFactory.getRemoteInstance().batchModify(idSet, param);
        if (result.isEmpty()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"BATCHEDIT_SUCCESS"));
            this.getUIWindow().close();
        } else {
            MsgBox.showInfo((String)result.replace("<br/>", "\r\n"));
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

