/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.common.help.msgHelp.client.TMMsgBox;
import com.kingdee.eas.tm.common.help.msgHelp.client.util.TMMsgURLUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTipInfo;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipResourceUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipUtil;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.ProductCodeSourceTypeEnum;
import com.kingdee.eas.tm.im.ProductCodeStatusEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.basedata.client.AbstractProductEditUI;
import com.kingdee.eas.tm.im.basedata.client.TreeTaxClassificationCodeF7PromptDialog;
import com.kingdee.eas.tm.im.basedata.client.util.TCCClientUtil;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.im.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.TCCUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ProductEditUI
extends AbstractProductEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductEditUI.class);
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private SelectorListener prmtTCCSelectorListener = null;
    private DataChangeListener prmtTaxClassificationCodeChange = null;
    private DataChangeListener txtTaxRateChange = null;
    private ItemListener chkHasPreferentialChange = null;
    private ItemListener comboPreferentialPoliciesChange = null;
    private ChangeListener isVehicleChange = null;
    private String currentCUID;
    private int modelLength = 40;
    private Map btnMap = new HashMap();
    private static TreeTaxClassificationCodeF7PromptDialog defaultTreeTCCF7PromptDialog;
    private static TreeTaxClassificationCodeF7PromptDialog filterTreeTCCF7PromptDialog;

    public ProductEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
    }

    protected IObjectValue createNewData() {
        ProductCodeInfo productInfo = new ProductCodeInfo();
        productInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        productInfo.setPreferentialPolicies(PreferentialPoliciesEnum.Null);
        productInfo.setSourceType(ProductCodeSourceTypeEnum.MANUAL);
        productInfo.setIsVehicle(false);
        return productInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ProductCodeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        TCCClientUtil.initTCC(this.prmtTaxClassificationCode);
        TCCClientUtil.initTaxRate(this.txtTaxRate);
        defaultTreeTCCF7PromptDialog = new TreeTaxClassificationCodeF7PromptDialog((IUIObject)this);
        this.txtPrice.setPrecision(10);
        this.txtPrice.setRemoveingZeroInDispaly(false);
        this.txtPrice.setHorizontalAlignment(4);
        this.addCustomerToolTip();
    }

    protected void addCustomerToolTip() {
        TMToolTipUtil.setToolTipInfo((JComponent)this.contName, (TMToolTipInfo)new TMToolTipInfo("contName", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("PRODUCT_Name"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.contCompany, (TMToolTipInfo)new TMToolTipInfo("contCompany", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("PRODUCT_Company"), (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("FIELDTITLE") + ";" + "https://vip.kingdee.com/article/260729824740887296?productLineId=8"));
        TMToolTipUtil.setToolTipInfo((JComponent)this.contCustomer, (TMToolTipInfo)new TMToolTipInfo("contVersion", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("PRODUCT_Customer"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.contTaxClassificationCode, (TMToolTipInfo)new TMToolTipInfo("contTaxClassificationCode", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("PRODUCT_TaxClassificationCode"), (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("FIELDTITLE") + ";" + "https://vip.kingdee.com/article/256785309931769088?productLineId=8"));
        TMToolTipUtil.setToolTipInfo((JComponent)this.contTaxRate, (TMToolTipInfo)new TMToolTipInfo("contTaxRate", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("PRODUCT_TaxRate"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.contPreferentialPolicies, (TMToolTipInfo)new TMToolTipInfo("contPreferentialPolicies", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("PRODUCT_PreferentialPolicies"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.chkIsDiffTax, (TMToolTipInfo)new TMToolTipInfo("chkIsDiffTax", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("PRODUCT_IsDiffTax"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.chkIsVehicle, (TMToolTipInfo)new TMToolTipInfo("chkIsVehicle", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("PRODUCT_IsVehicle"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.contModel, (TMToolTipInfo)new TMToolTipInfo("contModel", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("PRODUCT_Model"), ""));
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initBtnStatus();
        this.initIsVehicle(true);
        if (this.editData.getTaxClassificationCode() != null) {
            TaxClassificationCodeInfo tccInfo = this.editData.getTaxClassificationCode();
            String vatSpecialManagement = tccInfo.getVATSpecialManagement();
            Set<PreferentialPoliciesEnum> policiesSet = TCCUtil.getPreferentialPoliciesByTCC(vatSpecialManagement);
            this.comboPreferentialPolicies.removeAllItems();
            this.comboPreferentialPolicies.addItems(policiesSet.toArray());
            if (!this.editData.isHasPreferential()) {
                ArrayList<Object> items = new ArrayList<Object>();
                for (int i = 0; i < this.comboPreferentialPolicies.getItemCount(); ++i) {
                    items.add(this.comboPreferentialPolicies.getItemAt(i));
                }
                if (!items.contains((Object)PreferentialPoliciesEnum.Null)) {
                    this.comboPreferentialPolicies.addItem((Object)PreferentialPoliciesEnum.Null);
                }
                this.comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.Null);
            } else {
                this.comboPreferentialPolicies.setSelectedItem((Object)this.editData.getPreferentialPolicies());
            }
            if ("EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState())) {
                if (PreferentialPoliciesEnum.NoTaxation.getAlias().equals(vatSpecialManagement) && BigDecimal.ZERO.equals(tccInfo.getTaxRate())) {
                    this.chkHasPreferential.setEnabled(false);
                    this.chkHasPreferential.setSelected(true);
                    this.comboPreferentialPolicies.setEnabled(false);
                    this.comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.NoTaxation);
                    this.txtTaxRate.setNumberValue((Number)BigDecimal.ZERO);
                    this.txtTaxRate.setEnabled(false);
                } else {
                    this.chkHasPreferential.setEnabled(true);
                    this.comboPreferentialPolicies.setEnabled(this.chkHasPreferential.isSelected());
                }
            }
        }
        this.initListeners();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    private void initBtnStatus() {
        ProductCodeStatusEnum status = this.editData.getStatus();
        boolean isLight = false;
        if (ProductCodeStatusEnum.FORBIDDEN.equals((Object)status)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
    }

    private void removeListener() {
        if (this.prmtTaxClassificationCodeChange != null) {
            this.prmtTaxClassificationCode.removeDataChangeListener(this.prmtTaxClassificationCodeChange);
        }
        if (this.txtTaxRateChange != null) {
            this.txtTaxRate.removeDataChangeListener(this.txtTaxRateChange);
        }
        if (this.chkHasPreferentialChange != null) {
            this.chkHasPreferential.removeItemListener(this.chkHasPreferentialChange);
        }
        if (this.comboPreferentialPoliciesChange != null) {
            this.comboPreferentialPolicies.removeItemListener(this.comboPreferentialPoliciesChange);
        }
        if (this.isVehicleChange != null) {
            this.chkIsVehicle.removeChangeListener(this.isVehicleChange);
        }
        if (this.prmtTCCSelectorListener != null) {
            this.prmtTaxClassificationCode.removeSelectorListener(this.prmtTCCSelectorListener);
        }
    }

    private void initListeners() {
        if (this.prmtTaxClassificationCodeChange == null) {
            this.prmtTaxClassificationCodeChange = TCCClientUtil.getTaxClassificationCodeChange(this.prmtTaxClassificationCode, this.prmtTaxClass, this.comboPreferentialPolicies, this.chkHasPreferential, this.txtTaxRate);
        }
        this.prmtTaxClassificationCode.addDataChangeListener(this.prmtTaxClassificationCodeChange);
        if (this.txtTaxRateChange == null) {
            this.txtTaxRateChange = TCCClientUtil.getTaxRateChange(this.comboPreferentialPolicies, this.chkHasPreferential, this.txtTaxRate);
        }
        this.txtTaxRate.addDataChangeListener(this.txtTaxRateChange);
        if (this.chkHasPreferentialChange == null) {
            this.chkHasPreferentialChange = TCCClientUtil.getHasPreferentialChange(this.comboPreferentialPolicies);
        }
        this.chkHasPreferential.addItemListener(this.chkHasPreferentialChange);
        if (this.comboPreferentialPoliciesChange == null) {
            this.comboPreferentialPoliciesChange = TCCClientUtil.getPreferentialPoliciesChange(this.prmtTaxClassificationCode, this.comboPreferentialPolicies, this.chkHasPreferential, this.txtTaxRate);
        }
        this.comboPreferentialPolicies.addItemListener(this.comboPreferentialPoliciesChange);
        if (this.isVehicleChange == null) {
            this.isVehicleChange = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    ProductEditUI.this.initIsVehicle(false);
                }
            };
        }
        this.chkIsVehicle.addChangeListener(this.isVehicleChange);
        if (this.prmtTCCSelectorListener == null) {
            this.prmtTCCSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    ProductEditUI.this.initTCCF7();
                }
            };
        }
        this.prmtTaxClassificationCode.addSelectorListener(this.prmtTCCSelectorListener);
    }

    private void initTCCF7() {
        TreeTaxClassificationCodeF7PromptDialog selector = defaultTreeTCCF7PromptDialog;
        if (this.chkIsVehicle.isSelected()) {
            if (filterTreeTCCF7PromptDialog == null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("simpleName", (Object)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"Vehicle"), CompareType.EQUALS));
                filterTreeTCCF7PromptDialog = new TreeTaxClassificationCodeF7PromptDialog((IUIObject)this, filter);
            }
            selector = filterTreeTCCF7PromptDialog;
        }
        this.prmtTaxClassificationCode.setSelector((KDPromptSelector)selector);
    }

    protected void initIsVehicle(boolean isOnload) {
        boolean isVehicle = this.chkIsVehicle.isSelected();
        Object tcc = this.prmtTaxClassificationCode.getValue();
        if (!isOnload && isVehicle && tcc instanceof TaxClassificationCodeInfo && !((TaxClassificationCodeInfo)tcc).getSimpleName().equals(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"Vehicle"))) {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"ISEmptyTCC")))) {
                this.prmtTaxClassificationCode.setValue(null);
                this.chkIsVehicle.setSelected(true);
            } else {
                return;
            }
        }
        this.txtVehicleType.setEnabled(isVehicle);
        this.txtFacPlateModel.setEnabled(isVehicle);
        this.txtOrigin.setEnabled(isVehicle);
        this.txtTonnage.setEnabled(isVehicle);
        this.txtLimitPopulation.setEnabled(isVehicle);
        this.txtProductionEnterprise.setEnabled(isVehicle);
        if (!isVehicle) {
            this.txtVehicleType.setText(null);
            this.txtFacPlateModel.setText(null);
            this.txtOrigin.setText(null);
            this.txtTonnage.setText(null);
            this.txtLimitPopulation.setText(null);
            this.txtProductionEnterprise.setText(null);
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        ProductCodeInfo info = (ProductCodeInfo)newData;
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setSourceType(ProductCodeSourceTypeEnum.MANUAL);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequired();
        super.actionSubmit_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getStatus() != null && ProductCodeStatusEnum.USING.equals((Object)this.editData.getStatus())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        if (ProductCodeStatusEnum.USING.equals((Object)this.editData.getStatus())) {
            TMMsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"CANNOTEDIT"), (Map)TMMsgURLUtil.getMsgURL((String)"IMK"));
            return;
        }
        super.actionEdit_actionPerformed(e);
        Object o = this.prmtTaxClassificationCode.getValue();
        if (o != null && o instanceof TaxClassificationCodeInfo) {
            TaxClassificationCodeInfo tccInfo = (TaxClassificationCodeInfo)o;
            String vatSpecialManagement = tccInfo.getVATSpecialManagement();
            if (PreferentialPoliciesEnum.NoTaxation.getAlias().equals(vatSpecialManagement) && BigDecimal.ZERO.equals(tccInfo.getTaxRate())) {
                this.chkHasPreferential.setSelected(true);
                this.chkHasPreferential.setEnabled(false);
                this.comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.NoTaxation);
                this.comboPreferentialPolicies.setEnabled(false);
                this.txtTaxRate.setNumberValue((Number)BigDecimal.ZERO);
                this.txtTaxRate.setEnabled(false);
            } else {
                this.chkHasPreferential.setEnabled(true);
                this.comboPreferentialPolicies.setEnabled(this.chkHasPreferential.isSelected());
            }
        }
        this.initBtnStatus();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        if (ProductCodeStatusEnum.USING.equals((Object)this.editData.getStatus())) {
            TMMsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"CANNOTREMOVE"), (Map)TMMsgURLUtil.getMsgURL((String)"IMK"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    private void checkRequired() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"NUMBER"));
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"NAME"));
        }
        if (this.prmtTaxClassificationCode.getText().isEmpty()) {
            sb.append("\u3001").append(this.contTaxClassificationCode.getBoundLabelText());
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"NOTNULL"));
        }
        if (IMUtils.getStringlength(this.txtModel.getText()) > this.modelLength) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"model"));
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"OVERLENGTH"));
        }
        if (sb.length() > 0) {
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.comboStatus.setSelectedItem((Object)ProductCodeStatusEnum.USING);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("taxClassificationCode.parent.*"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("expenseItem.id"));
        sic.add(new SelectorItemInfo("expenseItem.name"));
        sic.add(new SelectorItemInfo("expenseItem.number"));
        return sic;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        this.verify(e);
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>();
        pks.add(pk);
        ArrayList result = ProductCodeFactory.getRemoteInstance().setUnActive(pks);
        if (result.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
        } else {
            TMMsgBox.showInfo((String)result.get(0).toString(), (Map)TMMsgURLUtil.getMsgURL((String)"IMK"));
        }
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.setSaved(true);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        this.verify(e);
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>();
        pks.add(pk);
        ArrayList result = ProductCodeFactory.getRemoteInstance().setActive(pks);
        if (result.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
        } else {
            TMMsgBox.showInfo((String)result.get(0).toString(), (Map)TMMsgURLUtil.getMsgURL((String)"IMK"));
        }
        this.setDataObject(this.getValue((IObjectPK)pk));
        if (this.editData.getStatus() != null && ProductCodeStatusEnum.USING.equals((Object)this.editData.getStatus())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        this.setSaved(true);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.handUIException(e);
        }
        if (pk != null && !this.uiHelper.isAddNew(action)) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    public void handUIException(Throwable exc) {
        if (TMMsgBox.handUIException((Component)((Object)this), (Throwable)exc, (String)"IMK")) {
            super.handUIException(exc);
        }
    }
}

