/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.common.help.msgHelp.client.TMMsgBox;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.ProductCodeCollection;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.basedata.MatchTccStrategyEnum;
import com.kingdee.eas.tm.im.basedata.client.AbstractProductGeneticMatchTccUI;
import com.kingdee.eas.tm.im.basedata.client.TreeTaxClassificationCodeF7PromptDialog;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.TCCUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ProductGeneticMatchTccUI
extends AbstractProductGeneticMatchTccUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductGeneticMatchTccUI.class);
    private static final String TAXCLASSCODE_QUERY = "com.kingdee.eas.tm.im.app.TaxClassificationCodeQuery";
    private static final String PRODUCT_QUERY = "com.kingdee.eas.tm.im.app.F7ProductCodeQuery";
    private static final String TB_PRODUCTNUMBER = "productNumber";
    private static final String TB_PRODUCTNAME = "productName";
    private static final String TB_TCCNUMBER = "tccNumber";
    private static final String TB_TCCNAME = "tccName";
    private static final String TB_TAXRATE = "taxRate";
    private static final String TB_HASPREFERENTIAL = "hasPreferential";
    private static final String TB_PREFERENTIALPOLICIES = "preferentialPolicies";
    private static final String TB_MATCHRESULT = "matchResult";
    private IObjectCollection products = null;
    private ItemListener hasPreferentialListener = null;
    private DataChangeListener taxRateListener = null;
    private KDTEditAdapter entryTableChange = null;
    private ItemListener policiesListener = null;
    private SelectorListener tccF7SelectorListener = null;
    private List productIds = new ArrayList();
    private int ratePrecision = 4;
    private Map<String, IObjectCollection> tccInfoMap = new HashMap<String, IObjectCollection>();
    private KDTMouseListener entryMosueListener = null;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.beforeLoad();
        super.onLoad();
        this.afterLoad();
    }

    protected void beforeLoad() {
        this.productIds = (List)this.getUIContext().get("ids");
    }

    protected void afterLoad() throws BOSException {
        this.cbIgnoreMatched.setSelected(true);
        this.cbFilterByTcc.setSelected(true);
        this.loadData();
        this.innerLoadFields();
        this.initControl();
        this.initListeners();
    }

    protected void loadData() throws BOSException {
        int i;
        this.products = new ProductCodeCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(this.productIds), CompareType.INCLUDE));
        view.setSelector(this.getSelector());
        view.setFilter(filter);
        ProductCodeCollection coll = ProductCodeFactory.getRemoteInstance().getProductCodeCollection(view);
        ProductCodeInfo productCodeInfo = null;
        HashMap<String, ProductCodeInfo> productCodeMap = new HashMap<String, ProductCodeInfo>();
        int size = coll.size();
        for (i = 0; i < size; ++i) {
            productCodeInfo = coll.get(i);
            productCodeMap.put(productCodeInfo.getId().toString(), productCodeInfo);
        }
        size = this.productIds.size();
        for (i = 0; i < size; ++i) {
            productCodeInfo = (ProductCodeInfo)productCodeMap.get(this.productIds.get(i));
            if (productCodeInfo == null) continue;
            this.products.addObject((IObjectValue)productCodeInfo);
        }
        this.initOldData();
    }

    private void innerLoadFields() {
        this.tblMain.removeRows();
        ProductCodeInfo product = null;
        int size = this.products.size();
        for (int i = 0; i < size; ++i) {
            product = (ProductCodeInfo)this.products.getObject(i);
            this.appendNewLine(product);
        }
    }

    protected void initControl() {
        this.tblMain.getActionMap().remove("AddRow");
        this.tblMain.getActionMap().remove("RemoveRow");
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getActionMap().remove("Paste");
        this.cbxMatchTccStrategy.setSelectedItem((Object)MatchTccStrategyEnum.firstMatch);
        this.cbxMatchTccStrategy.setEnabled(false);
        this.actionSaveContinue.setVisible(false);
        KDTableHelper.updateEnterWithTab((KDTable)this.tblMain, (boolean)false);
        KDTableHelper.downArrowAutoAddRow((KDTable)this.tblMain, (boolean)false, null);
        this.tblMain.getColumn(TB_PRODUCTNUMBER).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(TB_PRODUCTNUMBER).getStyleAttributes().setBackground(new Color(192, 192, 192));
        this.tblMain.getColumn(TB_MATCHRESULT).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(TB_MATCHRESULT).getStyleAttributes().setFontColor(new Color(102, 153, 255));
        this.tblMain.getColumn(TB_TCCNAME).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(TB_TCCNAME).getStyleAttributes().setBackground(new Color(192, 192, 192));
        this.tblMain.getColumn(TB_HASPREFERENTIAL).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(true);
        this.initHasPreferential();
        this.initTaxRate();
        this.initTCCF7();
        this.initProductF7();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            TaxClassificationCodeInfo tccInfo = (TaxClassificationCodeInfo)row.getCell(TB_TCCNUMBER).getValue();
            if (tccInfo == null) {
                row.getCell(TB_HASPREFERENTIAL).getStyleAttributes().setLocked(true);
                row.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(true);
                continue;
            }
            boolean hasPreferential = (Boolean)row.getCell(TB_HASPREFERENTIAL).getValue();
            row.getCell(TB_HASPREFERENTIAL).getStyleAttributes().setLocked(false);
            row.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(!hasPreferential);
            this.initComboPolicies(row, tccInfo);
        }
    }

    private void initListeners() {
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        if (IMUtils.objectEquals(e.getOldValue(), e.getValue())) {
                            return;
                        }
                        ProductGeneticMatchTccUI.this.kdtEntries_ChangedStopped(e);
                    }
                    catch (Exception exc) {
                        ProductGeneticMatchTccUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.tblMain.addKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.entryMosueListener == null) {
            this.entryMosueListener = new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    try {
                        ProductGeneticMatchTccUI.this.tblMain_tableClicked(e);
                    }
                    catch (Exception exc) {
                        ProductGeneticMatchTccUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.tblMain.addKDTMouseListener(this.entryMosueListener);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) {
        IRow curRow;
        Integer value;
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2 && this.tblMain.getColumn(e.getColIndex()).getKey().equals(TB_MATCHRESULT) && (value = (Integer)(curRow = this.getCurRow()).getCell(TB_MATCHRESULT).getUserObject()) != null && value > 0) {
            this.tblMain.getEditManager().editCellAt(e.getRowIndex(), 2);
            KDBizPromptBox taxClassCode = (KDBizPromptBox)this.tblMain.getColumn(TB_TCCNUMBER).getEditor().getComponent();
            taxClassCode.setDataBySelector();
        }
    }

    protected void kdtEntries_ChangedStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        String fieldName = this.tblMain.getColumnKey(colIndex);
        if (TB_TCCNUMBER.equals(fieldName)) {
            this.tccDataChanged(e);
        }
    }

    private void tccDataChanged(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        TaxClassificationCodeInfo tccInfo = (TaxClassificationCodeInfo)e.getValue();
        if (tccInfo == null) {
            row.getCell(TB_TCCNAME).setValue(null);
            row.getCell(TB_TAXRATE).setValue(null);
            row.getCell(TB_HASPREFERENTIAL).setValue((Object)false);
            row.getCell(TB_PREFERENTIALPOLICIES).setValue((Object)PreferentialPoliciesEnum.Null);
            row.getCell(TB_TCCNAME).setValue(null);
            row.getCell(TB_TAXRATE).getStyleAttributes().setLocked(false);
            row.getCell(TB_HASPREFERENTIAL).getStyleAttributes().setLocked(true);
            row.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(true);
        } else {
            row.getCell(TB_TCCNUMBER).setValue((Object)tccInfo);
            row.getCell(TB_TCCNAME).setValue((Object)tccInfo.getName());
            row.getCell(TB_TAXRATE).setValue((Object)(tccInfo.getTaxRate() == null ? BigDecimal.ZERO : tccInfo.getTaxRate()));
            row.getCell(TB_HASPREFERENTIAL).setValue((Object)false);
            row.getCell(TB_TAXRATE).getStyleAttributes().setLocked(false);
            row.getCell(TB_HASPREFERENTIAL).getStyleAttributes().setLocked(false);
            row.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(true);
            KDComboBox comboPreferentialPolicies = this.initComboPolicies(row, tccInfo);
            String vatSpecialManagement = tccInfo.getVATSpecialManagement();
            if (PreferentialPoliciesEnum.NoTaxation.getAlias().equals(vatSpecialManagement) && BigDecimal.ZERO.equals(tccInfo.getTaxRate())) {
                row.getCell(TB_HASPREFERENTIAL).setValue((Object)true);
                comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.NoTaxation);
            } else {
                comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.Null);
            }
            row.getCell(TB_PREFERENTIALPOLICIES).setValue(comboPreferentialPolicies.getSelectedItem());
        }
    }

    private KDComboBox initComboPolicies(IRow curRow, TaxClassificationCodeInfo tccInfo) {
        String vatSpecialManagement = tccInfo.getVATSpecialManagement();
        KDComboBox comboPreferentialPolicies = new KDComboBox();
        if (this.policiesListener == null) {
            this.policiesListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ProductGeneticMatchTccUI.this.policiesChanged(e);
                }
            };
        }
        comboPreferentialPolicies.putClientProperty((Object)"jump", (Object)"false");
        Set<PreferentialPoliciesEnum> policiesSet = TCCUtil.getPreferentialPoliciesByTCC(vatSpecialManagement);
        comboPreferentialPolicies.addItems(policiesSet.toArray());
        if (PreferentialPoliciesEnum.NoTaxation.getAlias().equals(vatSpecialManagement) && BigDecimal.ZERO.equals(tccInfo.getTaxRate())) {
            curRow.getCell(TB_HASPREFERENTIAL).getStyleAttributes().setLocked(true);
            curRow.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(true);
            curRow.getCell(TB_TAXRATE).setValue((Object)BigDecimal.ZERO);
            curRow.getCell(TB_TAXRATE).getStyleAttributes().setLocked(true);
        } else {
            ArrayList<Object> items = new ArrayList<Object>();
            for (int i = 0; i < comboPreferentialPolicies.getItemCount(); ++i) {
                items.add(comboPreferentialPolicies.getItemAt(i));
            }
            if (!items.contains((Object)PreferentialPoliciesEnum.Null)) {
                comboPreferentialPolicies.addItem((Object)PreferentialPoliciesEnum.Null);
            }
            curRow.getCell(TB_HASPREFERENTIAL).getStyleAttributes().setLocked(false);
        }
        comboPreferentialPolicies.addItemListener(this.policiesListener);
        curRow.getCell(TB_PREFERENTIALPOLICIES).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboPreferentialPolicies));
        return comboPreferentialPolicies;
    }

    private void policiesChanged(ItemEvent e) {
        IRow curRow = this.getCurRow();
        KDComboBox comboPreferentialPolicies = (KDComboBox)curRow.getCell(TB_PREFERENTIALPOLICIES).getEditor().getComponent();
        List<BigDecimal> taxRateList = TCCUtil.getTaxRateByPolicies((PreferentialPoliciesEnum)((Object)comboPreferentialPolicies.getSelectedItem()));
        if (taxRateList != null && taxRateList.size() > 0) {
            curRow.getCell(TB_TAXRATE).setValue((Object)taxRateList.get(0));
        } else if (curRow.getCell(TB_TCCNUMBER).getValue() instanceof TaxClassificationCodeInfo) {
            TaxClassificationCodeInfo tcc = (TaxClassificationCodeInfo)curRow.getCell(TB_TCCNUMBER).getValue();
            curRow.getCell(TB_TAXRATE).setValue((Object)tcc.getTaxRate());
        }
    }

    private void initHasPreferential() {
        KDCheckBox check = new KDCheckBox();
        this.hasPreferentialListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProductGeneticMatchTccUI.this.hasPreferentialChanged(e.getStateChange() == 1);
            }
        };
        check.addItemListener(this.hasPreferentialListener);
        this.tblMain.getColumn(TB_HASPREFERENTIAL).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)check));
    }

    private void initProductF7() {
        KDBizPromptBox productF7 = new KDBizPromptBox();
        productF7.setQueryInfo(PRODUCT_QUERY);
        productF7.setEditFormat("$number$");
        productF7.setDisplayFormat("$number$");
        productF7.setCommitFormat("$number$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        productF7.setEntityViewInfo(view);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)productF7);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tblMain.getColumn(TB_PRODUCTNUMBER).setRenderer((IBasicRender)avr);
        this.tblMain.getColumn(TB_PRODUCTNUMBER).setEditor((ICellEditor)itemEditor);
    }

    private void initTaxRate() {
        KDFormattedTextField formattedField = new KDFormattedTextField();
        formattedField.setDataType(1);
        formattedField.setMaximumValue((Comparable)BigDecimal.ONE);
        formattedField.setMinimumValue((Comparable)BigDecimal.ZERO);
        formattedField.setSupportedEmpty(false);
        formattedField.setPrecision(this.ratePrecision);
        formattedField.setRemoveingZeroInEdit(false);
        formattedField.setRemoveingZeroInDispaly(false);
        formattedField.setHorizontalAlignment(4);
        this.taxRateListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                ProductGeneticMatchTccUI.this.taxRateDataChanged(e);
            }
        };
        formattedField.addDataChangeListener(this.taxRateListener);
        this.tblMain.getColumn(TB_TAXRATE).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedField));
        this.tblMain.getColumn(TB_TAXRATE).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.ratePrecision));
    }

    private void initTCCF7() {
        KDBizPromptBox taxClassCode = new KDBizPromptBox();
        taxClassCode.setQueryInfo(TAXCLASSCODE_QUERY);
        taxClassCode.setEditFormat("$mergeCode$");
        taxClassCode.setDisplayFormat("$mergeCode$");
        taxClassCode.setCommitFormat("$mergeCode$");
        taxClassCode.setSelectorCollection(TCCUtil.getTCCSelector());
        taxClassCode.setHistoryRecordEnabled(false);
        taxClassCode.setSelector((KDPromptSelector)new TreeTaxClassificationCodeF7PromptDialog((IUIObject)this));
        this.tccF7SelectorListener = new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ProductGeneticMatchTccUI.this.tccF7WillShow();
            }
        };
        taxClassCode.addSelectorListener(this.tccF7SelectorListener);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)taxClassCode);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$mergeCode$"));
        this.tblMain.getColumn(TB_TCCNUMBER).setRenderer((IBasicRender)avr);
        this.tblMain.getColumn(TB_TCCNUMBER).setEditor((ICellEditor)itemEditor);
    }

    private void tccF7WillShow() {
        KDTSelectBlock selected = this.tblMain.getSelectManager().get();
        int selectedRow = selected.getBeginRow();
        IRow row = this.tblMain.getRow(selectedRow);
        KDBizPromptBox prmtTccF7 = (KDBizPromptBox)this.tblMain.getColumn(TB_TCCNUMBER).getEditor().getComponent();
        ProductCodeInfo product = (ProductCodeInfo)row.getCell(TB_PRODUCTNUMBER).getValue();
        HashSet<String> idSet = new HashSet<String>();
        TaxClassificationCodeCollection tccColl = (TaxClassificationCodeCollection)this.tccInfoMap.get(product.getId().toString());
        if (tccColl != null && tccColl.size() > 0 && this.cbFilterByTcc.isSelected()) {
            TaxClassificationCodeInfo tccInfo = null;
            int size = tccColl.size();
            for (int i = 0; i < size; ++i) {
                tccInfo = tccColl.get(i);
                idSet.add(tccInfo.getId().toString());
            }
        }
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true, CompareType.EQUALS));
        if (idSet.size() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        }
        env.setFilter(fi);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("doQueryAtCreateUI", false);
        prmtTccF7.setSelector((KDPromptSelector)new TreeTaxClassificationCodeF7PromptDialog((IUIObject)this, fi, paramMap));
        prmtTccF7.setEntityViewInfo(env);
        prmtTccF7.getQueryAgent().resetRuntimeEntityView();
    }

    private void taxRateDataChanged(DataChangeEvent e) {
        IRow curRow = this.getCurRow();
        if (((Boolean)curRow.getCell(TB_HASPREFERENTIAL).getValue()).booleanValue()) {
            BigDecimal value;
            List<BigDecimal> taxRateList = TCCUtil.getTaxRateByPolicies((PreferentialPoliciesEnum)((Object)curRow.getCell(TB_PREFERENTIALPOLICIES).getValue()));
            BigDecimal bigDecimal = value = e.getNewValue() == null ? null : ((BigDecimal)e.getNewValue()).setScale(this.ratePrecision, 4);
            if (taxRateList != null && !taxRateList.contains(value)) {
                curRow.getCell(TB_HASPREFERENTIAL).setValue((Object)false);
                this.hasPreferentialChanged(false);
            }
        }
    }

    private void hasPreferentialChanged(Boolean selected) {
        IRow curRow = this.getCurRow();
        KDComboBox comboPreferentialPolicies = (KDComboBox)curRow.getCell(TB_PREFERENTIALPOLICIES).getEditor().getComponent();
        if (selected.booleanValue()) {
            comboPreferentialPolicies.removeItem((Object)PreferentialPoliciesEnum.Null);
            curRow.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(false);
            this.policiesChanged(null);
        } else {
            ArrayList<Object> items = new ArrayList<Object>();
            for (int i = 0; i < comboPreferentialPolicies.getItemCount(); ++i) {
                items.add(comboPreferentialPolicies.getItemAt(i));
            }
            if (!items.contains((Object)PreferentialPoliciesEnum.Null)) {
                comboPreferentialPolicies.addItem((Object)PreferentialPoliciesEnum.Null);
            }
            comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.Null);
            curRow.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(true);
        }
        curRow.getCell(TB_PREFERENTIALPOLICIES).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboPreferentialPolicies));
        curRow.getCell(TB_PREFERENTIALPOLICIES).setValue(comboPreferentialPolicies.getSelectedItem());
    }

    private IRow getCurRow() {
        KDTSelectBlock selected = this.tblMain.getSelectManager().get();
        int selectedRow = selected.getBeginRow();
        return this.tblMain.getRow(selectedRow);
    }

    private void appendNewLine(ProductCodeInfo product) {
        if (product == null) {
            return;
        }
        IRow row = this.tblMain.addRow();
        this.updateLineData(product, row);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.innerStoreFields();
    }

    protected void innerStoreFields() {
        String productName = null;
        TaxClassificationCodeInfo tccInfo = null;
        BigDecimal taxRate = null;
        boolean hasPreferential = false;
        PreferentialPoliciesEnum preferentialPolicies = null;
        ProductCodeInfo product = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            product = (ProductCodeInfo)row.getCell(TB_PRODUCTNUMBER).getValue();
            productName = (String)row.getCell(TB_PRODUCTNAME).getValue();
            tccInfo = (TaxClassificationCodeInfo)row.getCell(TB_TCCNUMBER).getValue();
            taxRate = (BigDecimal)row.getCell(TB_TAXRATE).getValue();
            hasPreferential = (Boolean)row.getCell(TB_HASPREFERENTIAL).getValue();
            preferentialPolicies = (PreferentialPoliciesEnum)((Object)row.getCell(TB_PREFERENTIALPOLICIES).getValue());
            product.setName(productName);
            product.setTaxClassificationCode(tccInfo);
            product.setTaxClass(tccInfo != null ? tccInfo.getParent() : null);
            product.setTaxRate(taxRate);
            product.setHasPreferential(hasPreferential);
            product.setPreferentialPolicies(preferentialPolicies);
        }
    }

    private void updateLineData(ProductCodeInfo product, IRow row) {
        if (product == null || row == null) {
            return;
        }
        row.getCell(TB_PRODUCTNUMBER).setValue((Object)product);
        row.getCell(TB_PRODUCTNAME).setValue((Object)product.getName());
        row.getCell(TB_TCCNUMBER).setValue((Object)product.getTaxClassificationCode());
        row.getCell(TB_TCCNAME).setValue(product.getTaxClassificationCode() != null ? product.getTaxClassificationCode().getName() : null);
        row.getCell(TB_TAXRATE).setValue((Object)product.getTaxRate());
        row.getCell(TB_HASPREFERENTIAL).setValue((Object)product.isHasPreferential());
        row.getCell(TB_PREFERENTIALPOLICIES).setValue((Object)product.getPreferentialPolicies());
        TaxClassificationCodeCollection tccColl = (TaxClassificationCodeCollection)this.tccInfoMap.get(product.getId().toString());
        if (tccColl != null && tccColl.size() > 0) {
            row.getCell(TB_MATCHRESULT).setValue((Object)("\u5339\u914d\u7ed3\u679c" + tccColl.size() + "\u6761"));
            row.getCell(TB_MATCHRESULT).setUserObject((Object)tccColl.size());
        }
    }

    @Override
    public void actionMatch_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        if (this.products.size() == 0) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("productCodes", this.products);
        params.put("matchTccStrategy", this.cbxMatchTccStrategy.getSelectedItem());
        params.put("ignoreMatched", this.cbIgnoreMatched.isSelected());
        Map oldDataMap = this.getOldDataMap();
        Map result = ProductCodeFactory.getRemoteInstance().matchTccCode(params);
        Map tempTCCInfoMap = (Map)result.get("tccInfoMap");
        if (tempTCCInfoMap.isEmpty()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"NOT_MATCH_TCC"));
            SysUtil.abort();
        }
        this.tccInfoMap = (Map)result.get("tccInfoMap");
        this.products = (IObjectCollection)result.get("productCodes");
        this.setOldDataMap(oldDataMap);
        this.innerLoadFields();
        this.initControl();
    }

    protected Map getOldDataMap() {
        HashMap<String, Map> oldDataMap = new HashMap<String, Map>();
        ProductCodeInfo productCodeInfo = null;
        int size = this.products.size();
        for (int i = 0; i < size; ++i) {
            productCodeInfo = (ProductCodeInfo)this.products.getObject(i);
            oldDataMap.put(productCodeInfo.getId().toString(), productCodeInfo.getOldValues());
        }
        return oldDataMap;
    }

    protected void setOldDataMap(Map oldDataMap) {
        ProductCodeInfo productCodeInfo = null;
        int size = this.products.size();
        for (int i = 0; i < size; ++i) {
            productCodeInfo = (ProductCodeInfo)this.products.getObject(i);
            productCodeInfo.setOldValues((Map)oldDataMap.get(productCodeInfo.getId().toString()));
        }
    }

    @Override
    public void actionResetData_actionPerformed(ActionEvent e) throws Exception {
        this.tccInfoMap.clear();
        this.loadData();
        this.innerLoadFields();
        this.initControl();
    }

    @Override
    public void actionSaveContinue_actionPerformed(ActionEvent e) throws Exception {
        this.save();
        this.removeMatchedRow();
        if (this.tblMain.getRowCount() == 0) {
            this.actionExitCurrent_actionPerformed(e);
        }
    }

    protected void removeMatchedRow() {
        this.tblMain.removeRows();
        ProductCodeInfo product = null;
        for (int i = 0; i < this.products.size(); ++i) {
            product = (ProductCodeInfo)this.products.getObject(i);
            if (product.getTaxClassificationCode() != null) {
                this.productIds.remove(product.getId().toString());
                this.products.removeObject((IObjectValue)product);
                --i;
                continue;
            }
            this.appendNewLine(product);
        }
    }

    protected void save() throws EASBizException, BOSException {
        if (this.products.size() == 0) {
            return;
        }
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        this.checkRequiredFields();
        this.storeFields();
        ProductCodeFactory.getRemoteInstance().batchSave(this.products);
        this.afterSave();
    }

    protected void afterSave() {
        this.initOldData();
    }

    protected void initOldData() {
        ProductCodeInfo productCodeInfo = null;
        int size = this.products.size();
        for (int i = 0; i < size; ++i) {
            productCodeInfo = (ProductCodeInfo)this.products.getObject(i);
            productCodeInfo.copyNewToOld();
        }
    }

    public boolean isModify() {
        this.storeFields();
        ProductCodeInfo productCodeInfo = null;
        int size = this.products.size();
        for (int i = 0; i < size; ++i) {
            productCodeInfo = (ProductCodeInfo)this.products.getObject(i);
            productCodeInfo.setSyncOldValue(false);
            if (!productCodeInfo.isValueChange()) continue;
            return true;
        }
        return false;
    }

    public boolean checkBeforeWindowClosing() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify()) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                try {
                    this.actionSave.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                    UtilRequest.setPrepare((boolean)false);
                    this.btnSave.getAction().actionPerformed(event);
                    return !this.actionSave.isInvokeFailed();
                }
                catch (Exception exc) {
                    return false;
                }
            }
            return result == 1;
        }
        return true;
    }

    protected void checkRequiredFields() {
        String productName = null;
        TaxClassificationCodeInfo tccInfo = null;
        StringBuffer errorMsg = new StringBuffer();
        StringBuffer errorDetail = new StringBuffer();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            productName = (String)row.getCell(TB_PRODUCTNAME).getValue();
            tccInfo = (TaxClassificationCodeInfo)row.getCell(TB_TCCNUMBER).getValue();
            errorDetail = new StringBuffer();
            if (StringUtils.isEmpty((String)productName)) {
                errorDetail.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"NAME"));
            }
            if (tccInfo == null) {
                errorDetail.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"TAXCLASSIFICATIONCODE"));
            }
            if (errorDetail.length() <= 0) continue;
            String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMCommonResource", (String)"ROW_NOTNULL", (Object[])new Object[]{i + 1, errorDetail.substring(1)});
            errorMsg.append(msg).append("\r\n");
        }
        if (errorMsg.length() > 0) {
            MsgBox.showWarning((String)errorMsg.toString());
            SysUtil.abort();
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.save();
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("taxClassificationCode.*"));
        sic.add(new SelectorItemInfo("taxClassificationCode.parent.*"));
        return sic;
    }

    public void handUIException(Throwable exc) {
        if (TMMsgBox.handUIException((CoreUI)this, (Throwable)exc, (String)"IMK", (String)"MatchTCC")) {
            super.handUIException(exc);
        }
    }
}

