/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.TaxDataInfo;
import com.kingdee.eas.basedata.framework.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.ProductCodeSourceTypeEnum;
import com.kingdee.eas.tm.im.ProductCodeStatusEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.basedata.client.AbstractProductImportUI;
import com.kingdee.eas.tm.im.basedata.client.TreeTaxClassificationCodeF7PromptDialog;
import com.kingdee.eas.tm.im.util.TCCUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ProductImportUI
extends AbstractProductImportUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductImportUI.class);
    private static final String CUSTOMER_QUERY = "com.kingdee.eas.basedata.master.cssp.app.F7CustomerQuery";
    private static final String EXPENSEITEM_QUERY = "com.kingdee.eas.tm.im.app.F7commonExpenseTypeQuery";
    private static final String TAXCLASSCODE_QUERY = "com.kingdee.eas.tm.im.app.TaxClassificationCodeQuery";
    private static final String UNIT_QUERY = "com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery";
    private static final String CU_QUERY = "com.kingdee.eas.basedata.framework.app.CtrlUnitQuery";
    private static final String COMPANY_QUERY = "com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery";
    private static final String TB_NUMBER = "number";
    private static final String TB_NAME = "name";
    private static final String TB_COMPANY = "company";
    private static final String TB_CUSTOMER = "customer";
    private static final String TB_MATERIAL = "material";
    private static final String TB_EXPENSEITEM = "expenseItem";
    private static final String TB_SIMPLECODE = "simpleCode";
    private static final String TB_MODEL = "model";
    private static final String TB_TAXCLASS = "taxClass";
    private static final String TB_TAXCLASSIFICATIONCODE = "taxClassificationCode";
    private static final String TB_TAXDATA = "taxData";
    private static final String TB_TAXRATE = "taxRate";
    private static final String TB_UNIT = "unit";
    private static final String TB_PRICE = "price";
    private static final String TB_ISTAX = "isTax";
    private static final String TB_ISDIFFTAX = "isDiffTax";
    private static final String TB_HASPREFERENTIAL = "hasPreferential";
    private static final String TB_PREFERENTIALPOLICIES = "preferentialPolicies";
    private static final String TB_ISVEHICLE = "isVehicle";
    private static final String TB_VEHICLETYPE = "vehicleType";
    private static final String TB_FACPLATEMODEL = "facPlateModel";
    private static final String TB_ORIGIN = "origin";
    private static final String TB_TONNAGE = "tonnage";
    private static final String TB_LIMITPOPULATION = "limitPopulation";
    private static final String TB_PRODUCTIONENTERPRISE = "productionEnterprise";
    private static final String[] TB_VEHICLEFIELDS = new String[]{"vehicleType", "facPlateModel", "origin", "tonnage", "limitPopulation", "productionEnterprise"};
    private static final String TB_REMARK = "remark";
    private static final String TB_CU = "CU";
    private DataChangeListener companyListener = null;
    private DataChangeListener materialListener = null;
    private DataChangeListener expenseItemListener = null;
    private DataChangeListener tccListener = null;
    private DataChangeListener taxRateListener = null;
    private ItemListener hasPreferentialListener = null;
    private ItemListener isVehicleChange = null;
    private ItemListener policiesListener = null;
    private KDTEditAdapter entryTableChange = null;
    private static TreeTaxClassificationCodeF7PromptDialog defaultTreeTCCF7PromptDialog;
    private static TreeTaxClassificationCodeF7PromptDialog filterTreeTCCF7PromptDialog;
    private String[] fieldsToCopy = new String[]{"customer", "taxClass", "taxClassificationCode", "taxRate", "isTax", "hasPreferential", "isDiffTax", "isVehicle"};

    protected KDTable getDetailTable() {
        return this.mainTable;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public void onLoad() throws Exception {
        this.mainTable.checkParsed();
        super.onLoad();
        Map uiContext = this.getUIContext();
        this.initCompanyF7();
        this.initCustomerF7();
        this.initMaterialF7();
        this.initExpenseItemF7();
        this.initTCCF7();
        this.initTaxRate();
        this.initIsTax();
        this.initIsDiffTax();
        this.initIsVehicle();
        this.initHasPreferential();
        this.initUnitF7();
        this.initPriceField();
        this.initRemare();
        this.initCUF7();
        IRow row = this.mainTable.addRow();
        row.getCell(TB_ISTAX).setValue((Object)true);
        row.getCell(TB_ISDIFFTAX).setValue((Object)false);
        row.getCell(TB_ISVEHICLE).setValue((Object)false);
        row.getCell(TB_HASPREFERENTIAL).setValue((Object)false);
        String method = uiContext.get("method").toString();
        if ("importMaterial".equals(method)) {
            this.mainTable.getColumn(TB_MATERIAL).setWidth(96);
            this.mainTable.getColumn(TB_MATERIAL).getStyleAttributes().setHided(false);
            this.mainTable.getColumn(TB_MATERIAL).setRequired(true);
        } else if ("importExpenseItem".equals(method)) {
            this.mainTable.getColumn(TB_EXPENSEITEM).setWidth(96);
            this.mainTable.getColumn(TB_EXPENSEITEM).getStyleAttributes().setHided(false);
            this.mainTable.getColumn(TB_EXPENSEITEM).setRequired(true);
        }
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        ProductImportUI.this.kdtEntries_ChangedStopped(e);
                    }
                    catch (Exception exc) {
                        ProductImportUI.this.handUIException(exc);
                    }
                }

                public void editStarting(KDTEditEvent e) {
                    try {
                        ProductImportUI.this.kdtEntries_editStarting(e);
                    }
                    catch (Exception exc) {
                        ProductImportUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.mainTable.addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    protected void kdtEntries_editStarting(KDTEditEvent e) throws BOSException {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.mainTable.getColumnKey(colIndex);
        if (TB_EXPENSEITEM.equals(fieldName)) {
            KDBizPromptBox expenseItemF7 = (KDBizPromptBox)this.getDetailTable().getColumn(TB_EXPENSEITEM).getEditor().getComponent();
            this.setExpenseItemF7Filter(expenseItemF7);
        } else if (TB_TAXCLASSIFICATIONCODE.equals(fieldName)) {
            KDBizPromptBox tccF7 = (KDBizPromptBox)this.getDetailTable().getColumn(TB_TAXCLASSIFICATIONCODE).getEditor().getComponent();
            boolean isVehicle = (Boolean)this.getDetailTable().getRow(rowIndex).getCell(TB_ISVEHICLE).getValue();
            this.setTCCF7Filter(tccF7, isVehicle);
        }
    }

    protected void setTCCF7Filter(KDBizPromptBox tccF7, boolean isVehicle) {
        TreeTaxClassificationCodeF7PromptDialog selector = defaultTreeTCCF7PromptDialog;
        if (isVehicle) {
            if (filterTreeTCCF7PromptDialog == null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("simpleName", (Object)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"Vehicle"), CompareType.EQUALS));
                filterTreeTCCF7PromptDialog = new TreeTaxClassificationCodeF7PromptDialog((IUIObject)this, filter);
            }
            selector = filterTreeTCCF7PromptDialog;
        }
        tccF7.setSelector((KDPromptSelector)selector);
    }

    protected void setExpenseItemF7Filter(KDBizPromptBox expenseItemF7) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)true, CompareType.EQUALS));
        view.setFilter(filter);
        expenseItemF7.setEntityViewInfo(view);
    }

    protected void kdtEntries_ChangedStopped(KDTEditEvent e) throws Exception {
        BigDecimal taxRate;
        Object value;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.mainTable.getRow(rowIndex);
        String fieldName = this.mainTable.getColumnKey(colIndex);
        if (TB_TAXRATE.equals(fieldName) && (value = e.getValue()) != null && ((taxRate = (BigDecimal)value).compareTo(BigDecimal.ZERO) < 0 || taxRate.compareTo(BigDecimal.ONE) >= 0)) {
            row.getCell(TB_TAXRATE).setValue(e.getOldValue());
            return;
        }
    }

    private void initCompanyF7() {
        KDBizPromptBox company = new KDBizPromptBox();
        company.setQueryInfo(COMPANY_QUERY);
        company.setEditFormat("$number$");
        company.setDisplayFormat("$name$");
        company.setCommitFormat("$number$");
        company.setEnabledMultiSelection(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true));
        view.setFilter(filter);
        company.setEntityViewInfo(view);
        this.companyListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                ProductImportUI.this.companyChanged(e);
            }
        };
        company.addDataChangeListener(this.companyListener);
        SelectorItemCollection selectors = company.getSelectorCollection();
        if (selectors == null) {
            selectors = new SelectorItemCollection();
        }
        selectors.add(new SelectorItemInfo("*"));
        company.setSelectorCollection(selectors);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)company);
        this.mainTable.getColumn(TB_COMPANY).setEditor((ICellEditor)itemEditor);
    }

    private void initCustomerF7() {
        KDBizPromptBox customer = new KDBizPromptBox();
        customer.setQueryInfo(CUSTOMER_QUERY);
        customer.setEditFormat("$number$");
        customer.setDisplayFormat("$name$");
        customer.setCommitFormat("$number$");
        customer.setHasCUDefaultFilter(false);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)customer);
        this.mainTable.getColumn(TB_CUSTOMER).setEditor((ICellEditor)itemEditor);
    }

    private void initMaterialF7() {
        OrgUnitInfo orginfo = (OrgUnitInfo)this.getUIContext().get("Company");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        if (orginfo != null && orginfo.getId() != null) {
            tmpFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orginfo.getId().toString(), CompareType.EQUALS));
        }
        tmpFilter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        tmpFilter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)new Integer(1), CompareType.EQUALS));
        view.setFilter(tmpFilter);
        KDBizPromptBox prmtMaterail = new KDBizPromptBox();
        prmtMaterail.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialFIQuery");
        prmtMaterail.setEditFormat("$number$");
        prmtMaterail.setDisplayFormat("$name$");
        prmtMaterail.setCommitFormat("$number$");
        prmtMaterail.setCurrentMainBizOrgUnit(orginfo, OrgType.Company);
        prmtMaterail.setEntityViewInfo(view);
        this.materialListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                ProductImportUI.this.materialChanged(e);
            }
        };
        prmtMaterail.addDataChangeListener(this.materialListener);
        GeneralKDPromptSelectorAdaptor selectorLisenter = new GeneralKDPromptSelectorAdaptor((KDPromptBox)prmtMaterail, "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI", (Object)this, MaterialGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.material.app.F7MaterialFIQuery", "materialGroup.id", "orgUnit.id");
        selectorLisenter.setIsMultiSelect(true);
        prmtMaterail.setSelector((KDPromptSelector)selectorLisenter);
        prmtMaterail.addSelectorListener((SelectorListener)selectorLisenter);
        prmtMaterail.setEnabledMultiSelection(true);
        SelectorItemCollection selectors = prmtMaterail.getSelectorCollection();
        if (selectors == null) {
            selectors = new SelectorItemCollection();
        }
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("baseUnit.id"));
        selectors.add(new SelectorItemInfo("baseUnit.number"));
        selectors.add(new SelectorItemInfo("baseUnit.name"));
        prmtMaterail.setSelectorCollection(selectors);
        this.mainTable.getColumn(TB_MATERIAL).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMaterail));
    }

    private void initExpenseItemF7() {
        KDBizPromptBox expenseItem = new KDBizPromptBox();
        expenseItem.setQueryInfo(EXPENSEITEM_QUERY);
        expenseItem.setEditFormat("$number$");
        expenseItem.setDisplayFormat("$name$");
        expenseItem.setCommitFormat("$number$");
        expenseItem.setEnabledMultiSelection(true);
        this.expenseItemListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                ProductImportUI.this.expenseItemChanged(ProductImportUI.TB_EXPENSEITEM, e);
            }
        };
        expenseItem.addDataChangeListener(this.expenseItemListener);
        SelectorItemCollection selectors = expenseItem.getSelectorCollection();
        if (selectors == null) {
            selectors = new SelectorItemCollection();
        }
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("defaultUnit.id"));
        selectors.add(new SelectorItemInfo("defaultUnit.name"));
        selectors.add(new SelectorItemInfo("defaultUnit.number"));
        expenseItem.setSelectorCollection(selectors);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)expenseItem);
        this.mainTable.getColumn(TB_EXPENSEITEM).setEditor((ICellEditor)itemEditor);
    }

    private void initTCCF7() {
        KDBizPromptBox taxClassCode = new KDBizPromptBox();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true, CompareType.EQUALS));
        view.setFilter(tmpFilter);
        taxClassCode.setEntityViewInfo(view);
        taxClassCode.setQueryInfo(TAXCLASSCODE_QUERY);
        taxClassCode.setEditFormat("$mergeCode$");
        taxClassCode.setDisplayFormat("$mergeCode$");
        taxClassCode.setCommitFormat("$mergeCode$");
        taxClassCode.setSelectorCollection(TCCUtil.getTCCSelector());
        defaultTreeTCCF7PromptDialog = new TreeTaxClassificationCodeF7PromptDialog((IUIObject)this);
        taxClassCode.setSelector((KDPromptSelector)defaultTreeTCCF7PromptDialog);
        if (this.tccListener == null) {
            this.tccListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ProductImportUI.this.tccDataChanged(e);
                }
            };
        }
        taxClassCode.addDataChangeListener(this.tccListener);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)taxClassCode);
        this.mainTable.getColumn(TB_TAXCLASSIFICATIONCODE).setEditor((ICellEditor)itemEditor);
    }

    private void tccDataChanged(DataChangeEvent e) {
        IRow curRow = this.getCurRow();
        TaxClassificationCodeInfo tccInfo = (TaxClassificationCodeInfo)e.getNewValue();
        if (tccInfo == null) {
            curRow.getCell(TB_TAXCLASS).setValue(null);
            curRow.getCell(TB_TAXRATE).setValue(null);
            curRow.getCell(TB_TAXRATE).getStyleAttributes().setLocked(false);
            curRow.getCell(TB_HASPREFERENTIAL).getStyleAttributes().setLocked(true);
            curRow.getCell(TB_HASPREFERENTIAL).setValue((Object)false);
            curRow.getCell(TB_PREFERENTIALPOLICIES).setValue(null);
            curRow.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(true);
            return;
        }
        curRow.getCell(TB_TAXCLASS).setValue((Object)tccInfo.getParent());
        curRow.getCell(TB_TAXCLASSIFICATIONCODE).setValue((Object)tccInfo);
        curRow.getCell(TB_TAXRATE).setValue((Object)(tccInfo.getTaxRate() == null ? BigDecimal.ZERO : tccInfo.getTaxRate()));
        curRow.getCell(TB_TAXRATE).getStyleAttributes().setLocked(false);
        curRow.getCell(TB_HASPREFERENTIAL).setValue((Object)false);
        curRow.getCell(TB_HASPREFERENTIAL).getStyleAttributes().setLocked(false);
        curRow.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(true);
        String vatSpecialManagement = tccInfo.getVATSpecialManagement();
        KDComboBox comboPreferentialPolicies = new KDComboBox();
        if (this.policiesListener == null) {
            this.policiesListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ProductImportUI.this.policiesChanged(e);
                }
            };
        }
        Set<PreferentialPoliciesEnum> policiesSet = TCCUtil.getPreferentialPoliciesByTCC(vatSpecialManagement);
        comboPreferentialPolicies.addItems(policiesSet.toArray());
        if (PreferentialPoliciesEnum.NoTaxation.getAlias().equals(vatSpecialManagement) && BigDecimal.ZERO.equals(tccInfo.getTaxRate())) {
            curRow.getCell(TB_HASPREFERENTIAL).setValue((Object)true);
            curRow.getCell(TB_HASPREFERENTIAL).getStyleAttributes().setLocked(true);
            comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.NoTaxation);
            curRow.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(true);
            curRow.getCell(TB_TAXRATE).setValue((Object)BigDecimal.ZERO);
            curRow.getCell(TB_TAXRATE).getStyleAttributes().setLocked(true);
        } else {
            ArrayList<Object> items = new ArrayList<Object>();
            for (int i = 0; i < comboPreferentialPolicies.getItemCount(); ++i) {
                items.add(comboPreferentialPolicies.getItemAt(i));
            }
            if (!items.contains((Object)PreferentialPoliciesEnum.Null)) {
                comboPreferentialPolicies.addItem((Object)PreferentialPoliciesEnum.Null);
            }
            comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.Null);
            curRow.getCell(TB_HASPREFERENTIAL).getStyleAttributes().setLocked(false);
        }
        comboPreferentialPolicies.addItemListener(this.policiesListener);
        curRow.getCell(TB_PREFERENTIALPOLICIES).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboPreferentialPolicies));
        curRow.getCell(TB_PREFERENTIALPOLICIES).setValue(comboPreferentialPolicies.getSelectedItem());
        this.setDefaultValueOnColumn(curRow.getRowIndex() + 1, this.mainTable.getRowCount() - curRow.getRowIndex() - 1);
    }

    private IRow getCurRow() {
        KDTSelectBlock selected = this.mainTable.getSelectManager().get();
        int selectedRow = selected.getBeginRow();
        return this.mainTable.getRow(selectedRow);
    }

    private void initTaxRate() {
        KDFormattedTextField formattedField = new KDFormattedTextField();
        formattedField.setDataType(1);
        formattedField.setPrecision(4);
        formattedField.setRemoveingZeroInEdit(false);
        formattedField.setRemoveingZeroInDispaly(false);
        formattedField.setHorizontalAlignment(4);
        this.taxRateListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                ProductImportUI.this.taxRateDataChanged(e);
            }
        };
        formattedField.addDataChangeListener(this.taxRateListener);
        this.mainTable.getColumn(TB_TAXRATE).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedField));
    }

    private void taxRateDataChanged(DataChangeEvent e) {
        List<BigDecimal> taxRateList;
        IRow curRow = this.getCurRow();
        if (((Boolean)curRow.getCell(TB_HASPREFERENTIAL).getValue()).booleanValue() && (taxRateList = TCCUtil.getTaxRateByPolicies((PreferentialPoliciesEnum)((Object)curRow.getCell(TB_PREFERENTIALPOLICIES).getValue()))) != null && !taxRateList.contains(e.getNewValue())) {
            curRow.getCell(TB_HASPREFERENTIAL).setValue((Object)false);
            this.hasPreferentialChanged(false);
        }
    }

    protected BigDecimal getBigDecimal4Cell(IRow row, String column) {
        BigDecimal value = (BigDecimal)row.getCell(column).getValue();
        return value == null ? BigDecimal.ZERO : value;
    }

    private void initIsTax() {
        KDCheckBox check = new KDCheckBox();
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((JCheckBox)check);
        this.mainTable.getColumn(TB_ISTAX).setEditor((ICellEditor)itemEditor);
    }

    private void initIsDiffTax() {
        KDCheckBox check = new KDCheckBox();
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((JCheckBox)check);
        this.mainTable.getColumn(TB_ISDIFFTAX).setEditor((ICellEditor)itemEditor);
    }

    private void initIsVehicle() {
        KDCheckBox check = new KDCheckBox();
        this.isVehicleChange = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProductImportUI.this.isVehicleChanged(e.getStateChange() == 1);
            }
        };
        check.addItemListener(this.isVehicleChange);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((JCheckBox)check);
        this.mainTable.getColumn(TB_ISVEHICLE).setEditor((ICellEditor)itemEditor);
    }

    private void initHasPreferential() {
        KDCheckBox check = new KDCheckBox();
        this.hasPreferentialListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProductImportUI.this.hasPreferentialChanged(e.getStateChange() == 1);
            }
        };
        check.addItemListener(this.hasPreferentialListener);
        this.mainTable.getColumn(TB_HASPREFERENTIAL).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)check));
    }

    private void hasPreferentialChanged(Boolean selected) {
        IRow curRow = this.getCurRow();
        KDComboBox comboPreferentialPolicies = (KDComboBox)curRow.getCell(TB_PREFERENTIALPOLICIES).getEditor().getComponent();
        if (selected.booleanValue()) {
            comboPreferentialPolicies.removeItem((Object)PreferentialPoliciesEnum.Null);
            curRow.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(false);
        } else {
            ArrayList<Object> items = new ArrayList<Object>();
            for (int i = 0; i < comboPreferentialPolicies.getItemCount(); ++i) {
                items.add(comboPreferentialPolicies.getItemAt(i));
            }
            if (!items.contains((Object)PreferentialPoliciesEnum.Null)) {
                comboPreferentialPolicies.addItem((Object)PreferentialPoliciesEnum.Null);
            }
            comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.Null);
            curRow.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(true);
        }
        curRow.getCell(TB_PREFERENTIALPOLICIES).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboPreferentialPolicies));
        curRow.getCell(TB_PREFERENTIALPOLICIES).setValue(comboPreferentialPolicies.getSelectedItem());
    }

    private void isVehicleChanged(Boolean selected) {
        IRow curRow = this.getCurRow();
        int length = TB_VEHICLEFIELDS.length;
        for (int i = 0; i < length; ++i) {
            curRow.getCell(TB_VEHICLEFIELDS[i]).getStyleAttributes().setLocked(selected == false);
            if (selected.booleanValue()) continue;
            curRow.getCell(TB_VEHICLEFIELDS[i]).setValue(null);
        }
        KDCheckBox isVehicleBox = (KDCheckBox)this.getDetailTable().getColumn(TB_ISVEHICLE).getEditor().getComponent();
        boolean isVehicle = isVehicleBox.getSelected() == 32;
        Object tcc = curRow.getCell(TB_TAXCLASSIFICATIONCODE).getValue();
        if (isVehicle && tcc instanceof TaxClassificationCodeInfo && !((TaxClassificationCodeInfo)tcc).getSimpleName().equals(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"Vehicle"))) {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"ISEmptyTCC")))) {
                curRow.getCell(TB_TAXCLASSIFICATIONCODE).setValue(null);
                curRow.getCell(TB_TAXCLASS).setValue(null);
                curRow.getCell(TB_TAXRATE).setValue(null);
                curRow.getCell(TB_TAXRATE).getStyleAttributes().setLocked(false);
                curRow.getCell(TB_HASPREFERENTIAL).getStyleAttributes().setLocked(true);
                curRow.getCell(TB_HASPREFERENTIAL).setValue((Object)false);
                curRow.getCell(TB_PREFERENTIALPOLICIES).setValue(null);
                curRow.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(true);
                isVehicleBox.setSelected(true);
            } else {
                isVehicleBox.setSelected(false);
            }
        }
    }

    private void policiesChanged(ItemEvent e) {
        IRow curRow = this.getCurRow();
        KDComboBox comboPreferentialPolicies = (KDComboBox)curRow.getCell(TB_PREFERENTIALPOLICIES).getEditor().getComponent();
        List<BigDecimal> taxRateList = TCCUtil.getTaxRateByPolicies((PreferentialPoliciesEnum)((Object)comboPreferentialPolicies.getSelectedItem()));
        if (taxRateList != null && taxRateList.size() > 0) {
            curRow.getCell(TB_TAXRATE).setValue((Object)taxRateList.get(0));
        } else if (curRow.getCell(TB_TAXCLASSIFICATIONCODE).getValue() instanceof TaxClassificationCodeInfo) {
            TaxClassificationCodeInfo tcc = (TaxClassificationCodeInfo)curRow.getCell(TB_TAXCLASSIFICATIONCODE).getValue();
            curRow.getCell(TB_TAXRATE).setValue((Object)tcc.getTaxRate());
        }
    }

    private void initUnitF7() {
        KDBizPromptBox prmtMaterialUnit = new KDBizPromptBox();
        prmtMaterialUnit.setQueryInfo(UNIT_QUERY);
        prmtMaterialUnit.setEditFormat("$number$");
        prmtMaterialUnit.setDisplayFormat("$name$");
        prmtMaterialUnit.setCommitFormat("$number$");
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)prmtMaterialUnit);
        this.mainTable.getColumn(TB_UNIT).setEditor((ICellEditor)itemEditor);
    }

    private void initPriceField() {
        KDFormattedTextField price = new KDFormattedTextField();
        price.setDataType(1);
        price.setPrecision(8);
        price.setSupportedEmpty(true);
        price.setRemoveingZeroInDispaly(false);
        price.setHorizontalAlignment(4);
        KDTDefaultCellEditor priceEditor = new KDTDefaultCellEditor((JTextField)price);
        this.mainTable.getColumn(TB_PRICE).setEditor((ICellEditor)priceEditor);
        this.mainTable.getColumn(TB_PRICE).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)8));
    }

    private void initRemare() {
        KDTextField remare = new KDTextField();
        remare.setMaxLength(80);
        KDTDefaultCellEditor remakeEditor = new KDTDefaultCellEditor((JTextField)remare);
        this.mainTable.getColumn(TB_REMARK).setEditor((ICellEditor)remakeEditor);
    }

    private void initCUF7() {
        KDBizPromptBox company = new KDBizPromptBox();
        company.setQueryInfo(CU_QUERY);
        company.setEditFormat("$number$");
        company.setDisplayFormat("$name$");
        company.setCommitFormat("$number$");
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)company);
        this.mainTable.getColumn(TB_CU).setEditor((ICellEditor)itemEditor);
    }

    protected void companyChanged(DataChangeEvent e) {
        try {
            CompanyOrgUnitInfo[] companys;
            KDBizPromptBox companyF7 = (KDBizPromptBox)e.getSource();
            KDTSelectBlock selected = this.mainTable.getSelectManager().get();
            if (selected == null) {
                return;
            }
            int selectedRow = selected.getBeginRow();
            if (companyF7.getValue() == null) {
                return;
            }
            if (companyF7.getValue() instanceof CompanyOrgUnitInfo[]) {
                companys = (CompanyOrgUnitInfo[])companyF7.getValue();
            } else if (companyF7.getValue() instanceof Object[]) {
                Object[] objects = (Object[])companyF7.getValue();
                if (objects.length == 0) {
                    return;
                }
                companys = new CompanyOrgUnitInfo[objects.length];
                System.arraycopy(objects, 0, companys, 0, objects.length);
            } else {
                return;
            }
            this.doCompanyChanged(companyF7, companys, selectedRow);
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    protected void doCompanyChanged(KDBizPromptBox bizMaterialBox, CompanyOrgUnitInfo[] companys, int selectedRow) {
        if (companys == null || companys.length == 0) {
            bizMaterialBox.setValue(null);
            return;
        }
        IRow curRow = this.getCurRow();
        MaterialInfo mat = (MaterialInfo)curRow.getCell(TB_MATERIAL).getValue();
        ExpenseTypeInfo expenseItemInfo = (ExpenseTypeInfo)curRow.getCell(TB_EXPENSEITEM).getValue();
        String oldNumber = "";
        if (mat != null) {
            oldNumber = mat.getNumber();
        } else if (expenseItemInfo != null) {
            oldNumber = expenseItemInfo.getNumber();
        }
        int curCol = this.mainTable.getColumnIndex(TB_COMPANY);
        bizMaterialBox.removeDataChangeListener(this.companyListener);
        int length = companys.length;
        if (length > 0) {
            CompanyOrgUnitInfo company = null;
            boolean needInsert = false;
            int insertedRowCount = 0;
            for (int i = 0; i < length; ++i) {
                if (needInsert) {
                    this.mainTable.addRow(selectedRow + insertedRowCount, (IRow)curRow.clone());
                    needInsert = false;
                }
                company = companys[i];
                IRow newRow = this.mainTable.getRow(selectedRow + insertedRowCount);
                if (companys[i] == null) {
                    newRow.getCell(curCol).setValue(null);
                    return;
                }
                newRow.getCell(curCol).setValue((Object)company);
                if (newRow.getCell(TB_NUMBER).getValue() != null) {
                    newRow.getCell(TB_NUMBER).setValue((Object)(company.getNumber() + "_" + oldNumber));
                }
                needInsert = true;
                ++insertedRowCount;
            }
        }
        bizMaterialBox.addDataChangeListener(this.companyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void materialChanged(DataChangeEvent e) {
        try {
            KDBizPromptBox bizMaterialBox = (KDBizPromptBox)e.getSource();
            KDTSelectBlock selected = this.mainTable.getSelectManager().get();
            if (selected == null) {
                return;
            }
            int selectedRow = selected.getBeginRow();
            if (bizMaterialBox.getValue() == null) {
                return;
            }
            MaterialInfo[] materialInfos = null;
            if (bizMaterialBox.getValue() instanceof MaterialInfo[]) {
                materialInfos = (MaterialInfo[])bizMaterialBox.getValue();
            } else if (bizMaterialBox.getValue() instanceof MaterialInfo) {
                Object o;
                ICell cell;
                materialInfos = new MaterialInfo[]{(MaterialInfo)bizMaterialBox.getValue()};
                if (selected != null && selectedRow >= 0 && (cell = this.mainTable.getRow(selectedRow).getCell(TB_MATERIAL)) != null && (o = cell.getValue()) != null && o instanceof MaterialInfo && materialInfos[0].getId().toString().equals(((MaterialInfo)o).getId().toString())) {
                    return;
                }
            } else if (bizMaterialBox.getValue() instanceof Object[]) {
                Object[] objects = (Object[])bizMaterialBox.getValue();
                if (objects.length == 0) {
                    return;
                }
                materialInfos = new MaterialInfo[objects.length];
                System.arraycopy(objects, 0, materialInfos, 0, objects.length);
            } else {
                return;
            }
            this.doMaterialChanged(bizMaterialBox, materialInfos, selectedRow);
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    protected void doMaterialChanged(KDBizPromptBox bizMaterialBox, MaterialInfo[] materialInfos, int selectedRow) throws Exception {
        if (materialInfos == null || materialInfos.length == 0) {
            bizMaterialBox.setValue(null);
            return;
        }
        KDTable table = this.mainTable;
        KDTSelectBlock ksb = table.getSelectManager().get();
        int beginRow = ksb.getBeginRow();
        IRow curRow = table.getRow(beginRow);
        int curCol = table.getColumnIndex(TB_MATERIAL);
        bizMaterialBox.removeDataChangeListener(this.materialListener);
        CtrlUnitInfo CU = SysContext.getSysContext().getCurrentCtrlUnit();
        int length = materialInfos.length;
        if (length > 0) {
            IRow curRow2 = null;
            MaterialInfo mi = null;
            boolean needInsert = false;
            int insertedRowCount = 0;
            for (int i = 0; i < length; ++i) {
                if (needInsert) {
                    this.mainTable.addRow(beginRow + insertedRowCount);
                    needInsert = false;
                }
                mi = materialInfos[i];
                curRow2 = table.getRow(beginRow + insertedRowCount);
                if (materialInfos[i] == null) {
                    curRow2.getCell(curCol).setValue(null);
                    return;
                }
                curRow2.getCell(curCol).setValue(null);
                curRow2.getCell(curCol).setValue((Object)mi);
                if (curRow2.getCell(TB_NUMBER).getValue() == null) {
                    curRow2.getCell(TB_NUMBER).setValue((Object)mi.getNumber());
                }
                if (curRow2.getCell(TB_NAME).getValue() == null) {
                    curRow2.getCell(TB_NAME).setValue((Object)mi.getName());
                }
                curRow2.getCell(TB_MODEL).setValue((Object)mi.getModel());
                curRow2.getCell(TB_UNIT).setValue((Object)mi.getBaseUnit());
                curRow2.getCell(TB_CU).setValue((Object)CU);
                needInsert = true;
                ++insertedRowCount;
            }
            if (!needInsert && insertedRowCount > 0) {
                this.removeLine(table, beginRow + insertedRowCount);
            }
            this.afterInsert(beginRow, (DataBaseInfo[])materialInfos);
        } else {
            curRow.getCell(curCol).setValue((Object)new MaterialInfo());
            curRow.getCell(curCol).setValue(null);
        }
        bizMaterialBox.addDataChangeListener(this.materialListener);
    }

    protected void expenseItemChanged(String expenseItem, DataChangeEvent e) {
        try {
            KDBizPromptBox bizExpenseItemBox = (KDBizPromptBox)e.getSource();
            KDTable tb = this.mainTable;
            KDTSelectBlock selected = tb.getSelectManager().get();
            if (selected == null) {
                return;
            }
            int selectedRow = selected.getBeginRow();
            if (bizExpenseItemBox.getValue() == null) {
                return;
            }
            ExpenseTypeInfo[] expenseItemInfos = null;
            if (bizExpenseItemBox.getValue() instanceof ExpenseTypeInfo[]) {
                expenseItemInfos = (ExpenseTypeInfo[])bizExpenseItemBox.getValue();
            } else if (bizExpenseItemBox.getValue() instanceof ExpenseTypeInfo) {
                Object o;
                ICell cell;
                expenseItemInfos = new ExpenseTypeInfo[]{(ExpenseTypeInfo)bizExpenseItemBox.getValue()};
                if (selected != null && selectedRow >= 0 && (cell = tb.getRow(selectedRow).getCell(expenseItem)) != null && (o = cell.getValue()) != null && o instanceof ExpenseTypeInfo && expenseItemInfos[0].getId().toString().equals(((ExpenseTypeInfo)o).getId().toString())) {
                    return;
                }
            } else if (bizExpenseItemBox.getValue() instanceof Object[]) {
                Object[] objects = (Object[])bizExpenseItemBox.getValue();
                if (objects.length == 0) {
                    return;
                }
                expenseItemInfos = new ExpenseTypeInfo[objects.length];
                System.arraycopy(objects, 0, expenseItemInfos, 0, objects.length);
            } else {
                return;
            }
            this.doExpenseItemChanged(bizExpenseItemBox, expenseItemInfos, selectedRow, expenseItem);
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    protected void doExpenseItemChanged(KDBizPromptBox bizExpenseItemBox, ExpenseTypeInfo[] expenseItemInfos, int selectedRow, String materialFieldname) throws Exception {
        if (expenseItemInfos == null || expenseItemInfos.length == 0) {
            bizExpenseItemBox.setValue(null);
            return;
        }
        KDTable table = this.mainTable;
        KDTSelectBlock ksb = table.getSelectManager().get();
        int beginRow = ksb.getBeginRow();
        IRow curRow = table.getRow(beginRow);
        int curCol = table.getColumnIndex(materialFieldname);
        bizExpenseItemBox.removeDataChangeListener(this.expenseItemListener);
        CtrlUnitInfo CU = SysContext.getSysContext().getCurrentCtrlUnit();
        int length = expenseItemInfos.length;
        if (length > 0) {
            IRow curRow2 = null;
            ExpenseTypeInfo etInfo = null;
            boolean needInsert = false;
            int insertedRowCount = 0;
            for (int i = 0; i < length; ++i) {
                if (needInsert) {
                    this.mainTable.addRow(beginRow + insertedRowCount);
                    needInsert = false;
                }
                etInfo = expenseItemInfos[i];
                curRow2 = table.getRow(beginRow + insertedRowCount);
                if (expenseItemInfos[i] == null) {
                    curRow2.getCell(curCol).setValue(null);
                    return;
                }
                curRow2.getCell(curCol).setValue(null);
                curRow2.getCell(curCol).setValue((Object)etInfo);
                if (curRow2.getCell(TB_NUMBER).getValue() == null) {
                    curRow2.getCell(TB_NUMBER).setValue((Object)etInfo.getNumber());
                }
                if (curRow2.getCell(TB_NAME).getValue() == null) {
                    curRow2.getCell(TB_NAME).setValue((Object)etInfo.getName());
                }
                curRow2.getCell(TB_UNIT).setValue((Object)etInfo.getDefaultUnit());
                curRow2.getCell(TB_CU).setValue((Object)CU);
                needInsert = true;
                ++insertedRowCount;
            }
            if (!needInsert && insertedRowCount > 0) {
                this.removeLine(table, beginRow + insertedRowCount);
            }
            this.afterInsert(beginRow, (DataBaseInfo[])expenseItemInfos);
        } else {
            curRow.getCell(curCol).setValue((Object)new ExpenseTypeInfo());
            curRow.getCell(curCol).setValue(null);
        }
        bizExpenseItemBox.addDataChangeListener(this.expenseItemListener);
    }

    protected void afterInsert(int rowIdx, DataBaseInfo[] infos) throws Exception {
        if (infos.length > 1) {
            this.setDefaultValueOnColumn(rowIdx + 1, infos.length - 1);
        }
    }

    protected void setDefaultValueOnColumn(int beginIdx, int count) {
        if (this.fieldsToCopy != null && this.fieldsToCopy.length > 0) {
            IRow oRow;
            Object[] values = new Object[this.fieldsToCopy.length];
            if (this.mainTable.getRowCount() > 1 && beginIdx == -1) {
                beginIdx = this.mainTable.getRowCount() - 1;
            }
            if ((oRow = this.mainTable.getRow(beginIdx - 1)) == null) {
                oRow = this.mainTable.getRow(beginIdx);
            }
            if (oRow == null) {
                oRow = this.mainTable.getRow(beginIdx + 1);
            }
            if (oRow != null) {
                for (int j = 0; j < this.fieldsToCopy.length; ++j) {
                    if (oRow.getCell(this.fieldsToCopy[j]) == null) continue;
                    values[j] = oRow.getCell(this.fieldsToCopy[j]).getValue();
                }
                for (int i = beginIdx; i < beginIdx + count; ++i) {
                    IRow newRow = this.mainTable.getRow(i);
                    if (newRow == null) continue;
                    for (int j = 0; j < this.fieldsToCopy.length; ++j) {
                        if (newRow.getCell(this.fieldsToCopy[j]) == null || newRow.getCell(this.fieldsToCopy[j]).getValue() != null) continue;
                        newRow.getCell(this.fieldsToCopy[j]).setValue(values[j]);
                        if (TB_TAXCLASSIFICATIONCODE.equals(this.fieldsToCopy[j])) {
                            newRow.getCell(TB_PREFERENTIALPOLICIES).setEditor(oRow.getCell(TB_PREFERENTIALPOLICIES).getEditor());
                            newRow.getCell(TB_HASPREFERENTIAL).getStyleAttributes().setLocked(oRow.getCell(TB_HASPREFERENTIAL).getStyleAttributes().isLocked());
                            newRow.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().setLocked(oRow.getCell(TB_PREFERENTIALPOLICIES).getStyleAttributes().isLocked());
                        }
                        if (!TB_ISVEHICLE.equals(this.fieldsToCopy[j])) continue;
                        int length = TB_VEHICLEFIELDS.length;
                        for (int k = 0; k < length; ++k) {
                            newRow.getCell(TB_VEHICLEFIELDS[k]).getStyleAttributes().setLocked(oRow.getCell(TB_VEHICLEFIELDS[k]).getStyleAttributes().isLocked());
                        }
                    }
                }
            }
        }
    }

    protected void removeLine(KDTable table, int rowIndex) {
        if (table == null) {
            return;
        }
        if (table.getRow(rowIndex) != null) {
            table.getSelectManager().select(rowIndex, 0, rowIndex, 0, 2);
            IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
            table.removeRow(rowIndex);
            IObjectCollection collection = (IObjectCollection)table.getUserObject();
            if (collection == null) {
                logger.error((Object)"collection not be binded to table");
            } else if (detailData != null) {
                collection.removeObject(detailData);
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        int count = this.mainTable.getRowCount();
        this.checkBeforeSave();
        ProductCodeInfo[] infos = new ProductCodeInfo[count];
        for (int i = 0; i < count; ++i) {
            IRow row = this.mainTable.getRow(i);
            ProductCodeInfo pcInfo = new ProductCodeInfo();
            pcInfo.setId(BOSUuid.create((BOSObjectType)pcInfo.getBOSType()));
            pcInfo.setNumber(this.dealString(row, TB_NUMBER));
            pcInfo.setName(this.dealString(row, TB_NAME));
            pcInfo.setCompany((CompanyOrgUnitInfo)row.getCell(TB_COMPANY).getValue());
            pcInfo.setCustomer((CustomerInfo)row.getCell(TB_CUSTOMER).getValue());
            pcInfo.setMaterial((MaterialInfo)row.getCell(TB_MATERIAL).getValue());
            pcInfo.setExpenseItem((ExpenseTypeInfo)row.getCell(TB_EXPENSEITEM).getValue());
            pcInfo.setSimpleCode(this.dealString(row, TB_SIMPLECODE));
            pcInfo.setModel(this.dealString(row, TB_MODEL));
            pcInfo.setTaxClass((TaxClassificationCodeInfo)row.getCell(TB_TAXCLASS).getValue());
            pcInfo.setTaxClassificationCode((TaxClassificationCodeInfo)row.getCell(TB_TAXCLASSIFICATIONCODE).getValue());
            pcInfo.setTaxData((TaxDataInfo)row.getCell(TB_TAXDATA).getValue());
            pcInfo.setTaxRate(row.getCell(TB_TAXRATE).getValue() == null ? BigDecimal.ZERO : new BigDecimal(row.getCell(TB_TAXRATE).getValue().toString()));
            pcInfo.setHasPreferential((Boolean)row.getCell(TB_HASPREFERENTIAL).getValue());
            pcInfo.setPreferentialPolicies((PreferentialPoliciesEnum)((Object)row.getCell(TB_PREFERENTIALPOLICIES).getValue()));
            pcInfo.setUnit((MeasureUnitInfo)row.getCell(TB_UNIT).getValue());
            pcInfo.setPrice(row.getCell(TB_PRICE).getValue() == null ? BigDecimal.ZERO : new BigDecimal(row.getCell(TB_PRICE).getValue().toString()));
            pcInfo.setIsTax((Boolean)row.getCell(TB_ISTAX).getValue());
            pcInfo.setIsDiffTax((Boolean)row.getCell(TB_ISDIFFTAX).getValue());
            pcInfo.setRemark(this.dealString(row, TB_REMARK));
            pcInfo.setStatus(ProductCodeStatusEnum.USING);
            pcInfo.setSourceType(ProductCodeSourceTypeEnum.MANUAL);
            pcInfo.setLongNumber(pcInfo.getNumber());
            pcInfo.setIsLeaf(true);
            pcInfo.setLevel(1);
            pcInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            pcInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            pcInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
            pcInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            pcInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
            pcInfo.setIsVehicle((Boolean)row.getCell(TB_ISVEHICLE).getValue());
            pcInfo.setVehicleType(this.dealString(row, TB_VEHICLETYPE));
            pcInfo.setFacPlateModel(this.dealString(row, TB_FACPLATEMODEL));
            pcInfo.setOrigin(this.dealString(row, TB_ORIGIN));
            pcInfo.setTonnage(this.dealString(row, TB_TONNAGE));
            pcInfo.setLimitPopulation(this.dealString(row, TB_LIMITPOPULATION));
            pcInfo.setProductionEnterprise(this.dealString(row, TB_PRODUCTIONENTERPRISE));
            infos[i] = pcInfo;
        }
        if (infos.length > 0) {
            Map result = ProductCodeFactory.getRemoteInstance().batchSave(infos);
            String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"PRODUCTIMPORT_MSG", (Object[])new Object[]{result.get("success"), result.get("error")});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)result.get("errorMsg").toString(), (int)1);
        }
    }

    private String dealString(IRow row, String columnName) {
        return row.getCell(columnName).getValue() == null ? null : row.getCell(columnName).getValue().toString();
    }

    private void checkBeforeSave() {
        StringBuffer total = new StringBuffer();
        for (int i = 0; i < this.mainTable.getRowCount(); ++i) {
            if (this.mainTable.getCell(i, TB_NUMBER).getValue() == null) {
                total.append(this.getEntryMsg(i + 1, "TB_NUMBER"));
            }
            if (this.mainTable.getCell(i, TB_NAME).getValue() == null) {
                total.append(this.getEntryMsg(i + 1, "TB_NAME"));
            }
            if (this.mainTable.getColumn(TB_MATERIAL).isRequired() && this.mainTable.getCell(i, TB_MATERIAL).getValue() == null) {
                total.append(this.getEntryMsg(i + 1, "TB_MATERIAL"));
            }
            if (this.mainTable.getColumn(TB_EXPENSEITEM).isRequired() && this.mainTable.getCell(i, TB_EXPENSEITEM).getValue() == null) {
                total.append(this.getEntryMsg(i + 1, "TB_EXPENSEITEM"));
            }
            if (this.mainTable.getCell(i, TB_TAXCLASSIFICATIONCODE).getValue() != null) continue;
            total.append(this.getEntryMsg(i + 1, "TB_TAXCLASSIFICATIONNAME"));
        }
        if (total.length() > 0) {
            MsgBox.showInfo((String)total.toString());
            SysUtil.abort();
        }
    }

    private String getEntryMsg(int i, String field) {
        return EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"ENTRYNULL_MSG", (Object[])new Object[]{i, EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)field)});
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.mainTable.addRow();
        row.getCell(TB_ISTAX).setValue((Object)true);
        row.getCell(TB_HASPREFERENTIAL).setValue((Object)false);
        row.getCell(TB_ISDIFFTAX).setValue((Object)false);
        row.getCell(TB_ISVEHICLE).setValue((Object)false);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.mainTable == null) {
            return;
        }
        IRow row = null;
        if (this.mainTable.getSelectManager().size() > 0) {
            int top = this.mainTable.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(this.mainTable) ? this.mainTable.addRow() : this.mainTable.addRow(top);
        } else {
            row = this.mainTable.addRow();
        }
        row.getCell(TB_ISTAX).setValue((Object)true);
        row.getCell(TB_HASPREFERENTIAL).setValue((Object)false);
        row.getCell(TB_ISDIFFTAX).setValue((Object)false);
        row.getCell(TB_ISVEHICLE).setValue((Object)false);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.mainTable != null) {
            this.removeLine(this.mainTable);
            if (this.mainTable.getRowCount() == 0) {
                FocusTraversalPolicy policy = null;
                Object container = null;
                Component initComponent = null;
                if (this.getFocusTraversalPolicy() != null && this.getFocusTraversalPolicy() instanceof UIFocusTraversalPolicy) {
                    policy = this.getFocusTraversalPolicy();
                    container = this;
                    Component[] traverComponent = ((UIFocusTraversalPolicy)policy).getComponents();
                    for (int i = 0; i < traverComponent.length; ++i) {
                        if (traverComponent[i] != this.mainTable) continue;
                        initComponent = traverComponent[i];
                        break;
                    }
                    if (initComponent == null) {
                        initComponent = policy.getLastComponent((Container)container);
                        initComponent.requestFocusInWindow();
                    } else if (initComponent != null) {
                        Component component = policy.getComponentBefore((Container)container, initComponent);
                        while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                            component = policy.getComponentBefore((Container)container, component);
                        }
                        component.requestFocusInWindow();
                    }
                } else if (policy == null) {
                    if (this.getUIWindow() instanceof Dialog) {
                        policy = ((Dialog)this.uiWindow).getFocusTraversalPolicy();
                        container = (Dialog)this.uiWindow;
                    } else if (this.getUIWindow() instanceof Window) {
                        policy = ((Window)this.uiWindow).getFocusTraversalPolicy();
                        container = (Window)this.uiWindow;
                    }
                    if (policy != null) {
                        try {
                            Component component = policy.getComponentBefore((Container)container, (Component)this.mainTable);
                            while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                                component = policy.getComponentBefore((Container)container, component);
                            }
                            component.requestFocusInWindow();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    protected boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }
}

