/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.basedata.client.AbstractPwySetCAUI;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.common.uihelper.IAsyncJob;
import com.kingdee.eas.tm.im.common.uihelper.UIHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PwySetCAUI
extends AbstractPwySetCAUI {
    private static final Logger logger = CoreUIObject.getLogger(PwySetCAUI.class);
    private UIHelper uiHelper = new UIHelper(this);
    private int invoicePercent = 0;

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        final PwySetCAUI ui = this;
        this.uiHelper.doInDeamon(e, new IAsyncJob(){

            @Override
            public CoreUI getOwner() {
                return ui;
            }

            @Override
            public int getProgress() {
                return PwySetCAUI.this.invoicePercent;
            }

            @Override
            public Object execute() {
                try {
                    PwySetCAUI.this.innerSetCA();
                }
                catch (Exception e) {
                    ui.handUIException((Throwable)e);
                }
                return null;
            }
        });
    }

    public void innerSetCA() throws Exception {
        String ca = this.txtCA.getText();
        this.invoicePercent = 10;
        if (ca.isEmpty()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.PwySettingResource", (String)"CANULL"));
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        PwySettingInfo info = PwySettingFactory.getRemoteInstance().getPwySettingInfo((IObjectPK)new ObjectUuidPK(this.getUIContext().get("id").toString()));
        param.put("pwyid", info.getId().toString());
        param.put("ca", ca);
        PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_SET_CA, TransSrcSystemEnum.easgui, info.getCompany().getId().toString(), param);
        PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getRemoteInstance().invoke(actionParam);
        IPwyService pwyService = PwyServiceHelper.getPwyService(null, invokeParam);
        pwyService.invoke();
        String message = "";
        String errorCode = "";
        try {
            JSONObject jsonData = new JSONObject(pwyService.getInvokeParam().getRevMsg());
            errorCode = jsonData.get("errcode").toString();
            message = jsonData.get("description").toString();
        }
        catch (JSONException e1) {
            throw new IMException(IMException.JSON_ERROR);
        }
        this.invoicePercent = 100;
        if ("0".equals(errorCode)) {
            this.disposeUIWindow();
            MsgBox.showInfo((String)message);
        } else {
            MsgBox.showInfo((String)message);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

