/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tm.common.help.msgHelp.client.TMMsgBox;
import com.kingdee.eas.tm.common.help.msgHelp.client.util.TMMsgURLUtil;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.PwySettingStatusEnum;
import com.kingdee.eas.tm.im.basedata.client.AbstractPwySettingListUI;
import com.kingdee.eas.tm.im.common.IMCommonProcessor;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.im.common.uihelper.IAsyncJob;
import com.kingdee.eas.tm.im.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class PwySettingListUI
extends AbstractPwySettingListUI
implements IPermSupport4ListUI {
    private static final String SETCAUI_CLASS = "com.kingdee.eas.tm.im.basedata.client.PwySetCAUI";
    private ListUIHelper uiHelper = null;
    private int invoicePercent = 0;
    private CommonQueryDialog commonQueryDialog = null;
    private static final Logger logger = CoreUIObject.getLogger(PwySettingListUI.class);
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public PwySettingListUI() throws Exception {
        this.uiHelper = new ListUIHelper(this);
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.tm.im.basedata.client.PwySettingEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PwySettingFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnOpenDisk.setIcon(EASResource.getIcon((String)"imgTbtn_openlink"));
        this.btnCloseDisk.setIcon(EASResource.getIcon((String)"imgTbtn_cutlink"));
        try {
            this.initPermActions();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        try {
            while (rowSet.next()) {
                EntityObjectInfo entity;
                PropertyInfo property;
                if (rowSet.getString("billBosType") == null || rowSet.getString("matchField") == null || (property = (entity = metaDataLoader.getEntity(BOSObjectType.create((String)rowSet.getString("billBosType")))).getPropertyByName(rowSet.getString("matchField"))) == null) continue;
                rowSet.updateString("matchField", property.getAlias());
                if (rowSet.getString("matchFieldValue") == null) continue;
                rowSet.updateString("matchFieldValue", this.getDisplayName(property, rowSet.getString("matchFieldValue")));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDisplayName(PropertyInfo info, String dbValue) {
        String displayName = dbValue;
        try {
            if (info instanceof LinkPropertyInfo) {
                ObjectUuidPK objectUuidPK = new ObjectUuidPK(dbValue);
                IDynamicObject iDynamicObject = DynamicObjectFactory.getRemoteInstance();
                IObjectValue coreBill = iDynamicObject.getValue(objectUuidPK.getObjectType(), (IObjectPK)objectUuidPK);
                return coreBill.get("name").toString();
            }
            if (info.get("dataType") == null) {
                return displayName;
            }
            String dataType = info.get("dataType").toString();
            if (DataType.SHORT.toString().equals(dataType) || DataType.INTEGER.toString().equals(dataType) || DataType.LONG.toString().equals(dataType) || DataType.FLOAT.toString().equals(dataType) || DataType.DOUBLE.toString().equals(dataType) || DataType.DECIMAL.toString().equals(dataType) || DataType.DATE.toString().equals(dataType) || DataType.TIME.toString().equals(dataType) || DataType.TIMESTAMP.toString().equals(dataType) || DataType.CHAR.toString().equals(dataType)) return displayName;
            if (DataType.BOOLEAN.toString().equals(dataType)) {
                if (dbValue.equals("1")) {
                    return IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_true", IMUtils.getLocale());
                }
                if (!dbValue.equals("0")) return displayName;
                return IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_false", IMUtils.getLocale());
            }
            if (DataType.BYTE.toString().equals(dataType) || DataType.STRING.toString().equals(dataType) || DataType.BYTEARRAY.toString().equals(dataType) || DataType.OBJECTPK.toString().equals(dataType) || DataType.ROWSET.toString().equals(dataType) || DataType.BOSUUID.toString().equals(dataType) || DataType.UUID.toString().equals(dataType)) return displayName;
            if (DataType.ENUM.toString().equals(dataType)) {
                String enumClazz = info.get("metadataRef").toString();
                if (enumClazz.isEmpty()) return displayName;
                Enum value = IMUtils.getEnumValue(enumClazz, dbValue);
                if (value == null) return displayName;
                return value.getAlias();
            }
            if (DataType.OBJECTVALUE.toString().equals(dataType)) return displayName;
            if (!DataType.OBJECTCOLLECTION.toString().equals(dataType)) return displayName;
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return displayName;
    }

    @Override
    public void actionOpenDisk_actionPerformed(ActionEvent e) throws Exception {
        PwySettingListUI ui = this;
        this.uiHelper.doInDeamon(e, new IAsyncJob((CoreUI)ui){
            final /* synthetic */ CoreUI val$ui;
            {
                this.val$ui = coreUI;
            }

            @Override
            public CoreUI getOwner() {
                return this.val$ui;
            }

            @Override
            public int getProgress() {
                return PwySettingListUI.this.invoicePercent;
            }

            @Override
            public Object execute() {
                try {
                    PwySettingListUI.this.innerOpenDisk();
                }
                catch (Exception e) {
                    this.val$ui.handUIException((Throwable)e);
                }
                return null;
            }
        });
    }

    public void innerOpenDisk() throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        this.invoicePercent = 10;
        PwySettingInfo info = PwySettingFactory.getRemoteInstance().getPwySettingInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        IObjectPK logPk = LogUtils.beginLog(null, "openDisk", BOSObjectType.create((String)"5FFAC545"), (IObjectPK)new ObjectUuidPK(info.getId()), info.getLogInfo(), "im_pwySetting_openDisk", "");
        if (PwySettingStatusEnum.FORBIDDEN.equals((Object)info.getStatus())) {
            MsgBox.showWarning((String)IMUtils.getString("com.kingdee.eas.tm.im.PwySettingResource", "Active_Selected", IMUtils.getLocale()));
            return;
        }
        if (!OPTypeEnum.MakeInvoice.equals((Object)info.getOpType())) {
            MsgBox.showWarning((String)IMUtils.getString("com.kingdee.eas.tm.im.PwySettingResource", "OPERATIONDISK_ERRORMSG", IMUtils.getLocale()));
            return;
        }
        ArrayList ids = this.getSelectedIdValues();
        if (ids.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.PwySettingResource", (String)"NONSUPPORTBATCH"));
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pwyid", info.getId().toString());
        PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_PAPER_INIT, TransSrcSystemEnum.easgui, info.getCompany().getId().toString(), param);
        PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getRemoteInstance().invoke(actionParam);
        IPwyService pwyService = PwyServiceHelper.getPwyService(null, invokeParam);
        pwyService.invoke();
        String message = "";
        try {
            if (pwyService.getInvokeParam().isSuccess()) {
                JSONObject jsonData = new JSONObject(pwyService.getInvokeParam().getRevMsg());
                message = jsonData.get("description").toString();
            } else {
                if (pwyService.getInvokeParam().getRevMsg() == null) {
                    throw new IMException(IMException.JSON_ERROR);
                }
                JSONObject jsonData = new JSONObject(pwyService.getInvokeParam().getRevMsg());
                message = jsonData.get("description").toString();
            }
        }
        catch (JSONException e1) {
            throw new IMException(IMException.JSON_ERROR);
        }
        this.invoicePercent = 100;
        if (pwyService.getInvokeParam().isSuccess()) {
            MsgBox.showInfo((String)message);
        } else {
            TMMsgBox.showInfo((String)message, (Map)TMMsgURLUtil.getMsgURL((String)"IMK"));
        }
        LogUtils.afterLog(null, logPk);
        this.refreshList();
    }

    @Override
    public void actionCloseDisk_actionPerformed(ActionEvent e) throws Exception {
        PwySettingListUI ui = this;
        this.uiHelper.doInDeamon(e, new IAsyncJob((CoreUI)ui){
            final /* synthetic */ CoreUI val$ui;
            {
                this.val$ui = coreUI;
            }

            @Override
            public CoreUI getOwner() {
                return this.val$ui;
            }

            @Override
            public int getProgress() {
                return PwySettingListUI.this.invoicePercent;
            }

            @Override
            public Object execute() {
                try {
                    PwySettingListUI.this.innerCloseDisk();
                }
                catch (Exception e) {
                    this.val$ui.handUIException((Throwable)e);
                }
                return null;
            }
        });
    }

    public void innerCloseDisk() throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        this.invoicePercent = 10;
        PwySettingInfo info = PwySettingFactory.getRemoteInstance().getPwySettingInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        IObjectPK logPk = LogUtils.beginLog(null, "colseDisk", BOSObjectType.create((String)"5FFAC545"), (IObjectPK)new ObjectUuidPK(info.getId()), info.getLogInfo(), "im_pwySetting_colseDisk", "");
        if (PwySettingStatusEnum.FORBIDDEN.equals((Object)info.getStatus())) {
            MsgBox.showWarning((String)IMUtils.getString("com.kingdee.eas.tm.im.PwySettingResource", "Active_Selected", IMUtils.getLocale()));
            return;
        }
        if (!OPTypeEnum.MakeInvoice.equals((Object)info.getOpType())) {
            MsgBox.showWarning((String)IMUtils.getString("com.kingdee.eas.tm.im.PwySettingResource", "OPERATIONDISK_ERRORMSG", IMUtils.getLocale()));
            return;
        }
        ArrayList ids = this.getSelectedIdValues();
        if (ids.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.PwySettingResource", (String)"NONSUPPORTBATCH"));
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pwyid", info.getId().toString());
        PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_PAPER_UNINIT, TransSrcSystemEnum.easgui, info.getCompany().getId().toString(), param);
        PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getRemoteInstance().invoke(actionParam);
        IPwyService pwyService = PwyServiceHelper.getPwyService(null, invokeParam);
        pwyService.invoke();
        String message = "";
        try {
            JSONObject jsonData = new JSONObject(pwyService.getInvokeParam().getRevMsg());
            message = jsonData.get("description").toString();
        }
        catch (JSONException e1) {
            throw new IMException(IMException.JSON_ERROR);
        }
        this.invoicePercent = 100;
        MsgBox.showInfo((String)message);
        LogUtils.afterLog(null, logPk);
        this.refreshList();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        PwySettingInfo info = PwySettingFactory.getRemoteInstance().getPwySettingInfo((IObjectPK)new ObjectUuidPK(id));
        if (PwySettingStatusEnum.USING.equals((Object)info.getStatus())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.PwySettingResource", (String)"CANNOTEDIT"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi;
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int billCount = ids.size();
        ArrayList errorList = PwySettingFactory.getRemoteInstance().active(new HashSet(ids));
        if (errorList.size() > 0) {
            StringBuffer errorDetailMSG = new StringBuffer();
            for (int i = 0; i < errorList.size(); ++i) {
                errorDetailMSG.append(errorList.get(i)).append("\r\n");
            }
            int errorCount = errorList.size();
            String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelCancelError", IMUtils.getLocale(), new Object[]{String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
            TMMsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorDetailMSG.toString(), (int)1, (Map)TMMsgURLUtil.getMsgURL((String)"IMK"));
        } else {
            String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelCancelSuccess", IMUtils.getLocale());
            MsgBox.showInfo((String)summaryMsg);
        }
        this.actionRefresh_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelError");
        if (this.confirmDialog(cancelMsg)) {
            ArrayList ids = this.getSelectedIdValues();
            int billCount = ids.size();
            ArrayList errorList = PwySettingFactory.getRemoteInstance().inActive(new HashSet(this.getSelectedIdValues()));
            if (errorList.size() > 0) {
                StringBuffer errorDetailMSG = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorDetailMSG.append(errorList.get(i)).append("\r\n");
                }
                int errorCount = errorList.size();
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelError", IMUtils.getLocale(), new Object[]{String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
                MsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorDetailMSG.toString(), (int)1);
            } else {
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelSuccess", IMUtils.getLocale());
                MsgBox.showInfo((String)summaryMsg);
            }
            this.actionRefresh_actionPerformed(e);
        }
    }

    protected void Remove() throws Exception {
        this.uiHelper.batchOperation("delete", this.tblMain, this.getKeyFieldName(), "number", "5FFAC545");
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        if (this.isSupportedBatchActions()) {
            PwySettingInfo info = null;
            try {
                if (!StringUtils.isEmpty((String)this.getSelectedKeyValue()) && this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue())) && (info = PwySettingFactory.getRemoteInstance().getPwySettingInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))) != null && info.getCompany() != null) {
                    pk = new ObjectUuidPK(info.getCompany().getId().toString());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (pk != null) {
                return pk;
            }
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = new CommonQueryDialog();
        }
        if (this.getUIWindow() == null) {
            this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            this.commonQueryDialog.setOwner((Component)((Object)this));
        }
        this.commonQueryDialog.setUiObject((IUIObject)this);
        this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
        this.commonQueryDialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        if (this.orgContextManager != null) {
            if (this.orgContextManager.getOwner() != null && this.orgContextManager.getOwner() instanceof CustomerQueryPanel) {
                this.commonQueryDialog.addUserPanel((KDPanel)((CustomerQueryPanel)this.orgContextManager.getOwner()));
            }
            this.orgContextManager.init(this.getUIContext());
        }
        try {
            this.commonQueryDialog.setProcessor((IProcessor)new IMCommonProcessor((IUIObject)this));
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        this.commonQueryDialog.setMaxReturnCountVisible(true);
        this.commonQueryDialog.setWidth(510);
        this.commonQueryDialog.setHeight(340);
        return this.commonQueryDialog;
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
        this.uiHelper.bindPermission((AbstractButton)this.btnRemove, (IItemAction)this.actionRemove, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.btnCancelCancel, (IItemAction)this.actionCancelCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.btnCancel, (IItemAction)this.actionCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemRemove, (IItemAction)this.actionRemove, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemCancelCancel, (IItemAction)this.actionCancelCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemCancel, (IItemAction)this.actionCancel, this.getServiceContext());
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "company";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }

    public void handUIException(Throwable exc) {
        if (TMMsgBox.handUIException((Component)((Object)this), (Throwable)exc, (String)"IMK")) {
            super.handUIException(exc);
        }
    }
}

