/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client.util;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.util.TCCUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TCCClientUtil {
    public static void initTCC(KDBizPromptBox prmtTaxClassificationCode) {
        if (prmtTaxClassificationCode.getSelectorCollection() == null) {
            prmtTaxClassificationCode.setSelectorCollection(TCCUtil.getTCCSelector());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true, CompareType.EQUALS));
        view.setFilter(tmpFilter);
        prmtTaxClassificationCode.setEntityViewInfo(view);
    }

    public static void initTaxRate(KDFormattedTextField txtTaxRate) {
        txtTaxRate.setMaximumValue((Comparable)BigDecimal.ONE);
        txtTaxRate.setMinimumValue((Comparable)BigDecimal.ZERO);
        txtTaxRate.setPrecision(4);
        txtTaxRate.setRemoveingZeroInEdit(false);
        txtTaxRate.setRemoveingZeroInDispaly(false);
        txtTaxRate.setHorizontalAlignment(4);
    }

    public static DataChangeListener getTaxClassificationCodeChange(final KDBizPromptBox prmtTaxClassificationCode, final KDBizPromptBox prmtTaxClass, final KDComboBox comboPreferentialPolicies, final KDCheckBox chkHasPreferential, final KDFormattedTextField txtTaxRate) {
        return new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object o = prmtTaxClassificationCode.getValue();
                if (o != null && o instanceof TaxClassificationCodeInfo) {
                    TaxClassificationCodeInfo tccInfo = (TaxClassificationCodeInfo)o;
                    String vatSpecialManagement = tccInfo.getVATSpecialManagement();
                    Set<PreferentialPoliciesEnum> policiesSet = TCCUtil.getPreferentialPoliciesByTCC(vatSpecialManagement);
                    comboPreferentialPolicies.removeAllItems();
                    comboPreferentialPolicies.addItems(policiesSet.toArray());
                    if (!comboPreferentialPolicies.isEnabled()) {
                        ArrayList<Object> items = new ArrayList<Object>();
                        for (int i = 0; i < comboPreferentialPolicies.getItemCount(); ++i) {
                            items.add(comboPreferentialPolicies.getItemAt(i));
                        }
                        if (!items.contains((Object)PreferentialPoliciesEnum.Null)) {
                            comboPreferentialPolicies.addItem((Object)PreferentialPoliciesEnum.Null);
                        }
                        comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.Null);
                    }
                    if (PreferentialPoliciesEnum.NoTaxation.getAlias().equals(vatSpecialManagement) && BigDecimal.ZERO.equals(tccInfo.getTaxRate())) {
                        chkHasPreferential.setSelected(true);
                        chkHasPreferential.setEnabled(false);
                        comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.NoTaxation);
                        comboPreferentialPolicies.setEnabled(false);
                        txtTaxRate.setNumberValue((Number)BigDecimal.ZERO);
                        txtTaxRate.setEnabled(false);
                    } else {
                        chkHasPreferential.setSelected(false);
                        chkHasPreferential.setEnabled(true);
                        comboPreferentialPolicies.setEnabled(false);
                        txtTaxRate.setEnabled(true);
                    }
                    prmtTaxClass.setValue((Object)tccInfo.getParent());
                    txtTaxRate.setNumberValue((Number)(tccInfo.getTaxRate() == null ? BigDecimal.ZERO : tccInfo.getTaxRate()));
                } else {
                    prmtTaxClass.setValue(null);
                    txtTaxRate.setNumberValue((Number)BigDecimal.ZERO);
                    txtTaxRate.setEnabled(true);
                    chkHasPreferential.setEnabled(false);
                    chkHasPreferential.setSelected(false);
                    comboPreferentialPolicies.removeAllItems();
                    ArrayList<Object> items = new ArrayList<Object>();
                    for (int i = 0; i < comboPreferentialPolicies.getItemCount(); ++i) {
                        items.add(comboPreferentialPolicies.getItemAt(i));
                    }
                    if (!items.contains((Object)PreferentialPoliciesEnum.Null)) {
                        comboPreferentialPolicies.addItem((Object)PreferentialPoliciesEnum.Null);
                    }
                    comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.Null);
                    comboPreferentialPolicies.setEnabled(false);
                }
            }
        };
    }

    public static DataChangeListener getTaxRateChange(final KDComboBox comboPreferentialPolicies, final KDCheckBox chkHasPreferential, final KDFormattedTextField txtTaxRate) {
        return new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                List<BigDecimal> taxRateList;
                BigDecimal taxRate;
                Object value = e.getNewValue();
                if (value != null && ((taxRate = (BigDecimal)value).compareTo(BigDecimal.ZERO) < 0 || taxRate.compareTo(BigDecimal.ONE) >= 0)) {
                    txtTaxRate.setValue(e.getOldValue());
                    return;
                }
                if (chkHasPreferential.isSelected() && (taxRateList = TCCUtil.getTaxRateByPolicies((PreferentialPoliciesEnum)((Object)comboPreferentialPolicies.getSelectedItem()))) != null && !taxRateList.contains(value)) {
                    chkHasPreferential.setSelected(false);
                }
                txtTaxRate.setValue(value);
            }
        };
    }

    public static ItemListener getHasPreferentialChange(final KDComboBox comboPreferentialPolicies) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    comboPreferentialPolicies.removeItem((Object)PreferentialPoliciesEnum.Null);
                    comboPreferentialPolicies.setEnabled(true);
                } else {
                    comboPreferentialPolicies.setEnabled(false);
                    ArrayList<Object> items = new ArrayList<Object>();
                    for (int i = 0; i < comboPreferentialPolicies.getItemCount(); ++i) {
                        items.add(comboPreferentialPolicies.getItemAt(i));
                    }
                    if (!items.contains((Object)PreferentialPoliciesEnum.Null)) {
                        comboPreferentialPolicies.addItem((Object)PreferentialPoliciesEnum.Null);
                    }
                    comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.Null);
                }
            }
        };
    }

    public static ItemListener getPreferentialPoliciesChange(final KDBizPromptBox prmtTaxClassificationCode, final KDComboBox comboPreferentialPolicies, final KDCheckBox chkHasPreferential, final KDFormattedTextField txtTaxRate) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                List<BigDecimal> taxRateList = TCCUtil.getTaxRateByPolicies((PreferentialPoliciesEnum)((Object)comboPreferentialPolicies.getSelectedItem()));
                if (!chkHasPreferential.isSelected() && comboPreferentialPolicies.getSelectedItem() != PreferentialPoliciesEnum.Null) {
                    ArrayList<Object> items = new ArrayList<Object>();
                    for (int i = 0; i < comboPreferentialPolicies.getItemCount(); ++i) {
                        items.add(comboPreferentialPolicies.getItemAt(i));
                    }
                    if (!items.contains((Object)PreferentialPoliciesEnum.Null)) {
                        comboPreferentialPolicies.addItem((Object)PreferentialPoliciesEnum.Null);
                    }
                    comboPreferentialPolicies.setSelectedItem((Object)PreferentialPoliciesEnum.Null);
                    return;
                }
                if (taxRateList != null && taxRateList.size() > 0) {
                    txtTaxRate.setNumberValue((Number)taxRateList.get(0));
                } else if (prmtTaxClassificationCode.getValue() instanceof TaxClassificationCodeInfo) {
                    TaxClassificationCodeInfo tcc = (TaxClassificationCodeInfo)prmtTaxClassificationCode.getValue();
                    txtTaxRate.setNumberValue((Number)tcc.getTaxRate());
                }
            }
        };
    }
}

