/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceReqBillTypeEnum;
import com.kingdee.eas.tm.im.client.AbstractAddSrcBillPage;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AddSrcBillPage
extends AbstractAddSrcBillPage {
    private static final Logger logger = CoreUIObject.getLogger(AddSrcBillPage.class);
    private boolean isReq;
    String custID = null;
    String companyID = null;
    boolean isBlueInvoice = true;
    boolean isDiffTax;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUIContext();
        this.initControl();
    }

    public void initUIContext() {
        Map uiCtx = this.getUIContext();
        if (uiCtx.get("custID") != null) {
            this.custID = uiCtx.get("custID").toString();
        }
        if (uiCtx.get("companyID") != null) {
            this.companyID = uiCtx.get("companyID").toString();
        }
        if (uiCtx.get("isBlueInvoice") != null) {
            this.isBlueInvoice = Boolean.parseBoolean(uiCtx.get("isBlueInvoice").toString());
        }
        if (uiCtx.get("isReq") != null) {
            this.isReq = Boolean.parseBoolean(uiCtx.get("isReq").toString());
        }
        if (uiCtx.get("isDiffTax") != null) {
            this.isDiffTax = Boolean.parseBoolean(uiCtx.get("isDiffTax").toString());
        }
    }

    public void initControl() throws EASBizException, BOSException {
        this.prmtOtherbill.setEnabledMultiSelection(true);
        this.prmtOtherbill.setDisplayFormat("$number$");
        this.prmtOtherbill.setEditFormat("$number$");
        if (this.isReq) {
            String reqbill_alias = MakeInvoiceReqBillTypeEnum.MakeInvoiceReq.getAlias();
            this.kDLabelContainer1.setBoundLabelText(reqbill_alias);
            this.initMakeInvoiceReqF7Filter();
        } else {
            String otherbill_alias = MakeInvoiceReqBillTypeEnum.OtherReceiveBill.getAlias();
            this.kDLabelContainer1.setBoundLabelText(otherbill_alias);
            this.initOtherBillF7Filter();
        }
    }

    protected void initOtherBillF7Filter() throws BOSException, EASBizException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bosType", "FC910EF3");
        params.put("isBlueInvoice", this.isBlueInvoice);
        params.put("companyID", this.companyID);
        params.put("customerID", this.custID);
        Map retValue = MakeInvoiceFactory.getRemoteInstance().getAddSrcBillFilter(params);
        FilterInfo filter = (FilterInfo)retValue.get("filter");
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        this.prmtOtherbill.setEntityViewInfo(ev);
        this.prmtOtherbill.setQueryInfo("com.kingdee.eas.tm.im.app.F7OtherBillQuery");
        this.prmtOtherbill.getQueryAgent().resetRuntimeEntityView();
    }

    protected void initMakeInvoiceReqF7Filter() throws BOSException, EASBizException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bosType", "AC368D2D");
        params.put("isBlueInvoice", this.isBlueInvoice);
        params.put("isDiffTax", this.isDiffTax);
        params.put("companyID", this.companyID);
        params.put("customerID", this.custID);
        Map retValue = MakeInvoiceFactory.getRemoteInstance().getAddSrcBillFilter(params);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = (FilterInfo)retValue.get("filter");
        ev.setFilter(filter);
        this.prmtOtherbill.setQueryInfo("com.kingdee.eas.tm.im.app.F7MakeInvoiceReqQuery");
        this.prmtOtherbill.setEntityViewInfo(ev);
        this.prmtOtherbill.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        Map uiCtx = this.getUIContext();
        HashSet mkinvoiceIDs = (HashSet)uiCtx.get("mkIds");
        Object otherBills = this.prmtOtherbill.getValue();
        HashSet<String> otherIdSet = new HashSet<String>();
        if (otherBills instanceof IObjectValue) {
            otherIdSet.add(((IObjectValue)otherBills).get("id").toString());
        } else if (otherBills instanceof Object[]) {
            Object[] bills = (Object[])otherBills;
            for (int i = 0; i < bills.length; ++i) {
                IObjectValue info = (IObjectValue)bills[i];
                if (info == null) continue;
                otherIdSet.add(info.get("id").toString());
            }
        }
        if (otherIdSet.isEmpty()) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "AddSrcBillSelect", IMUtils.getLocale()));
            return;
        }
        Map retMap = new HashMap();
        retMap = MakeInvoiceFactory.getRemoteInstance().checkBeforeAddSrcBill(mkinvoiceIDs, otherIdSet);
        if (retMap.get("errorMsg") != null) {
            String errorString = retMap.get("errorMsg").toString();
            MsgBox.showDetailAndOK((Component)((Object)this), (String)IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "AddSrcBillFailed", IMUtils.getLocale()), (String)errorString, (int)8188);
            return;
        }
        retMap = MakeInvoiceFactory.getRemoteInstance().addSrcBill(this.getIDStr(mkinvoiceIDs), this.getIDStr(otherIdSet));
        if (!retMap.isEmpty()) {
            ArrayList errorMsgList = (ArrayList)retMap.get("errorMsg");
            if (!CollectionUtil.isEmpty(errorMsgList)) {
                StringBuffer stringBuffer = new StringBuffer();
                for (String str : errorMsgList) {
                    stringBuffer.append(str).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "AddSrcBillFailed", IMUtils.getLocale()), (String)stringBuffer.toString(), (int)8188);
                this.actionExitCurrent_actionPerformed(e);
            } else {
                MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "AddSrcBillSuccess", IMUtils.getLocale()));
                this.actionExitCurrent_actionPerformed(e);
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    private String getIDStr(Set ids) {
        StringBuffer ret = new StringBuffer();
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            ret.append(iter.next().toString()).append(",");
        }
        return ret.toString();
    }
}

