/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.tm.im.FullElecInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.client.AbstractClaimInvoiceUI;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClaimInvoiceUI
extends AbstractClaimInvoiceUI {
    private static final Logger logger = CoreUIObject.getLogger(ClaimInvoiceUI.class);
    private ArrayList ids = new ArrayList();
    private String buyerTaxNo = "";
    private DataChangeListener claimCompanyF7Change = null;
    private String invoiceBosType = "";

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.initUI();
        this.btnOK.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.setClaimCompanyF7Filter();
        this.initListeners();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void removeListener() {
        if (this.claimCompanyF7Change != null) {
            this.claimCompanyF7.removeDataChangeListener(this.claimCompanyF7Change);
        }
    }

    private void initListeners() {
        if (this.claimCompanyF7Change == null) {
            this.claimCompanyF7Change = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ClaimInvoiceUI.this.claimCompanyF7_dataChanged(e);
                }
            };
        }
        this.claimCompanyF7.addDataChangeListener(this.claimCompanyF7Change);
    }

    private void claimCompanyF7_dataChanged(DataChangeEvent e) {
        this.btnOK.requestFocus();
    }

    private void initUI() {
        Map uiCtx = this.getUIContext();
        this.ids = (ArrayList)uiCtx.get("ids");
        this.buyerTaxNo = (String)uiCtx.get("buyerTaxNo");
        this.invoiceBosType = (String)uiCtx.get("invoiceBosType");
    }

    protected void setClaimCompanyF7Filter() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> idset = new HashSet<String>();
        idset.add("111111111111111111111111111=");
        try {
            String permItem = null;
            permItem = "AF83503C".equals(this.invoiceBosType) ? "im_fullElecInvoice_claimInvoice" : "im_incomeInvoice_claimInvoice";
            if (!StringUtils.isEmpty((String)permItem)) {
                OrgUnitCollection orgColl = IMFacadeFactory.getRemoteInstance().getAuthOrgsByType(OrgType.Company, permItem);
                if (orgColl != null && orgColl.size() > 0) {
                    for (int i = 0; i < orgColl.size(); ++i) {
                        OrgUnitInfo orgInfo = orgColl.get(i);
                        if (orgInfo == null || !orgInfo.isIsCompanyOrgUnit() || !orgInfo.getBoolean("isBizUnit")) continue;
                        idset.add(orgInfo.getId().toString());
                    }
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
            }
            if (!StringUtils.isEmpty((String)this.buyerTaxNo)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("taxNumber", (Object)this.buyerTaxNo, CompareType.EQUALS));
            }
            ev.setFilter(filterInfo);
            this.claimCompanyF7.setEntityViewInfo(ev);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.claimCompanyF7.getValue() == null) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "claimCompanyIsNull", IMUtils.getLocale()));
            SysUtil.abort();
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.claimCompanyF7.getValue();
        Map retMap = new HashMap();
        retMap = "AF83503C".equals(this.invoiceBosType) ? FullElecInvoiceFacadeFactory.getRemoteInstance().claimInvoice(this.ids, companyInfo.getId().toString()) : IncomeInvoiceFactory.getRemoteInstance().claimInvoice(this.ids, companyInfo.getId().toString());
        this.actionExitCurrent_actionPerformed(e);
        String errorMsg = (String)retMap.get("errorMsg");
        if (!StringUtils.isEmpty((String)errorMsg)) {
            String detailMsg = (String)retMap.get("detailMsg");
            if (!StringUtils.isEmpty((String)detailMsg)) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)errorMsg, (String)detailMsg, (int)0);
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "ClaimInvoiceFailed", IMUtils.getLocale()), (String)errorMsg, (int)0);
            }
        } else {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "ClaimInvoiceComplete", IMUtils.getLocale(), new Object[]{this.ids.size()}));
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }
}

