/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.tm.im.client.AbstractDiffTaxUI;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DiffTaxUI
extends AbstractDiffTaxUI {
    private static final Logger logger = CoreUIObject.getLogger(DiffTaxUI.class);
    private static final int AMT_PRECISION = 2;
    private boolean isOk = false;
    private BigDecimal quantity = BigDecimal.ZERO;
    private BigDecimal noTaxAmt = BigDecimal.ZERO;
    private BigDecimal deductAmt = BigDecimal.ZERO;
    private HashMap retMap = new HashMap();

    public HashMap getRetMap() {
        return this.retMap;
    }

    public boolean isOk() {
        return this.isOk;
    }

    public void setOk(boolean isOk) {
        this.isOk = isOk;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initParams();
        this.initEditor();
    }

    private void initParams() {
        Map uiCtx = this.getUIContext();
        this.quantity = (BigDecimal)uiCtx.get("quantity");
        this.noTaxAmt = (BigDecimal)uiCtx.get("noTaxAmt");
        this.deductAmt = (BigDecimal)uiCtx.get("deductAmt");
    }

    private void initEditor() {
        this.setBigDecimalEditor(this.txtDeductAmt, 2);
        this.txtDeductAmt.setMinimumValue((Comparable)BigDecimal.ZERO);
        this.txtDeductAmt.setValue((Object)this.deductAmt);
        this.btnOk.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    private void setBigDecimalEditor(KDFormattedTextField formattedField, int Precision) {
        formattedField.setDataType(1);
        formattedField.setPrecision(Precision);
        formattedField.setNegatived(false);
        formattedField.setSupportedEmpty(false);
        formattedField.setRemoveingZeroInEdit(false);
        formattedField.setRemoveingZeroInDispaly(false);
        formattedField.setHorizontalAlignment(4);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeOK();
        BigDecimal deductAmt = (BigDecimal)this.txtDeductAmt.getValue();
        this.retMap.put("deductAmt", deductAmt);
        this.setOk(true);
        this.actionExitCurrent_actionPerformed(e);
    }

    protected void checkBeforeOK() {
        BigDecimal diffAmt;
        if (this.txtDeductAmt.getValue() == null) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "pleaseInputDeductAmt", IMUtils.getLocale()));
            SysUtil.abort();
        }
        if (BigDecimal.ZERO.compareTo(diffAmt = (BigDecimal)this.txtDeductAmt.getValue()) != 0 && BigDecimal.ZERO.compareTo(this.noTaxAmt) != 0 && diffAmt.signum() != this.noTaxAmt.signum()) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "deductAmt_signIsReverse", IMUtils.getLocale()));
            SysUtil.abort();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }
}

