/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.tm.common.help.msgHelp.client.TMMsgBox;
import com.kingdee.eas.tm.common.help.msgHelp.client.util.TMMsgURLUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTipInfo;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipResourceUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipUtil;
import com.kingdee.eas.tm.im.FullElecInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.PwySettingCollection;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.client.AbstractDownLoadFullElecInvoiceUI;
import com.kingdee.eas.tm.im.client.comp.IMSupplierCommonPromptDialog;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.msg.result.PoolDownloadResult;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.util.IMPermissionUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class DownLoadFullElecInvoiceUI
extends AbstractDownLoadFullElecInvoiceUI {
    private static final Logger logger = CoreUIObject.getLogger(DownLoadFullElecInvoiceUI.class);
    private static final String EMPTYSTR = "";
    private static final int ZERO = 0;
    private static final String DISK = "Disk";
    private static final String WEB = "Web";
    private DataChangeListener prmtCompanyListener = null;
    private ItemListener fullElecSpecialListener = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setDefaultValue();
        this.initListeners();
        this.initSupplierF7();
        this.addCustomerToolTip();
    }

    protected void addCustomerToolTip() {
        TMToolTipUtil.setToolTipInfo((JComponent)this.contStartTime, (TMToolTipInfo)new TMToolTipInfo("contStartTime", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("DOWNLOADII_StartTime"), EMPTYSTR));
        TMToolTipUtil.setToolTipInfo((JComponent)this.contEndTime, (TMToolTipInfo)new TMToolTipInfo("contEndTime", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("DOWNLOADII_EndTime"), EMPTYSTR));
    }

    private void setDefaultValue() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        OrgUnitInfo[] orgUnits = null;
        OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        OrgUnitInfo defaultOrgUnit = null;
        try {
            orgUnits = IMPermissionUtil.getAuthOrgByPermItem(null, (IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, "im_fullElecInvoice_download");
            if (orgUnits != null && orgUnits.length > 0) {
                for (int i = 0; i < orgUnits.length; ++i) {
                    companyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnits[i];
                    if (!companyOrgUnitInfo.getId().toString().equals(currentMainOrg.getId().toString())) continue;
                    defaultOrgUnit = currentMainOrg;
                }
                if (defaultOrgUnit == null) {
                    defaultOrgUnit = orgUnits[0];
                }
                this.prmtCompany.setValue((Object)defaultOrgUnit);
            }
        }
        catch (Exception e) {
            this.prmtCompany.setValue((Object)currentMainOrg);
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.handUIException(e);
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add("1111111111111111");
        if (orgUnits != null && orgUnits.length > 0) {
            for (int i = 0; i < orgUnits.length; ++i) {
                companyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnits[i];
                idSet.add(companyOrgUnitInfo.getId().toString());
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCompany.setEntityViewInfo(view);
        this.prmtSupplier.setValue(null);
        Date date = new Date();
        this.endTime.setValue((Object)new Timestamp(date.getTime()));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        this.startTime.setValue((Object)new Timestamp(calendar.getTimeInMillis()));
        this.txtInvoiceNumber.setText(null);
        this.chkFullElecSpecial.setSelected(true);
        this.chkFullElecCommon.setSelected(false);
        this.chkNormal.setSelected(true);
        this.chkOutOfControl.setSelected(false);
        this.chkCancel.setSelected(false);
        this.chkAbnormal.setSelected(false);
        this.chkRed.setSelected(false);
        this.chkPartRed.setSelected(false);
        this.chkFullRed.setSelected(false);
        this.chkRedConfirm.setSelected(false);
        this.chkUnCheck.setSelected(true);
        this.chkCheck.setSelected(true);
        this.chkConfirmed.setSelected(true);
        this.txtInvoiceNumber.requestFocus();
    }

    protected Set getOrgIds() {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add("111111111111111111111111111=");
        if (this.prmtCompany.getValue() != null) {
            Object[] obj = this.prmtCompany.getValue() instanceof Object[] ? (Object[])this.prmtCompany.getValue() : new Object[]{this.prmtCompany.getValue()};
            for (int i = 0; i < obj.length; ++i) {
                if (obj[i] == null) continue;
                idSet.add(((CompanyOrgUnitInfo)obj[i]).getId().toString());
            }
        }
        return idSet;
    }

    private void initListeners() {
        if (this.fullElecSpecialListener == null) {
            this.fullElecSpecialListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        if (!DownLoadFullElecInvoiceUI.this.chkFullElecSpecial.isSelected()) {
                            DownLoadFullElecInvoiceUI.this.chkUnCheck.setEnabled(false);
                            DownLoadFullElecInvoiceUI.this.chkUnCheck.setSelected(false);
                            DownLoadFullElecInvoiceUI.this.chkCheck.setEnabled(false);
                            DownLoadFullElecInvoiceUI.this.chkCheck.setSelected(false);
                            DownLoadFullElecInvoiceUI.this.chkConfirmed.setEnabled(false);
                            DownLoadFullElecInvoiceUI.this.chkConfirmed.setSelected(false);
                        } else {
                            DownLoadFullElecInvoiceUI.this.chkUnCheck.setEnabled(true);
                            DownLoadFullElecInvoiceUI.this.chkUnCheck.setSelected(true);
                            DownLoadFullElecInvoiceUI.this.chkCheck.setEnabled(true);
                            DownLoadFullElecInvoiceUI.this.chkCheck.setSelected(true);
                            DownLoadFullElecInvoiceUI.this.chkConfirmed.setEnabled(true);
                            DownLoadFullElecInvoiceUI.this.chkConfirmed.setSelected(true);
                        }
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                        DownLoadFullElecInvoiceUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.chkFullElecSpecial.addItemListener(this.fullElecSpecialListener);
        if (this.prmtCompanyListener == null) {
            this.prmtCompanyListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    DownLoadFullElecInvoiceUI.this.initSupplierF7();
                }
            };
        }
        this.prmtCompany.addDataChangeListener(this.prmtCompanyListener);
    }

    private void initSupplierF7() {
        this.prmtSupplier.setValue(null);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Set ids = this.getOrgIds();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplierCompany.usingStatus", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("taxRegisterNo"));
        sic.add(new SelectorItemInfo("supplierCount"));
        view.setSelector(sic);
        this.prmtSupplier.setEntityViewInfo(view);
        IMSupplierCommonPromptDialog supplierF7Dialog = new IMSupplierCommonPromptDialog(ids);
        this.prmtSupplier.setSelector((KDPromptSelector)supplierF7Dialog);
    }

    @Override
    public void actionDownLoad_actionPerformed(ActionEvent e) throws Exception {
        this.txtResult.setText(EMPTYSTR);
        this.downloadCheck();
        this.asynDownloadInvoice("0");
    }

    @Override
    public void actionDownLoadDetail_actionPerformed(ActionEvent e) throws Exception {
        this.txtResult.setText(EMPTYSTR);
        this.downloadCheck();
        this.asynDownloadInvoice("1");
    }

    public void downloadCheck() {
        Date endDate;
        Date beginDate;
        if (this.startTime.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("startTimeNotNull"));
            SysUtil.abort();
        }
        if (this.endTime.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("endTimeNotNull"));
            SysUtil.abort();
        }
        if ((beginDate = (Date)this.startTime.getValue()).compareTo(endDate = (Date)this.endTime.getValue()) > 0) {
            MsgBox.showInfo((String)this.getResource("timeRangeError"));
            SysUtil.abort();
        }
        if (this.companyIsNull()) {
            MsgBox.showInfo((String)this.getResource("companyNotNull"));
            SysUtil.abort();
        }
        if (!this.chkFullElecCommon.isSelected() && !this.chkFullElecSpecial.isSelected()) {
            MsgBox.showInfo((String)this.getResource("invoiceTypeError"));
            SysUtil.abort();
        }
        if (!(this.chkNormal.isSelected() || this.chkOutOfControl.isSelected() || this.chkCancel.isSelected() || this.chkAbnormal.isSelected() || this.chkRed.isSelected() || this.chkPartRed.isSelected() || this.chkFullRed.isSelected() || this.chkRedConfirm.isSelected())) {
            MsgBox.showInfo((String)this.getResource("invoiceStatusError"));
            SysUtil.abort();
        }
        if (!this.chkUnCheck.isSelected() && !this.chkCheck.isSelected() && !this.chkConfirmed.isSelected() && this.chkFullElecSpecial.isSelected()) {
            MsgBox.showInfo((String)this.getResource("CCStatusError"));
            SysUtil.abort();
        }
    }

    public void asynDownloadInvoice(final String oprType) {
        SwingWorker dataWorker = new SwingWorker(){

            public Object construct() {
                try {
                    DownLoadFullElecInvoiceUI.this.btnDownLoad.setEnabled(false);
                    DownLoadFullElecInvoiceUI.this.btnDownLoadDetail.setEnabled(false);
                    ArrayList resultList = new ArrayList();
                    resultList = DownLoadFullElecInvoiceUI.this.downloadInvoice(oprType);
                    DownLoadFullElecInvoiceUI.this.handleResultAndShowMsg(resultList);
                }
                catch (Exception e) {
                    DownLoadFullElecInvoiceUI.this.handUIException(e);
                }
                catch (Throwable ex) {
                    DownLoadFullElecInvoiceUI.this.handUIException(ex);
                }
                finally {
                    DownLoadFullElecInvoiceUI.this.btnDownLoad.setEnabled(true);
                    DownLoadFullElecInvoiceUI.this.btnDownLoadDetail.setEnabled(true);
                }
                return null;
            }

            public void finished() {
            }
        };
        dataWorker.start();
    }

    private ArrayList downloadInvoice(String type) throws BOSException, EASBizException {
        Map diskMap;
        ArrayList<Map> returnList = new ArrayList<Map>();
        Map paramMap = this.buildPwyParam(type);
        if (paramMap.isEmpty()) {
            return returnList;
        }
        Map webMap = this.requestAndSolve(WEB, (List)paramMap.get(WEB));
        if (webMap != null && !webMap.isEmpty()) {
            returnList.add(webMap);
        }
        if ((diskMap = this.requestAndSolve(DISK, (List)paramMap.get(DISK))) != null && !diskMap.isEmpty()) {
            returnList.add(diskMap);
        }
        return returnList;
    }

    private void showBuildPwyParamMsg(String oprType) throws BOSException {
        HashSet companyIDs = new HashSet(this.getCompanyIDs());
        String invoiceNo = this.txtInvoiceNumber.getText();
        String[] invoiceTypes = null;
        for (String type : "0".equals(oprType) ? new String[]{WEB, DISK} : new String[]{WEB}) {
            if (DISK.equals(type)) {
                boolean isNotNeedDisk = this.isNotNeedDisk(companyIDs);
                if (isNotNeedDisk) {
                    this.setTxtResultMsg(IMUtils.getString("com.kingdee.eas.tm.common.invoicePool.FullElecInvoiceResource", "notNeedDisk", IMUtils.getLocale()));
                }
                if (invoiceNo != null && !invoiceNo.trim().isEmpty()) {
                    this.setTxtResultMsg(IMUtils.getString("com.kingdee.eas.tm.common.invoicePool.FullElecInvoiceResource", "DISK_invoiceNo_buildParam", IMUtils.getLocale()));
                    continue;
                }
                this.setTxtResultMsg(IMUtils.getString("com.kingdee.eas.tm.common.invoicePool.FullElecInvoiceResource", "DISK_condition_buildParam", IMUtils.getLocale()));
                continue;
            }
            if (!WEB.equals(type)) continue;
            if (invoiceNo != null && !invoiceNo.trim().isEmpty()) {
                this.setTxtResultMsg(IMUtils.getString("com.kingdee.eas.tm.common.invoicePool.FullElecInvoiceResource", "WEB_invoiceNo_buildParam", IMUtils.getLocale()));
                continue;
            }
            this.setTxtResultMsg(IMUtils.getString("com.kingdee.eas.tm.common.invoicePool.FullElecInvoiceResource", "WEB_condition_buildParam", IMUtils.getLocale()));
        }
    }

    private Map buildPwyParam(String type) throws EASBizException, BOSException {
        this.showBuildPwyParamMsg(type);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("srcSystem", "2");
        String invoiceNo = this.txtInvoiceNumber.getText();
        if (!StringUtils.isEmpty((String)invoiceNo)) {
            invoiceNo = invoiceNo.trim();
        }
        HashMap<String, Object> formData = new HashMap<String, Object>();
        SimpleDateFormat slp = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = slp.format((Date)this.startTime.getValue());
        String endDate = slp.format((Date)this.endTime.getValue());
        formData.put("invoiceType", this.getInvoiceType());
        if (!StringUtils.isEmpty((String)invoiceNo)) {
            formData.put("invoiceType", "27,26");
        }
        formData.put("companyIDs", this.getCompanyIDs());
        formData.put("invoiceStatus", this.getInvoiceStatusValues());
        formData.put("invoiceCode", EMPTYSTR);
        formData.put("invoiceNumber", invoiceNo);
        formData.put("beginDate", startDate);
        formData.put("endDate", endDate);
        formData.put("checkStatus", this.getAuthenticateFlagsValues());
        formData.put("supplierTaxNos", this.getSupplierTaxNo());
        params.put("formData", formData);
        Map retMap = new HashMap();
        retMap = FullElecInvoiceFacadeFactory.getRemoteInstance().buildDownloadPwyParam(params);
        return retMap;
    }

    protected Map requestAndSolve(String type, List paramList) throws EASBizException, BOSException {
        HashMap<String, Cloneable> ret = new HashMap<String, Cloneable>();
        if (paramList == null || paramList.isEmpty()) {
            return null;
        }
        String requestMsg = DISK.equals(type) ? IMUtils.getString("com.kingdee.eas.tm.common.invoicePool.FullElecInvoiceResource", "DISK_REQUSTING", IMUtils.getLocale()) : IMUtils.getString("com.kingdee.eas.tm.common.invoicePool.FullElecInvoiceResource", "WEB_REQUSTING", IMUtils.getLocale());
        this.setTxtResultMsg(requestMsg);
        HashMap bizBillTypeMap = new HashMap();
        Set<Object> keySet = new HashSet();
        ArrayList resultList = new ArrayList();
        ArrayList<String> errorMsg = new ArrayList<String>();
        PwyInvokeParam invokeParam = null;
        Map invokeActionMap = null;
        for (int i = 0; i < paramList.size(); ++i) {
            invokeParam = (PwyInvokeParam)paramList.get(i);
            if (invokeParam.isError()) {
                if (errorMsg.contains(invokeParam.getExceptionMsg())) continue;
                errorMsg.add(invokeParam.getExceptionMsg());
                continue;
            }
            IPwyService pwyService = PwyServiceHelper.getPwyService(null, invokeParam);
            pwyService.invoke();
            if (!pwyService.isSuccess()) {
                if (errorMsg.contains(pwyService.getInvokeParam().getDescription())) continue;
                errorMsg.add(pwyService.getInvokeParam().getDescription());
                continue;
            }
            invokeActionMap = pwyService.getInvokeParam().getInvokeActionMap();
            for (Object result : invokeActionMap.values()) {
                if (!(result instanceof PoolDownloadResult)) continue;
                resultList.add(result);
            }
            keySet = invokeActionMap.keySet();
            Iterator<Object> it = keySet.iterator();
            String keyString = EMPTYSTR;
            Object key = null;
            while (it.hasNext()) {
                key = it.next();
                if (!(key instanceof String) || !(keyString = (String)key).startsWith("BizBillType_")) continue;
                bizBillTypeMap.put(keyString, invokeActionMap.get(keyString));
            }
        }
        this.setTxtResultMsg(IMUtils.getString("com.kingdee.eas.tm.common.invoicePool.FullElecInvoiceResource", "solve_complete", IMUtils.getLocale()));
        ret.put("errorMsg", errorMsg);
        ret.put("resultList", resultList);
        ret.put("bizBillTypeMap", bizBillTypeMap);
        return ret;
    }

    private boolean isNotNeedDisk(Set companyIDs) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("fpdkType"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("opType", (Object)"1"));
        ev.setFilter(filter);
        PwySettingCollection col = PwySettingFactory.getRemoteInstance().getPwySettingCollection(ev);
        boolean isNotNeedDisk = true;
        for (int i = 0; i < col.size(); ++i) {
            PwySettingInfo info = col.get(i);
            if (info.isFpdkType()) continue;
            isNotNeedDisk = false;
            break;
        }
        return isNotNeedDisk;
    }

    private Object getAuthenticateFlagsValues() {
        String authString = EMPTYSTR;
        if (this.chkUnCheck.isSelected()) {
            authString = authString + "0,";
        }
        if (this.chkCheck.isSelected()) {
            authString = authString + "1,";
        }
        if (this.chkConfirmed.isSelected()) {
            authString = authString + "2,3,";
        }
        if (EMPTYSTR.equals(authString)) {
            return null;
        }
        authString = authString.substring(0, authString.length() - 1);
        return authString;
    }

    private String getInvoiceStatusValues() {
        String invoiceStatusValueString = EMPTYSTR;
        if (this.chkNormal.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "0,";
        }
        if (this.chkOutOfControl.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "1,";
        }
        if (this.chkCancel.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "2,";
        }
        if (this.chkRed.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "3,";
        }
        if (this.chkAbnormal.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "4,5,";
        }
        if (this.chkRedConfirm.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "6,";
        }
        if (this.chkPartRed.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "7,";
        }
        if (this.chkFullRed.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "8,";
        }
        if (EMPTYSTR.equals(invoiceStatusValueString)) {
            return EMPTYSTR;
        }
        invoiceStatusValueString = invoiceStatusValueString.substring(0, invoiceStatusValueString.length() - 1);
        return invoiceStatusValueString;
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        RptParams pp = new RptParams();
        if (this.prmtCompany.getValue() != null) {
            pp.setObject("Company", this.prmtCompany.getValue());
        } else {
            pp.setObject("Company", null);
        }
        if (this.prmtSupplier.getValue() != null) {
            pp.setObject("Supplier", this.prmtSupplier.getValue());
        } else {
            pp.setObject("Supplier", null);
        }
        if (this.startTime.getValue() != null) {
            pp.setObject("InvoiceDateFrom", (Object)sdf.format(this.startTime.getValue()));
        } else {
            pp.setObject("InvoiceDateFrom", null);
        }
        if (this.endTime.getValue() != null) {
            pp.setObject("InvoiceDateTo", (Object)sdf.format(this.endTime.getValue()));
        } else {
            pp.setObject("InvoiceDateTo", null);
        }
        if (this.txtInvoiceNumber.getText() != null && !this.txtInvoiceNumber.getText().isEmpty()) {
            pp.setObject("InvoiceNumber", (Object)this.txtInvoiceNumber.getText());
        } else {
            pp.setObject("InvoiceNumber", null);
        }
        pp.setObject("chkFullElecSpecial", (Object)this.chkFullElecSpecial.isSelected());
        pp.setObject("chkFullElecCommon", (Object)this.chkFullElecCommon.isSelected());
        pp.setObject("chkNormal", (Object)this.chkNormal.isSelected());
        pp.setObject("chkOutOfControl", (Object)this.chkOutOfControl.isSelected());
        pp.setObject("chkCancel", (Object)this.chkCancel.isSelected());
        pp.setObject("chkAbnormal", (Object)this.chkAbnormal.isSelected());
        pp.setObject("chkRed", (Object)this.chkRed.isSelected());
        pp.setObject("chkPartRed", (Object)this.chkPartRed.isSelected());
        pp.setObject("chkFullRed", (Object)this.chkFullRed.isSelected());
        pp.setObject("chkRedConfirm", (Object)this.chkRedConfirm.isSelected());
        pp.setObject("chkUnCheck", (Object)this.chkUnCheck.isSelected());
        pp.setObject("chkCheck", (Object)this.chkCheck.isSelected());
        pp.setObject("chkConfirmed", (Object)this.chkConfirmed.isSelected());
        return pp;
    }

    public boolean verify() {
        if (this.companyIsNull()) {
            MsgBox.showInfo((String)this.getResource("companyNotNull"));
            return false;
        }
        if (this.startTime.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("startTimeNotNull"));
            return false;
        }
        if (this.endTime.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("endTimeNotNull"));
            return false;
        }
        return true;
    }

    public void setCustomCondition(RptParams params) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (params.getObject("Company") != null) {
            this.prmtCompany.setValue(params.getObject("Company"));
        } else {
            this.prmtCompany.setValue(null);
        }
        if (params.getObject("Supplier") != null) {
            this.prmtSupplier.setValue(params.getObject("Supplier"));
        } else {
            this.prmtSupplier.setValue(null);
        }
        try {
            if (params.getObject("InvoiceDateFrom") != null) {
                this.startTime.setValue((Object)sdf.parse(params.getObject("InvoiceDateFrom").toString()));
            } else {
                this.startTime.setValue(null);
            }
            if (params.getObject("InvoiceDateTo") != null) {
                this.endTime.setValue((Object)sdf.parse(params.getObject("InvoiceDateTo").toString()));
            } else {
                this.endTime.setValue(null);
            }
        }
        catch (ParseException e) {
            this.handUIException(e);
        }
        if (params.getObject("InvoiceNumber") != null) {
            this.txtInvoiceNumber.setText(params.getObject("InvoiceNumber").toString());
        } else {
            this.txtInvoiceNumber.setText(null);
        }
        this.chkFullElecSpecial.setSelected(params.getBoolean("chkFullElecSpecial"));
        this.chkFullElecCommon.setSelected(params.getBoolean("chkFullElecCommon"));
        this.chkNormal.setSelected(params.getBoolean("chkNormal"));
        this.chkOutOfControl.setSelected(params.getBoolean("chkOutOfControl"));
        this.chkCancel.setSelected(params.getBoolean("chkCancel"));
        this.chkAbnormal.setSelected(params.getBoolean("chkAbnormal"));
        this.chkRed.setSelected(params.getBoolean("chkRed"));
        this.chkPartRed.setSelected(params.getBoolean("chkPartRed"));
        this.chkFullRed.setSelected(params.getBoolean("chkFullRed"));
        this.chkRedConfirm.setSelected(params.getBoolean("chkRedConfirm"));
        this.chkUnCheck.setSelected(params.getBoolean("chkUnCheck"));
        this.chkCheck.setSelected(params.getBoolean("chkCheck"));
        this.chkConfirmed.setSelected(params.getBoolean("chkConfirmed"));
    }

    private List getCompanyIDs() {
        ArrayList<String> companyIDs = new ArrayList<String>();
        if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            CompanyOrgUnitInfo[] company = (CompanyOrgUnitInfo[])this.prmtCompany.getValue();
            for (int i = 0; i < company.length; ++i) {
                companyIDs.add(company[i].getId().toString());
            }
        } else if (this.prmtCompany.getValue() instanceof Object[]) {
            Object[] companys = (Object[])this.prmtCompany.getValue();
            for (int i = 0; i < companys.length; ++i) {
                if (!(companys[i] instanceof OrgUnitInfo)) continue;
                companyIDs.add(((OrgUnitInfo)companys[i]).getId().toString());
            }
        } else if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
            companyIDs.add(((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString());
        }
        return companyIDs;
    }

    private String getInvoiceType() {
        String invoiceTypes = EMPTYSTR;
        if (this.chkFullElecSpecial.isSelected()) {
            invoiceTypes = invoiceTypes + "27";
        }
        if (this.chkFullElecCommon.isSelected()) {
            if (!StringUtils.isEmpty((String)invoiceTypes)) {
                invoiceTypes = invoiceTypes + ",";
            }
            invoiceTypes = invoiceTypes + "26";
        }
        return invoiceTypes;
    }

    private List<String> getSupplierTaxNo() {
        ArrayList<String> supplierTaxNo = new ArrayList<String>();
        if (this.prmtSupplier.getValue() == null) {
            supplierTaxNo.add(EMPTYSTR);
        } else if (this.prmtSupplier.getValue() instanceof SupplierInfo[]) {
            SupplierInfo[] supplier = (SupplierInfo[])this.prmtSupplier.getValue();
            for (int i = 0; i < supplier.length; ++i) {
                supplierTaxNo.add(supplier[i].getTaxRegisterNo());
            }
        } else if (this.prmtSupplier.getValue() instanceof Object[]) {
            Object[] supplier = (Object[])this.prmtSupplier.getValue();
            for (int i = 0; i < supplier.length; ++i) {
                supplierTaxNo.add(((SupplierInfo)supplier[i]).getTaxRegisterNo());
            }
        } else if (this.prmtSupplier.getValue() instanceof SupplierInfo) {
            supplierTaxNo.add(((SupplierInfo)this.prmtSupplier.getValue()).getTaxRegisterNo());
        }
        return supplierTaxNo;
    }

    private void setTxtResultMsg(String txtMsg) {
        this.txtResult.setText(this.txtResult.getText() + txtMsg + "\u3002 \n");
    }

    private void handleResultAndShowMsg(ArrayList<Map> resultList) {
        ArrayList downloadResultList = new ArrayList();
        ArrayList<String> errList = new ArrayList<String>();
        HashMap bizBillTypeMap = new HashMap();
        for (Map map : resultList) {
            if (map.get("resultList") != null) {
                downloadResultList.addAll((List)map.get("resultList"));
            }
            if (map.get("errorMsg") != null) {
                errList.addAll((List)map.get("errorMsg"));
            }
            if (map.get("bizBillTypeMap") == null) continue;
            Map tempMap = new HashMap();
            tempMap = (Map)map.get("bizBillTypeMap");
            bizBillTypeMap.putAll(tempMap);
        }
        HashMap<String, PoolDownloadResult> companyTotalMap = new HashMap<String, PoolDownloadResult>();
        PoolDownloadResult result = null;
        PoolDownloadResult curResult = null;
        for (int i = 0; i < downloadResultList.size(); ++i) {
            result = (PoolDownloadResult)downloadResultList.get(i);
            if (result == null) continue;
            if (companyTotalMap.containsKey(result.getCompany().getId().toString())) {
                curResult = (PoolDownloadResult)companyTotalMap.get(result.getCompany().getId().toString());
                curResult.merge(result);
                continue;
            }
            companyTotalMap.put(result.getCompany().getId().toString(), result);
        }
        String detailRes = IMUtils.getString("com.kingdee.eas.tm.common.invoicePool.FullElecInvoiceResource", "Msg_DownloadDetail", IMUtils.getLocale());
        MessageFormat format = new MessageFormat(detailRes);
        BigDecimal totalSuccessCount = BigDecimal.ZERO;
        StringBuffer detailMsg = new StringBuffer();
        for (String key : companyTotalMap.keySet()) {
            Map<String, BigDecimal> fullElecCommonMap;
            Map<String, BigDecimal> fullElecSpecialMap;
            result = (PoolDownloadResult)companyTotalMap.get(key);
            result.calculate();
            if (result.getErrMsgList().size() > 0) {
                errList.addAll(result.getErrMsgList());
            }
            if ((fullElecSpecialMap = result.getInvoiceTypeTotalMap().get("27")) == null) {
                fullElecSpecialMap = new HashMap<String, BigDecimal>();
            }
            if ((fullElecCommonMap = result.getInvoiceTypeTotalMap().get("26")) == null) {
                fullElecCommonMap = new HashMap<String, BigDecimal>();
            }
            totalSuccessCount = totalSuccessCount.add(IMUtils.isNullToZero(fullElecSpecialMap.get("billCount"))).add(IMUtils.isNullToZero(fullElecCommonMap.get("billCount")));
            if (detailMsg.length() > 0) {
                detailMsg.append("\n");
            }
            detailMsg.append(format.format(new Object[]{result.getCompany().getName(), IMUtils.isNullToZero(fullElecSpecialMap.get("billCount")), IMUtils.isNullToZero(fullElecSpecialMap.get("invoiceAmount")), IMUtils.isNullToZero(fullElecSpecialMap.get("totalTaxAmount")), IMUtils.isNullToZero(fullElecSpecialMap.get("billEntryCount")), IMUtils.isNullToZero(fullElecCommonMap.get("billCount")), IMUtils.isNullToZero(fullElecCommonMap.get("invoiceAmount")), IMUtils.isNullToZero(fullElecCommonMap.get("totalTaxAmount")), IMUtils.isNullToZero(fullElecCommonMap.get("billEntryCount"))}));
        }
        if (detailMsg.length() > 0) {
            detailMsg.append("\n");
        }
        String summaryMsg = this.getResource("DownloadMsg", new Object[]{totalSuccessCount});
        if (BigDecimal.ZERO.compareTo(totalSuccessCount) == 0) {
            if (errList.size() == 0) {
                TMMsgBox.showInfo((String)summaryMsg, (Map)TMMsgURLUtil.getMsgURL((String)"IMS"));
            } else {
                TMMsgBox.showError((String)IMUtils.buildErrorMsg(errList), (Map)TMMsgURLUtil.getMsgURL((String)"IMS"));
            }
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)summaryMsg, (String)detailMsg.toString(), (int)1);
        }
        if (errList.size() > 0) {
            this.setTxtResultMsg(IMUtils.buildErrorMsg(errList));
        }
        this.btnDownLoad.setEnabled(true);
        this.btnDownLoadDetail.setEnabled(true);
    }

    private boolean companyIsNull() {
        if (this.prmtCompany.getValue() == null) {
            return true;
        }
        if (this.prmtCompany.getValue() instanceof Object[]) {
            Object[] values;
            for (Object value : values = (Object[])this.prmtCompany.getValue()) {
                if (value == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String getResource(String key) {
        return IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", key, IMUtils.getLocale());
    }

    private String getResource(String key, Object[] params) {
        return IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", key, IMUtils.getLocale(), params);
    }

    public void clear() {
        this.setDefaultValue();
    }

    public void handUIException(Throwable exc) {
        if (TMMsgBox.handUIException((Component)((Object)this), (Throwable)exc, (String)"IMS")) {
            super.handUIException(exc);
        }
    }
}

