/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.tm.common.help.msgHelp.client.TMMsgBox;
import com.kingdee.eas.tm.common.help.msgHelp.client.util.TMMsgURLUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTipInfo;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipResourceUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipUtil;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingCollection;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.client.AbstractDownLoadIncomeInvoiceUI;
import com.kingdee.eas.tm.im.client.comp.IMSupplierCommonPromptDialog;
import com.kingdee.eas.tm.im.client.comp.IProgressMonitor;
import com.kingdee.eas.tm.im.client.comp.IRunnableWithProgress;
import com.kingdee.eas.tm.im.client.comp.ProgressDialog;
import com.kingdee.eas.tm.im.client.comp.ProgressDialogHelper;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.msg.result.IncomeInvoiceDownloadResult;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PoolPwyHelper;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.param.TaxNoSumResult;
import com.kingdee.eas.tm.im.util.IMPermissionUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class DownLoadIncomeInvoiceUI
extends AbstractDownLoadIncomeInvoiceUI {
    private static final Logger logger = CoreUIObject.getLogger(DownLoadIncomeInvoiceUI.class);
    private static final String EMPTYSTR = "";
    private static final int ZERO = 0;
    private static final String DISK = "Disk";
    private static final String WEB = "Web";
    private int invoicePercent = 0;
    private DataChangeListener prmtCompanyListener = null;
    private ItemListener specialListener = null;
    private ItemListener elecSpecialListener = null;
    protected ProgressDialog progressDialog = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setDefaultValue();
        this.initListeners();
        this.initSupplierF7();
        this.addCustomerToolTip();
    }

    protected void addCustomerToolTip() {
        TMToolTipUtil.setToolTipInfo((JComponent)this.contStartTime, (TMToolTipInfo)new TMToolTipInfo("contStartTime", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("DOWNLOADII_StartTime"), EMPTYSTR));
        TMToolTipUtil.setToolTipInfo((JComponent)this.contEndTime, (TMToolTipInfo)new TMToolTipInfo("contEndTime", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("DOWNLOADII_EndTime"), EMPTYSTR));
    }

    private void setDefaultValue() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        OrgUnitInfo[] orgUnits = null;
        OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        OrgUnitInfo defaultOrgUnit = null;
        try {
            orgUnits = IMPermissionUtil.getAuthOrgByPermItem(null, (IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, "im_incomeInvoice_download");
            if (orgUnits != null && orgUnits.length > 0) {
                for (int i = 0; i < orgUnits.length; ++i) {
                    companyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnits[i];
                    if (!companyOrgUnitInfo.getId().toString().equals(currentMainOrg.getId().toString())) continue;
                    defaultOrgUnit = currentMainOrg;
                }
                if (defaultOrgUnit == null) {
                    defaultOrgUnit = orgUnits[0];
                }
                this.prmtCompany.setValue((Object)defaultOrgUnit);
            }
        }
        catch (Exception e) {
            this.prmtCompany.setValue((Object)currentMainOrg);
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.handUIException(e);
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add("1111111111111111");
        if (orgUnits != null && orgUnits.length > 0) {
            for (int i = 0; i < orgUnits.length; ++i) {
                companyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnits[i];
                idSet.add(companyOrgUnitInfo.getId().toString());
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCompany.setEntityViewInfo(view);
        this.prmtSupplier.setValue(null);
        Date date = new Date();
        this.endTime.setValue((Object)new Timestamp(date.getTime()));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        this.startTime.setValue((Object)new Timestamp(calendar.getTimeInMillis()));
        this.txtInvoiceCode.setText(null);
        this.txtInvoiceNumber.setText(null);
        this.chkCommon.setSelected(false);
        this.chkSpecial.setSelected(true);
        this.chkElecSpecial.setSelected(true);
        this.chkElec.setSelected(false);
        this.chkNormal.setSelected(true);
        this.chkCredit.setSelected(false);
        this.chkCancel.setSelected(false);
        this.chkLosecontrol.setSelected(false);
        this.chkUnusual.setSelected(false);
        this.chkPartlyRed.setSelected(false);
        this.chkFullRed.setSelected(false);
        this.chkUnconfirmRed.setSelected(false);
        this.chkUnCheck.setSelected(true);
        this.chkCheck.setSelected(true);
        this.chkConfirmed.setSelected(true);
        this.txtInvoiceCode.requestFocus();
    }

    protected Set getOrgIds() {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add("111111111111111111111111111=");
        if (this.prmtCompany.getValue() != null) {
            Object[] obj = this.prmtCompany.getValue() instanceof Object[] ? (Object[])this.prmtCompany.getValue() : new Object[]{this.prmtCompany.getValue()};
            for (int i = 0; i < obj.length; ++i) {
                if (obj[i] == null) continue;
                idSet.add(((CompanyOrgUnitInfo)obj[i]).getId().toString());
            }
        }
        return idSet;
    }

    private void initListeners() {
        if (this.specialListener == null) {
            this.specialListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        if (!DownLoadIncomeInvoiceUI.this.chkSpecial.isSelected() && !DownLoadIncomeInvoiceUI.this.chkElecSpecial.isSelected()) {
                            DownLoadIncomeInvoiceUI.this.chkUnCheck.setEnabled(false);
                            DownLoadIncomeInvoiceUI.this.chkUnCheck.setSelected(false);
                            DownLoadIncomeInvoiceUI.this.chkCheck.setEnabled(false);
                            DownLoadIncomeInvoiceUI.this.chkCheck.setSelected(false);
                            DownLoadIncomeInvoiceUI.this.chkConfirmed.setEnabled(false);
                            DownLoadIncomeInvoiceUI.this.chkConfirmed.setSelected(false);
                        } else {
                            DownLoadIncomeInvoiceUI.this.chkUnCheck.setEnabled(true);
                            DownLoadIncomeInvoiceUI.this.chkUnCheck.setSelected(true);
                            DownLoadIncomeInvoiceUI.this.chkCheck.setEnabled(true);
                            DownLoadIncomeInvoiceUI.this.chkCheck.setSelected(true);
                            DownLoadIncomeInvoiceUI.this.chkConfirmed.setEnabled(true);
                            DownLoadIncomeInvoiceUI.this.chkConfirmed.setSelected(true);
                        }
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                        DownLoadIncomeInvoiceUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.chkSpecial.addItemListener(this.specialListener);
        if (this.elecSpecialListener == null) {
            this.elecSpecialListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        if (!DownLoadIncomeInvoiceUI.this.chkSpecial.isSelected() && !DownLoadIncomeInvoiceUI.this.chkElecSpecial.isSelected()) {
                            DownLoadIncomeInvoiceUI.this.chkUnCheck.setEnabled(false);
                            DownLoadIncomeInvoiceUI.this.chkUnCheck.setSelected(false);
                            DownLoadIncomeInvoiceUI.this.chkCheck.setEnabled(false);
                            DownLoadIncomeInvoiceUI.this.chkCheck.setSelected(false);
                            DownLoadIncomeInvoiceUI.this.chkConfirmed.setEnabled(false);
                            DownLoadIncomeInvoiceUI.this.chkConfirmed.setSelected(false);
                        } else {
                            DownLoadIncomeInvoiceUI.this.chkUnCheck.setEnabled(true);
                            DownLoadIncomeInvoiceUI.this.chkUnCheck.setSelected(true);
                            DownLoadIncomeInvoiceUI.this.chkCheck.setEnabled(true);
                            DownLoadIncomeInvoiceUI.this.chkCheck.setSelected(true);
                            DownLoadIncomeInvoiceUI.this.chkConfirmed.setEnabled(true);
                            DownLoadIncomeInvoiceUI.this.chkConfirmed.setSelected(true);
                        }
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                        DownLoadIncomeInvoiceUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.chkElecSpecial.addItemListener(this.elecSpecialListener);
        if (this.prmtCompanyListener == null) {
            this.prmtCompanyListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    DownLoadIncomeInvoiceUI.this.initSupplierF7();
                }
            };
        }
        this.prmtCompany.addDataChangeListener(this.prmtCompanyListener);
    }

    private void initSupplierF7() {
        this.prmtSupplier.setValue(null);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Set ids = this.getOrgIds();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplierCompany.usingStatus", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("taxRegisterNo"));
        sic.add(new SelectorItemInfo("supplierCount"));
        view.setSelector(sic);
        this.prmtSupplier.setEntityViewInfo(view);
        IMSupplierCommonPromptDialog supplierF7Dialog = new IMSupplierCommonPromptDialog(ids);
        this.prmtSupplier.setSelector((KDPromptSelector)supplierF7Dialog);
    }

    @Override
    public void actionDownLoad_actionPerformed(ActionEvent e) throws Exception {
        this.txtResult.setText(EMPTYSTR);
        this.downloadCheck();
        this.doInProgressDialog(0);
    }

    @Override
    public void actionDownLoadDetail_actionPerformed(ActionEvent e) throws Exception {
        this.txtResult.setText(EMPTYSTR);
        this.downloadCheck();
        this.doInProgressDialog(1);
    }

    public void downloadCheck() {
        Date endDate;
        Date beginDate;
        if (this.startTime.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("startTimeNotNull"));
            SysUtil.abort();
        }
        if (this.endTime.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("endTimeNotNull"));
            SysUtil.abort();
        }
        if ((beginDate = (Date)this.startTime.getValue()).compareTo(endDate = (Date)this.endTime.getValue()) > 0) {
            MsgBox.showInfo((String)this.getResource("timeRangeError"));
            SysUtil.abort();
        }
        if (this.companyIsNull()) {
            MsgBox.showInfo((String)this.getResource("companyNotNull"));
            SysUtil.abort();
        }
        if (!(this.chkCommon.isSelected() || this.chkSpecial.isSelected() || this.chkElecSpecial.isSelected() || this.chkElec.isSelected())) {
            MsgBox.showInfo((String)this.getResource("invoiceTypeError"));
            SysUtil.abort();
        }
        if (!(this.chkNormal.isSelected() || this.chkLosecontrol.isSelected() || this.chkCancel.isSelected() || this.chkCredit.isSelected() || this.chkUnusual.isSelected() || this.chkPartlyRed.isSelected() || this.chkFullRed.isSelected() || this.chkUnconfirmRed.isSelected())) {
            MsgBox.showInfo((String)this.getResource("invoiceStatusError"));
            SysUtil.abort();
        }
        if (!(this.chkUnCheck.isSelected() || this.chkCheck.isSelected() || this.chkConfirmed.isSelected() || !this.chkSpecial.isSelected() && !this.chkElecSpecial.isSelected())) {
            MsgBox.showInfo((String)this.getResource("CCStatusError"));
            SysUtil.abort();
        }
        String invoiceCode = this.txtInvoiceCode.getText();
        String invoiceNo = this.txtInvoiceNumber.getText();
        if (StringUtils.isEmpty((String)invoiceCode) && !StringUtils.isEmpty((String)invoiceNo)) {
            MsgBox.showInfo((String)this.getResource("InvoiceCodeError"));
            SysUtil.abort();
        } else if (StringUtils.isEmpty((String)invoiceNo) && !StringUtils.isEmpty((String)invoiceCode)) {
            MsgBox.showInfo((String)this.getResource("InvoiceNoError"));
            SysUtil.abort();
        }
    }

    private boolean companyIsNull() {
        if (this.prmtCompany.getValue() == null) {
            return true;
        }
        if (this.prmtCompany.getValue() instanceof Object[]) {
            Object[] values;
            for (Object value : values = (Object[])this.prmtCompany.getValue()) {
                if (value == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void doInProgressDialog(int type) {
        if (this.progressDialog == null) {
            this.progressDialog = ProgressDialogHelper.createProgressDialog((CoreUI)this.getParent().getParent().getParent(), true);
        }
        this.progressDialog.run(false, true, this.getRunnableWithProgress(type));
    }

    private IRunnableWithProgress getRunnableWithProgress(final int type) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(IProgressMonitor monitor) {
                try {
                    String action = EASResource.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"LoadingInvoice");
                    monitor.beginTask(EASResource.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"LoadingInvoice", (Object[])new Object[0]), -1);
                    monitor.nextStep(EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Msg_ProgressSend"));
                    ArrayList<Map> resultList = new ArrayList<Map>();
                    if (0 == type) {
                        Map webMap = DownLoadIncomeInvoiceUI.this.downloadInvoice(DownLoadIncomeInvoiceUI.WEB);
                        resultList.add(webMap);
                        Map diskMap = DownLoadIncomeInvoiceUI.this.downloadInvoice(DownLoadIncomeInvoiceUI.DISK);
                        resultList.add(diskMap);
                    } else {
                        Map webMap = DownLoadIncomeInvoiceUI.this.downloadInvoice(DownLoadIncomeInvoiceUI.WEB);
                        resultList.add(webMap);
                    }
                    DownLoadIncomeInvoiceUI.this.handleResultAndShowMsg(resultList);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    DownLoadIncomeInvoiceUI.this.handUIException(e);
                }
                finally {
                    DownLoadIncomeInvoiceUI.this.btnDownLoad.setEnabled(true);
                    DownLoadIncomeInvoiceUI.this.btnDownLoadDetail.setEnabled(true);
                    monitor.done();
                }
            }
        };
    }

    private Map downloadInvoice(String type) throws BOSException, EASBizException {
        this.btnDownLoad.setEnabled(false);
        this.btnDownLoadDetail.setEnabled(false);
        HashMap<String, Cloneable> ret = new HashMap<String, Cloneable>();
        List paramList = this.buildPwyParam(type);
        if (paramList.isEmpty()) {
            return ret;
        }
        HashMap<String, List> params = new HashMap<String, List>();
        params.put("paramList", paramList);
        List list = PwyServiceFacadeFactory.getRemoteInstance().buildPwyParam(paramList);
        this.setTxtResultMsg("\u6b63\u5728\u53d1\u8d77\u8bf7\u6c42\u3002");
        HashMap bizBillTypeMap = new HashMap();
        Set<Object> keySet = new HashSet();
        ArrayList resultList = new ArrayList();
        ArrayList<String> errorMsg = new ArrayList<String>();
        PwyInvokeParam invokeParam = null;
        Map invokeActionMap = null;
        String downloadType = EMPTYSTR;
        if (WEB.equals(type)) {
            downloadType = this.getResource("web_download");
        } else if (DISK.equals(type)) {
            downloadType = this.getResource("disk_download");
        }
        for (int i = 0; i < list.size(); ++i) {
            invokeParam = (PwyInvokeParam)list.get(i);
            if (invokeParam.isError()) {
                if (errorMsg.contains(downloadType + invokeParam.getExceptionMsg())) continue;
                errorMsg.add(downloadType + invokeParam.getExceptionMsg());
                continue;
            }
            IPwyService pwyService = PwyServiceHelper.getPwyService(null, invokeParam);
            pwyService.invoke();
            if (!pwyService.isSuccess()) {
                if (errorMsg.contains(downloadType + pwyService.getInvokeParam().getDescription())) continue;
                errorMsg.add(downloadType + pwyService.getInvokeParam().getDescription());
                continue;
            }
            invokeActionMap = pwyService.getInvokeParam().getInvokeActionMap();
            for (Object result : invokeActionMap.values()) {
                if (!(result instanceof IncomeInvoiceDownloadResult)) continue;
                resultList.add(result);
            }
            keySet = invokeActionMap.keySet();
            Iterator<Object> it = keySet.iterator();
            String keyString = EMPTYSTR;
            Object key = null;
            while (it.hasNext()) {
                key = it.next();
                if (!(key instanceof String) || !(keyString = (String)key).startsWith("BizBillType_")) continue;
                bizBillTypeMap.put(keyString, invokeActionMap.get(keyString));
            }
        }
        this.setTxtResultMsg("\u5904\u7406\u5b8c\u6210\u3002");
        ret.put("errorMsg", errorMsg);
        ret.put("resultList", resultList);
        ret.put("bizBillTypeMap", bizBillTypeMap);
        return ret;
    }

    private List buildPwyParam(String type) throws EASBizException, BOSException {
        Set companyIDs = this.getCompanyIDs();
        Set supplierTaxNo = this.getSupplierTaxNo();
        SimpleDateFormat slp = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = slp.format((Date)this.startTime.getValue());
        String endDate = slp.format((Date)this.endTime.getValue());
        String invoiceCode = this.txtInvoiceCode.getText();
        String invoiceNo = this.txtInvoiceNumber.getText();
        ArrayList<HashMap> bodyList = new ArrayList<HashMap>();
        PwyServiceType msgType = null;
        if (DISK.equals(type)) {
            boolean isNotNeedDisk = this.isNotNeedDisk(companyIDs);
            if (isNotNeedDisk) {
                this.setTxtResultMsg("\u8f6f\u8bc1\u4e66\u6a21\u5f0f\uff0c\u4e0d\u8fdb\u884c\u7a0e\u76d8\u4e0b\u8f7d\u3002");
                return bodyList;
            }
            if (!this.chkSpecial.isSelected() && !this.chkElecSpecial.isSelected()) {
                this.setTxtResultMsg("\u672a\u9009\u4e2d\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u6216\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968\uff0c\u4e0d\u8fdb\u884c\u7a0e\u76d8\u4e0b\u8f7d\u3002");
                return bodyList;
            }
            if (invoiceNo != null && !invoiceNo.trim().isEmpty()) {
                this.setTxtResultMsg("\u6839\u636e\u4ee3\u7801\u53f7\u7801\u4e0b\u8f7d\u53d1\u7968\uff0c\u7a0e\u76d8\u53c2\u6570\u7ec4\u88c5\u4e2d\u3002");
                this.addDiskDownloadSingleParams(invoiceCode, invoiceNo, startDate, endDate, bodyList);
                msgType = PwyServiceType.OPR_POOL_DISK_DOWNLOAD_SINGLE;
            } else {
                this.setTxtResultMsg("\u6839\u636e\u6761\u4ef6\u8303\u56f4\u4e0b\u8f7d\u53d1\u7968\uff0c\u7a0e\u76d8\u53c2\u6570\u7ec4\u88c5\u4e2d\u3002");
                this.addDiskDownloadParams(supplierTaxNo, startDate, endDate, bodyList);
                msgType = PwyServiceType.OPR_POOL_DISK_DOWNLOAD;
            }
        } else if (WEB.equals(type)) {
            if (invoiceNo != null && !invoiceNo.trim().isEmpty()) {
                this.setTxtResultMsg("\u6839\u636e\u4ee3\u7801\u53f7\u7801\u4e0b\u8f7d\u53d1\u7968\uff0c\u53d1\u7968\u4e91\u5b98\u7f51\u53c2\u6570\u7ec4\u88c5\u4e2d\u3002");
                this.addWebDownloadCodeNoParams(invoiceCode, invoiceNo, bodyList);
                msgType = PwyServiceType.OPR_POOL_WEB_DOWNLOAD_CODENO;
            } else {
                this.setTxtResultMsg("\u6839\u636e\u6761\u4ef6\u8303\u56f4\u4e0b\u8f7d\u53d1\u7968\uff0c\u53d1\u7968\u4e91\u5b98\u7f51\u53c2\u6570\u7ec4\u88c5\u4e2d\u3002");
                this.addWebDownloadParams(supplierTaxNo, startDate, endDate, bodyList);
                msgType = PwyServiceType.OPR_POOL_WEB_DOWNLOAD;
            }
        }
        ArrayList<PwyActionParam> paramList = new ArrayList<PwyActionParam>();
        PwyActionParam actionParam = null;
        Map resultMap = PwySettingFactory.getRemoteInstance().getTaxNoSumResult(companyIDs);
        for (String taxNo : resultMap.keySet()) {
            for (HashMap pwyData : bodyList) {
                CompanyOrgUnitInfo company;
                HashMap tempParam = new HashMap();
                HashMap<String, String> newPwyData = new HashMap<String, String>();
                newPwyData.putAll(pwyData);
                tempParam.put("sumRet", resultMap.get(taxNo));
                if (this.getInvoiceStatusValues().contains(",")) {
                    tempParam.put("status", this.getInvoiceStatusValues());
                }
                if (!StringUtils.isEmpty((String)(company = ((TaxNoSumResult)resultMap.get(taxNo)).getDefaultCompany()).getTaxNumber())) {
                    newPwyData.put("buyerTaxNo", company.getTaxNumber().trim());
                }
                tempParam.put("pwyData", newPwyData);
                actionParam = new PwyActionParam(msgType, TransSrcSystemEnum.easgui, company.getId().toString(), tempParam);
                paramList.add(actionParam);
            }
        }
        return paramList;
    }

    private boolean isNotNeedDisk(Set companyIDs) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("fpdkType"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("opType", (Object)"1"));
        ev.setFilter(filter);
        PwySettingCollection col = PwySettingFactory.getRemoteInstance().getPwySettingCollection(ev);
        boolean isNotNeedDisk = true;
        for (int i = 0; i < col.size(); ++i) {
            PwySettingInfo info = col.get(i);
            if (info.isFpdkType()) continue;
            isNotNeedDisk = false;
            break;
        }
        return isNotNeedDisk;
    }

    protected void addDiskDownloadSingleParams(String invoiceCode, String invoiceNo, String startDate, String endDate, List<HashMap> bodyList) {
        String[] codeArr = invoiceCode.trim().split("[;\uff1b]");
        String[] noArr = invoiceNo.trim().split("[;\uff1b]");
        int noLen = noArr.length;
        int codeLen = codeArr.length;
        for (int i = 0; i < noLen; ++i) {
            HashMap<String, String> diskDownloadSingleParams = new HashMap<String, String>();
            if (i < codeLen) {
                diskDownloadSingleParams.put("invoiceCode", codeArr[i]);
            } else {
                diskDownloadSingleParams.put("invoiceCode", EMPTYSTR);
            }
            diskDownloadSingleParams.put("invoiceNo", noArr[i]);
            diskDownloadSingleParams.put("startDate", startDate);
            diskDownloadSingleParams.put("endDate", endDate);
            bodyList.add(diskDownloadSingleParams);
        }
    }

    protected void addDiskDownloadParams(Set<String> supplierTaxNo, String startDate, String endDate, List<HashMap> bodyList) {
        HashMap<String, Object> searchOpt = new HashMap<String, Object>();
        searchOpt.put("startTime", startDate);
        searchOpt.put("endTime", endDate);
        searchOpt.put("authenticateFlags", this.getAuthenticateFlagsValues());
        if (!this.getPwyInvoiceStatusValues().contains(",")) {
            searchOpt.put("invoiceStatus", this.getPwyInvoiceStatusValues());
        }
        String invoiceTypes = EMPTYSTR;
        if (this.chkSpecial.isSelected()) {
            invoiceTypes = invoiceTypes + "4";
        }
        if (this.chkElecSpecial.isSelected()) {
            if (!StringUtils.isEmpty((String)invoiceTypes)) {
                invoiceTypes = invoiceTypes + ",";
            }
            invoiceTypes = invoiceTypes + "2";
        }
        searchOpt.put("invoiceType", invoiceTypes);
        if (supplierTaxNo.isEmpty()) {
            searchOpt.put("salerTaxNo", EMPTYSTR);
            List diskDownloadParams = PoolPwyHelper.getDiskDownloadParams(searchOpt, EMPTYSTR, 0, EMPTYSTR);
            bodyList.addAll(diskDownloadParams);
        } else {
            for (String taxNo : supplierTaxNo) {
                searchOpt.put("salerTaxNo", taxNo);
                List diskDownloadParams = PoolPwyHelper.getDiskDownloadParams(searchOpt, EMPTYSTR, 0, EMPTYSTR);
                bodyList.addAll(diskDownloadParams);
            }
        }
    }

    protected void addWebDownloadCodeNoParams(String invoiceCode, String invoiceNo, List<HashMap> bodyList) {
        String[] codeArr = invoiceCode.trim().split("[;\uff1b]");
        String[] noArr = invoiceNo.trim().split("[;\uff1b]");
        int noLen = noArr.length;
        int codeLen = codeArr.length;
        for (int i = 0; i < noLen; ++i) {
            HashMap<String, String> webDownloadCodeNoParams = new HashMap<String, String>();
            if (i < codeLen) {
                webDownloadCodeNoParams.put("invoiceCode", codeArr[i]);
            } else {
                webDownloadCodeNoParams.put("invoiceCode", EMPTYSTR);
            }
            webDownloadCodeNoParams.put("invoiceNo", noArr[i]);
            bodyList.add(webDownloadCodeNoParams);
        }
    }

    protected void addWebDownloadParams(Set<String> supplierTaxNo, String startDate, String endDate, List<HashMap> bodyList) {
        HashMap pwyData;
        Object pwyData2;
        String invoiceTypes = EMPTYSTR;
        if (this.chkSpecial.isSelected()) {
            invoiceTypes = invoiceTypes + "4";
        }
        if (this.chkElecSpecial.isSelected()) {
            if (!StringUtils.isEmpty((String)invoiceTypes)) {
                invoiceTypes = invoiceTypes + ",";
            }
            invoiceTypes = invoiceTypes + "2";
        }
        if (this.chkSpecial.isSelected() || this.chkElecSpecial.isSelected()) {
            if (supplierTaxNo.isEmpty()) {
                pwyData2 = this.getWebPwyData(startDate, endDate, invoiceTypes);
                ((HashMap)pwyData2).put("authenticateFlags", this.getAuthenticateFlagsValues());
                bodyList.add((HashMap)pwyData2);
            } else {
                for (String taxNo : supplierTaxNo) {
                    pwyData = this.getWebPwyData(startDate, endDate, invoiceTypes);
                    pwyData.put("authenticateFlags", this.getAuthenticateFlagsValues());
                    pwyData.put("salerTaxNo", taxNo);
                    bodyList.add(pwyData);
                }
            }
        }
        invoiceTypes = EMPTYSTR;
        if (this.chkCommon.isSelected()) {
            invoiceTypes = invoiceTypes + "3,5";
        }
        if (this.chkElec.isSelected()) {
            if (!StringUtils.isEmpty((String)invoiceTypes)) {
                invoiceTypes = invoiceTypes + ",";
            }
            invoiceTypes = invoiceTypes + "1";
        }
        if (!invoiceTypes.isEmpty()) {
            if (supplierTaxNo.isEmpty()) {
                pwyData2 = this.getWebPwyData(startDate, endDate, invoiceTypes);
                bodyList.add((HashMap)pwyData2);
            } else {
                for (String taxNo : supplierTaxNo) {
                    pwyData = this.getWebPwyData(startDate, endDate, invoiceTypes);
                    pwyData.put("salerTaxNo", taxNo);
                    bodyList.add(pwyData);
                }
            }
        }
    }

    protected HashMap getWebPwyData(String startDate, String endDate, String invoiceTypes) {
        HashMap<String, Object> pwyData = new HashMap<String, Object>();
        pwyData.put("startTime", startDate);
        pwyData.put("endTime", endDate);
        pwyData.put("invoiceTypes", invoiceTypes);
        if (!this.getPwyInvoiceStatusValues().contains(",")) {
            pwyData.put("invoiceStatus", this.getPwyInvoiceStatusValues());
        }
        pwyData.put("salerTaxNo", EMPTYSTR);
        pwyData.put("pageNo", 1);
        pwyData.put("pageSize", 300);
        return pwyData;
    }

    private Object getAuthenticateFlagsValues() {
        String authString = EMPTYSTR;
        if (this.chkUnCheck.isSelected()) {
            authString = authString + "0,";
        }
        if (this.chkCheck.isSelected()) {
            authString = authString + "1,";
        }
        if (this.chkConfirmed.isSelected()) {
            authString = authString + "2,3,";
        }
        if (EMPTYSTR.equals(authString)) {
            return null;
        }
        authString = authString.substring(0, authString.length() - 1);
        return authString;
    }

    private String getInvoiceStatusValues() {
        String invoiceStatusValueString = EMPTYSTR;
        if (this.chkNormal.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "0,";
        }
        if (this.chkCancel.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "1,";
        }
        if (this.chkUnusual.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "2,6,";
        }
        if (this.chkLosecontrol.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "3,";
        }
        if (this.chkCredit.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "4,";
        }
        if (this.chkUnconfirmRed.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "7,";
        }
        if (this.chkPartlyRed.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "8,";
        }
        if (this.chkFullRed.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "9,";
        }
        if (EMPTYSTR.equals(invoiceStatusValueString)) {
            return EMPTYSTR;
        }
        invoiceStatusValueString = invoiceStatusValueString.substring(0, invoiceStatusValueString.length() - 1);
        return invoiceStatusValueString;
    }

    private String getPwyInvoiceStatusValues() {
        String invoiceStatusValueString = EMPTYSTR;
        if (this.chkNormal.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "0,";
        }
        if (this.chkLosecontrol.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "1,";
        }
        if (this.chkCancel.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "2,";
        }
        if (this.chkCredit.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "3,";
        }
        if (this.chkUnusual.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "4,5,";
        }
        if (this.chkUnconfirmRed.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "6,";
        }
        if (this.chkPartlyRed.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "7,";
        }
        if (this.chkFullRed.isSelected()) {
            invoiceStatusValueString = invoiceStatusValueString + "8,";
        }
        if (EMPTYSTR.equals(invoiceStatusValueString)) {
            return EMPTYSTR;
        }
        invoiceStatusValueString = invoiceStatusValueString.substring(0, invoiceStatusValueString.length() - 1);
        return invoiceStatusValueString;
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        RptParams pp = new RptParams();
        if (this.prmtCompany.getValue() != null) {
            pp.setObject("Company", this.prmtCompany.getValue());
        } else {
            pp.setObject("Company", null);
        }
        if (this.prmtSupplier.getValue() != null) {
            pp.setObject("Supplier", this.prmtSupplier.getValue());
        } else {
            pp.setObject("Supplier", null);
        }
        if (this.startTime.getValue() != null) {
            pp.setObject("InvoiceDateFrom", (Object)sdf.format(this.startTime.getValue()));
        } else {
            pp.setObject("InvoiceDateFrom", null);
        }
        if (this.endTime.getValue() != null) {
            pp.setObject("InvoiceDateTo", (Object)sdf.format(this.endTime.getValue()));
        } else {
            pp.setObject("InvoiceDateTo", null);
        }
        if (this.txtInvoiceCode.getText() != null && !this.txtInvoiceCode.getText().isEmpty()) {
            pp.setObject("InvoiceCode", (Object)this.txtInvoiceCode.getText());
        } else {
            pp.setObject("InvoiceCode", null);
        }
        if (this.txtInvoiceNumber.getText() != null && !this.txtInvoiceNumber.getText().isEmpty()) {
            pp.setObject("InvoiceNumber", (Object)this.txtInvoiceNumber.getText());
        } else {
            pp.setObject("InvoiceNumber", null);
        }
        pp.setObject("chkCommon", (Object)this.chkCommon.isSelected());
        pp.setObject("chkSpecial", (Object)this.chkSpecial.isSelected());
        pp.setObject("chkElecSpecial", (Object)this.chkElecSpecial.isSelected());
        pp.setObject("chkElec", (Object)this.chkElec.isSelected());
        pp.setObject("chkNormal", (Object)this.chkNormal.isSelected());
        pp.setObject("chkLosecontrol", (Object)this.chkLosecontrol.isSelected());
        pp.setObject("chkCancel", (Object)this.chkCancel.isSelected());
        pp.setObject("chkCredit", (Object)this.chkCredit.isSelected());
        pp.setObject("chkUnusual", (Object)this.chkUnusual.isSelected());
        pp.setObject("chkPartlyRed", (Object)this.chkPartlyRed.isSelected());
        pp.setObject("chkFullRed", (Object)this.chkFullRed.isSelected());
        pp.setObject("chkUnconfirmRed", (Object)this.chkUnconfirmRed.isSelected());
        pp.setObject("chkUnCheck", (Object)this.chkUnCheck.isSelected());
        pp.setObject("chkCheck", (Object)this.chkCheck.isSelected());
        pp.setObject("chkConfirmed", (Object)this.chkConfirmed.isSelected());
        return pp;
    }

    public boolean verify() {
        if (this.companyIsNull()) {
            MsgBox.showInfo((String)this.getResource("companyNotNull"));
            return false;
        }
        if (this.startTime.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("startTimeNotNull"));
            return false;
        }
        if (this.endTime.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("endTimeNotNull"));
            return false;
        }
        return true;
    }

    public void setCustomCondition(RptParams params) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (params.getObject("Company") != null) {
            this.prmtCompany.setValue(params.getObject("Company"));
        } else {
            this.prmtCompany.setValue(null);
        }
        if (params.getObject("Supplier") != null) {
            this.prmtSupplier.setValue(params.getObject("Supplier"));
        } else {
            this.prmtSupplier.setValue(null);
        }
        try {
            if (params.getObject("InvoiceDateFrom") != null) {
                this.startTime.setValue((Object)sdf.parse(params.getObject("InvoiceDateFrom").toString()));
            } else {
                this.startTime.setValue(null);
            }
            if (params.getObject("InvoiceDateTo") != null) {
                this.endTime.setValue((Object)sdf.parse(params.getObject("InvoiceDateTo").toString()));
            } else {
                this.endTime.setValue(null);
            }
        }
        catch (ParseException e) {
            this.handUIException(e);
        }
        if (params.getObject("InvoiceCode") != null) {
            this.txtInvoiceCode.setText(params.getObject("InvoiceCode").toString());
        } else {
            this.txtInvoiceCode.setText(null);
        }
        if (params.getObject("InvoiceNumber") != null) {
            this.txtInvoiceNumber.setText(params.getObject("InvoiceNumber").toString());
        } else {
            this.txtInvoiceNumber.setText(null);
        }
        this.chkCommon.setSelected(params.getBoolean("chkCommon"));
        this.chkSpecial.setSelected(params.getBoolean("chkSpecial"));
        this.chkElecSpecial.setSelected(params.getBoolean("chkElecSpecial"));
        this.chkElec.setSelected(params.getBoolean("chkElec"));
        this.chkNormal.setSelected(params.getBoolean("chkNormal"));
        this.chkLosecontrol.setSelected(params.getBoolean("chkLosecontrol"));
        this.chkCancel.setSelected(params.getBoolean("chkCancel"));
        this.chkCredit.setSelected(params.getBoolean("chkCredit"));
        this.chkUnusual.setSelected(params.getBoolean("chkUnusual"));
        this.chkPartlyRed.setSelected(params.getBoolean("chkPartlyRed"));
        this.chkFullRed.setSelected(params.getBoolean("chkFullRed"));
        this.chkUnconfirmRed.setSelected(params.getBoolean("chkUnconfirmRed"));
        this.chkUnCheck.setSelected(params.getBoolean("chkUnCheck"));
        this.chkCheck.setSelected(params.getBoolean("chkCheck"));
        this.chkConfirmed.setSelected(params.getBoolean("chkConfirmed"));
    }

    private Set getCompanyIDs() {
        HashSet<String> companyIDs = new HashSet<String>();
        if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            CompanyOrgUnitInfo[] company = (CompanyOrgUnitInfo[])this.prmtCompany.getValue();
            for (int i = 0; i < company.length; ++i) {
                companyIDs.add(company[i].getId().toString());
            }
        } else if (this.prmtCompany.getValue() instanceof Object[]) {
            Object[] companys = (Object[])this.prmtCompany.getValue();
            for (int i = 0; i < companys.length; ++i) {
                if (!(companys[i] instanceof OrgUnitInfo)) continue;
                companyIDs.add(((OrgUnitInfo)companys[i]).getId().toString());
            }
        } else if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
            companyIDs.add(((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString());
        }
        return companyIDs;
    }

    private Set getSupplierTaxNo() {
        HashSet<String> supplierTaxNo = new HashSet<String>();
        if (this.prmtSupplier.getValue() == null) {
            supplierTaxNo.add(EMPTYSTR);
        } else if (this.prmtSupplier.getValue() instanceof SupplierInfo[]) {
            SupplierInfo[] supplier = (SupplierInfo[])this.prmtSupplier.getValue();
            for (int i = 0; i < supplier.length; ++i) {
                supplierTaxNo.add(supplier[i].getTaxRegisterNo());
            }
        } else if (this.prmtSupplier.getValue() instanceof Object[]) {
            Object[] supplier = (Object[])this.prmtSupplier.getValue();
            for (int i = 0; i < supplier.length; ++i) {
                supplierTaxNo.add(((SupplierInfo)supplier[i]).getTaxRegisterNo());
            }
        } else if (this.prmtSupplier.getValue() instanceof SupplierInfo) {
            supplierTaxNo.add(((SupplierInfo)this.prmtSupplier.getValue()).getTaxRegisterNo());
        }
        return supplierTaxNo;
    }

    private void setTxtResultMsg(String txtMsg) {
        this.txtResult.setText(this.txtResult.getText() + txtMsg + "\u3002 \n");
    }

    private void handleResultAndShowMsg(ArrayList<Map> resultList) {
        String str;
        String[] invoiceCodeNo;
        ArrayList downloadResultList = new ArrayList();
        ArrayList<String> errList = new ArrayList<String>();
        HashMap bizBillTypeMap = new HashMap();
        for (Map map : resultList) {
            if (map.get("resultList") != null) {
                downloadResultList.addAll((List)map.get("resultList"));
            }
            if (map.get("errorMsg") != null) {
                errList.addAll((List)map.get("errorMsg"));
            }
            if (map.get("bizBillTypeMap") == null) continue;
            Map tempMap = new HashMap();
            tempMap = (Map)map.get("bizBillTypeMap");
            bizBillTypeMap.putAll(tempMap);
        }
        HashMap<String, IncomeInvoiceDownloadResult> companyTotalMap = new HashMap<String, IncomeInvoiceDownloadResult>();
        IncomeInvoiceDownloadResult result = null;
        IncomeInvoiceDownloadResult curResult = null;
        for (int i = 0; i < downloadResultList.size(); ++i) {
            result = (IncomeInvoiceDownloadResult)downloadResultList.get(i);
            if (result == null) continue;
            if (companyTotalMap.containsKey(result.getCompany().getId().toString())) {
                curResult = (IncomeInvoiceDownloadResult)companyTotalMap.get(result.getCompany().getId().toString());
                curResult.merge(result);
                continue;
            }
            companyTotalMap.put(result.getCompany().getId().toString(), result);
        }
        String detailRes = this.getResource("Msg_DownloadDetail");
        MessageFormat format = new MessageFormat(detailRes);
        int totalSuccessCount = 0;
        StringBuffer detailMsg = new StringBuffer();
        for (String key : companyTotalMap.keySet()) {
            result = (IncomeInvoiceDownloadResult)companyTotalMap.get(key);
            result.calculate();
            if (result.getErrMsgList().size() > 0) {
                errList.addAll(result.getErrMsgList());
            }
            totalSuccessCount += result.getSpecialCount() + result.getElecSpecialCount() + result.getCommonCount() + result.getElecCount();
            if (detailMsg.length() > 0) {
                detailMsg.append("\r\n");
            }
            detailMsg.append(format.format(new Object[]{result.getCompany().getName()}));
            if (this.isSingleDownload()) {
                detailMsg.append(this.getResource("InvoiceTypeDetailDownLoadMsg", new Object[]{PayInvoiceTypeEnum.VALUEADDEDTAXINV.getAlias(IMUtils.getLocale()), result.getSpecialCount(), result.getSpecialAmount(), result.getSpecialTax(), result.getSpecialDetialCount()}));
                detailMsg.append(this.getResource("InvoiceTypeDetailDownLoadMsg", new Object[]{PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.getAlias(IMUtils.getLocale()), result.getElecSpecialCount(), result.getElecSpecialAmount(), result.getElecSpecialTax(), result.getElecSpecialDetialCount()}));
                detailMsg.append(this.getResource("InvoiceTypeDetailDownLoadMsg", new Object[]{PayInvoiceTypeEnum.COMMONINVOICE.getAlias(IMUtils.getLocale()), result.getCommonCount(), result.getCommonAmount(), result.getCommonTax(), result.getCommonDetialCount()}));
                detailMsg.append(this.getResource("InvoiceTypeDetailDownLoadMsg", new Object[]{PayInvoiceTypeEnum.ELECTRONICINVOICE.getAlias(IMUtils.getLocale()), result.getElecCount(), result.getElecAmount(), result.getElecTax(), result.getElecDetialCount()}));
                continue;
            }
            if (this.chkSpecial.isSelected()) {
                detailMsg.append(this.getResource("InvoiceTypeDetailDownLoadMsg", new Object[]{PayInvoiceTypeEnum.VALUEADDEDTAXINV.getAlias(IMUtils.getLocale()), result.getSpecialCount(), result.getSpecialAmount(), result.getSpecialTax(), result.getSpecialDetialCount()}));
            }
            if (this.chkElecSpecial.isSelected()) {
                detailMsg.append(this.getResource("InvoiceTypeDetailDownLoadMsg", new Object[]{PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.getAlias(IMUtils.getLocale()), result.getElecSpecialCount(), result.getElecSpecialAmount(), result.getElecSpecialTax(), result.getElecSpecialDetialCount()}));
            }
            if (this.chkCommon.isSelected()) {
                detailMsg.append(this.getResource("InvoiceTypeDetailDownLoadMsg", new Object[]{PayInvoiceTypeEnum.COMMONINVOICE.getAlias(IMUtils.getLocale()), result.getCommonCount(), result.getCommonAmount(), result.getCommonTax(), result.getCommonDetialCount()}));
            }
            if (!this.chkElec.isSelected()) continue;
            detailMsg.append(this.getResource("InvoiceTypeDetailDownLoadMsg", new Object[]{PayInvoiceTypeEnum.ELECTRONICINVOICE.getAlias(IMUtils.getLocale()), result.getElecCount(), result.getElecAmount(), result.getElecTax(), result.getElecDetialCount()}));
        }
        if (detailMsg.length() > 0) {
            if (detailMsg.toString().endsWith("\n")) {
                detailMsg = new StringBuffer(detailMsg.toString().substring(0, detailMsg.length() - 1));
            }
            detailMsg.append("\r\n");
        }
        ArrayList<String> isMatchedBills = new ArrayList<String>();
        ArrayList<String> reimbursedBills = new ArrayList<String>();
        if (bizBillTypeMap.size() > 0) {
            String invoiceStatusChanged = this.getResource("invoiceStatusChanged", new Object[]{bizBillTypeMap.size()});
            Iterator it = bizBillTypeMap.keySet().iterator();
            String bosType = EMPTYSTR;
            String key = EMPTYSTR;
            while (it.hasNext()) {
                key = it.next().toString();
                bosType = (String)bizBillTypeMap.get(key);
                if ("48DA3A71".equals(bosType)) {
                    isMatchedBills.add(key);
                    continue;
                }
                if (!"4A44F49F".equals(bosType)) continue;
                reimbursedBills.add(key);
            }
        }
        if (isMatchedBills.size() > 0) {
            if (detailMsg.length() > 0) {
                detailMsg.append("\r\n");
            }
            detailMsg.append(this.getResource("invoiceStatusChanged_isMatched")).append("\r\n");
            detailMsg.append(this.getResource("InvoiceCodeOrNumber")).append("\r\n");
            invoiceCodeNo = null;
            str = EMPTYSTR;
            int j = isMatchedBills.size();
            for (int i = 0; i < j; ++i) {
                str = (String)isMatchedBills.get(i);
                invoiceCodeNo = str.split("_");
                if (invoiceCodeNo == null || invoiceCodeNo.length <= 2) continue;
                detailMsg.append(invoiceCodeNo[1] + "   " + invoiceCodeNo[2]).append("\r\n");
            }
        }
        if (reimbursedBills.size() > 0) {
            if (detailMsg.length() > 0) {
                detailMsg.append("\r\n");
            }
            detailMsg.append(this.getResource("invoiceStatusChanged_reimbursed")).append("\r\n");
            detailMsg.append(this.getResource("InvoiceCodeOrNumber")).append("\r\n");
            invoiceCodeNo = null;
            str = EMPTYSTR;
            int j = reimbursedBills.size();
            for (int i = 0; i < j; ++i) {
                str = (String)reimbursedBills.get(i);
                invoiceCodeNo = str.split("_");
                if (invoiceCodeNo == null || invoiceCodeNo.length <= 2) continue;
                detailMsg.append(invoiceCodeNo[1] + "   " + invoiceCodeNo[2]).append("\r\n");
            }
        }
        String summaryMsg = this.getResource("DownloadMsg", new Object[]{totalSuccessCount});
        if (totalSuccessCount == 0) {
            if (errList.size() == 0) {
                TMMsgBox.showInfo((String)summaryMsg, (Map)TMMsgURLUtil.getMsgURL((String)"IMS"));
            } else {
                TMMsgBox.showError((String)IMUtils.buildErrorMsg(errList), (Map)TMMsgURLUtil.getMsgURL((String)"IMS"));
            }
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)summaryMsg, (String)detailMsg.toString(), (int)1);
        }
        if (errList.size() > 0) {
            this.setTxtResultMsg(IMUtils.buildErrorMsg(errList));
        }
        this.btnDownLoad.setEnabled(true);
        this.btnDownLoadDetail.setEnabled(true);
    }

    private boolean isSingleDownload() {
        String invoiceNo = this.txtInvoiceNumber.getText();
        return !StringUtils.isEmpty((String)invoiceNo);
    }

    private String getResource(String key) {
        return IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", key, IMUtils.getLocale());
    }

    private String getResource(String key, Object[] params) {
        return IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", key, IMUtils.getLocale(), params);
    }

    public void clear() {
        this.setDefaultValue();
    }

    public void handUIException(Throwable exc) {
        if (TMMsgBox.handUIException((Component)((Object)this), (Throwable)exc, (String)"IMS")) {
            super.handUIException(exc);
        }
    }
}

