/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.tm.common.help.msgHelp.client.TMMsgBox;
import com.kingdee.eas.tm.im.PwyHelper;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.client.AbstractDownLoadMakeInvoiceUI;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.msg.result.MakeInvoiceDownloadResult;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoiceBillQueryBaseService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DownLoadMakeInvoiceUI
extends AbstractDownLoadMakeInvoiceUI {
    private static final Logger logger = CoreUIObject.getLogger(DownLoadMakeInvoiceUI.class);
    private PwyHelper pwyHelper = new PwyHelper();
    private boolean isComplete = false;
    private boolean isOk = false;
    private String completeMsg = "";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() {
        Calendar cale = Calendar.getInstance();
        cale.add(2, 0);
        cale.set(5, 1);
        this.dpStartDate.setValue((Object)cale.getTime());
        cale = Calendar.getInstance();
        cale.add(2, 1);
        cale.set(5, 0);
        this.dpEndDate.setValue((Object)cale.getTime());
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)OrgType.Company));
        try {
            Set orgIds = PermissionFactory.getRemoteInstance().getAuthorizedOrgIds(this.getUserPk(), OrgType.Company, (IObjectPK)treePK, "im_makeInvoice_download");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtCompanyOrg.setEntityViewInfo(view);
            CompanyOrgUnitInfo companyInfo = IMUtils.getPermissionCompany("im_makeInvoice_download");
            this.prmtCompanyOrg.setData((Object)companyInfo);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        Object[] companyOrg = this.prmtCompanyOrg.getValue() instanceof CompanyOrgUnitInfo ? new Object[]{this.prmtCompanyOrg.getValue()} : (Object[])this.prmtCompanyOrg.getValue();
        if (companyOrg == null || companyOrg[0] == null) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "CompanyNotNULL", IMUtils.getLocale()));
            return;
        }
        Date start = (Date)this.dpStartDate.getValue();
        if (start == null) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "StartDateNotNULL", IMUtils.getLocale()));
            return;
        }
        Date end = (Date)this.dpEndDate.getValue();
        if (end == null) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "EndDateNotNULL", IMUtils.getLocale()));
            return;
        }
        ArrayList<String> errorList = new ArrayList<String>();
        StringBuffer detailMsg = new StringBuffer();
        ArrayList resultList = new ArrayList();
        ArrayList<PwyActionParam> paramList = new ArrayList<PwyActionParam>();
        PwyActionParam actionParam = null;
        String orgID = null;
        CompanyOrgUnitInfo company = null;
        Map params = null;
        for (int i = 0; i < companyOrg.length; ++i) {
            company = (CompanyOrgUnitInfo)companyOrg[i];
            orgID = company.getId().toString();
            params = this.buildParam(company);
            actionParam = new PwyActionParam();
            actionParam.setMsgType(PwyServiceType.OPR_WEB_DOWNLOAD_MAKEINV);
            actionParam.setOwnerSystem(TransSrcSystemEnum.easgui);
            actionParam.setOrgId(orgID);
            actionParam.setParams(params);
            if (!StringUtils.isEmpty((String)this.txtInvCode.getText()) || !StringUtils.isEmpty((String)this.txtInvNumber.getText())) {
                actionParam.setMsgType(PwyServiceType.OPR_WEB_DOWNLOAD_SINGLE_MAKEINV);
            }
            paramList.add(actionParam);
        }
        List list = PwyServiceFacadeFactory.getRemoteInstance().buildPwyParam(paramList);
        PwyInvokeParam invokeParam = null;
        for (int i = 0; i < list.size(); ++i) {
            invokeParam = (PwyInvokeParam)list.get(i);
            if (invokeParam.isError()) {
                errorList.add(invokeParam.getExceptionMsg());
                continue;
            }
            MakeInvoiceBillQueryBaseService pwyService = (MakeInvoiceBillQueryBaseService)PwyServiceHelper.getPwyService(null, invokeParam);
            pwyService.invoke();
            if (!pwyService.isSuccess()) {
                errorList.addAll(pwyService.getErrorList());
                continue;
            }
            resultList.addAll((Collection)pwyService.getInvokeActionMap().get("result"));
        }
        detailMsg.append(this.buildErrorMsg(errorList));
        int successCount = 0;
        if (resultList.size() > 0) {
            Map companyTotalMap = this.buildCompanyTotalMap(resultList);
            MakeInvoiceDownloadResult result = null;
            for (String companyID : companyTotalMap.keySet()) {
                result = (MakeInvoiceDownloadResult)companyTotalMap.get(companyID);
                String companyName = result.getCompany().getName();
                if (result.getSuccessCount() == 0) {
                    detailMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "NotDownloadInvoice", IMUtils.getLocale(), new Object[]{companyName}) + "\r\n");
                    continue;
                }
                successCount = result.getSuccessCount();
                detailMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "DownloadInvoice", IMUtils.getLocale(), new Object[]{companyName, successCount, result.getTaxAmt(), result.getPriceTax()}) + "\r\n");
            }
        }
        this.setComplete(true);
        this.setOk(true);
        if (errorList.size() > 0) {
            this.setComplete(false);
        } else if (successCount == 0) {
            this.setOk(false);
        }
        this.setCompleteMsg(detailMsg.toString());
        this.actionExitCurrent_actionPerformed(e);
    }

    private Map buildCompanyTotalMap(List list) {
        HashMap<String, MakeInvoiceDownloadResult> companyTotalMap = new HashMap<String, MakeInvoiceDownloadResult>();
        MakeInvoiceDownloadResult result = null;
        MakeInvoiceDownloadResult curResult = null;
        for (int i = 0; i < list.size(); ++i) {
            result = (MakeInvoiceDownloadResult)list.get(i);
            if (result == null) continue;
            if (companyTotalMap.containsKey(result.getCompany().getId().toString())) {
                curResult = (MakeInvoiceDownloadResult)companyTotalMap.get(result.getCompany().getId().toString());
                curResult.setSuccessCount(curResult.getSuccessCount() + result.getSuccessCount());
                curResult.setTaxAmt(curResult.getTaxAmt().add(result.getTaxAmt()));
                curResult.setPriceTax(curResult.getPriceTax().add(result.getPriceTax()));
                continue;
            }
            companyTotalMap.put(result.getCompany().getId().toString(), result);
        }
        return companyTotalMap;
    }

    private Map buildParam(CompanyOrgUnitInfo company) {
        String invoiceNo;
        String taxNo = company.getTaxNumber();
        if (!StringUtils.isEmpty((String)taxNo)) {
            taxNo = taxNo.trim();
        }
        SimpleDateFormat slp = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = (Date)this.dpStartDate.getValue();
        Date endDate = (Date)this.dpEndDate.getValue();
        String invoiceCode = this.txtInvCode.getText();
        if (invoiceCode != null) {
            invoiceCode = invoiceCode.trim();
        }
        if ((invoiceNo = this.txtInvNumber.getText()) != null) {
            invoiceNo = invoiceNo.trim();
        }
        String invoiceType = "1,2,3,4,5,26,27";
        if (this.cbxInvoiceType.getSelectedItem().equals(PayInvoiceTypeEnum.ELECTRONICINVOICE)) {
            invoiceType = "1";
        } else if (this.cbxInvoiceType.getSelectedItem().equals(PayInvoiceTypeEnum.VALUEADDEDTAXINV)) {
            invoiceType = "4";
        } else if (this.cbxInvoiceType.getSelectedItem().equals(PayInvoiceTypeEnum.COMMONINVOICE)) {
            invoiceType = "3,5";
        } else if (this.cbxInvoiceType.getSelectedItem().equals(PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE)) {
            invoiceType = "2";
        } else if (this.cbxInvoiceType.getSelectedItem().equals(PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE)) {
            invoiceType = "26";
        } else if (this.cbxInvoiceType.getSelectedItem().equals(PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE)) {
            invoiceType = "27";
        }
        HashMap<String, Object> accountData = new HashMap<String, Object>();
        accountData.put("taxNo", taxNo);
        accountData.put("startTime", slp.format(startDate));
        accountData.put("endTime", slp.format(endDate));
        accountData.put("invoiceType", invoiceType);
        accountData.put("invoiceCode", invoiceCode);
        accountData.put("invoiceNo", invoiceNo);
        accountData.put("pageNo", 1);
        accountData.put("pageSize", 50);
        return accountData;
    }

    private String buildErrorMsg(List errorList) {
        StringBuffer sb = new StringBuffer();
        int size = errorList.size();
        for (int i = 0; i < size; ++i) {
            sb.append(errorList.get(i)).append("\r\n");
        }
        return sb.toString();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }

    public String getCompleteMsg() {
        return this.completeMsg;
    }

    public void setCompleteMsg(String completeMsg) {
        this.completeMsg = completeMsg;
    }

    public boolean isOk() {
        return this.isOk;
    }

    public void setOk(boolean isOk) {
        this.isOk = isOk;
    }

    public void handUIException(Throwable exc) {
        if (TMMsgBox.handUIException((Component)((Object)this), (Throwable)exc, (String)"IMK")) {
            super.handUIException(exc);
        }
    }
}

