/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.common.help.msgHelp.client.TMMsgBox;
import com.kingdee.eas.tm.common.httpClient.HttpClientUtil;
import com.kingdee.eas.tm.im.OutputInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.client.AbstractDownLoadRedInvoiceUI;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.GoldTaxDiskInfoPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.util.IMPermissionUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class DownLoadRedInvoiceUI
extends AbstractDownLoadRedInvoiceUI {
    private static final Logger logger = CoreUIObject.getLogger(DownLoadRedInvoiceUI.class);
    private boolean isComplete = false;
    private boolean isOk = false;
    private String completeMsg = "";
    private int totalCount = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() {
        Calendar cale = Calendar.getInstance();
        cale.add(2, 0);
        cale.set(5, 1);
        this.startDate.setValue((Object)cale.getTime());
        cale = Calendar.getInstance();
        cale.add(2, 1);
        cale.set(5, 0);
        this.endDate.setValue((Object)cale.getTime());
        try {
            OrgUnitInfo[] orgUnits = IMPermissionUtil.getAuthOrgByPermItem(null, this.getUserPk(), OrgType.Company, "im_makeInvoice_downred");
            OrgUnitInfo orgInfo = null;
            HashSet<String> idset = new HashSet<String>();
            if (orgUnits != null && orgUnits.length > 0) {
                for (int i = 0; i < orgUnits.length; ++i) {
                    orgInfo = orgUnits[i];
                    if (orgInfo == null || !orgInfo.getBoolean("isBizUnit")) continue;
                    idset.add(orgInfo.getId().toString());
                }
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
            view.setFilter(filter);
            this.prmtCompany.setEntityViewInfo(view);
            CompanyOrgUnitInfo initCompany = null;
            initCompany = IMUtils.getPermissionCompany("im_makeInvoice_downred");
            if (initCompany != null) {
                this.prmtCompany.setValue((Object)initCompany);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        SimpleDateFormat slp = new SimpleDateFormat("yyyy-MM-dd");
        Object[] companyOrg = null;
        if (this.prmtCompany.getValue() != null) {
            companyOrg = this.prmtCompany.getValue() instanceof Object[] ? (Object[])this.prmtCompany.getValue() : new Object[]{this.prmtCompany.getValue()};
        }
        if (companyOrg == null || companyOrg[0] == null) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "CompanyNotNULL", IMUtils.getLocale()));
            return;
        }
        Date start = (Date)this.startDate.getValue();
        if (start == null) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "StartDateNotNULL", IMUtils.getLocale()));
            return;
        }
        Date end = (Date)this.endDate.getValue();
        if (end == null) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "EndDateNotNULL", IMUtils.getLocale()));
            return;
        }
        String buyTaxNum = this.buyerTaxNum.getText();
        String saleTaxNum = this.salerTaxNum.getText();
        String infoNum = this.redNumber.getText();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("beginDate", slp.format(start));
        param.put("endDate", slp.format(end));
        param.put("purchaserTaxNum", buyTaxNum);
        param.put("salesTaxNum", saleTaxNum);
        param.put("infoNum", infoNum);
        ArrayList redJson = new ArrayList();
        StringBuffer detailMsg = new StringBuffer();
        String openDiskFailure = IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "OpenDiskFailure", IMUtils.getLocale());
        HashMap<String, String> companyMap = new HashMap<String, String>();
        HashMap companyTotalMap = new HashMap();
        for (int i = 0; i < companyOrg.length; ++i) {
            CompanyOrgUnitInfo orgUnitInfo = (CompanyOrgUnitInfo)companyOrg[i];
            String orgID = orgUnitInfo.getId().toString();
            IObjectPK logPk = LogUtils.beginLog(null, "downRedNumber", BOSObjectType.create((String)"412A6F98"), (IObjectPK)new ObjectUuidPK(orgID), orgUnitInfo.getName(), "im_mkInvoice_downRedNumber", "");
            PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_REDINVOICE_QUERY, TransSrcSystemEnum.easgui, orgID, param);
            PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getRemoteInstance().invoke(actionParam);
            if ((invokeParam = PwyServiceHelper.invoke(null, invokeParam)).isSuccess()) {
                companyMap.put(orgUnitInfo.getId().toString(), orgUnitInfo.getName());
                companyTotalMap.put(orgUnitInfo.getId().toString(), invokeParam.getInvokeActionMap().get("successCount"));
                this.totalCount += ((Integer)invokeParam.getInvokeActionMap().get("successCount")).intValue();
                LogUtils.afterLog(null, logPk);
                continue;
            }
            detailMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "DownLoadRedFailure", IMUtils.getLocale(), new Object[]{orgUnitInfo.getName(), invokeParam.getDescription()})).append("\r\n");
        }
        for (Object key : companyMap.keySet()) {
            detailMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "DownLoadRedSuccess", IMUtils.getLocale(), new Object[]{companyMap.get(key), companyTotalMap.get(key)})).append("\r\n");
        }
        this.setTotalCount(this.totalCount);
        this.setComplete(true);
        this.setOk(true);
        this.setCompleteMsg(detailMsg.toString());
        this.actionExitCurrent_actionPerformed(e);
    }

    private String downRedInvoice(String companyOrgID, HashMap param) throws EASBizException, BOSException {
        Map retValue = OutputInvoiceFacadeFactory.getRemoteInstance().invoke(PwyServiceType.OPR_REDINVOICE_QUERY, companyOrgID, null, param);
        String accountData = retValue.get("accountData").toString();
        String accountUrl = retValue.get("accountUrl").toString();
        return HttpClientUtil.doPost((String)accountUrl, (String)accountData);
    }

    private HashMap getDeviceInfo(String companyOrgID) throws JSONException, EASBizException, BOSException {
        PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_PAPER_TAXCARD_BASE, TransSrcSystemEnum.easgui, companyOrgID, null);
        PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getRemoteInstance().invoke(actionParam);
        GoldTaxDiskInfoPwyService pwyService = (GoldTaxDiskInfoPwyService)PwyServiceHelper.getPwyService(null, invokeParam);
        pwyService.invoke();
        if (pwyService.isSuccess()) {
            JSONObject jsonObj = new JSONObject(pwyService.getInvokeParam().getRevMsg());
            String sjd = jsonObj.get("sjd").toString();
            JSONObject sjdJson = new JSONObject(sjd);
            String jsph = sjdJson.get("jsph").toString();
            String jspjh = sjdJson.get("jspjh").toString();
            String qynsrsbh = sjdJson.get("qynsrsbh").toString();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("jsph", jsph);
            map.put("jspjh", jspjh);
            map.put("qynsrsbh", qynsrsbh);
            return map;
        }
        return null;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }

    public String getCompleteMsg() {
        return this.completeMsg;
    }

    public void setCompleteMsg(String completeMsg) {
        this.completeMsg = completeMsg;
    }

    public boolean isOk() {
        return this.isOk;
    }

    public void setOk(boolean isOk) {
        this.isOk = isOk;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void handUIException(Throwable exc) {
        if (TMMsgBox.handUIException((CoreUI)this, (Throwable)exc, (String)"IMK", (String)"DownRedNum")) {
            super.handUIException(exc);
        }
    }
}

