/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.tm.common.invoicePool.TMFullElecInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.im.FilterCommonStatusEnum;
import com.kingdee.eas.tm.im.InvoiceCCStatusEnum;
import com.kingdee.eas.tm.im.client.AbstractFullElecInvoiceFilterUI;
import com.kingdee.eas.tm.im.client.IncomeInvoiceFilterUI;
import com.kingdee.eas.tm.im.client.util.IMClientUtils;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.apache.log4j.Logger;

public class FullElecInvoiceFilterUI
extends AbstractFullElecInvoiceFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(IncomeInvoiceFilterUI.class);
    private ItemListener invoiceTypeListener = null;
    private boolean isIgnorePermission = false;

    public FullElecInvoiceFilterUI() throws Exception {
        this.getElementsInfo();
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        RangeFilterElement bizDateElements = new RangeFilterElement("bizDate", (Component)this.bizDateFrom, (Component)this.bizDateTo);
        bizDateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)bizDateElements);
        elements.add((FilterElement)new SingleFilterElement("invoiceType", (Component)this.kDComboInvoiceType, (Object)FilterCommonStatusEnum.NULL));
        elements.add((FilterElement)new SingleFilterElement("invoiceStatus", (Component)this.kDComboStatus, (Object)FilterCommonStatusEnum.NULL));
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("company.id", (Component)this.prmtCompany);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, SCMClientUtils.getResource((String)"MAINBIZORGISNULL")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "company.id");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadStatus();
        this.loadInvoiceType();
        this.setAuthenticateStatusEnabled();
        IMClientUtils.initCompanyTreeF7(this.prmtCompany, (IUIObject)this, this.getViewPermission());
        this.setF7Filter();
        this.setDefaultValue();
        this.initListeners();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
    }

    protected void loadInvoiceType() {
        this.kDComboInvoiceType.removeAllItems();
        this.kDComboInvoiceType.addItem((Object)FilterCommonStatusEnum.NULL);
        this.kDComboInvoiceType.addItem((Object)TMInvoiceType.INVOICETYPE_FULL_ELEC_SPECIAL);
        this.kDComboInvoiceType.addItem((Object)TMInvoiceType.INVOICETYPE_FULL_ELEC_COMMON);
    }

    private void loadStatus() {
        this.kDComboStatus.removeAllItems();
        this.kDComboStatus.addItem((Object)FilterCommonStatusEnum.NULL);
        this.kDComboStatus.addItems(TMFullElecInvoiceStatus.getEnumList().toArray());
    }

    private void initListeners() {
        if (this.invoiceTypeListener == null) {
            this.invoiceTypeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FullElecInvoiceFilterUI.this.invoiceTypeChange(e);
                }
            };
        }
        this.kDComboInvoiceType.addItemListener(this.invoiceTypeListener);
    }

    private void invoiceTypeChange(ItemEvent e) {
        this.setAuthenticateStatusEnabled();
        this.kDComboAuthenticateStatus.setSelectedItem((Object)InvoiceCCStatusEnum.NULL);
    }

    private void setAuthenticateStatusEnabled() {
        this.kDComboAuthenticateStatus.setEditable(false);
        if (this.kDComboInvoiceType.getSelectedItem() != null && this.kDComboInvoiceType.getSelectedItem() == FilterCommonStatusEnum.NULL) {
            this.kDComboAuthenticateStatus.setEnabled(false);
            return;
        }
        TMInvoiceType invoiceTypeEnum = (TMInvoiceType)this.kDComboInvoiceType.getSelectedItem();
        if (TMInvoiceType.INVOICETYPE_FULL_ELEC_SPECIAL.equals((Object)invoiceTypeEnum)) {
            this.kDComboAuthenticateStatus.setEnabled(true);
        } else {
            this.kDComboAuthenticateStatus.setEnabled(false);
        }
    }

    private void setF7Filter() {
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected String getViewPermission() {
        if (this.isIgnorePermission) {
            return "";
        }
        return "im_fullElecInvoice_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "company.id";
    }

    protected void setDefaultValue() {
        this.kDComboStatus.setSelectedItem((Object)TMFullElecInvoiceStatus.NORMAL);
        SCMQueryFormat.formatStartTime((KDDatePicker)this.bizDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.bizDateTo);
        this.radioHead.setSelected(true);
        this.kDTextBillingCompany.setText(null);
        this.kDTextTaxNumber.setText(null);
        this.kDTextInvoiceNumber.setText(null);
    }

    public FilterInfo getFilterInfo() {
        InvoiceCCStatusEnum ccStatusEnum;
        FilterInfo filterInfo = super.getFilterInfo();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        if (StringUtils.isEmpty((String)filterInfo.getMaskString())) {
            filterInfo.setMaskString(" ( #0 ) ");
        }
        if (this.radioHead.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entry.seq", (Object)new Integer(1), CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND ( #" + (filterInfo.getFilterItems().size() - 1));
            filterInfo.getFilterItems().add(new FilterItemInfo("entry.seq", null, CompareType.IS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " OR   #" + (filterInfo.getFilterItems().size() - 1) + ") ");
        } else if (this.radioEntry.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entry.seq", (Object)new Integer(0), CompareType.NOTEQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND ( #" + (filterInfo.getFilterItems().size() - 1));
            filterInfo.getFilterItems().add(new FilterItemInfo("entry.seq", null, CompareType.IS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " OR   #" + (filterInfo.getFilterItems().size() - 1) + ") ");
        }
        if (!StringUtils.isEmpty((String)this.kDTextBillingCompany.getText())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("salerName", (Object)("%" + this.kDTextBillingCompany.getText() + "%"), CompareType.LIKE));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND   (#" + (filterInfo.getFilterItems().size() - 1) + ") ");
        }
        if (!StringUtils.isEmpty((String)this.kDTextTaxNumber.getText())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("salerTaxNo", (Object)("%" + this.kDTextTaxNumber.getText() + "%"), CompareType.LIKE));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND   (#" + (filterInfo.getFilterItems().size() - 1) + ") ");
        }
        if (!StringUtils.isEmpty((String)this.kDTextInvoiceNumber.getText())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)("%" + this.kDTextInvoiceNumber.getText() + "%"), CompareType.LIKE));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND   (#" + (filterInfo.getFilterItems().size() - 1) + ") ");
        }
        if (InvoiceCCStatusEnum.UNCHECK.equals((Object)(ccStatusEnum = (InvoiceCCStatusEnum)((Object)this.kDComboAuthenticateStatus.getSelectedItem())))) {
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAbs.checkState", (Object)"0", CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND ( #" + (filterInfo.getFilterItems().size() - 1));
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAbs.confirmState", (Object)"0", CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND   #" + (filterInfo.getFilterItems().size() - 1) + ") ");
        } else if (InvoiceCCStatusEnum.CHECK.equals((Object)ccStatusEnum)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAbs.checkState", (Object)"1", CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND ( #" + (filterInfo.getFilterItems().size() - 1));
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAbs.confirmState", (Object)"0", CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND   #" + (filterInfo.getFilterItems().size() - 1) + ") ");
        } else if (InvoiceCCStatusEnum.CONFIRMED.equals((Object)ccStatusEnum)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAbs.checkState", (Object)"1", CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND ( #" + (filterInfo.getFilterItems().size() - 1));
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAbs.confirmState", (Object)"1", CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND   #" + (filterInfo.getFilterItems().size() - 1) + ") ");
        }
        return filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        int intValue;
        super.loadData(entityViewInfo);
        FilterItemCollection filters = entityViewInfo.getFilter().getFilterItems();
        Object obj = IMUtils.getCompareValue(filters, "salerName", CompareType.LIKE);
        if (obj != null) {
            this.kDTextBillingCompany.setText(obj.toString().split("%")[1]);
        } else {
            this.kDTextBillingCompany.setText(null);
        }
        obj = IMUtils.getCompareValue(filters, "salerTaxNo", CompareType.LIKE);
        if (obj != null) {
            this.kDTextTaxNumber.setText(obj.toString().split("%")[1]);
        } else {
            this.kDTextTaxNumber.setText(null);
        }
        obj = IMUtils.getCompareValue(filters, "invoiceNo", CompareType.LIKE);
        if (obj != null) {
            this.kDTextInvoiceNumber.setText(obj.toString().split("%")[1]);
        } else {
            this.kDTextInvoiceNumber.setText(null);
        }
        obj = IMUtils.getCompareValue(filters, "entry.seq", CompareType.EQUALS);
        if (obj == null) {
            this.radioEntry.setSelected(true);
        } else if (obj instanceof Integer && (intValue = ((Integer)obj).intValue()) == 1) {
            this.radioHead.setSelected(true);
        }
        Object isCheck = IMUtils.getCompareValue(filters, "checkAbs.checkState", CompareType.EQUALS);
        Object isConfirm = IMUtils.getCompareValue(filters, "checkAbs.confirmState", CompareType.EQUALS);
        if (isCheck == null || isConfirm == null) {
            this.kDComboAuthenticateStatus.setSelectedItem((Object)InvoiceCCStatusEnum.NULL);
        } else if ("0".equals(isCheck) && "0".equals(isConfirm)) {
            this.kDComboAuthenticateStatus.setSelectedItem((Object)InvoiceCCStatusEnum.UNCHECK);
        } else if ("1".equals(isCheck) && "0".equals(isConfirm)) {
            this.kDComboAuthenticateStatus.setSelectedItem((Object)InvoiceCCStatusEnum.CHECK);
        } else if ("1".equals(isCheck) && "1".equals(isConfirm)) {
            this.kDComboAuthenticateStatus.setSelectedItem((Object)InvoiceCCStatusEnum.CONFIRMED);
        } else {
            this.kDComboAuthenticateStatus.setSelectedItem((Object)InvoiceCCStatusEnum.NULL);
        }
    }

    public void afterMainOrgChanged(String ids) {
        super.afterMainOrgChanged(ids);
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        sorter.add(new SorterItemInfo("entry.id"));
        return sorter;
    }

    public boolean isIgnorePermission() {
        return this.isIgnorePermission;
    }

    public void setIgnorePermission(boolean isIgnorePermission) {
        this.isIgnorePermission = isIgnorePermission;
    }
}

