/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.xml.impl.MapStateManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.QuickFilteringSupportManager;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.InvoiceTypeTabEnum;
import com.kingdee.eas.tm.common.invoicePool.TMSourceType;
import com.kingdee.eas.tm.im.IncomeInvoiceActionEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceActionTypeEnum;
import com.kingdee.eas.tm.im.client.AbstractFullElecInvoiceListUI;
import com.kingdee.eas.tm.im.client.FullElecInvoiceFilterUI;
import com.kingdee.eas.tm.im.client.IncomeInvoiceContainerUI;
import com.kingdee.eas.tm.im.client.comp.PwyInvoiceHelper;
import com.kingdee.eas.tm.im.common.IMCommonProcessor;
import com.kingdee.eas.tm.im.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.im.param.ActionParam;
import com.kingdee.eas.tm.im.param.InvoiceHelperParam;
import com.kingdee.eas.tm.im.util.ExplorerUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.rim.RIMUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class FullElecInvoiceListUI
extends AbstractFullElecInvoiceListUI {
    private static final Logger logger = CoreUIObject.getLogger(FullElecInvoiceListUI.class);
    public static final String TBL_COMPANYID = "company.id";
    private CommonQueryDialog commonQueryDialog = null;
    private FullElecInvoiceFilterUI filterUI = null;
    QuickFilteringSupportItems qsi = new QuickFilteringSupportItems(true, true);
    private PwyInvoiceHelper pwyInvoiceHelper = new PwyInvoiceHelper((CoreUI)this);
    private ItemListener cbInvoiceTypeTabChange = null;

    public FullElecInvoiceListUI() throws Exception {
        this.uiHelper = new ListUIHelper((ListUI)this);
    }

    @Override
    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        if (this.getUIContext().get("ExchangeFilter") == null) {
            return this.qsi;
        }
        return null;
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("ExchangeFilter") == null) {
            this.setDefaultQuickFilterInfo();
        }
        super.onLoad();
        this.initColumnTable();
        this.initControl();
        this.initListeners();
    }

    protected void initControl() {
        this.cbInvoiceTypeTab.setSelectedItem((Object)InvoiceTypeTabEnum.INVOICE_FULL_SPECOM);
        this.btnDelVoucher.setVisible(false);
        this.setContainerUI((IncomeInvoiceContainerUI)((Object)this.getUIContext().get("containerUI")));
        if (this.getContainerUI() == null) {
            this.kDLabelContainer1.setVisible(false);
            KDLayout.Constraints constraints = new KDLayout.Constraints(10, 10, 996, 581, 15);
            this.tblMain.putClientProperty((Object)"KDLayoutConstraints", (Object)constraints);
        }
    }

    private void initListeners() {
        if (this.cbInvoiceTypeTabChange == null) {
            this.cbInvoiceTypeTabChange = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        FullElecInvoiceListUI.this.cbInvoiceTypeTabChange_Change(e);
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                }
            };
            this.cbInvoiceTypeTab.addItemListener(this.cbInvoiceTypeTabChange);
        }
    }

    protected void cbInvoiceTypeTabChange_Change(ItemEvent e) throws Exception {
        if (1 != e.getStateChange()) {
            return;
        }
        if (this.getContainerUI() == null) {
            return;
        }
        this.getContainerUI().refreshListUI((InvoiceTypeTabEnum)this.cbInvoiceTypeTab.getSelectedItem());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAcceptInv.addAssistMenuItem((JMenuItem)IMUtils.cloneMenuItem(this.menuPwyAccept));
        this.btnAcceptInv.addAssistMenuItem((JMenuItem)IMUtils.cloneMenuItem(this.menuCancelAcceptInv));
        this.menuAcceptInv.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.btnVoucher.addAssistMenuItem((JMenuItem)IMUtils.cloneMenuItem(this.menuItemDelVoucher));
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        if (RIMUtil.isOpenRIM(null)) {
            RIMUtil.openRIMPage(this, "aws_invoice_query_main");
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "ComfirmDelete", IMUtils.getLocale());
        if (this.confirmDialog(cancelMsg)) {
            ActionParam params = new ActionParam();
            params.setAction(IncomeInvoiceActionEnum.DELINVOICE);
            params.setActiontype(IncomeInvoiceActionTypeEnum.SAME);
            this.dispatchAction(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "DeleteAction", IMUtils.getLocale()), params);
            this.refreshList();
        }
    }

    @Override
    public void actionDownLoadInvoice_actionPerformed(ActionEvent e) throws Exception {
        this.downloadInvoice(e);
    }

    @Override
    public void actionViewInvoice_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String invoiceId = this.getSelectedKeyValue();
        FullElectricInvoiceInfo invoiceBill = FullElectricInvoiceFactory.getRemoteInstance().getFullElectricInvoiceInfo((IObjectPK)new ObjectUuidPK(invoiceId));
        String viewInvoiceURL = invoiceBill.getPdfurl();
        if (TMSourceType.RIMPWYDOWNLOAD.equals((Object)invoiceBill.getSourceType())) {
            if (viewInvoiceURL == null) {
                viewInvoiceURL = invoiceBill.getDownloadUrl();
            }
            if (viewInvoiceURL == null) {
                viewInvoiceURL = invoiceBill.getSnapshotUrl();
            }
            viewInvoiceURL = RIMUtil.rimPageUrl(viewInvoiceURL, null);
        }
        if (StringUtils.isEmpty((String)viewInvoiceURL)) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "InvoiceURL_NotExist", IMUtils.getLocale()));
            SysUtil.abort();
        }
        ExplorerUtil.browse(viewInvoiceURL);
    }

    @Override
    public void actionClaimInvoice_actionPerformed(ActionEvent e) throws Exception {
        this.claimInvoice(e);
    }

    @Override
    public void actionAcceptInv_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ActionParam params = new ActionParam();
        params.setAction(IncomeInvoiceActionEnum.ACCEPTCHECKINVOICE);
        params.setActiontype(IncomeInvoiceActionTypeEnum.SAME);
        this.dispatchAction(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "AcceptAction", IMUtils.getLocale()), params);
        this.refreshList();
    }

    @Override
    public void actionCancelAcceptInv_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ActionParam params = new ActionParam();
        params.setAction(IncomeInvoiceActionEnum.ACCEPTCHECKINVOICE);
        params.setActiontype(IncomeInvoiceActionTypeEnum.REVERSE);
        this.dispatchAction(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "CancelAcceptAction", IMUtils.getLocale()), params);
        this.refreshList();
    }

    @Override
    public void actionPwyAccept_actionPerformed(ActionEvent e) throws Exception {
        InvoiceHelperParam helperParam = new InvoiceHelperParam();
        helperParam.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        helperParam.setNeedUpdate(true);
        helperParam.setOperation(InvoiceHelperParam.OPR_FULLELEC_ACCEPT);
        this.pwyInvoiceHelper.invoiceHelperAction(helperParam);
    }

    @Override
    public void actionUseing_actionPerformed(ActionEvent e) throws Exception {
        this.useing(e);
    }

    @Override
    public void actionSupplier_actionPerformed(ActionEvent e) throws Exception {
        this.setSupplier(e);
    }

    @Override
    public void actionSetProject_actionPerformed(ActionEvent e) throws Exception {
        this.setProject(e);
    }

    @Override
    public void actionDeduct_actionPerformed(ActionEvent e) throws Exception {
        this.deduct(e);
    }

    @Override
    public void actionTaxTransfer_actionPerformed(ActionEvent e) throws Exception {
        this.taxTransfer(e);
    }

    private boolean dispatchAction(String operName, ActionParam params) throws BOSException, EASBizException {
        return this.dispatchAction(operName, params, null, this.pwyInvoiceHelper);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (this.getUIContext().get("ExchangeFilter") != null) {
            viewInfo = (EntityViewInfo)this.getUIContext().get("ExchangeFilter");
            viewInfo.getSelector().clear();
            this.mainQuery = viewInfo;
        }
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        return exec;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected Map<String, BigDecimal> getSumMap4FootRow(List<String> fieldSumList) throws Exception {
        Map originalSumMap = super.getSumMap4FootRow(fieldSumList);
        this.reCalHeadColumns(new String[]{"CHECKABS.EFFECTIVETAXAMT"}, new String[]{"checkAbs.effectiveTaxAmt"}, originalSumMap);
        return originalSumMap;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FullElectricInvoiceFactory.getRemoteInstance();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    private void initColumnTable() {
        String[] amtfields = new String[]{"invoiceAmount", "totalTaxAmount", "checkAbs.effectiveTaxAmt", "totalAmount", "entry.taxAmount", "entry.detailAmount", "entry.amount", "deductTaxAmt", "unTransferTaxAmt", "transferTaxAmt"};
        for (int i = 0; i < amtfields.length; ++i) {
            this.tblMain.getColumn(amtfields[i]).getStyleAttributes().setNumberFormat("#,##0.00");
            this.tblMain.getColumn(amtfields[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        String[] pricefields = new String[]{"entry.unitPrice", "entry.num"};
        for (int i = 0; i < pricefields.length; ++i) {
            this.tblMain.getColumn(pricefields[i]).getStyleAttributes().setNumberFormat("#,##0.##########");
            this.tblMain.getColumn(pricefields[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        String[] taxRatefields = new String[]{"entry.taxRate"};
        for (int i = 0; i < taxRatefields.length; ++i) {
            this.tblMain.getColumn(taxRatefields[i]).getStyleAttributes().setNumberFormat("%{0.##########}f");
            this.tblMain.getColumn(taxRatefields[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "number", "company.number", "company.name", "createTime", "bizBillType.name", "bizBillNumber", "invoiceType", "invoiceNo", "invoiceDate", "invoiceAmount", "totalTaxAmount", "checkAbs.effectiveTaxAmt", "totalAmount", "invoiceStatus", "checkStatus", "currentAccountType", "currAcctSupplier.number", "currAcctSupplier.name", "isAccept", "acceptUser.number", "acceptUser.name", "acceptInvoiceDate", "salerName", "salerTaxNo", "buyerName", "buyerTaxNo", "drawer", "incomeType.name", "fiDeduct", "deductTaxAmt", "unTransferTaxAmt", "transferTaxAmt", "taxTransferItem.number", "taxTransferItem.name", "type", "originalInvoiceCode", "originalInvoiceNo", "invalidDate", "fiVouchered", "ownVoucherType.name", "ownVoucherNumber", "isBusiness", "voucherPeriod.number", "voucherType.name", "voucherNumber", "isPayment", "project.number", "project.name", "checkAbs.checkState", "checkAbs.checkTime", "checkUser.number", "checkUser.name", "checkAbs.checkWay", "checkAbs.checkPurpose", "taxPeriod.number", "checkAbs.confirmState", "checkAbs.confirmTime", "confirmUser.number", "confirmUser.name", "checkAbs.checkType", "remark", "sourceType", "downloadUrl", "batchNo", "bizBillType.webViewUrl", TBL_COMPANYID, "bizBillID", "isNonCompliant", "nonCompliantState", "nonCompliantExplain"};
        return columns;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"invoiceNo"};
        return locateNames;
    }

    @Override
    protected String getPropertyOfBizDate() {
        return "createTime";
    }

    @Override
    protected String getPropertyOfBizOrg(OrgType mainBizOrgType) {
        return TBL_COMPANYID;
    }

    @Override
    public QuickFilteringSupportManager createQuickFilteringSupportManager() throws Exception {
        if (this.isViewForIdList() || this.getQuickFilteringSupportManager() != null) {
            return this.getQuickFilteringSupportManager();
        }
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null && this.getBizType() != null) {
            qfsi.setBosType(this.getBizType().toString());
        }
        return new QuickFilteringSupportManager((ListUI)this, qfsi, (Component)this.tblMain);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            if (this.getUIContext().get("OwnerWindow") == null) {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            try {
                this.commonQueryDialog.setProcessor((IProcessor)new IMCommonProcessor((IUIObject)this));
                ISCMFilter filterUI = (ISCMFilter)this.getFilterUI();
                filterUI.setIsSupportMultiOrgs(true);
                this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
            }
            catch (Exception e) {
                logger.info((Object)e);
                this.handUIException(e);
                SysUtil.abort();
            }
            this.commonQueryDialog.setWidth(510);
            this.commonQueryDialog.setHeight(300);
        }
        return this.commonQueryDialog;
    }

    private CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new FullElecInvoiceFilterUI();
            if (Boolean.TRUE.equals(this.getUIContext().get("IGNORE_DATAPERMISSION_CHECK"))) {
                this.filterUI.setIgnorePermission(true);
            }
        }
        return this.filterUI;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        if (ev != null) {
            FilterInfo filter = ev.getFilter();
            if (filter == null) {
                return;
            }
            FilterItemCollection filterItems = filter.getFilterItems();
            FilterInfo filterNew = new FilterInfo();
            boolean hasDeduct = false;
            for (int i = 0; i < filterItems.size(); ++i) {
                FilterItemInfo filterItem = filterItems.get(i);
                if (filterItem.getStateManager() instanceof MapStateManager && "fiDeduct".equalsIgnoreCase((String)filterItem.getStateManager().getStateValue("propertyName")) && "EMPTY".equalsIgnoreCase((String)filterItem.getStateManager().getStateValue("compareValue"))) {
                    HashSet<String> deductSet = new HashSet<String>();
                    if (CompareType.IS.equals((Object)((CompareType)filterItem.getStateManager().getStateValue("compareType")))) {
                        hasDeduct = true;
                        filterItem = new FilterItemInfo("id", null, CompareType.ISNOT);
                    } else {
                        deductSet.add("1");
                        deductSet.add("2");
                        filterItem = new FilterItemInfo("fiDeduct", deductSet, CompareType.INCLUDE);
                    }
                }
                filterNew.getFilterItems().add(filterItem);
            }
            filterNew.setMaskString(filter.getMaskString());
            if (hasDeduct) {
                FilterInfo filterDeduct = new FilterInfo();
                filterDeduct.getFilterItems().add(new FilterItemInfo("fiDeduct", (Object)"0", CompareType.EQUALS));
                filterDeduct.getFilterItems().add(new FilterItemInfo("fiDeduct", null, CompareType.EQUALS));
                filterDeduct.setMaskString("(#0 OR #1)");
                try {
                    filterNew.mergeFilter(filterDeduct, "AND");
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            ev.clear();
            ev.setFilter(filterNew);
        }
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "fullElectricInvoice";
        param.datataskMode = 1;
        param.alias = IMUtils.getString("com.kingdee.eas.tm.common.invoicePool.FullElecInvoiceResource", "FullElectricInvoice", IMUtils.getLocale());
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        HashSet selectIds = new HashSet(this.getSelectedIdValues());
        try {
            if (selectIds.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.INCLUDE));
                filter.mergeFilter(this.mainQuery.getFilter(), "AND");
                hashtable.put("filter", filter);
            } else if (this.mainQuery != null) {
                hashtable.put("filter", this.mainQuery.getFilter());
            }
        }
        catch (Exception filter) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("serialNo");
        return sic;
    }
}

