/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.tm.common.help.msgHelp.client.TMMsgBox;
import com.kingdee.eas.tm.common.help.msgHelp.client.util.TMMsgURLUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTipInfo;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipResourceUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipUtil;
import com.kingdee.eas.tm.common.invoicePool.CheckTypeEnum;
import com.kingdee.eas.tm.im.AuthenticateTypeEnum;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IncomeAuthenticateStatusEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.InvResourceType;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.basedata.client.TreeTaxClassificationCodeF7PromptDialog;
import com.kingdee.eas.tm.im.client.AbstractIncomeInvoiceEditUI;
import com.kingdee.eas.tm.im.client.MySwingWork;
import com.kingdee.eas.tm.im.client.MyThreadPool;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.incomeinvoice.IncomeInvoiceCheckInvoicePwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.im.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.TCCUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class IncomeInvoiceEditUI
extends AbstractIncomeInvoiceEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(IncomeInvoiceEditUI.class);
    private static final String TB_PRODUCTNAME = "productName";
    private static final String TB_SPECS = "specs";
    private static final String TB_UNITNAME = "unitName";
    private static final String TB_QUANTITY = "quantity";
    private static final String TB_TAXEXCLUDED = "taxExcluded";
    private static final String TB_TAXPRICE = "taxPrice";
    private static final String TB_MONEY = "money";
    private static final String TB_TAXRATE = "taxRate";
    private static final String TB_TAXAMT = "taxAmt";
    private static final String TB_TAXTOTAL = "taxTotal";
    private static final String TB_TAXCLASSIFICATIONNUMBER = "taxClassificationNumber";
    private static final String TAXCLASSCODE_QUERY = "com.kingdee.eas.tm.im.app.TaxClassificationCodeQuery";
    private boolean isInTax = true;
    public static final Color FOOTROWCOLOR = new Color(252, 255, 206);
    private static final String NUMFORMAT = "###,##0.##########";
    private static int QTY_PRECISION = 9;
    private static final int AMT_PRECISION = 2;
    private static final int PRICE_PRECISION = 10;
    private static final String[] AMT_FIELD = new String[]{"money", "taxAmt", "taxTotal"};
    private static final String[] PRICE_FIELD = new String[]{"taxExcluded", "taxPrice"};
    private KDTEditAdapter entryTableChange = null;
    private DataChangeListener prmtCompanyListener = null;
    private ItemListener chkIsInTaxListener = null;
    private ItemListener comboInvoiceTypeChange = null;
    private EditUIHelper uiHelper = new EditUIHelper((EditUI)this);
    private int invoicePercent = 0;

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IncomeInvoiceFactory.getRemoteInstance();
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtCompany;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    protected IObjectValue createNewData() {
        IncomeInvoiceInfo info = new IncomeInvoiceInfo();
        CompanyOrgUnitInfo company = null;
        try {
            company = IMUtils.getPermissionCompany("im_incomeInvoice_new");
            if (company == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"NewIncomeInvWithoutPerm"));
                SysUtil.abort();
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        try {
            info.setCurrentAccountType(CurrentAccountType.SUPPLIER);
            info.setInvoiceType(PayInvoiceTypeEnum.VALUEADDEDTAXINV);
            info.setBizDate(new Date());
            info.setIsIssue(true);
            info.setCompany(company);
            info.getEntries().add((IncomeInvoiceEntryInfo)this.createNewDetailData(this.kdtEntries));
            info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            info.setResourceType(InvResourceType.INV_ADDNEW);
            info.setStatus(IncomeStatusEnum.NORMAL);
            info.setIsInTax(true);
            info.setIsIssue(false);
            info.setIsDeduct(null);
            info.setReBusiness(false);
            info.setBizBillType(null);
            info.setAuthenticateStatus(IncomeAuthenticateStatusEnum.UNAUTHORIZED);
            info.setIsNonCompliant(false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        IncomeInvoiceEntryInfo entryInfo = new IncomeInvoiceEntryInfo();
        entryInfo.setMoney(BigDecimal.ZERO.setScale(2));
        entryInfo.setTaxAmt(BigDecimal.ZERO.setScale(2));
        entryInfo.setTaxTotal(BigDecimal.ZERO.setScale(2));
        return entryInfo;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPrint.setEnabled(false);
        this.btnPrintPreview.setEnabled(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.menuItemPrint.setEnabled(false);
        this.menuItemPrintPreview.setEnabled(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
    }

    private void initDataButton() {
        if (this.editData.getResourceType().equals((Object)InvResourceType.INV_DOWNLOAD)) {
            this.txtInvoiceCode.setEditable(false);
            this.txtInvoiceNumber.setEditable(false);
            this.pkBizDate.setEditable(false);
            this.prmtCompany.setEditable(false);
            this.prmtProject.setEditable(true);
            this.comboCurrentAccountType.setEditable(false);
            this.prmtCurrAcctSupplier.setEditable(true);
            this.txtBillingCompany.setEditable(false);
            this.txtTaxNumber.setEditable(false);
            this.txtContact.setEditable(false);
            this.txtBankInformation.setEditable(false);
            this.txtPassword.setEditable(false);
            this.chkIsIssue.setEditable(false);
            this.chkIsInTax.setEditable(false);
            this.txtDescription.setEditable(false);
            this.prmtCreator.setEditable(false);
            this.prmtConfirmUser.setEditable(false);
        } else {
            this.txtInvoiceCode.setEditable(true);
            this.txtInvoiceNumber.setEditable(true);
            this.pkBizDate.setEditable(true);
            this.prmtCompany.setEditable(true);
            this.prmtProject.setEditable(true);
            this.comboCurrentAccountType.setEditable(false);
            this.prmtCurrAcctSupplier.setEditable(true);
            this.txtBillingCompany.setEditable(true);
            this.txtTaxNumber.setEditable(true);
            this.txtContact.setEditable(true);
            this.txtBankInformation.setEditable(true);
            this.txtPassword.setEditable(true);
            this.chkIsIssue.setEditable(true);
            this.chkIsInTax.setEditable(true);
            this.txtDescription.setEditable(true);
            this.prmtCreator.setEditable(false);
            this.prmtConfirmUser.setEditable(false);
        }
    }

    private void initTCCF7() {
        KDBizPromptBox taxClassCode = new KDBizPromptBox();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true, CompareType.EQUALS));
        view.setFilter(tmpFilter);
        taxClassCode.setEntityViewInfo(view);
        taxClassCode.setQueryInfo(TAXCLASSCODE_QUERY);
        taxClassCode.setEditFormat("$mergeCode$");
        taxClassCode.setDisplayFormat("$mergeCode$");
        taxClassCode.setCommitFormat("$mergeCode$");
        taxClassCode.setEditable(true);
        taxClassCode.setSelectorCollection(TCCUtil.getTCCSelector());
        taxClassCode.setSelector((KDPromptSelector)new TreeTaxClassificationCodeF7PromptDialog((IUIObject)this));
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)taxClassCode);
        this.kdtEntries.getColumn(TB_TAXCLASSIFICATIONNUMBER).setEditor((ICellEditor)itemEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$mergeCode$"));
        this.kdtEntries.getColumn(TB_TAXCLASSIFICATIONNUMBER).setRenderer((IBasicRender)avr);
    }

    private IRow getCurRow() {
        KDTSelectBlock selected = this.kdtEntries.getSelectManager().get();
        int selectedRow = selected.getBeginRow();
        return this.kdtEntries.getRow(selectedRow);
    }

    private void tccDataChanged(KDTEditEvent e) {
        IRow curRow = this.getCurRow();
        if (e.getValue() == e.getOldValue()) {
            return;
        }
        if (e.getValue() instanceof TaxClassificationCodeInfo) {
            TaxClassificationCodeInfo tccInfo = (TaxClassificationCodeInfo)e.getValue();
            curRow.getCell(TB_TAXCLASSIFICATIONNUMBER).setValue((Object)tccInfo.getMergeCode());
            curRow.getCell(TB_TAXRATE).setValue((Object)(tccInfo.getTaxRate() == null ? BigDecimal.ZERO : tccInfo.getTaxRate()));
            this.taxRateCalculate(curRow, (BigDecimal)curRow.getCell(TB_TAXRATE).getValue(), 2);
        } else {
            curRow.getCell(TB_TAXRATE).setValue(null);
            curRow.getCell(TB_TAXAMT).setValue((Object)new BigDecimal("0.00"));
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        KDFormattedTextField amt = new KDFormattedTextField();
        amt.setDataType(1);
        amt.setPrecision(2);
        amt.setSupportedEmpty(true);
        amt.setRemoveingZeroInDispaly(false);
        amt.setHorizontalAlignment(4);
        KDTDefaultCellEditor amtEditor = new KDTDefaultCellEditor((JTextField)amt);
        for (String field : AMT_FIELD) {
            this.kdtEntries.getColumn(field).setEditor((ICellEditor)amtEditor);
            this.kdtEntries.getColumn(field).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        }
        KDFormattedTextField rate = new KDFormattedTextField();
        rate.setDataType(1);
        rate.setPrecision(4);
        rate.setSupportedEmpty(true);
        rate.setNegatived(false);
        rate.setRemoveingZeroInDispaly(false);
        rate.setHorizontalAlignment(4);
        KDTDefaultCellEditor rateEditor = new KDTDefaultCellEditor((JTextField)rate);
        this.kdtEntries.getColumn(TB_TAXRATE).setEditor((ICellEditor)rateEditor);
        this.kdtEntries.getColumn(TB_TAXRATE).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)4));
        KDFormattedTextField qty = new KDFormattedTextField();
        qty.setDataType(1);
        qty.setPrecision(QTY_PRECISION);
        qty.setSupportedEmpty(true);
        qty.setRemoveingZeroInDispaly(false);
        qty.setHorizontalAlignment(4);
        KDTDefaultCellEditor qtyEditor = new KDTDefaultCellEditor((JTextField)qty);
        this.kdtEntries.getColumn(TB_QUANTITY).setEditor((ICellEditor)qtyEditor);
        this.kdtEntries.getColumn(TB_QUANTITY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)QTY_PRECISION));
        this.initPriceField();
        this.initButtonVisible();
        this.initTCCF7();
        this.initBtnStatus();
        this.comboInvoiceType.removeItem((Object)PayInvoiceTypeEnum.DEFAULTTYPE);
        this.comboInvoiceType.removeItem((Object)PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE);
        this.comboInvoiceType.removeItem((Object)PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE);
        if (this.getDetailTable() != null) {
            this.getDetailTable().getActionMap().remove("AddRow");
            this.getDetailTable().getActionMap().remove("RemoveRow");
            this.getDetailTable().getActionMap().remove("Delete");
            this.getDetailTable().getActionMap().remove("Paste");
        }
        this.addCustomerToolTip();
    }

    protected void addCustomerToolTip() {
        TMToolTipUtil.setToolTipInfo((JComponent)this.contProject, (TMToolTipInfo)new TMToolTipInfo("contProject", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("INCOMEINVOICE_Project"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.contContact, (TMToolTipInfo)new TMToolTipInfo("contContact", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("INCOMEINVOICE_Contact"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.contBankInformation, (TMToolTipInfo)new TMToolTipInfo("contBankInformation", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("INCOMEINVOICE_BankInformation"), ""));
    }

    private void initButtonVisible() {
        this.btnSubmit.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnAuditResult.setVisible(false);
    }

    private void initTableEditable() {
        this.isInTax = this.chkIsInTax.isSelected();
        if (this.isInTax) {
            this.kdtEntries.getColumn(TB_TAXEXCLUDED).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_TAXPRICE).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_MONEY).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_TAXTOTAL).getStyleAttributes().setLocked(false);
        } else {
            this.kdtEntries.getColumn(TB_TAXEXCLUDED).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_TAXPRICE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MONEY).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_TAXTOTAL).getStyleAttributes().setLocked(true);
        }
    }

    private void initPriceField() {
        int priceDisplayPrecision = this.getPricePrecision();
        KDFormattedTextField price = new KDFormattedTextField();
        price.setDataType(1);
        price.setPrecision(priceDisplayPrecision);
        price.setSupportedEmpty(true);
        price.setRemoveingZeroInDispaly(false);
        price.setHorizontalAlignment(4);
        price.setNegatived(false);
        KDTDefaultCellEditor priceEditor = new KDTDefaultCellEditor((JTextField)price);
        for (String field : PRICE_FIELD) {
            this.kdtEntries.getColumn(field).setEditor((ICellEditor)priceEditor);
            this.kdtEntries.getColumn(field).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)priceDisplayPrecision));
        }
    }

    private int getPricePrecision() {
        try {
            Object obj = this.prmtCompany.getValue();
            if (obj != null && obj instanceof CompanyOrgUnitInfo) {
                String companyId = ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
                IParamControl ipctr = ParamControlFactory.getRemoteInstance();
                ObjectUuidPK com = new ObjectUuidPK(companyId);
                return new Integer(ipctr.getParamValue((IObjectPK)com, "VATM001"));
            }
        }
        catch (Exception e) {
            logger.error((Object)(" get VATM001 failed. Company is " + ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString()));
            return 10;
        }
        return 10;
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initCompanyF7();
        this.initSupplierF7(null);
        this.initListeners();
        this.initDataButton();
        this.initComponents();
        this.initBtnStatus();
        this.appendFootRow(this.kdtEntries);
    }

    private void initBtnStatus() {
        this.updateButtonStatus();
        if (this.editData == null || this.getOprtState() == null || this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionCopy.setEnabled(false);
        } else {
            this.actionCopy.setEnabled(true);
        }
        AbstractAction actionTable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IncomeInvoiceEditUI.this.getDetailTable() != null) {
                    IncomeInvoiceEditUI.this.getDetailTable().removeRow(IncomeInvoiceEditUI.this.getDetailTable().getRowCount() - 1);
                    IncomeInvoiceEditUI.this.addLine(IncomeInvoiceEditUI.this.getDetailTable());
                }
            }
        };
        boolean tableKeyEnabled = this.isCanEditable();
        this.uiHelper.initTableKeyStroke(this.getDetailTable(), tableKeyEnabled, actionTable);
        this.actionAddLine.setEnabled(tableKeyEnabled);
        this.actionCopyLine.setEnabled(tableKeyEnabled);
        this.actionRemoveLine.setEnabled(tableKeyEnabled);
        this.actionInsertLine.setEnabled(tableKeyEnabled);
    }

    private void initComponents() {
        if (this.editData == null) {
            return;
        }
        this.initTableEditable();
        if (InvResourceType.INV_DOWNLOAD.equals((Object)this.editData.getResourceType())) {
            this.txtInvoiceCode.setEnabled(false);
            this.txtInvoiceNumber.setEnabled(false);
            this.pkBizDate.setEnabled(false);
            this.comboInvoiceType.setEnabled(false);
            this.txtBillingCompany.setEnabled(false);
            this.txtTaxNumber.setEnabled(false);
            this.txtContact.setEnabled(false);
            this.txtBankInformation.setEnabled(false);
            this.txtPassword.setEnabled(false);
            this.chkIsIssue.setEnabled(false);
            this.chkIsInTax.setEnabled(false);
            this.txtDescription.setEnabled(false);
            this.kdtEntries.getColumn(TB_PRODUCTNAME).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_SPECS).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_UNITNAME).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_QUANTITY).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_TAXEXCLUDED).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_TAXPRICE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MONEY).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_TAXRATE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_TAXAMT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_TAXTOTAL).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_TAXCLASSIFICATIONNUMBER).getStyleAttributes().setLocked(true);
        } else {
            this.txtInvoiceCode.setEnabled(true);
            this.txtInvoiceNumber.setEnabled(true);
            this.pkBizDate.setEnabled(true);
            this.comboInvoiceType.setEnabled(true);
            this.txtBillingCompany.setEnabled(true);
            this.txtTaxNumber.setEnabled(true);
            this.txtContact.setEnabled(true);
            this.txtBankInformation.setEnabled(true);
            this.txtPassword.setEnabled(true);
            this.chkIsIssue.setEnabled(true);
            this.chkIsInTax.setEnabled(true);
            this.txtDescription.setEnabled(true);
            this.kdtEntries.getColumn(TB_PRODUCTNAME).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_SPECS).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_UNITNAME).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_QUANTITY).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_TAXRATE).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_TAXAMT).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_TAXCLASSIFICATIONNUMBER).getStyleAttributes().setLocked(false);
        }
    }

    private void initCompanyF7() {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, this.getPermissionItem(this.getOprtState()));
        this.getMainBizOrg().setFilterInfoProducer((IFilterInfoProducer)iProducer);
        try {
            this.uiHelper.setMainBizOrgFilter();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
            if (company == null) {
                return;
            }
            try {
                company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            EntityViewInfo ev = this.prmtCompany.getEntityViewInfo();
            FilterInfo filter = ev.getFilter();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("taxNumber", (Object)(StringUtils.isEmpty((String)company.getTaxNumber()) ? company.getTaxNumber() : company.getTaxNumber().trim()), CompareType.EQUALS));
            try {
                filter.mergeFilter(filter1, "and");
                this.prmtCompany.setEntityViewInfo(ev);
                ev.setFilter(filter);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private void initListeners() {
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        IncomeInvoiceEditUI.this.kdtEntries_ChangedStopped(e);
                    }
                    catch (Exception exc) {
                        IncomeInvoiceEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtEntries.addKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.prmtCompanyListener == null) {
            this.prmtCompanyListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    IncomeInvoiceEditUI.this.initPriceField();
                    IncomeInvoiceEditUI.this.initSupplierF7(eventObj);
                }
            };
        }
        this.prmtCompany.addDataChangeListener(this.prmtCompanyListener);
        this.comboInvoiceTypeChange = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    IncomeInvoiceEditUI.this.comboInvoiceTypeItemChanged(e);
                }
                catch (Exception err) {
                    IncomeInvoiceEditUI.this.handUIException(err);
                }
            }
        };
        this.comboInvoiceType.addItemListener(this.comboInvoiceTypeChange);
        this.chkIsInTaxListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    IncomeInvoiceEditUI.this.chkIsInTaxItemChanged(arg0);
                }
                catch (Exception e) {
                    IncomeInvoiceEditUI.this.handUIException(e);
                }
            }
        };
        this.chkIsInTax.addItemListener(this.chkIsInTaxListener);
    }

    protected void comboInvoiceTypeItemChanged(ItemEvent e) {
        this.txtTaxNumber.setRequired(PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals(this.comboInvoiceType.getSelectedItem()) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals(this.comboInvoiceType.getSelectedItem()));
        this.txtTaxNumber.repaint();
    }

    private void initSupplierF7(DataChangeEvent e) {
        String companyId = null;
        if (e == null) {
            companyId = this.prmtCompany.getValue() == null ? "" : ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
        } else if (e.getNewValue() != null) {
            companyId = ((CompanyOrgUnitInfo)e.getNewValue()).getId().toString();
            if (e.getNewValue() != e.getOldValue()) {
                this.prmtCurrAcctSupplier.setValue(null);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1));
        view.setFilter(filter);
        this.prmtCurrAcctSupplier.setEntityViewInfo(view);
        this.prmtCurrAcctSupplier.setHasCUDefaultFilter(false);
    }

    protected void chkIsInTaxItemChanged(ItemEvent arg0) {
        this.initTableEditable();
    }

    protected void kdtEntries_ChangedStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        if (TB_TAXCLASSIFICATIONNUMBER.equals(fieldName)) {
            this.tccDataChanged(e);
        }
        this.calEntryfield(e, rowIndex, colIndex);
    }

    private void calEntryfield(KDTEditEvent e, int rowIndex, int colIndex) {
        IRow row = this.kdtEntries.getRow(rowIndex);
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        BigDecimal quantity = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal taxRate = BigDecimal.ZERO;
        BigDecimal totalAmt = this.getBigDecimal4Cell(row, TB_MONEY);
        BigDecimal taxAmt = this.getBigDecimal4Cell(row, TB_TAXAMT);
        BigDecimal taxTotalAmt = this.getBigDecimal4Cell(row, TB_TAXTOTAL);
        int amtPrecision = 2;
        this.isInTax = this.chkIsInTax.isSelected();
        if (row.getCell(TB_QUANTITY).getValue() != null && !TB_QUANTITY.equals(fieldName)) {
            BigDecimal qty = this.getBigDecimal4Cell(row, TB_QUANTITY);
            qty = this.isInTax ? (this.getBigDecimal4Cell(row, TB_TAXTOTAL).signum() == -1 ? qty.abs().negate() : qty.abs()) : (this.getBigDecimal4Cell(row, TB_MONEY).signum() == -1 ? qty.abs().negate() : qty.abs());
            row.getCell(TB_QUANTITY).setValue((Object)qty);
        }
        if (TB_QUANTITY.equals(fieldName) || TB_TAXEXCLUDED.equals(fieldName) || TB_TAXPRICE.equals(fieldName)) {
            if (this.isInTax) {
                if (row.getCell(TB_TAXPRICE).getValue() == null) {
                    row.getCell(TB_TAXEXCLUDED).setValue(null);
                    return;
                }
                row.getCell(TB_TAXEXCLUDED).setValue((Object)this.getBigDecimal4Cell(row, TB_TAXPRICE).divide(this.getBigDecimal4Cell(row, TB_TAXRATE).add(BigDecimal.ONE), 10, 4));
            } else {
                if (row.getCell(TB_TAXEXCLUDED).getValue() == null) {
                    row.getCell(TB_TAXPRICE).setValue(null);
                    return;
                }
                row.getCell(TB_TAXPRICE).setValue((Object)this.getBigDecimal4Cell(row, TB_TAXEXCLUDED).multiply(this.getBigDecimal4Cell(row, TB_TAXRATE).add(BigDecimal.ONE)).setScale(10, 4));
            }
            if (row.getCell(TB_QUANTITY).getValue() == null) {
                return;
            }
        }
        if (TB_QUANTITY.equals(fieldName)) {
            quantity = this.getBigDecimal4Cell(row, TB_QUANTITY);
            taxRate = this.getBigDecimal4Cell(row, TB_TAXRATE);
            totalAmt = this.getBigDecimal4Cell(row, TB_MONEY);
            taxTotalAmt = this.getBigDecimal4Cell(row, TB_TAXTOTAL);
            if (this.isInTax) {
                taxPrice = this.getBigDecimal4Cell(row, TB_TAXPRICE);
                price = taxPrice.divide(taxRate.add(BigDecimal.ONE), 10, 4);
                taxTotalAmt = taxPrice.multiply(quantity).setScale(amtPrecision, 4);
                taxAmt = taxTotalAmt.divide(taxRate.add(BigDecimal.ONE), amtPrecision, 4).multiply(taxRate).setScale(amtPrecision, 4);
                totalAmt = taxTotalAmt.subtract(taxAmt).setScale(amtPrecision, 4);
                row.getCell(TB_TAXEXCLUDED).setValue((Object)price);
                row.getCell(TB_MONEY).setValue((Object)totalAmt);
                row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
                row.getCell(TB_TAXTOTAL).setValue((Object)taxTotalAmt);
            } else {
                price = this.getBigDecimal4Cell(row, TB_TAXEXCLUDED);
                taxPrice = price.multiply(taxRate.add(BigDecimal.ONE)).setScale(10, 4);
                totalAmt = price.multiply(quantity).setScale(amtPrecision, 4);
                taxAmt = totalAmt.multiply(taxRate).setScale(amtPrecision, 4);
                taxTotalAmt = totalAmt.add(taxAmt);
                row.getCell(TB_TAXPRICE).setValue((Object)taxPrice);
                row.getCell(TB_MONEY).setValue((Object)totalAmt);
                row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
                row.getCell(TB_TAXTOTAL).setValue((Object)taxTotalAmt);
            }
        }
        if (TB_TAXPRICE.equals(fieldName)) {
            quantity = this.getBigDecimal4Cell(row, TB_QUANTITY);
            taxRate = this.getBigDecimal4Cell(row, TB_TAXRATE);
            if (this.isInTax) {
                taxPrice = this.getBigDecimal4Cell(row, TB_TAXPRICE);
                price = taxPrice.divide(taxRate.add(BigDecimal.ONE), 10, 4);
                taxTotalAmt = taxPrice.multiply(quantity).setScale(amtPrecision, 4);
                taxAmt = taxTotalAmt.divide(taxRate.add(BigDecimal.ONE), amtPrecision, 4).multiply(taxRate).setScale(amtPrecision, 4);
                totalAmt = taxTotalAmt.subtract(taxAmt).setScale(amtPrecision, 4);
                row.getCell(TB_TAXEXCLUDED).setValue((Object)price);
                row.getCell(TB_MONEY).setValue((Object)totalAmt);
                row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
                row.getCell(TB_TAXTOTAL).setValue((Object)taxTotalAmt);
            }
        }
        if (TB_TAXEXCLUDED.equals(fieldName)) {
            quantity = this.getBigDecimal4Cell(row, TB_QUANTITY);
            taxRate = this.getBigDecimal4Cell(row, TB_TAXRATE);
            price = this.getBigDecimal4Cell(row, TB_TAXEXCLUDED);
            taxPrice = price.multiply(taxRate.add(BigDecimal.ONE));
            totalAmt = price.multiply(quantity).setScale(amtPrecision, 4);
            taxAmt = totalAmt.multiply(taxRate).setScale(amtPrecision, 4);
            taxTotalAmt = totalAmt.add(taxAmt);
            row.getCell(TB_TAXPRICE).setValue((Object)taxPrice);
            row.getCell(TB_MONEY).setValue((Object)totalAmt);
            row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
            row.getCell(TB_TAXTOTAL).setValue((Object)taxTotalAmt);
        }
        if (TB_TAXAMT.equals(fieldName)) {
            taxTotalAmt = this.getBigDecimal4Cell(row, TB_TAXTOTAL);
            totalAmt = this.getBigDecimal4Cell(row, TB_MONEY);
            taxAmt = this.getBigDecimal4Cell(row, TB_TAXAMT);
            if (this.isInTax) {
                if (taxTotalAmt.signum() == -1 && taxAmt.signum() == 1 || taxTotalAmt.signum() == 1 && taxAmt.signum() == -1) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"ILLEG_TAXAMT"));
                    row.getCell(TB_TAXAMT).setValue(e.getOldValue());
                    return;
                }
                if (taxAmt.abs().compareTo(taxTotalAmt.abs()) > 0) {
                    row.getCell(TB_TAXAMT).setValue(e.getOldValue());
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"LARGER_TAXAMT"));
                    return;
                }
                totalAmt = taxTotalAmt.subtract(taxAmt).setScale(amtPrecision, 4);
                row.getCell(TB_MONEY).setValue((Object)totalAmt);
            } else {
                if (totalAmt.signum() == -1 && taxAmt.signum() == 1 || totalAmt.signum() == 1 && taxAmt.signum() == -1) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"ILLEG_TAXAMT"));
                    row.getCell(TB_TAXAMT).setValue(e.getOldValue());
                    return;
                }
                taxTotalAmt = taxAmt.add(totalAmt).setScale(amtPrecision, 4);
                row.getCell(TB_TAXTOTAL).setValue((Object)taxTotalAmt);
            }
        }
        if (TB_TAXTOTAL.equals(fieldName)) {
            quantity = this.getBigDecimal4Cell(row, TB_QUANTITY);
            taxTotalAmt = this.getBigDecimal4Cell(row, TB_TAXTOTAL);
            taxRate = this.getBigDecimal4Cell(row, TB_TAXRATE);
            if (this.isInTax) {
                if (quantity.compareTo(BigDecimal.ZERO) != 0) {
                    taxPrice = taxTotalAmt.divide(quantity, 10, 4);
                    price = taxPrice.divide(taxRate.add(BigDecimal.ONE), 10, 4);
                    row.getCell(TB_TAXPRICE).setValue((Object)taxPrice);
                    row.getCell(TB_TAXEXCLUDED).setValue((Object)price);
                }
                taxAmt = taxTotalAmt.divide(taxRate.add(BigDecimal.ONE), amtPrecision, 4).multiply(taxRate).setScale(amtPrecision, 4);
                totalAmt = taxTotalAmt.subtract(taxAmt).setScale(amtPrecision, 4);
                row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
                row.getCell(TB_MONEY).setValue((Object)totalAmt);
            }
        }
        if (TB_MONEY.equals(fieldName)) {
            quantity = this.getBigDecimal4Cell(row, TB_QUANTITY);
            taxRate = this.getBigDecimal4Cell(row, TB_TAXRATE);
            totalAmt = this.getBigDecimal4Cell(row, TB_MONEY);
            if (quantity.compareTo(BigDecimal.ZERO) != 0) {
                price = totalAmt.divide(quantity, 10, 4);
                taxPrice = price.multiply(taxRate.add(BigDecimal.ONE));
                row.getCell(TB_TAXPRICE).setValue((Object)taxPrice);
                row.getCell(TB_TAXEXCLUDED).setValue((Object)price);
            }
            taxAmt = totalAmt.multiply(taxRate).setScale(amtPrecision, 4);
            taxTotalAmt = totalAmt.add(taxAmt);
            row.getCell(TB_TAXTOTAL).setValue((Object)taxTotalAmt);
            row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
        }
        if (TB_TAXRATE.equals(fieldName)) {
            Object value = e.getValue();
            if (value != null && ((taxRate = (BigDecimal)value).compareTo(BigDecimal.ZERO) < 0 || taxRate.compareTo(BigDecimal.ONE) >= 0)) {
                row.getCell(fieldName).setValue(e.getOldValue());
                return;
            }
            quantity = this.getBigDecimal4Cell(row, TB_QUANTITY);
            taxRate = this.getBigDecimal4Cell(row, TB_TAXRATE);
            if (taxRate.compareTo(new BigDecimal(1)) > 0) {
                row.getCell(TB_TAXRATE).setValue(null);
            } else {
                this.taxRateCalculate(row, taxRate, amtPrecision);
            }
        }
        this.calSumRow();
    }

    private void taxRateCalculate(IRow row, BigDecimal taxRate, int amtPrecision) {
        if (this.isInTax) {
            BigDecimal taxPrice = this.getBigDecimal4Cell(row, TB_TAXPRICE);
            BigDecimal taxTotalAmt = this.getBigDecimal4Cell(row, TB_TAXTOTAL);
            if (row.getCell(TB_TAXPRICE).getValue() != null) {
                BigDecimal price = taxPrice.divide(taxRate.add(BigDecimal.ONE), 10, 4);
                row.getCell(TB_TAXEXCLUDED).setValue((Object)price);
            }
            BigDecimal taxAmt = taxTotalAmt.divide(taxRate.add(BigDecimal.ONE), amtPrecision, 4).multiply(taxRate).setScale(amtPrecision, 4);
            BigDecimal totalAmt = taxTotalAmt.subtract(taxAmt);
            row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
            row.getCell(TB_MONEY).setValue((Object)totalAmt);
        } else {
            BigDecimal price = this.getBigDecimal4Cell(row, TB_TAXEXCLUDED);
            BigDecimal totalAmt = this.getBigDecimal4Cell(row, TB_MONEY);
            if (row.getCell(TB_TAXEXCLUDED).getValue() != null) {
                BigDecimal taxPrice = price.multiply(taxRate.add(BigDecimal.ONE));
                row.getCell(TB_TAXPRICE).setValue((Object)taxPrice);
            }
            BigDecimal taxAmt = totalAmt.multiply(taxRate).setScale(amtPrecision, 4);
            BigDecimal taxTotalAmt = totalAmt.add(taxAmt);
            row.getCell(TB_TAXTOTAL).setValue((Object)taxTotalAmt);
            row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
        }
    }

    private BigDecimal getBigDecimal4Cell(IRow row, String column) {
        BigDecimal value = (BigDecimal)row.getCell(column).getValue();
        return value == null ? BigDecimal.ZERO : value;
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "im_incomeInvoice_new";
        }
        if ("EDIT".equals(status)) {
            return "im_incomeInvoice_update";
        }
        if ("VIEW".equals(status) || "FINDVIEW".equals(status)) {
            return "im_makeInvoice_view";
        }
        return "im_incomeInvoice_new";
    }

    private void removeListener() {
        if (this.entryTableChange != null) {
            this.kdtEntries.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
        if (this.prmtCompanyListener != null) {
            this.prmtCompany.removeDataChangeListener(this.prmtCompanyListener);
        }
        if (this.comboInvoiceTypeChange != null) {
            this.comboInvoiceType.removeItemListener(this.comboInvoiceTypeChange);
        }
        if (this.chkIsInTaxListener != null) {
            this.chkIsInTax.removeItemListener(this.chkIsInTaxListener);
        }
    }

    protected void appendFootRow(KDTable table) {
        super.appendFootRow(table);
        if (this.getDetailTable() != null) {
            IRow totolRow;
            KDTFootManager footRowManager = this.getDetailTable().getFootManager();
            if (footRowManager == null) {
                String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                footRowManager = new KDTFootManager(this.getDetailTable());
                footRowManager.addFootView();
                this.getDetailTable().setFootManager(footRowManager);
                totolRow = footRowManager.addFootRow(0);
                totolRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                totolRow.getStyleAttributes().setBackground(FOOTROWCOLOR);
                this.getDetailTable().getIndexColumn().setWidthAdjustMode((short)1);
                this.getDetailTable().getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, total);
            } else {
                totolRow = footRowManager.getFootRow(0);
            }
            if (totolRow == null) {
                return;
            }
            String[] colNames = this.getSumColNames();
            for (int i = 0; i < colNames.length; ++i) {
                if (totolRow.getCell(colNames[i]) == null) continue;
                totolRow.getCell(colNames[i]).getStyleAttributes().setNumberFormat(NUMFORMAT);
            }
        }
        this.calSumRow();
    }

    private void calSumRow() {
        this.kdtEntries.getRowCount();
        BigDecimal footNoTaxAmt = BigDecimal.ZERO;
        BigDecimal footTaxAmt = BigDecimal.ZERO;
        BigDecimal footPriceTax = BigDecimal.ZERO;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            footNoTaxAmt = footNoTaxAmt.add(this.getBigDecimal4Cell(this.kdtEntries.getRow(i), TB_MONEY));
            footTaxAmt = footTaxAmt.add(this.getBigDecimal4Cell(this.kdtEntries.getRow(i), TB_TAXAMT));
            footPriceTax = footPriceTax.add(this.getBigDecimal4Cell(this.kdtEntries.getRow(i), TB_TAXTOTAL));
        }
        this.kdtEntries.getFootRow(0).getCell(TB_MONEY).setValue((Object)footNoTaxAmt);
        this.kdtEntries.getFootRow(0).getCell(TB_TAXAMT).setValue((Object)footTaxAmt);
        this.kdtEntries.getFootRow(0).getCell(TB_TAXTOTAL).setValue((Object)footPriceTax);
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected String[] getSumColNames() {
        return new String[]{TB_MONEY, TB_TAXAMT, TB_TAXTOTAL};
    }

    @Override
    protected void comboInvoiceType_itemStateChanged(ItemEvent e) throws Exception {
        PayInvoiceTypeEnum selectedItem = (PayInvoiceTypeEnum)this.comboInvoiceType.getSelectedItem();
        if (selectedItem == PayInvoiceTypeEnum.COMMONINVOICE || selectedItem == PayInvoiceTypeEnum.ELECTRONICINVOICE) {
            this.txtTaxNumber.setRequired(false);
        } else {
            this.txtTaxNumber.setRequired(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IObjectValue value = this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (value == null) {
            throw new ObjectNotFoundException();
        }
        this.checkBizAllow();
        super.actionEdit_actionPerformed(e);
        this.initDataButton();
        this.initComponents();
        this.initBtnStatus();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getResourceType() == null) {
            this.editData.setResourceType(InvResourceType.INV_ADDNEW);
        }
        this.checkBizAllow();
        this.checkRequiredFields();
        super.actionSave_actionPerformed(e);
    }

    private void checkBizAllow() {
        if (this.getEditData() == null || this.getEditData().getId() == null) {
            return;
        }
        if (AuthenticateTypeEnum.ONLINE.equals((Object)this.editData.getAuthenticateType())) {
            MsgBox.showWarning((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "NotEdit_Authenticate", IMUtils.getLocale()));
            SysUtil.abort();
        } else if (this.editData.getCheckAbs() != null && CheckTypeEnum.ONLINE.equals((Object)this.editData.getCheckAbs().getCheckType())) {
            MsgBox.showWarning((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "NotEdit_Authenticate", IMUtils.getLocale()));
            SysUtil.abort();
        } else if (this.editData.isIsAccept()) {
            MsgBox.showWarning((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "NotEdit_Accept", IMUtils.getLocale()));
            SysUtil.abort();
        } else if (this.editData.isIsReceive()) {
            MsgBox.showWarning((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "NotEdit_Receive", IMUtils.getLocale()));
            SysUtil.abort();
        } else if (this.editData.getVoucher() != null) {
            MsgBox.showWarning((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "NotEdit_Voucher", IMUtils.getLocale()));
            SysUtil.abort();
        }
    }

    protected boolean isCanEditable() {
        if (AuthenticateTypeEnum.ONLINE.equals((Object)this.editData.getAuthenticateType())) {
            return false;
        }
        if (this.editData.getCheckAbs() != null && CheckTypeEnum.ONLINE.equals((Object)this.editData.getCheckAbs().getCheckType())) {
            return false;
        }
        if (this.editData.isIsAccept()) {
            return false;
        }
        if (this.editData.isIsReceive()) {
            return false;
        }
        return !InvResourceType.INV_DOWNLOAD.equals((Object)this.editData.getResourceType());
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        IncomeInvoiceInfo editData = (IncomeInvoiceInfo)newData;
        editData.setInvoiceCode(null);
        editData.setInvoiceNumber(null);
        editData.setPassword(null);
        editData.setStatus(IncomeStatusEnum.NORMAL);
        editData.setAuthenticateDate(null);
        editData.setAuthenticateStatus(IncomeAuthenticateStatusEnum.UNAUTHORIZED);
        editData.put("authenticateType", null);
        editData.put("authenticateWay", null);
        editData.setAuthenticator(null);
        editData.setDueDate(null);
        editData.setIsCheck(false);
        editData.setBizBillType(null);
        editData.setIsAccept(false);
        editData.setAcceptInvoiceDate(null);
        editData.setAcceptUser(null);
        editData.setIsReceive(false);
        editData.setReceiveDate(null);
        editData.setReceiveUser(null);
        editData.setResourceType(InvResourceType.INV_ADDNEW);
        editData.setFiVouchered(false);
        editData.setVoucher(null);
        editData.setVoucherNumber(null);
        editData.setVoucherType(null);
        editData.setBelongTaxPeriod(null);
        editData.setPdfUrl(null);
        editData.setCheckDate(null);
        editData.setSourceInvoiceCode(null);
        editData.setSourceInvoiceNumber(null);
        editData.setIsDeduct(null);
        editData.setReBusiness(false);
        editData.setBizBillID(null);
        editData.setBizBillEntryID(null);
        editData.setBizBillNumber(null);
        editData.setBizBillType(null);
        editData.setIsPayment(false);
        editData.setDeductTaxAmt(null);
        editData.setBizVoucherID(null);
        editData.setBizVoucherPeriod(null);
        editData.setBizVoucherNumber(null);
        editData.setBizVoucherType(null);
        editData.setTmInvoiceType(null);
        editData.setIncomeType(null);
        editData.setReceiveSeq(null);
        editData.setCheckAbs(null);
        editData.setNonCompliantInvoice(null);
        editData.setIsNonCompliant(false);
        editData.setNonCompliantState(null);
        editData.setNonCompliantExplain(null);
    }

    private void checkRequiredFields() {
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        if (this.txtInvoiceCode.getText().isEmpty()) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "InvoiceCode", IMUtils.getLocale()));
        }
        if (this.txtInvoiceNumber.getText().isEmpty()) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "InvoiceNumber", IMUtils.getLocale()));
        }
        if (this.pkBizDate.getValue() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "InvoiceDate", IMUtils.getLocale()));
        }
        if (this.prmtCompany.getValue() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "Company", IMUtils.getLocale()));
        }
        if (this.comboInvoiceType.getSelectedItem() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "InvoiceType", IMUtils.getLocale()));
        }
        if (this.txtBillingCompany.getText().isEmpty()) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "BillCompany", IMUtils.getLocale()));
        }
        if (this.txtTaxNumber.isRequired() && this.txtTaxNumber.getText().isEmpty()) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "TaxNumber", IMUtils.getLocale()));
        }
        if (sb.length() > 0) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "NotNull", IMUtils.getLocale())).append("\r\n");
        }
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            if (this.kdtEntries.getRow(i).getCell(TB_PRODUCTNAME).getValue() != null) continue;
            sb.append(this.getEntryMsg(i + 1, IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "ProductName", IMUtils.getLocale())));
        }
        if (sb2.length() > 0) {
            sb.append(sb2);
        }
        if (sb.length() > 0) {
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    private String getEntryMsg(int i, String field) {
        return IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "Entries_NotNull", IMUtils.getLocale(), new Object[]{i, field}) + "\r\n";
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (pk != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("checkAbs.confirmUser.*"));
        selectors.add(new SelectorItemInfo("checkAbs.*"));
        selectors.add(new SelectorItemInfo("voucher.*"));
        selectors.add(new SelectorItemInfo("nonCompliantInvoice.*"));
        selectors.add(new SelectorItemInfo("nonCompliantInvoice.entry.*"));
        selectors.add(new SelectorItemInfo("nonCompliantInvoice.entry.nonCompliantType.*"));
        return selectors;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "company";
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return this.prmtCompany;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    @Override
    public String getPermItem(String status) {
        return this.getPermissionItem(status);
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void actionCheckInvoice_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null) {
            return;
        }
        if (!InvResourceType.INV_DOWNLOAD.equals((Object)this.editData.getResourceType())) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "CannotDownloadInvoice", IMUtils.getLocale()));
            SysUtil.abort();
        }
        this.doInDeamon(e);
    }

    private void doInDeamon(ActionEvent e) {
        this.invoicePercent = 30;
        String parentTxt = "";
        AbstractButton button = (AbstractButton)e.getSource();
        parentTxt = button.getText();
        final MonitorInfo info = new MonitorInfo(parentTxt, null, (Object)this, true);
        MySwingWork worker = new MySwingWork(){

            public Object construct() {
                try {
                    IncomeInvoiceEditUI.this.checkInvoice();
                    IncomeInvoiceEditUI.this.refresh();
                }
                catch (Exception ex) {
                    IncomeInvoiceEditUI.this.handUIException(ex);
                }
                catch (Throwable ex) {
                    IncomeInvoiceEditUI.this.handUIException(ex);
                }
                return null;
            }

            public void finished() {
                this.timerStop();
                MyThreadPool.destroyMonitor(info);
                MyThreadPool.destroyPorgressDialog();
            }

            @Override
            public void refreshProgress() {
                MyThreadPool.refreshProgress(IncomeInvoiceEditUI.this.invoicePercent);
            }
        };
        info.setWorker((SwingWorker)worker);
        MyThreadPool.getInstance();
        MyThreadPool.addActionThread(info);
        MyThreadPool.setBackgroundRunButtonEnabled(false);
    }

    private void checkInvoice() throws BOSException, EASBizException, JSONException {
        Map body = this.buildParams();
        PwyActionParam actionParam = null;
        actionParam = new PwyActionParam(PwyServiceType.OPR_INCOME_CHECKINVOICE, TransSrcSystemEnum.easgui, this.editData.getCompany().getId().toString(), this.editData.getId().toString(), body);
        PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getRemoteInstance().invoke(actionParam);
        IncomeInvoiceCheckInvoicePwyService pwyService = (IncomeInvoiceCheckInvoicePwyService)PwyServiceHelper.getPwyService(null, invokeParam);
        pwyService.invoke();
        ArrayList errorList = new ArrayList();
        if (!pwyService.isSuccess()) {
            TMMsgBox.showInfo((String)invokeParam.getDescription(), (Map)TMMsgURLUtil.getMsgURL((String)"IMS"));
        } else {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "CheckInvoiceSuccess", IMUtils.getLocale()));
        }
    }

    private Map buildParams() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        HashMap<String, Object> params = new HashMap<String, Object>();
        BigDecimal fpje = new BigDecimal(this.editData.getAmount().toString());
        BigDecimal invoiceMoney = fpje.setScale(2, 4);
        params.put("invoiceCode", this.editData.getInvoiceCode());
        params.put("invoiceNo", this.editData.getInvoiceNumber());
        params.put("invoiceDate", dateFormat.format(this.editData.getBizDate()));
        params.put("invoiceMoney", invoiceMoney);
        params.put("checkCode", this.getCheckCode());
        params.put("isCreateUrl", 0);
        return params;
    }

    private String getCheckCode() {
        String checkCode;
        String string = checkCode = StringUtils.isEmpty((String)this.editData.getCheckCode()) ? "" : this.editData.getCheckCode();
        if (checkCode.length() >= 6) {
            checkCode = checkCode.substring(checkCode.length() - 6, checkCode.length());
        }
        return checkCode;
    }

    private String buildErrorMsg(List errorList) {
        StringBuffer sb = new StringBuffer();
        if (errorList != null) {
            for (int i = 0; i < errorList.size(); ++i) {
                sb.append(errorList.get(i).toString() + "\n");
            }
        }
        return sb.toString();
    }

    private void refresh() {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        try {
            this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId().toString())));
            this.loadFields();
            this.initOldData((IObjectValue)this.editData);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void handUIException(Throwable exc) {
        if (TMMsgBox.handUIException((Component)((Object)this), (Throwable)exc, (String)"IMS")) {
            super.handUIException(exc);
        }
    }
}

