/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.tm.im.FilterCommonStatusEnum;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.InvoiceCCStatusEnum;
import com.kingdee.eas.tm.im.client.AbstractIncomeInvoiceFilterUI;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class IncomeInvoiceFilterUI
extends AbstractIncomeInvoiceFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(IncomeInvoiceFilterUI.class);
    private ItemListener invoiceTypeListener = null;
    private boolean isIgnorePermission = false;

    public IncomeInvoiceFilterUI() throws Exception {
        this.getElementsInfo();
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        RangeFilterElement bizDateElements = new RangeFilterElement("bizDate", (Component)this.bizDateFrom, (Component)this.bizDateTo);
        bizDateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)bizDateElements);
        elements.add((FilterElement)new SingleFilterElement("invoiceType", (Component)this.kDComboInvoiceType, (Object)PayInvoiceTypeEnum.DEFAULTTYPE));
        elements.add((FilterElement)new SingleFilterElement("status", (Component)this.kDComboStatus, (Object)FilterCommonStatusEnum.NULL));
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("company.id", (Component)this.prmtCompany);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, SCMClientUtils.getResource((String)"MAINBIZORGISNULL")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "company.id");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadStatus();
        this.setAuthenticateStatusEnabled();
        this.initCompanyF7();
        this.setF7Filter();
        this.setDefaultValue();
        this.initListeners();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
    }

    private void loadStatus() {
        this.kDComboStatus.removeAllItems();
        this.kDComboStatus.addItem((Object)FilterCommonStatusEnum.NULL);
        this.kDComboStatus.addItems(IncomeStatusEnum.getEnumList().toArray());
        this.kDComboStatus.removeItem((Object)IncomeStatusEnum.RETURN);
        this.kDComboInvoiceType.removeAllItems();
        this.kDComboInvoiceType.addItem((Object)PayInvoiceTypeEnum.DEFAULTTYPE);
        this.kDComboInvoiceType.addItem((Object)PayInvoiceTypeEnum.COMMONINVOICE);
        this.kDComboInvoiceType.addItem((Object)PayInvoiceTypeEnum.VALUEADDEDTAXINV);
        this.kDComboInvoiceType.addItem((Object)PayInvoiceTypeEnum.ELECTRONICINVOICE);
        this.kDComboInvoiceType.addItem((Object)PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE);
    }

    protected void initCompanyF7() throws EASBizException, BOSException {
        int f7DisplayMode = IncomeInvoiceFilterUI.getF7DisplayMode(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        if (f7DisplayMode == 0) {
            NewCompanyF7 companySelector = new NewCompanyF7((IUIObject)this);
            companySelector.setShowAssistantOrg(false);
            companySelector.setIsCUFilter(false);
            companySelector.setShowVirtual(true);
            companySelector.setContainSealUp(false);
            companySelector.setNeedAddAssistant(true);
            companySelector.setMultiSelect(true);
            FilterInfo filter = new FilterInfo();
            String companyFilterSql = "select FID from T_ORG_Company where FIsBizUnit = 1 and FIsCompanyOrgUnit = 1";
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)companyFilterSql, CompareType.INNER));
            companySelector.setOuterFilterInfo(filter);
            companySelector.setPermissionItem(this.getViewPermission());
            this.prmtCompany.setSelector((KDPromptSelector)companySelector);
            this.prmtCompany.setHistoryRecordEnabled(false);
        } else {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            HashSet<String> idset = new HashSet<String>();
            idset.add("111111111111111111111111111=");
            OrgUnitCollection authorizedMainOrgs = IMFacadeFactory.getRemoteInstance().getAuthOrgsByType(OrgType.Company, this.getViewPermission());
            FilterInfo filter = new FilterInfo();
            if (authorizedMainOrgs != null && authorizedMainOrgs.size() > 0) {
                for (int i = 0; i < authorizedMainOrgs.size(); ++i) {
                    OrgUnitInfo orgInfo = authorizedMainOrgs.get(i);
                    if (orgInfo == null || !orgInfo.isIsCompanyOrgUnit() || !orgInfo.getBoolean("isBizUnit")) continue;
                    idset.add(orgInfo.getId().toString());
                }
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
            ev.setFilter(filterInfo);
            this.prmtCompany.setEntityViewInfo(ev);
        }
    }

    private void initListeners() {
        if (this.invoiceTypeListener == null) {
            this.invoiceTypeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    IncomeInvoiceFilterUI.this.invoiceTypeChange(e);
                }
            };
        }
        this.kDComboInvoiceType.addItemListener(this.invoiceTypeListener);
    }

    private void invoiceTypeChange(ItemEvent e) {
        this.setAuthenticateStatusEnabled();
        this.kDComboAuthenticateStatus.setSelectedItem((Object)InvoiceCCStatusEnum.NULL);
    }

    private void setAuthenticateStatusEnabled() {
        this.kDComboAuthenticateStatus.setEditable(false);
        PayInvoiceTypeEnum invoiceTypeEnum = (PayInvoiceTypeEnum)this.kDComboInvoiceType.getSelectedItem();
        if (PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)invoiceTypeEnum) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)invoiceTypeEnum)) {
            this.kDComboAuthenticateStatus.setEnabled(true);
        } else {
            this.kDComboAuthenticateStatus.setEnabled(false);
        }
    }

    public static int getF7DisplayMode(String cuId) throws BOSException, EASBizException {
        try {
            IParamControl ipc = ParamControlFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(cuId);
            return Integer.valueOf(ipc.getParamValue((IObjectPK)pk, "TM001"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void setF7Filter() {
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected String getViewPermission() {
        if (this.isIgnorePermission) {
            return "";
        }
        return "im_incomeInvoice_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "company.id";
    }

    protected void setDefaultValue() {
        this.kDComboStatus.setSelectedItem((Object)IncomeStatusEnum.NORMAL);
        SCMQueryFormat.formatStartTime((KDDatePicker)this.bizDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.bizDateTo);
        this.radioHead.setSelected(true);
        this.kDTextBillingCompany.setText(null);
        this.kDTextTaxNumber.setText(null);
        this.kDTextInvoiceCode.setText(null);
        this.kDTextInvoiceNumber.setText(null);
    }

    public FilterInfo getFilterInfo() {
        InvoiceCCStatusEnum ccStatusEnum;
        FilterInfo filterInfo = super.getFilterInfo();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        if (StringUtils.isEmpty((String)filterInfo.getMaskString())) {
            filterInfo.setMaskString(" ( #0 ) ");
        }
        if (this.radioHead.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.seq", (Object)new Integer(1), CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND ( #" + (filterInfo.getFilterItems().size() - 1));
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.seq", null, CompareType.IS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " OR   #" + (filterInfo.getFilterItems().size() - 1) + ") ");
        } else if (this.radioEntry.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.seq", (Object)new Integer(0), CompareType.NOTEQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND ( #" + (filterInfo.getFilterItems().size() - 1));
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.seq", null, CompareType.IS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " OR   #" + (filterInfo.getFilterItems().size() - 1) + ") ");
        }
        if (!StringUtils.isEmpty((String)this.kDTextBillingCompany.getText())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billingCompany", (Object)("%" + this.kDTextBillingCompany.getText() + "%"), CompareType.LIKE));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND   (#" + (filterInfo.getFilterItems().size() - 1) + ") ");
        }
        if (!StringUtils.isEmpty((String)this.kDTextTaxNumber.getText())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("taxNumber", (Object)("%" + this.kDTextTaxNumber.getText() + "%"), CompareType.LIKE));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND   (#" + (filterInfo.getFilterItems().size() - 1) + ") ");
        }
        if (!StringUtils.isEmpty((String)this.kDTextInvoiceCode.getText())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)("%" + this.kDTextInvoiceCode.getText() + "%"), CompareType.LIKE));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND   (#" + (filterInfo.getFilterItems().size() - 1) + ") ");
        }
        if (!StringUtils.isEmpty((String)this.kDTextInvoiceNumber.getText())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)("%" + this.kDTextInvoiceNumber.getText() + "%"), CompareType.LIKE));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND   (#" + (filterInfo.getFilterItems().size() - 1) + ") ");
        }
        if (InvoiceCCStatusEnum.UNCHECK.equals((Object)(ccStatusEnum = (InvoiceCCStatusEnum)((Object)this.kDComboAuthenticateStatus.getSelectedItem())))) {
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAbs.checkState", (Object)"0", CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND ( #" + (filterInfo.getFilterItems().size() - 1));
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAbs.confirmState", (Object)"0", CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND   #" + (filterInfo.getFilterItems().size() - 1) + ") ");
        } else if (InvoiceCCStatusEnum.CHECK.equals((Object)ccStatusEnum)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAbs.checkState", (Object)"1", CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND ( #" + (filterInfo.getFilterItems().size() - 1));
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAbs.confirmState", (Object)"0", CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND   #" + (filterInfo.getFilterItems().size() - 1) + ") ");
        } else if (InvoiceCCStatusEnum.CONFIRMED.equals((Object)ccStatusEnum)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAbs.checkState", (Object)"1", CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND ( #" + (filterInfo.getFilterItems().size() - 1));
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAbs.confirmState", (Object)"1", CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND   #" + (filterInfo.getFilterItems().size() - 1) + ") ");
        }
        return filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        int intValue;
        super.loadData(entityViewInfo);
        FilterItemCollection filters = entityViewInfo.getFilter().getFilterItems();
        Object obj = IMUtils.getCompareValue(filters, "billingCompany", CompareType.LIKE);
        if (obj != null) {
            this.kDTextBillingCompany.setText(obj.toString().split("%")[1]);
        } else {
            this.kDTextBillingCompany.setText(null);
        }
        obj = IMUtils.getCompareValue(filters, "taxNumber", CompareType.LIKE);
        if (obj != null) {
            this.kDTextTaxNumber.setText(obj.toString().split("%")[1]);
        } else {
            this.kDTextTaxNumber.setText(null);
        }
        obj = IMUtils.getCompareValue(filters, "invoiceCode", CompareType.LIKE);
        if (obj != null) {
            this.kDTextInvoiceCode.setText(obj.toString().split("%")[1]);
        } else {
            this.kDTextInvoiceCode.setText(null);
        }
        obj = IMUtils.getCompareValue(filters, "invoiceNumber", CompareType.LIKE);
        if (obj != null) {
            this.kDTextInvoiceNumber.setText(obj.toString().split("%")[1]);
        } else {
            this.kDTextInvoiceNumber.setText(null);
        }
        obj = IMUtils.getCompareValue(filters, "entries.seq", CompareType.EQUALS);
        if (obj == null) {
            this.radioEntry.setSelected(true);
        } else if (obj instanceof Integer && (intValue = ((Integer)obj).intValue()) == 1) {
            this.radioHead.setSelected(true);
        }
        Object isCheck = IMUtils.getCompareValue(filters, "checkAbs.checkState", CompareType.EQUALS);
        Object isConfirm = IMUtils.getCompareValue(filters, "checkAbs.confirmState", CompareType.EQUALS);
        if (isCheck == null || isConfirm == null) {
            this.kDComboAuthenticateStatus.setSelectedItem((Object)InvoiceCCStatusEnum.NULL);
        } else if ("0".equals(isCheck) && "0".equals(isConfirm)) {
            this.kDComboAuthenticateStatus.setSelectedItem((Object)InvoiceCCStatusEnum.UNCHECK);
        } else if ("1".equals(isCheck) && "0".equals(isConfirm)) {
            this.kDComboAuthenticateStatus.setSelectedItem((Object)InvoiceCCStatusEnum.CHECK);
        } else if ("1".equals(isCheck) && "1".equals(isConfirm)) {
            this.kDComboAuthenticateStatus.setSelectedItem((Object)InvoiceCCStatusEnum.CONFIRMED);
        } else {
            this.kDComboAuthenticateStatus.setSelectedItem((Object)InvoiceCCStatusEnum.NULL);
        }
    }

    public void afterMainOrgChanged(String ids) {
        super.afterMainOrgChanged(ids);
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        sorter.add(new SorterItemInfo("entries.id"));
        return sorter;
    }

    public boolean isIgnorePermission() {
        return this.isIgnorePermission;
    }

    public void setIgnorePermission(boolean isIgnorePermission) {
        this.isIgnorePermission = isIgnorePermission;
    }
}

