/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.client.AbstractInputRedNumUI;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class InputRedNumUI
extends AbstractInputRedNumUI {
    private static final Logger logger = CoreUIObject.getLogger(InputRedNumUI.class);
    private MakeInvoiceInfo info = null;
    private boolean isOk = false;
    private HashMap retMap = new HashMap();

    public boolean isOk() {
        return this.isOk;
    }

    public void setOk(boolean isOk) {
        this.isOk = isOk;
    }

    public HashMap getRetMap() {
        return this.retMap;
    }

    public void setRetMap(HashMap retMap) {
        this.retMap = retMap;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() {
        Map uiCtx = this.getUIContext();
        this.info = (MakeInvoiceInfo)uiCtx.get("editData");
        this.txtTaxNumber.setText(this.info.getBlueVoiceCode());
        this.txtTaxNo.setText(this.info.getBlueVoiceNum());
        this.txtRedNumber.setText(this.info.getRedVoiceNumber());
        if (!StringUtils.isEmpty((String)this.txtTaxNo.getText())) {
            this.chkBlue.setSelected(true);
            this.txtTaxNumber.setEditable(true);
            this.txtTaxNo.setEditable(true);
        } else {
            this.chkBlue.setSelected(false);
            this.txtTaxNumber.setEditable(false);
            this.txtTaxNo.setEditable(false);
        }
        if (StringUtils.isEmpty((String)this.txtRedNumber.getText())) {
            this.chkRed.setSelected(false);
            this.txtRedNumber.setEditable(false);
        } else {
            this.chkRed.setSelected(true);
            this.txtRedNumber.setEditable(true);
        }
        if (this.info.getInvoiceType().getValue().equals("0") || this.info.getInvoiceType().getValue().equals("2")) {
            this.chkBlue.setSelected(true);
            this.chkBlue.setEditable(false);
            this.chkBlue.setEnabled(false);
            this.txtTaxNumber.setEditable(true);
            this.txtTaxNumber.setEnabled(true);
            this.txtTaxNo.setEditable(true);
            this.txtTaxNo.setEnabled(true);
            this.chkRed.setSelected(false);
            this.chkRed.setEditable(false);
            this.chkRed.setEnabled(false);
            this.txtRedNumber.setEditable(false);
        }
        if (this.info.getInvoiceType().equals((Object)PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE) || this.info.getInvoiceType().equals((Object)PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE)) {
            this.txtTaxNumber.setEditable(false);
            this.txtTaxNumber.setEnabled(false);
        } else {
            this.txtTaxNumber.setEditable(true);
            this.txtTaxNumber.setEnabled(true);
        }
        if (this.info.getSrcSystem().getValue().equals("4")) {
            this.chkBlue.setEditable(false);
            this.chkBlue.setEnabled(false);
            this.txtTaxNumber.setEditable(false);
            this.txtTaxNo.setEditable(false);
        }
        this.chkRed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InputRedNumUI.this.redChange();
            }
        });
        this.chkBlue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InputRedNumUI.this.buleChange();
            }
        });
    }

    private void redChange() {
        if (this.chkRed.isSelected()) {
            this.txtRedNumber.setEditable(true);
            this.txtRedNumber.setEnabled(true);
        } else {
            this.txtRedNumber.setEditable(false);
            this.txtRedNumber.setEnabled(false);
            this.txtRedNumber.setText("");
        }
    }

    private void buleChange() {
        if (this.chkBlue.isSelected()) {
            if (this.info.getInvoiceType().equals((Object)PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE) || this.info.getInvoiceType().equals((Object)PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE)) {
                this.txtTaxNumber.setEditable(false);
                this.txtTaxNumber.setEnabled(false);
            } else {
                this.txtTaxNumber.setEditable(true);
                this.txtTaxNumber.setEnabled(true);
            }
            this.txtTaxNo.setEditable(true);
            this.txtTaxNo.setEnabled(true);
        } else {
            this.txtTaxNumber.setEditable(false);
            this.txtTaxNumber.setEnabled(false);
            this.txtTaxNo.setEditable(false);
            this.txtTaxNo.setEnabled(false);
            this.txtTaxNumber.setText("");
            this.txtTaxNo.setText("");
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        StringBuffer msg = new StringBuffer();
        this.txtTaxNumber.setText(this.txtTaxNumber.getText().trim());
        this.txtTaxNo.setText(this.txtTaxNo.getText().trim());
        this.txtRedNumber.setText(this.txtRedNumber.getText().trim());
        if (this.chkBlue.isSelected()) {
            if (this.info.getInvoiceType().equals((Object)PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE) || this.info.getInvoiceType().equals((Object)PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE)) {
                if (this.txtTaxNo.getText().isEmpty()) {
                    msg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "TaxNumberNotNull", IMUtils.getLocale())).append("\r\n");
                }
            } else if (this.txtTaxNumber.getText().isEmpty() || this.txtTaxNo.getText().isEmpty()) {
                msg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "TaxNoOrNumberNotNull", IMUtils.getLocale())).append("\r\n");
            }
            this.retMap.put("hasBlue", true);
        }
        if (this.chkRed.isSelected()) {
            if (this.txtRedNumber.getText().isEmpty()) {
                msg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "RedNumberNotNull", IMUtils.getLocale()));
            }
            this.retMap.put("hasRed", true);
        }
        if (msg.length() > 0) {
            MsgBox.showWarning((String)msg.toString());
            return;
        }
        this.retMap.put("blueNumber", this.txtTaxNumber.getText());
        this.retMap.put("blueNo", this.txtTaxNo.getText());
        this.retMap.put("redNum", this.txtRedNumber.getText());
        Map uiCtx = this.getUIContext();
        MakeInvoiceInfo info = (MakeInvoiceInfo)uiCtx.get("editData");
        boolean isRepetition = false;
        if (!StringUtils.isEmpty((String)this.txtTaxNumber.getText()) && !StringUtils.isEmpty((String)this.txtTaxNo.getText())) {
            FilterInfo blueInvoiceFilter = new FilterInfo();
            blueInvoiceFilter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)this.txtTaxNumber.getText(), CompareType.EQUALS));
            blueInvoiceFilter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)this.txtTaxNo.getText(), CompareType.EQUALS));
            boolean blueInvoiceExists = MakeInvoiceFactory.getRemoteInstance().exists(blueInvoiceFilter);
            FilterInfo isRepetitionFilter = new FilterInfo();
            isRepetitionFilter.getFilterItems().add(new FilterItemInfo("blueVoiceCode", (Object)this.txtTaxNumber.getText(), CompareType.EQUALS));
            isRepetitionFilter.getFilterItems().add(new FilterItemInfo("blueVoiceNum", (Object)this.txtTaxNo.getText(), CompareType.EQUALS));
            isRepetitionFilter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.EQUALS));
            isRepetition = MakeInvoiceFactory.getRemoteInstance().exists(isRepetitionFilter);
            if (blueInvoiceExists && !isRepetition) {
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(blueInvoiceFilter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("srcSystem"));
                view.setSelector(sic);
                MakeInvoiceCollection blueColl = MakeInvoiceFactory.getRemoteInstance().getMakeInvoiceCollection(view);
                if (blueColl.size() > 0) {
                    String srcSystem;
                    MakeInvoiceInfo blue = blueColl.get(0);
                    String string = srcSystem = blue.getSrcSystem() == null ? "" : blue.getSrcSystem().getValue();
                    if (!"5".equals(srcSystem) && !"7".equals(srcSystem)) {
                        int flag = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"BlueInvoiceExist"));
                        if (flag == 0) {
                            this.retMap.put("blueInvoiceExists", true);
                            this.retMap.put("blueInvoiceID", blue.getId().toString());
                            this.retMap.put("srcSystem", srcSystem);
                        } else {
                            this.txtTaxNumber.setText(null);
                            this.txtTaxNo.setText(null);
                            return;
                        }
                    }
                }
            }
        }
        if (!StringUtils.isEmpty((String)this.txtRedNumber.getText())) {
            FilterInfo isRepetitionFilter = new FilterInfo();
            isRepetitionFilter.getFilterItems().add(new FilterItemInfo("redVoiceNumber", (Object)this.txtRedNumber.getText(), CompareType.EQUALS));
            isRepetitionFilter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.EQUALS));
            isRepetition = MakeInvoiceFactory.getRemoteInstance().exists(isRepetitionFilter);
        }
        this.retMap.put("isRepetition", isRepetition);
        this.setOk(true);
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }
}

