/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.util.BizOrgEnum;
import com.kingdee.eas.framework.util.DateEnum;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.InvoiceRespInfo;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.TaxSeparationFactory;
import com.kingdee.eas.tm.im.client.AbstractMakeInvoceReqListUI;
import com.kingdee.eas.tm.im.client.MySwingWork;
import com.kingdee.eas.tm.im.client.MyThreadPool;
import com.kingdee.eas.tm.im.client.RuleItem;
import com.kingdee.eas.tm.im.client.SelectCombinRuleSchemeUI;
import com.kingdee.eas.tm.im.client.util.IMClientUtils;
import com.kingdee.eas.tm.im.common.IMCommonProcessor;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoicePwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.im.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class MakeInvoceReqListUI
extends AbstractMakeInvoceReqListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(MakeInvoceReqListUI.class);
    private ListUIHelper uiHelper = null;
    private CommonQueryDialog commonQueryDialog = null;
    private int invoicePercent = 0;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public MakeInvoceReqListUI() throws Exception {
        this.uiHelper = new ListUIHelper((ListUI)this);
    }

    protected String getEditUIName() {
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            this.initPermActions();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.btnInvoice.addAssistMenuItem((JMenuItem)ArApBillUIUtil.cloneMenuItem((KDMenuItem)this.menu_inv_vat));
        this.btnInvoice.addAssistMenuItem((JMenuItem)ArApBillUIUtil.cloneMenuItem((KDMenuItem)this.menu_inv_gen));
        this.btnInvoice.addAssistMenuItem((JMenuItem)ArApBillUIUtil.cloneMenuItem((KDMenuItem)this.menu_inv_Electric));
        this.btnInvoiceReq.addAssistMenuItem((JMenuItem)ArApBillUIUtil.cloneMenuItem((KDMenuItem)this.menu_req_vat));
        this.btnInvoiceReq.addAssistMenuItem((JMenuItem)ArApBillUIUtil.cloneMenuItem((KDMenuItem)this.menu_req_gen));
        this.btnInvoiceReq.addAssistMenuItem((JMenuItem)ArApBillUIUtil.cloneMenuItem((KDMenuItem)this.menu_req_Electric));
        this.btnInvoice.setIcon(EASResource.getIcon((String)"imgTbtn_checkprofit"));
        this.btnInvoiceReq.setIcon(EASResource.getIcon((String)"imgTbtn_adduction"));
        this.menuItemAddNew.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemCreateTo.setVisible(false);
        this.menuItemCopyTo.setVisible(false);
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        this.setDefaultQuickFilterInfo();
        super.onLoad();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxSeparationFactory.getRemoteInstance();
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"number", "bizDate", "company.name", "customer.name", "recOrgName", "taxNumber", "bankAccount", "address", "currency.name", "status", "sourceSys", "sourceBillNumber", "description"};
        return columns;
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tblMain.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionInvoiceVat_actionPerformed(ActionEvent e) throws Exception {
        this.doMakeInvoice(e, false, 1);
    }

    @Override
    public void actionInvoiceGen_actionPerformed(ActionEvent e) throws Exception {
        this.doMakeInvoice(e, false, 2);
    }

    @Override
    public void actionInvoiceElectric_actionPerformed(ActionEvent e) throws Exception {
        this.doMakeInvoice(e, false, 3);
    }

    @Override
    public void actionReqVat_actionPerformed(ActionEvent e) throws Exception {
        this.doMakeInvoice(e, true, 1);
    }

    @Override
    public void actionReqGen_actionPerformed(ActionEvent e) throws Exception {
        this.doMakeInvoice(e, true, 2);
    }

    @Override
    public void actionReqElectric_actionPerformed(ActionEvent e) throws Exception {
        this.doMakeInvoice(e, true, 3);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "mkInvoiceReq";
        param.alias = "mkInvoiceReq";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "mkInvoiceReq";
        param.datataskMode = 1;
        param.alias = "mkInvoiceReq";
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        try {
            hashtable.put("filter", this.mainQuery.getFilter());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi;
    }

    protected void setDefaultQuickFilterInfo() {
        QuickFilteringSupportItems qfsi = super.getQuickFilteringSupport();
        qfsi.setMustQueryAtFirst(true);
        if (qfsi != null) {
            qfsi.getSystemSolutionItem().getDefaultFilter().add(this.getPropertyOfBizOrg(this.getMainBizOrgType()), CompareType.EQUALS, (Object)BizOrgEnum.DEFAULTMAINORG).add(this.getPropertyOfBizDate(), CompareType.IS, (Object)DateEnum.RECENTONEMONTH);
        }
    }

    private String getPropertyOfBizOrg(OrgType type) {
        return "company.id";
    }

    private String getPropertyOfBizDate() {
        return "bizDate";
    }

    private void doMakeInvoice(ActionEvent e, boolean isReq, int invoiceType) throws Exception {
        ArrayList ids = this.getSelectedIdValuesArrayList();
        if (ids == null || ids.size() == 0) {
            return;
        }
        int retValue = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"TO_MAKEINVOICE"));
        if (retValue == 2) {
            return;
        }
        CommonQueryDialog downloadQueryDialog = IMClientUtils.showCombinRuleSchemeDialog((CoreUI)this, "com.kingdee.eas.tm.im.client.MakeInvoiceReqListUI", "AC368D2D", "412A6F98", true);
        if (downloadQueryDialog == null) {
            return;
        }
        SelectCombinRuleSchemeUI scheme = (SelectCombinRuleSchemeUI)downloadQueryDialog.getUserPanel(0);
        if (!scheme.getIsComfirm()) {
            return;
        }
        RuleItem srcItem = scheme.getSrcRule();
        RuleItem destItem = scheme.getDestRule();
        HashMap<String, String> ruleIDs = new HashMap<String, String>();
        if (srcItem != null) {
            ruleIDs.put("srcRuleID", srcItem.getId());
        }
        if (destItem != null) {
            ruleIDs.put("destRuleID", destItem.getId());
        }
        StringBuffer paramID = new StringBuffer();
        for (int i = 0; i < ids.size(); ++i) {
            paramID.append(ids.get(i)).append(",");
        }
        MakeInvoiceParam param = new MakeInvoiceParam();
        param.setBilBillIds(paramID.toString());
        param.setInvoiceType(invoiceType + "");
        param.setPrint(false);
        param.setReq(isReq);
        param.setRuleIDs(ruleIDs);
        param.setSrcBosType("3D667D4A");
        param.setSrcSystem(IMConstant.SRCTYPE_IM_REQ);
        this.doInDeamon(e, isReq, invoiceType, ids.size(), param, ids);
    }

    private void doInDeamon(ActionEvent e, final boolean isReq, final int invoiceType, final int billSize, final MakeInvoiceParam param, final List ids) {
        String parentTxt = "";
        this.invoicePercent = 0;
        KDMenuItem source = (KDMenuItem)e.getSource();
        if (source.getParent() instanceof KDPopupMenu) {
            KDPopupMenu parent = (KDPopupMenu)source.getParent();
            KDWorkButton button = (KDWorkButton)parent.getInvoker();
            parentTxt = button.getText();
        }
        final MonitorInfo info = new MonitorInfo(parentTxt + "-->" + source.getText(), null, (Object)this, true);
        MySwingWork worker = new MySwingWork(){

            public Object construct() {
                try {
                    MakeInvoceReqListUI.this.innerMakeInvoiceWithLock(isReq, invoiceType, billSize, param, ids);
                    MakeInvoceReqListUI.this.refreshList();
                }
                catch (Exception ex) {
                    MakeInvoceReqListUI.this.handUIException(ex);
                }
                catch (Throwable ex) {
                    MakeInvoceReqListUI.this.handUIException(ex);
                }
                return null;
            }

            public void finished() {
                this.timerStop();
                MyThreadPool.destroyMonitor(info);
                MyThreadPool.destroyPorgressDialog();
            }

            @Override
            public void refreshProgress() {
                MyThreadPool.refreshProgress(MakeInvoceReqListUI.this.invoicePercent);
            }
        };
        info.setWorker((SwingWorker)worker);
        MyThreadPool.getInstance();
        MyThreadPool.addActionThread(info);
        MyThreadPool.setBackgroundRunButtonEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerMakeInvoiceWithLock(boolean isReq, int invoiceType, int billSize, MakeInvoiceParam param, List ids) throws BOSException, EASBizException, JSONException {
        try {
            IMUtils.tryLock(ids);
            this.innerMakeInvoice(isReq, invoiceType, billSize, param, ids);
        }
        finally {
            IMUtils.releaseLock(ids);
        }
    }

    private void innerMakeInvoice(boolean isReq, int invoiceType, int billSize, MakeInvoiceParam param, List ids) throws BOSException, EASBizException, JSONException {
        InvoiceRespInfo resp = IMInvoiceFacadeFactory.getRemoteInstance().makeInvoice(param);
        String errorMsg = resp.getErrorMsg();
        ArrayList mkBillIds = resp.getMkSucessBillIds();
        ArrayList mkfailBills = resp.getMkFailBills();
        ArrayList arFailBills = resp.getBizFailBills();
        if (mkBillIds.isEmpty() && errorMsg.length() > 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"MKINVOICEREQ_MSG", (Object[])new Object[]{mkBillIds.size(), billSize - mkBillIds.size()});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)resp.getErrorMsg(), (int)1);
            return;
        }
        StringBuffer mkmsg = new StringBuffer();
        PwyServiceType serviceType = PwyServiceType.OPR_INV_PAPER_MAKE;
        if (invoiceType == 3) {
            serviceType = PwyServiceType.OPR_INV_DISKELECT_MAKE;
        }
        if (isReq) {
            String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"MAKEINVOICE_MSG_BILL", (Object[])new Object[]{billSize - arFailBills.size(), arFailBills.size()});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)(resp.getErrorMsg() + mkmsg.toString()), (int)1);
        } else {
            ArrayList list = IMInvoiceFacadeFactory.getRemoteInstance().buildPwyParam(mkBillIds, serviceType, TransSrcSystemEnum.easgui);
            int total = mkBillIds.size() + mkfailBills.size();
            int sucess = 0;
            BigDecimal a = new BigDecimal(90);
            BigDecimal b = new BigDecimal(list.size());
            BigDecimal c = BigDecimal.ZERO;
            if (list.size() > 0) {
                c = a.divide(b, 2, RoundingMode.HALF_UP);
            }
            for (int i = 0; i < list.size(); ++i) {
                this.invoicePercent = 10 + c.multiply(new BigDecimal(i)).intValue();
                Map resultMap = (Map)list.get(i);
                String invoiceNum = (String)resultMap.get("number");
                PwyInvokeParam invokeParam = (PwyInvokeParam)resultMap.get("invokeParam");
                MakeInvoicePwyService pwyService = (MakeInvoicePwyService)PwyServiceHelper.getPwyService(null, invokeParam);
                pwyService.invoke();
                if (pwyService.isSuccess()) {
                    ++sucess;
                    continue;
                }
                if (mkmsg.length() == 0) {
                    mkmsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"MAKEINVOICE_ERROR")).append("\r\n");
                }
                mkmsg.append(invoiceNum).append("-").append(pwyService.getInvokeParam().getDescription()).append("\r\n");
            }
            String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"ALL_MAKEINVOICE_REQ_MSG", (Object[])new Object[]{billSize - arFailBills.size(), arFailBills.size(), sucess, total - sucess});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)(resp.getErrorMsg() + mkmsg.toString()), (int)1);
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        IMCommonProcessor processor = new IMCommonProcessor((IUIObject)this);
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            if (this.getUIContext().get("OwnerWindow") == null) {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            try {
                this.commonQueryDialog.setUiObject((IUIObject)this);
                this.commonQueryDialog.setProcessor((IProcessor)processor);
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            this.commonQueryDialog.setWidth(510);
            this.commonQueryDialog.setHeight(300);
        }
        return this.commonQueryDialog;
    }

    private String buildErrorMsg(ArrayList msg) {
        StringBuffer retMsg = new StringBuffer();
        for (int i = 0; i < msg.size(); ++i) {
            retMsg.append(msg.get(i)).append("\r\n");
        }
        return retMsg.toString();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void afterMakeInvoice(String invoiceID, String pwyRetvalue) throws JSONException, EASBizException, BOSException {
        JSONObject value = new JSONObject(pwyRetvalue);
        JSONArray list = value.getJSONArray("lists");
        JSONObject invoiceJson = list.getJSONObject(0);
        String invoiceNo = invoiceJson.getString("fphm");
        String invoiceNum = invoiceJson.getString("fpdm");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("invoiceNo", invoiceNo);
        param.put("invoiceNum", invoiceNum);
        MakeInvoiceFactory.getRemoteInstance().make((IObjectPK)new ObjectUuidPK(invoiceID), param);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "company";
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
        this.uiHelper.bindPermission((AbstractButton)this.btnRemove, (IItemAction)this.actionRemove, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.btnTraceUp, (IItemAction)this.actionTraceUp, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.btnTraceDown, (IItemAction)this.actionTraceDown, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemRemove, (IItemAction)this.actionRemove, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemTraceUp, (IItemAction)this.actionTraceUp, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemTraceDown, (IItemAction)this.actionTraceDown, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menu_inv_vat, (IItemAction)this.actionInvoiceVat, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menu_inv_gen, (IItemAction)this.actionInvoiceGen, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menu_inv_Electric, (IItemAction)this.actionInvoiceElectric, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menu_req_vat, (IItemAction)this.actionReqVat, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menu_req_gen, (IItemAction)this.actionReqGen, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menu_req_Electric, (IItemAction)this.actionReqElectric, this.getServiceContext());
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(this.getUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.getOrgUnitInfo().getId()), "im_taxSeperation_new");
        super.actionImportData_actionPerformed(e);
    }
}

