/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.RowType;
import com.kingdee.eas.tm.im.client.MakeInvoiceEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;

public class MakeInvoiceAlgorithmUtil {
    private static final String TB_TAXCLASSNAME = "taxClassName";
    private static final String TB_PRODUCTNAME = "productName";
    private static final String TB_ENTRYNAME = "entryName";
    private static final String TB_SPECS = "specs";
    private static final String TB_MEASUREUNIT = "measureUnit";
    private static final String TB_MAKEINVOICEUNIT = "makeInvoiceUnit";
    private static final String TB_QUANTITY = "quantity";
    private static final String TB_NOTAXPRICE = "noTaxPrice";
    private static final String TB_PRICE = "price";
    private static final String TB_NOTAXAMT = "noTaxAmt";
    private static final String TB_TAXRATE = "taxRate";
    private static final String TB_TAXAMT = "taxAmt";
    private static final String TB_PRICETAX = "priceTax";
    private static final String TB_DISCOUNTRATE = "discountRate";
    private static final String TB_DISCOUNTAMT = "discountAmt";
    private static final String TB_TAXCLASSIFICATIONCODE = "taxClassificationCode";
    private static final String TB_HASPREFERENTIAL = "hasPreferential";
    private static final String TB_PREFERENTIALPOLICIES = "PreferentialPolicies";
    private static final String TB_BILLROWTYPE = "billRowType";
    private static final String TB_DEDUCTAMT = "deductAmt";
    private static final String TB_UNREDPRICETAX = "unRedPriceTax";
    private static final String TB_UNREDQTY = "unRedQty";
    private static final String TB_REDPRICETAX = "redPriceTax";
    private static final String TB_REDQTY = "redQty";
    private static final int AMT_PRECISION = 2;
    private static final int PRICE_PRECISION = 10;
    private static int QTY_PRECISION = 9;

    public static void entryCaculate(MakeInvoiceEditUI editUI, MakeInvoiceInfo editData, KDTEditEvent e, IRow row, String fieldName) {
        BigDecimal quantity = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_QUANTITY);
        BigDecimal noTaxPrice = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_NOTAXPRICE);
        BigDecimal price = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_PRICE);
        BigDecimal noTaxAmt = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_NOTAXAMT);
        BigDecimal taxRate = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_TAXRATE);
        BigDecimal taxAmt = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_TAXAMT);
        BigDecimal priceTax = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_PRICETAX);
        BigDecimal discountRate = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_DISCOUNTRATE);
        BigDecimal discountAmt = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_DISCOUNTAMT);
        int amtPrecision = 2;
        int ratePrecision = 2;
        if (editUI.chkIsContainTax.isSelected()) {
            if (TB_QUANTITY.equals(fieldName) || TB_PRICE.equals(fieldName)) {
                noTaxPrice = price.divide(taxRate.add(BigDecimal.ONE), 10, 4);
                priceTax = price.multiply(quantity).setScale(amtPrecision, 4);
                taxAmt = priceTax.divide(taxRate.add(BigDecimal.ONE), 10, 4).multiply(taxRate).setScale(amtPrecision, 4);
                noTaxAmt = priceTax.subtract(taxAmt).setScale(amtPrecision, 4);
                row.getCell(TB_NOTAXPRICE).setValue((Object)noTaxPrice);
                row.getCell(TB_PRICETAX).setValue((Object)priceTax);
                row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
                row.getCell(TB_NOTAXAMT).setValue((Object)noTaxAmt);
            } else if (TB_TAXRATE.equals(fieldName) || TB_ENTRYNAME.equals(fieldName) || TB_TAXCLASSIFICATIONCODE.equals(fieldName)) {
                noTaxPrice = price.divide(taxRate.add(BigDecimal.ONE), 10, 4);
                taxAmt = priceTax.divide(taxRate.add(BigDecimal.ONE), 10, 4).multiply(taxRate).setScale(amtPrecision, 4);
                noTaxAmt = priceTax.subtract(taxAmt).setScale(amtPrecision, 4);
                row.getCell(TB_NOTAXPRICE).setValue((Object)noTaxPrice);
                row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
                row.getCell(TB_NOTAXAMT).setValue((Object)noTaxAmt);
            } else if (TB_TAXAMT.equals(fieldName)) {
                if (priceTax.signum() == -1 && taxAmt.signum() == 1 || priceTax.signum() == 1 && taxAmt.signum() == -1) {
                    row.getCell(TB_TAXAMT).setValue(e.getOldValue());
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"ILLEG_TAXAMT"));
                    return;
                }
                if (taxAmt.abs().compareTo(priceTax.abs()) > 0) {
                    row.getCell(TB_TAXAMT).setValue(e.getOldValue());
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"LARGER_TAXAMT"));
                    return;
                }
                noTaxAmt = priceTax.subtract(taxAmt).setScale(amtPrecision, 4);
                row.getCell(TB_PRICETAX).setValue((Object)priceTax);
                row.getCell(TB_NOTAXAMT).setValue((Object)noTaxAmt);
            } else if (TB_PRICETAX.equals(fieldName)) {
                if (BigDecimal.ZERO.compareTo(quantity) != 0) {
                    if (MakeInvoiceAlgorithmUtil.isRedInvoice(editData)) {
                        if (BigDecimal.ZERO.compareTo(price) != 0) {
                            quantity = priceTax.divide(price, QTY_PRECISION, 4);
                            row.getCell(TB_QUANTITY).setValue((Object)quantity);
                        }
                    } else {
                        price = priceTax.divide(quantity, 10, 4);
                        noTaxPrice = price.divide(taxRate.add(BigDecimal.ONE), 10, 4);
                        row.getCell(TB_PRICE).setValue((Object)price);
                        row.getCell(TB_NOTAXPRICE).setValue((Object)noTaxPrice);
                    }
                }
                taxAmt = priceTax.divide(taxRate.add(BigDecimal.ONE), 10, 4).multiply(taxRate).setScale(amtPrecision, 4);
                noTaxAmt = priceTax.subtract(taxAmt).setScale(amtPrecision, 4);
                row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
                row.getCell(TB_NOTAXAMT).setValue((Object)noTaxAmt);
            }
        } else if (TB_QUANTITY.equals(fieldName) || TB_NOTAXPRICE.equals(fieldName)) {
            price = noTaxPrice.multiply(taxRate.add(BigDecimal.ONE)).setScale(10, 4);
            noTaxAmt = noTaxPrice.multiply(quantity).setScale(amtPrecision, 4);
            taxAmt = noTaxAmt.multiply(taxRate).setScale(amtPrecision, 4);
            priceTax = noTaxAmt.add(taxAmt).setScale(amtPrecision, 4);
            row.getCell(TB_PRICE).setValue((Object)price);
            row.getCell(TB_NOTAXAMT).setValue((Object)noTaxAmt);
            row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
            row.getCell(TB_PRICETAX).setValue((Object)priceTax);
        } else if (TB_TAXRATE.equals(fieldName) || TB_ENTRYNAME.equals(fieldName) || TB_TAXCLASSIFICATIONCODE.equals(fieldName)) {
            price = noTaxPrice.multiply(taxRate.add(BigDecimal.ONE)).setScale(10, 4);
            taxAmt = noTaxAmt.multiply(taxRate).setScale(amtPrecision, 4);
            priceTax = noTaxAmt.add(taxAmt).setScale(amtPrecision, 4);
            row.getCell(TB_PRICE).setValue((Object)price);
            row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
            row.getCell(TB_PRICETAX).setValue((Object)priceTax);
        } else if (TB_NOTAXAMT.equals(fieldName)) {
            if (MakeInvoiceAlgorithmUtil.isRedInvoice(editData)) {
                if (BigDecimal.ZERO.compareTo(noTaxPrice) != 0) {
                    quantity = noTaxAmt.divide(noTaxPrice, QTY_PRECISION, 4);
                    row.getCell(TB_QUANTITY).setValue((Object)quantity);
                }
            } else if (BigDecimal.ZERO.compareTo(quantity) != 0) {
                noTaxPrice = noTaxAmt.divide(quantity, 10, 4);
                price = noTaxPrice.multiply(taxRate.add(BigDecimal.ONE)).setScale(10, 4);
                row.getCell(TB_NOTAXPRICE).setValue((Object)noTaxPrice);
                row.getCell(TB_PRICE).setValue((Object)price);
            }
            taxAmt = noTaxAmt.multiply(taxRate).setScale(amtPrecision, 4);
            priceTax = noTaxAmt.add(taxAmt).setScale(amtPrecision, 4);
            row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
            row.getCell(TB_PRICETAX).setValue((Object)priceTax);
        } else if (TB_TAXAMT.equals(fieldName)) {
            if (noTaxAmt.signum() == -1 && taxAmt.signum() == 1 || noTaxAmt.signum() == 1 && taxAmt.signum() == -1) {
                row.getCell(TB_TAXAMT).setValue(e.getOldValue());
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"ILLEG_TAXAMT"));
                return;
            }
            priceTax = noTaxAmt.add(taxAmt).setScale(amtPrecision, 4);
            row.getCell(TB_NOTAXAMT).setValue((Object)noTaxAmt);
            row.getCell(TB_PRICETAX).setValue((Object)priceTax);
        }
        if (TB_DISCOUNTRATE.equals(fieldName) && row.getCell(TB_DISCOUNTRATE).getValue() != null) {
            discountAmt = noTaxAmt.multiply(discountRate).setScale(amtPrecision);
            row.getCell(TB_DISCOUNTAMT).setValue((Object)discountAmt);
        } else if (TB_DISCOUNTAMT.equals(fieldName) && row.getCell(TB_DISCOUNTAMT).getValue() != null && BigDecimal.ZERO.compareTo(noTaxAmt) != 0) {
            discountRate = discountAmt.divide(noTaxAmt, 10, 4).setScale(ratePrecision);
            row.getCell(TB_DISCOUNTRATE).setValue((Object)discountRate);
        }
    }

    public static void entryCaculateWithDeductAmt(MakeInvoiceEditUI editUI, MakeInvoiceInfo editData, KDTEditEvent e, IRow row, String fieldName) {
        BigDecimal quantity = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_QUANTITY);
        BigDecimal noTaxPrice = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_NOTAXPRICE);
        BigDecimal price = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_PRICE);
        BigDecimal noTaxAmt = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_NOTAXAMT);
        BigDecimal taxRate = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_TAXRATE);
        BigDecimal taxAmt = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_TAXAMT);
        BigDecimal priceTax = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_PRICETAX);
        BigDecimal deductAmt = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(row, TB_DEDUCTAMT);
        BigDecimal discountPriceTax = BigDecimal.ZERO;
        BigDecimal discountNoTaxAmt = BigDecimal.ZERO;
        BigDecimal discountTaxRate = BigDecimal.ZERO;
        IRow discountRow = null;
        if (RowType.DISCOUNTED_ROW.equals(row.getCell(TB_BILLROWTYPE).getValue())) {
            discountRow = editUI.getDetailTable().getRow(1);
            discountPriceTax = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(discountRow, TB_PRICETAX);
            discountNoTaxAmt = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(discountRow, TB_NOTAXAMT);
            discountTaxRate = MakeInvoiceAlgorithmUtil.getBigDecimal4Cell(discountRow, TB_TAXRATE);
        }
        int amtPrecision = 2;
        int ratePrecision = 2;
        if (editUI.chkIsContainTax.isSelected()) {
            if (TB_PRICETAX.equals(fieldName) || TB_TAXRATE.equals(fieldName) || TB_ENTRYNAME.equals(fieldName) || TB_TAXCLASSIFICATIONCODE.equals(fieldName) || TB_QUANTITY.equals(fieldName) || TB_PRICE.equals(fieldName) || TB_DEDUCTAMT.equals(fieldName)) {
                if ((TB_QUANTITY.equals(fieldName) || TB_PRICE.equals(fieldName)) && row.getCell(TB_QUANTITY).getValue() != null) {
                    priceTax = price.multiply(quantity).setScale(amtPrecision, 4);
                }
                taxAmt = deductAmt.abs().compareTo(priceTax.abs()) >= 0 ? BigDecimal.ZERO : priceTax.subtract(deductAmt).divide(taxRate.add(BigDecimal.ONE), 10, 4).multiply(taxRate).setScale(amtPrecision, 4);
                noTaxAmt = priceTax.subtract(taxAmt).setScale(amtPrecision, 4);
                if (!TB_QUANTITY.equals(fieldName) && MakeInvoiceAlgorithmUtil.isRedInvoice(editData)) {
                    quantity = priceTax.divide(price, QTY_PRECISION, 4);
                    row.getCell(TB_QUANTITY).setValue((Object)quantity);
                }
                if (BigDecimal.ZERO.compareTo(quantity) != 0) {
                    noTaxPrice = noTaxAmt.divide(quantity, 10, 4);
                    if (!(MakeInvoiceAlgorithmUtil.isRedInvoice(editData) || TB_QUANTITY.equals(fieldName) || TB_DEDUCTAMT.equals(fieldName) || TB_PRICE.equals(fieldName))) {
                        price = priceTax.divide(quantity, 10, 4);
                        row.getCell(TB_PRICE).setValue((Object)price);
                    }
                }
                row.getCell(TB_PRICETAX).setValue((Object)priceTax);
                row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
                row.getCell(TB_NOTAXAMT).setValue((Object)noTaxAmt);
                row.getCell(TB_NOTAXPRICE).setValue((Object)noTaxPrice);
                if (RowType.DISCOUNTED_ROW.equals(row.getCell(TB_BILLROWTYPE).getValue())) {
                    if (BigDecimal.ZERO.compareTo(priceTax.subtract(deductAmt.add(discountPriceTax.negate()))) >= 0) {
                        discountRow.getCell(TB_TAXAMT).setValue((Object)taxAmt.negate());
                        discountRow.getCell(TB_NOTAXAMT).setValue((Object)discountPriceTax.subtract(taxAmt.negate()));
                    } else {
                        BigDecimal discountTaxAmt = BigDecimal.ZERO;
                        discountNoTaxAmt = discountPriceTax.divide(BigDecimal.ONE.add(discountTaxRate), 2, 4);
                        discountTaxAmt = discountPriceTax.subtract(discountNoTaxAmt).setScale(2, 4);
                        discountRow.getCell(TB_TAXAMT).setValue((Object)discountTaxAmt);
                        discountRow.getCell(TB_NOTAXAMT).setValue((Object)discountNoTaxAmt);
                    }
                }
            }
        } else if (TB_NOTAXAMT.equals(fieldName) || TB_TAXRATE.equals(fieldName) || TB_ENTRYNAME.equals(fieldName) || TB_TAXCLASSIFICATIONCODE.equals(fieldName) || TB_QUANTITY.equals(fieldName) || TB_NOTAXPRICE.equals(fieldName) || TB_DEDUCTAMT.equals(fieldName)) {
            if ((TB_QUANTITY.equals(fieldName) || TB_NOTAXPRICE.equals(fieldName) || TB_DEDUCTAMT.equals(fieldName)) && row.getCell(TB_QUANTITY).getValue() != null) {
                noTaxAmt = noTaxPrice.multiply(quantity).setScale(amtPrecision, 4);
            }
            taxAmt = deductAmt.abs().compareTo(noTaxAmt.abs()) >= 0 ? BigDecimal.ZERO : noTaxAmt.subtract(deductAmt).multiply(taxRate).setScale(amtPrecision, 4);
            priceTax = noTaxAmt.add(taxAmt).setScale(amtPrecision, 4);
            if (!TB_QUANTITY.equals(fieldName) && MakeInvoiceAlgorithmUtil.isRedInvoice(editData)) {
                quantity = noTaxAmt.divide(noTaxPrice, QTY_PRECISION, 4);
                row.getCell(TB_QUANTITY).setValue((Object)quantity);
            }
            if (BigDecimal.ZERO.compareTo(quantity) != 0) {
                price = priceTax.divide(quantity, 10, 4);
                if (!(MakeInvoiceAlgorithmUtil.isRedInvoice(editData) || TB_QUANTITY.equals(fieldName) || TB_DEDUCTAMT.equals(fieldName) || TB_NOTAXPRICE.equals(fieldName))) {
                    noTaxPrice = noTaxAmt.divide(quantity, 10, 4);
                    row.getCell(TB_NOTAXPRICE).setValue((Object)noTaxPrice);
                }
            }
            row.getCell(TB_NOTAXAMT).setValue((Object)noTaxAmt);
            row.getCell(TB_TAXAMT).setValue((Object)taxAmt);
            row.getCell(TB_PRICETAX).setValue((Object)priceTax);
            row.getCell(TB_NOTAXPRICE).setValue((Object)noTaxPrice);
            row.getCell(TB_PRICE).setValue((Object)price);
            if (RowType.DISCOUNTED_ROW.equals(row.getCell(TB_BILLROWTYPE).getValue())) {
                if (BigDecimal.ZERO.compareTo(noTaxAmt.subtract(deductAmt.add(discountNoTaxAmt.negate()))) >= 0) {
                    discountRow.getCell(TB_TAXAMT).setValue((Object)taxAmt.negate());
                    discountRow.getCell(TB_PRICETAX).setValue((Object)discountNoTaxAmt.add(taxAmt.negate()));
                } else {
                    BigDecimal discountTaxAmt = BigDecimal.ZERO;
                    discountPriceTax = discountNoTaxAmt.multiply(BigDecimal.ONE.add(discountTaxRate)).setScale(2, 4);
                    discountTaxAmt = discountNoTaxAmt.multiply(discountTaxRate).setScale(2, 4);
                    discountRow.getCell(TB_TAXAMT).setValue((Object)discountTaxAmt);
                    discountRow.getCell(TB_PRICETAX).setValue((Object)discountPriceTax);
                }
            }
        }
    }

    private static BigDecimal getBigDecimal4Cell(IRow row, String column) {
        BigDecimal value = (BigDecimal)row.getCell(column).getValue();
        return value == null ? BigDecimal.ZERO : value;
    }

    private static boolean isRedInvoice(MakeInvoiceInfo editData) {
        return editData.getSrcSystem().equals((Object)InvoiceSrcSystem.REDINVOICE) || editData.getCopyBillId() != null && editData.isIsRedVoice();
    }
}

