/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.tm.im.MakeInvoiceReqAlgorithm;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.client.MakeInvoiceReqEditUI;
import com.kingdee.eas.tm.im.common.calculate.PropertyCalculator;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import java.math.BigDecimal;

public class MakeInvoiceReqAlgorithmForUI
extends MakeInvoiceReqAlgorithm {
    private MakeInvoiceReqEditUI editUI;
    private MakeInvoiceReqInfo info;

    public MakeInvoiceReqAlgorithmForUI(MakeInvoiceReqEditUI editUI, MakeInvoiceReqInfo info) {
        this.editUI = editUI;
        this.info = info;
    }

    @Override
    protected void init() {
        super.init();
        this.fieldMap.put("material", "materialNumber");
    }

    public void calByCurrencyChange() {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            this.calByCurrency(i);
        }
        this.calTotalFields();
    }

    public void calByExchangeRateChange() {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            this.calByExchangeRate(i);
        }
        this.calTotalFields();
    }

    public void calByTaxRateChange() {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            this.calByTaxRate(i);
        }
        this.calTotalFields();
    }

    public void calByTableChange(KDTEditEvent e) throws Exception {
        int i = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.editUI.getDetailTable() == null) {
            return;
        }
        if (i < 0 || colIndex < 0) {
            return;
        }
        if (this.editUI.getDetailTable().getRow(i) == null) {
            return;
        }
        String fieldName = this.editUI.getDetailTable().getColumnKey(colIndex);
        if ("unit".equalsIgnoreCase(fieldName)) {
            this.calByUnit(i);
        } else if ("qty".equalsIgnoreCase(fieldName)) {
            this.calByQty(i);
        } else if ("noTaxPrice".equalsIgnoreCase(fieldName)) {
            if (!this.editUI.btnComputeQty.isVisible()) {
                this.calByPriceComputeQty(i, e, this.editUI);
            } else {
                this.calByPrice(i);
            }
        } else if ("taxRate".equalsIgnoreCase(fieldName) || "taxClassificationCode".equalsIgnoreCase(fieldName)) {
            this.calByTaxRate(i);
        } else if ("price".equalsIgnoreCase(fieldName)) {
            if (!this.editUI.btnComputeQty.isVisible()) {
                this.calByTaxPriceComputeQty(i, e, this.editUI);
            } else {
                this.calByTaxPrice(i);
            }
        } else if ("discountType".equalsIgnoreCase(fieldName)) {
            this.calByDiscountType(i);
        } else if ("discountRate".equalsIgnoreCase(fieldName)) {
            this.calByDiscountRate(i);
        } else if ("discountAmount".equalsIgnoreCase(fieldName)) {
            this.calByDiscountAmount(i);
        } else if ("priceExcludingTax".equalsIgnoreCase(fieldName)) {
            if (!this.editUI.btnComputeQty.isVisible()) {
                this.calByAmountComputeQty(i, e, this.editUI);
            } else {
                this.calByAmount(i);
            }
        } else if ("tax".equalsIgnoreCase(fieldName)) {
            this.calByTax(i);
        } else if ("priceIncludingTax".equalsIgnoreCase(fieldName)) {
            if (!this.editUI.btnComputeQty.isVisible()) {
                this.calByTaxAmountComputeQty(i, e, this.editUI);
            } else {
                this.calByTaxAmount(i);
            }
        }
        this.calTotalFields();
    }

    @Override
    protected PropertyCalculator getPropertyCalculator(int i) {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row, this.fieldMap);
        return siCalculator;
    }

    @Override
    public int getEntrySize() {
        return this.editUI.getDetailTable().getRowCount();
    }

    @Override
    public boolean isInTax() {
        return this.editUI.chkIsInTax.isSelected();
    }

    @Override
    public ConvertModeEnum getConvertMode() {
        return this.info.getConvertMode();
    }

    @Override
    public BigDecimal getExchangeRate() {
        return this.obj2BigDecimal(this.editUI.txtExchangeRate.getText(), IMConstant.EXCHANGERATE_DEFAULT);
    }

    @Override
    public int getPricePrecision(int i) {
        int pricePrecision = 10;
        return this.getMaterial(i) == null ? pricePrecision : this.getMaterial(i).getPricePrecision();
    }

    public int getDefaultPricePrecision() {
        int pricePrecision = 10;
        return pricePrecision;
    }

    @Override
    public int getDefaultDiscountRatePrecision(int i) {
        Object value = this.editUI.paramMap.get("DISCOUNTRATEPRECISION");
        int discountRatePrecision = 4;
        if (value != null) {
            discountRatePrecision = Integer.parseInt(value.toString());
        }
        return discountRatePrecision;
    }

    @Override
    public int getAmountPrecision() {
        return this.editUI.amtPrecision;
    }

    @Override
    public int getLocalAmountPrecision() {
        return this.editUI.baseCurrencyInfo.getPrecision();
    }

    @Override
    protected void setTotalAmount(BigDecimal totalAmount) {
        this.editUI.txtPriceExcludingTax.setValue((Object)totalAmount);
    }

    @Override
    protected void setTotalTax(BigDecimal totalTax) {
        this.editUI.txtTax.setValue((Object)totalTax);
    }

    @Override
    protected boolean isBotp() {
        return this.editUI.isBotp;
    }

    @Override
    protected void setTotalTaxAmount(BigDecimal totalTaxAmount) {
        this.editUI.txtPriceIncludingTax.setValue((Object)totalTaxAmount);
    }

    @Override
    protected void setTotalLocalAmount(BigDecimal totalLocalAmount) {
        this.info.setPriceExcludingTaxLocal(totalLocalAmount);
    }

    @Override
    protected void setTotalLocalTax(BigDecimal totalLocalTax) {
        this.info.setTaxLocal(totalLocalTax);
    }

    @Override
    protected void setTotalLocalTaxAmount(BigDecimal totalLocalTaxAmount) {
        this.info.setPriceIncludingTaxLocal(totalLocalTaxAmount);
    }
}

