/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.tm.im.client.AbstractSelectVolumnInvoiceUI;
import com.kingdee.eas.tm.im.common.comm.msg.result.TaxCardInfo;
import com.kingdee.eas.tm.im.common.comm.msg.result.TaxCardVolumnInfo;
import com.kingdee.eas.tm.im.inv.OutputInvoiceType;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SelectVolumnInvoiceUI
extends AbstractSelectVolumnInvoiceUI {
    private static final Logger logger = CoreUIObject.getLogger(SelectVolumnInvoiceUI.class);
    private static final String TB_SELECTED = "selected";
    private static final String TB_INVOICETYPE = "invoiceType";
    private static final String TB_JSPH = "jsph";
    private static final String TB_JSPJH = "jspjh";
    private static final String TB_INVOICE_CODE = "invoice_code";
    private static final String TB_INVOICE_NUM = "invoice_num";
    private static final String TB_NEXT_INVOICE_NUM = "next_invoice_num";
    private static final String TB_VOL_NO = "vol_no";
    private static final String TB_REMAINDER = "remainder";
    private String[] lockColumns = new String[]{"jsph", "jspjh", "invoiceType", "invoice_code", "invoice_num", "next_invoice_num", "vol_no", "remainder"};
    List<String> settingIds = new ArrayList<String>();
    private Map<String, TaxCardInfo> setting2TaxCardMap = new HashMap<String, TaxCardInfo>();
    private Map<String, List<Map>> setting2InvoiceMap = new HashMap<String, List<Map>>();
    private Map<String, Integer> taxCard2Invoice = new HashMap<String, Integer>();
    private boolean isConfirm = false;
    private KDTEditAdapter volumnTableEditListener = null;
    private String selectedSettingId;
    private List errorMsg = new ArrayList();

    public void onLoad() throws Exception {
        this.volumnTable.checkParsed();
        super.onLoad();
        this.afterLoad();
    }

    protected void afterLoad() throws Exception {
        this.initContext();
        this.initControl();
        this.loadData();
        this.initEventLisenter();
    }

    protected void initContext() throws Exception {
        Map uiContext = this.getUIContext();
        this.settingIds = (List)uiContext.get("settingIds");
        this.setting2TaxCardMap = (Map)uiContext.get("setting2TaxCardMap");
        this.errorMsg = (List)uiContext.get("errorMsg");
        this.setting2InvoiceMap = (Map)uiContext.get("setting2InvoiceMap");
    }

    protected void initControl() throws Exception {
        this.volumnTable.getSelectManager().setSelectMode(2);
        this.volumnTable.getActionMap().remove("Paste");
        this.volumnTable.getActionMap().remove("Delete");
        this.setMergeColumn();
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.volumnTable.checkParsed();
            this.volumnTable.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.volumnTable.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[]{TB_INVOICETYPE};
    }

    protected void initEventLisenter() {
        if (this.volumnTableEditListener == null) {
            this.volumnTableEditListener = new KDTEditAdapter(){

                public void editValueChanged(KDTEditEvent e) {
                    SelectVolumnInvoiceUI.this.volumnTable_editValueChanged(e);
                }
            };
        }
        this.volumnTable.addKDTEditListener((KDTEditListener)this.volumnTableEditListener);
    }

    protected void volumnTable_editValueChanged(KDTEditEvent e) {
        IRow curRow = this.volumnTable.getRow(e.getRowIndex());
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        String fieldName = this.volumnTable.getColumnKey(colIndex);
        if (TB_SELECTED.equals(fieldName)) {
            Object value = curRow.getCell(TB_SELECTED).getValue();
            if (value == null || Boolean.FALSE.equals(value)) {
                curRow.getCell(TB_SELECTED).setValue((Object)Boolean.TRUE);
                TaxCardVolumnInfo selectTaxCardVolumnInfo = (TaxCardVolumnInfo)curRow.getUserObject();
                TaxCardInfo parent = selectTaxCardVolumnInfo.getParent();
                parent.setSelectedTaxCardVolumnInfo(selectTaxCardVolumnInfo);
                TaxCardVolumnInfo taxCardVolumnInfo = null;
                IRow row = null;
                for (int i = 0; i < this.volumnTable.getRowCount(); ++i) {
                    row = this.volumnTable.getRow(i);
                    taxCardVolumnInfo = (TaxCardVolumnInfo)row.getUserObject();
                    if (i == rowIndex || !taxCardVolumnInfo.getParent().equals(parent)) continue;
                    row.getCell(TB_SELECTED).setValue((Object)Boolean.FALSE);
                }
            } else {
                curRow.getCell(TB_SELECTED).setValue((Object)Boolean.FALSE);
                curRow.getCell(TB_SELECTED).setValue((Object)Boolean.TRUE);
            }
        }
    }

    protected void loadData() throws Exception {
        this.loadVolumnData();
        this.loadTipMessage();
    }

    protected void loadVolumnData() throws Exception {
        this.volumnTable.removeRows();
        TaxCardInfo taxCardInfo = null;
        String settingID2 = null;
        HashMap<String, String> uniqueMap = new HashMap<String, String>();
        String uniqueKey = null;
        List<Map> invoiceList = null;
        for (String settingID2 : this.setting2TaxCardMap.keySet()) {
            taxCardInfo = this.setting2TaxCardMap.get(settingID2);
            invoiceList = this.setting2InvoiceMap.get(settingID2);
            if (this.taxCard2Invoice.get(taxCardInfo.getId()) == null) {
                this.taxCard2Invoice.put(taxCardInfo.getId(), invoiceList.size());
            }
            if (uniqueMap.containsKey(uniqueKey = taxCardInfo.getUniqueKey())) {
                taxCardInfo.setNeedSetVolumn(false);
                continue;
            }
            uniqueMap.put(uniqueKey, uniqueKey);
            TaxCardVolumnInfo selectTaxCardVolumnInfo = taxCardInfo.getSelectedTaxCardVolumnInfo();
            List<TaxCardVolumnInfo> volumns = taxCardInfo.getVolumns();
            TaxCardVolumnInfo taxCardVolumnInfo = null;
            int size = volumns.size();
            for (int i = 0; i < size; ++i) {
                taxCardVolumnInfo = volumns.get(i);
                if (!OutputInvoiceType.OUTPUT_COMMON.equals((Object)taxCardVolumnInfo.getInvoiceType()) && !OutputInvoiceType.OUTPUT_COIL.equals((Object)taxCardVolumnInfo.getInvoiceType())) continue;
                IRow row = this.volumnTable.addRow();
                if (selectTaxCardVolumnInfo != null && selectTaxCardVolumnInfo.equals(taxCardVolumnInfo)) {
                    row.getCell(TB_SELECTED).setValue((Object)Boolean.TRUE);
                } else {
                    row.getCell(TB_SELECTED).setValue((Object)Boolean.FALSE);
                }
                row.getCell(TB_INVOICETYPE).setValue((Object)taxCardVolumnInfo.getInvoiceType().getAlias());
                row.getCell(TB_JSPH).setValue((Object)taxCardVolumnInfo.getJsph());
                row.getCell(TB_JSPJH).setValue((Object)taxCardVolumnInfo.getJspjh());
                row.getCell(TB_INVOICE_CODE).setValue((Object)taxCardVolumnInfo.getInvoice_code());
                row.getCell(TB_INVOICE_NUM).setValue((Object)taxCardVolumnInfo.getInvoice_num());
                row.getCell(TB_NEXT_INVOICE_NUM).setValue((Object)taxCardVolumnInfo.getNext_invoice_num());
                row.getCell(TB_VOL_NO).setValue((Object)taxCardVolumnInfo.getVol_no());
                row.getCell(TB_REMAINDER).setValue((Object)taxCardVolumnInfo.getRemainder());
                row.setUserObject((Object)taxCardVolumnInfo);
                this.setRowLock(row, this.lockColumns);
            }
        }
    }

    protected void setRowLock(IRow row, String[] lockColumns) {
        for (int i = 0; i < lockColumns.length; ++i) {
            row.getCell(lockColumns[i]).getStyleAttributes().setLocked(true);
        }
    }

    protected void loadTipMessage() throws BOSException {
        String msg = IMUtils.buildErrorMsg(this.errorMsg);
        this.tipMessage.setText(msg);
    }

    protected String checkRequireFields() throws Exception {
        String errorMsg = "";
        int rowCount = this.volumnTable.getRowCount();
        if (rowCount == 0) {
            this.isConfirm = false;
            errorMsg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"EMPTYROW");
        }
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.volumnTable.getRow(i);
            Object value = row.getCell(TB_SELECTED).getValue();
            if (value == null || !Boolean.TRUE.equals(value)) continue;
            TaxCardVolumnInfo volInfo = (TaxCardVolumnInfo)row.getUserObject();
            TaxCardInfo parent = volInfo.getParent();
            if (volInfo.getRemainder() >= this.taxCard2Invoice.get(parent.getId())) continue;
            errorMsg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"LeftInvoiceNumDoNotMake", (Object[])new Object[]{volInfo.getInvoice_num(), volInfo.getLast_invoice_num(), volInfo.getRemainder(), this.taxCard2Invoice.get(parent.getId())});
            this.isConfirm = false;
            return errorMsg;
        }
        return errorMsg;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = true;
        String errorMsg = this.checkRequireFields();
        if (StringUtils.isEmpty((String)errorMsg)) {
            this.actionExitCurrent_actionPerformed(e);
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)errorMsg);
        }
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }
}

