/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTipInfo;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipResourceUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipUtil;
import com.kingdee.eas.tm.im.SpecificInformationEntryCollection;
import com.kingdee.eas.tm.im.SpecificInformationEntryInfo;
import com.kingdee.eas.tm.im.SpecificInformationFactory;
import com.kingdee.eas.tm.im.SpecificInformationInfo;
import com.kingdee.eas.tm.im.TMProvCityRegionBizPromptBox;
import com.kingdee.eas.tm.im.client.AbstractSpecificInformationEditUI;
import com.kingdee.eas.tm.im.common.uihelper.SpecificServiceFieldProperties;
import com.kingdee.eas.tm.im.common.uihelper.SpecificServiceUtils;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.enums.EnumUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SpecificInformationEditUI
extends AbstractSpecificInformationEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SpecificInformationEditUI.class);
    private String specServiceType = null;
    private static final String NUMFORMAT = "###,##0.##########";
    protected int amtPrecision = 2;
    protected int pricePrecision = 2;
    private static final String TD_ADDRESS = "address";
    private static final String TD_ISCROSSCITY = "isCrosscity";
    private static final String TD_STRATDATE = "startDate";
    private static final String TD_ENDDATE = "endDate";
    private static final String TD_TAXPRICE = "taxPrice";
    private static final String TD_TAXAMOUNT = "taxAmount";
    private static final String TD_AREAUNIT = "areaUnit";
    private static final String AREAUNIT_ENUM = "com.kingdee.eas.tm.im.AreaUnitEnum";
    private static final String TD_TRANSTYPE = "transType";
    private static final String TRANSTYPE_ENUM = "com.kingdee.eas.tm.im.TransTypeEnum";
    private static final String ADDRESS_QUERY = "com.kingdee.eas.tm.im.app.ProvinceCityRegionQuery";
    private static final String[] SPECINFO_BOOLEAN_FIELD = new String[]{"isCrosscity"};
    private static final String[] SPECINFOENTRY_BOOLEAN_FIELD = new String[0];
    private static final String TD_SPECINFODATA = "SpecInfoData";
    private KDTEditAdapter specInfoTableChange = null;
    private KDTEditAdapter specInfoEntriesTableChange = null;

    public SpecificInformationEditUI() throws Exception {
    }

    public SpecificInformationEditUI(String specServiceType) throws Exception {
    }

    public void onLoad() throws Exception {
        this.kdtSpecInfo.checkParsed();
        this.kdtSpecInfoEntries.checkParsed();
        this.initParams();
        super.onLoad();
        this.initEntryEditor();
        this.setComponentVisibleBySpecificService(this.specServiceType);
        this.addCustomerToolTip();
    }

    @Override
    public void loadFields() {
        this.updateEditData();
        this.removeListener();
        super.loadFields();
        this.initListeners();
        this.setComponentVisibleBySpecificService(this.specServiceType);
        this.loadTableData();
    }

    protected void loadTableData() {
        try {
            SpecificServiceFieldProperties field;
            IRow row = null;
            Object obj = null;
            ArrayList<String> specFieldList = new ArrayList<String>();
            HashMap<String, SpecificServiceFieldProperties> specFieldMap = new HashMap<String, SpecificServiceFieldProperties>();
            ArrayList<String> specEntryFieldList = new ArrayList<String>();
            HashMap<String, SpecificServiceFieldProperties> specEntryFieldMap = new HashMap<String, SpecificServiceFieldProperties>();
            ArrayList<SpecificServiceFieldProperties> fields = SpecificServiceUtils.specServiceFieldMap.get(this.specServiceType);
            if (fields != null) {
                for (SpecificServiceFieldProperties fieldInfo : fields) {
                    if ("kDPSpeInfo".equals(fieldInfo.getPanelName())) {
                        specFieldList.add(fieldInfo.getSystemName());
                        specFieldMap.put(fieldInfo.getSystemName(), fieldInfo);
                        continue;
                    }
                    if (!"kDPSpeInfoEntries".equals(fieldInfo.getPanelName())) continue;
                    specEntryFieldList.add(fieldInfo.getSystemName());
                    specEntryFieldMap.put(fieldInfo.getSystemName(), fieldInfo);
                }
            }
            if (this.editData.get(TD_SPECINFODATA) != null && this.editData.get(TD_SPECINFODATA) instanceof String) {
                JSONObject specInfoData = new JSONObject((String)this.editData.get(TD_SPECINFODATA));
                if (specFieldList.size() > 0) {
                    row = this.kdtSpecInfo.addRow();
                }
                int size = specFieldList.size();
                for (int i = 0; i < size; ++i) {
                    field = (SpecificServiceFieldProperties)specFieldMap.get(specFieldList.get(i));
                    obj = specInfoData.has(field.getTransName()) ? SpecificServiceUtils.strTransformObject(field.getDataType(), specInfoData.getString(field.getTransName())) : null;
                    if (row == null || field == null || row.getCell(field.getSystemName()) == null) continue;
                    row.getCell(field.getSystemName()).setValue(obj);
                }
            }
            SpecificInformationEntryCollection entrys = this.editData.getEntries();
            JSONObject specInfoEntryData = null;
            int rowCount = this.kdtSpecInfoEntries.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                row = this.kdtSpecInfoEntries.getRow(i);
                if (row.getCell(TD_SPECINFODATA).getValue() == null || !(row.getCell(TD_SPECINFODATA).getValue() instanceof String)) continue;
                specInfoEntryData = new JSONObject((String)row.getCell(TD_SPECINFODATA).getValue());
                int size = specEntryFieldList.size();
                for (int j = 0; j < size; ++j) {
                    field = (SpecificServiceFieldProperties)specEntryFieldMap.get(specEntryFieldList.get(j));
                    obj = specInfoEntryData.has(field.getTransName()) ? SpecificServiceUtils.strTransformObject(field.getDataType(), specInfoEntryData.getString(field.getTransName())) : null;
                    if (row == null || field == null || row.getCell(field.getSystemName()) == null) continue;
                    row.getCell(field.getSystemName()).setValue(obj);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.afterStoreFields();
        this.editData.setSyncOldValue(true);
        this.editData.setSyncOldValue(false);
    }

    protected void afterStoreFields() {
        Object obj;
        SpecificServiceFieldProperties field;
        IRow row;
        HashMap<String, Object> specInfoData = new HashMap<String, Object>();
        HashMap<String, Object> specInfoEntryData = new HashMap<String, Object>();
        ArrayList<String> specFieldList = new ArrayList<String>();
        HashMap<String, SpecificServiceFieldProperties> specFieldMap = new HashMap<String, SpecificServiceFieldProperties>();
        ArrayList<String> specEntryFieldList = new ArrayList<String>();
        HashMap<String, SpecificServiceFieldProperties> specEntryFieldMap = new HashMap<String, SpecificServiceFieldProperties>();
        ArrayList<SpecificServiceFieldProperties> fields = SpecificServiceUtils.specServiceFieldMap.get(this.specServiceType);
        if (fields != null) {
            for (SpecificServiceFieldProperties fieldInfo : fields) {
                if ("kDPSpeInfo".equals(fieldInfo.getPanelName())) {
                    specFieldList.add(fieldInfo.getSystemName());
                    specFieldMap.put(fieldInfo.getSystemName(), fieldInfo);
                    continue;
                }
                if (!"kDPSpeInfoEntries".equals(fieldInfo.getPanelName())) continue;
                specEntryFieldList.add(fieldInfo.getSystemName());
                specEntryFieldMap.put(fieldInfo.getSystemName(), fieldInfo);
            }
        }
        int size = specFieldList.size();
        for (int i = 0; i < size; ++i) {
            row = this.kdtSpecInfo.getRow(0);
            field = (SpecificServiceFieldProperties)specFieldMap.get(specFieldList.get(i));
            obj = row.getCell((String)specFieldList.get(i)).getValue();
            obj = SpecificServiceUtils.objTransformString(field.getDataType(), obj);
            specInfoData.put(field.getTransName(), obj);
            if (!field.getSystemName().contains("field")) continue;
            this.editData.put(field.getSystemName(), obj);
        }
        this.editData.put(TD_SPECINFODATA, Kson.getGson().toJson(specInfoData));
        SpecificInformationEntryCollection entrys = this.editData.getEntries();
        int rowCount = this.kdtSpecInfoEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtSpecInfoEntries.getRow(i);
            specInfoEntryData = new HashMap();
            int size2 = specEntryFieldList.size();
            for (int j = 0; j < size2; ++j) {
                field = (SpecificServiceFieldProperties)specEntryFieldMap.get(specEntryFieldList.get(j));
                obj = row.getCell((String)specEntryFieldList.get(j)).getValue();
                obj = SpecificServiceUtils.objTransformString(field.getDataType(), obj);
                specInfoEntryData.put(field.getTransName(), obj);
            }
            entrys.get(i).put(TD_SPECINFODATA, Kson.getGson().toJson(specInfoEntryData));
        }
    }

    private void initParams() {
        Map uiCtx = this.getUIContext();
        this.specServiceType = (String)uiCtx.get("specServiceType");
    }

    private void updateEditData() {
        Map uiCtx = this.getUIContext();
        if (OprtState.ADDNEW.equals(this.getOprtState()) && uiCtx.get("editData") != null) {
            this.editData = (SpecificInformationInfo)uiCtx.get("editData");
        }
    }

    protected void initEntryEditor() {
        this.setProvCityRegionPrmtEditor(this.kdtSpecInfo, TD_ADDRESS, ADDRESS_QUERY, true);
        this.setBooleanEditor(this.kdtSpecInfo, TD_ISCROSSCITY);
        this.setDateEditor(this.kdtSpecInfo, TD_STRATDATE);
        this.setDateEditor(this.kdtSpecInfo, TD_ENDDATE);
        this.setBigDecimalEditor(this.kdtSpecInfo, TD_TAXPRICE, this.pricePrecision);
        this.setBigDecimalEditor(this.kdtSpecInfo, TD_TAXAMOUNT, this.amtPrecision);
        this.setEnumEditor(this.kdtSpecInfo, TD_AREAUNIT, AREAUNIT_ENUM);
        this.setEnumEditor(this.kdtSpecInfoEntries, TD_TRANSTYPE, TRANSTYPE_ENUM);
    }

    public void setComponentVisibleBySpecificService(String specServiceType) {
        int i;
        this.specServiceType = specServiceType;
        for (i = 0; i < this.kdtSpecInfo.getColumnCount(); ++i) {
            this.kdtSpecInfo.getColumn(i).getStyleAttributes().setHided(true);
        }
        for (i = 0; i < this.kdtSpecInfoEntries.getColumnCount(); ++i) {
            this.kdtSpecInfoEntries.getColumn(i).getStyleAttributes().setHided(true);
        }
        ArrayList<SpecificServiceFieldProperties> fields = SpecificServiceUtils.specServiceFieldMap.get(specServiceType);
        if (fields != null) {
            for (SpecificServiceFieldProperties fieldInfo : fields) {
                if ("kDPSpeInfo".equals(fieldInfo.getPanelName())) {
                    this.kdtSpecInfo.getColumn(fieldInfo.getSystemName()).getStyleAttributes().setHided(false);
                    this.kdtSpecInfo.getColumn(fieldInfo.getSystemName()).setRequired(fieldInfo.isRequired());
                    this.kdtSpecInfo.getHead().getRow(0).getCell(this.kdtSpecInfo.getColumnIndex(fieldInfo.getSystemName())).setValue((Object)fieldInfo.getDisplayName());
                    continue;
                }
                if (!"kDPSpeInfoEntries".equals(fieldInfo.getPanelName())) continue;
                this.kdtSpecInfoEntries.getColumn(fieldInfo.getSystemName()).getStyleAttributes().setHided(false);
                this.kdtSpecInfoEntries.getColumn(fieldInfo.getSystemName()).setRequired(fieldInfo.isRequired());
                this.kdtSpecInfoEntries.getHead().getRow(0).getCell(this.kdtSpecInfoEntries.getColumnIndex(fieldInfo.getSystemName())).setValue((Object)fieldInfo.getDisplayName());
            }
        }
    }

    public void clearKdTables() {
        int i;
        IRow row = null;
        this.kdtSpecInfo.removeRows();
        row = this.kdtSpecInfo.addRow();
        for (i = 0; i < SPECINFO_BOOLEAN_FIELD.length; ++i) {
            row.getCell(SPECINFO_BOOLEAN_FIELD[i]).setValue((Object)false);
        }
        this.kdtSpecInfoEntries.removeRows();
        row = this.kdtSpecInfoEntries.addRow();
        for (i = 0; i < SPECINFOENTRY_BOOLEAN_FIELD.length; ++i) {
            row.getCell(SPECINFOENTRY_BOOLEAN_FIELD[i]).setValue((Object)false);
        }
        this.editData.put(TD_SPECINFODATA, null);
        this.editData.getEntries().clear();
        this.editData.getEntries().add(new SpecificInformationEntryInfo());
        this.addCustomerToolTip();
        super.loadFields();
    }

    private void removeListener() {
        if (this.specInfoTableChange != null) {
            this.kdtSpecInfo.removeKDTEditListener((KDTEditListener)this.specInfoTableChange);
        }
        if (this.specInfoEntriesTableChange != null) {
            this.kdtSpecInfoEntries.removeKDTEditListener((KDTEditListener)this.specInfoEntriesTableChange);
        }
    }

    private void initListeners() {
        if (this.specInfoTableChange == null) {
            this.specInfoTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        if (IMUtils.objectEquals(e.getOldValue(), e.getValue())) {
                            return;
                        }
                        SpecificInformationEditUI.this.kdtSpecInfo_ChangedStopped(e);
                    }
                    catch (Exception exc) {
                        SpecificInformationEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtSpecInfo.addKDTEditListener((KDTEditListener)this.specInfoTableChange);
        if (this.specInfoEntriesTableChange == null) {
            this.specInfoEntriesTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        if (IMUtils.objectEquals(e.getOldValue(), e.getValue())) {
                            return;
                        }
                        SpecificInformationEditUI.this.kdtSpecInfoEntries_ChangedStopped(e);
                    }
                    catch (Exception exc) {
                        SpecificInformationEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtSpecInfoEntries.addKDTEditListener((KDTEditListener)this.specInfoEntriesTableChange);
    }

    protected void kdtSpecInfo_ChangedStopped(KDTEditEvent e) throws BOSException {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.kdtSpecInfo.getRow(rowIndex);
        String fieldName = this.kdtSpecInfo.getColumnKey(colIndex);
        if ("06".equals(this.specServiceType)) {
            if (TD_STRATDATE.equals(fieldName)) {
                Date endDate = (Date)row.getCell(TD_ENDDATE).getValue();
                if (e.getValue() != null && endDate != null && ((Date)e.getValue()).after(endDate)) {
                    row.getCell(fieldName).setValue(e.getOldValue());
                }
            } else if (TD_ENDDATE.equals(fieldName)) {
                Date beginDate = (Date)row.getCell(TD_STRATDATE).getValue();
                if (e.getValue() != null && beginDate != null && ((Date)e.getValue()).before(beginDate)) {
                    row.getCell(fieldName).setValue(e.getOldValue());
                }
            }
        }
    }

    protected void kdtSpecInfoEntries_ChangedStopped(KDTEditEvent e) throws BOSException {
    }

    private void setEnumEditor(KDTable table, String columeName, String enumClazz) {
        KDComboBox enumEditor = new KDComboBox();
        Object[] objs = EnumUtils.getEnumList((String)enumClazz).toArray();
        enumEditor.addItems(objs);
        table.getColumn(columeName).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)enumEditor));
    }

    private void setBigDecimalEditor(KDTable table, String column, int precision) {
        KDFormattedTextField formattedField = new KDFormattedTextField();
        formattedField.setDataType(1);
        formattedField.setPrecision(precision);
        formattedField.setNegatived(false);
        formattedField.setRemoveingZeroInEdit(true);
        formattedField.setRemoveingZeroInDispaly(true);
        formattedField.setMaximumValue((Comparable)Integer.valueOf(100000000));
        formattedField.setHorizontalAlignment(4);
        table.getColumn(column).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedField));
        table.getColumn(column).getStyleAttributes().setNumberFormat(NUMFORMAT);
        table.getColumn(column).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void setBooleanEditor(KDTable table, String columeName) {
        KDCheckBox checkBox = new KDCheckBox();
        table.getColumn(columeName).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)checkBox));
    }

    private void setDateEditor(KDTable table, String columeName) {
        KDDatePicker datePk = new KDDatePicker();
        table.getColumn(columeName).setEditor((ICellEditor)new KDTDefaultCellEditor(datePk));
        table.getColumn(columeName).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    private void setProvCityRegionPrmtEditor(KDTable table, String column, String queryInfo, boolean isSupportText) {
        TMProvCityRegionBizPromptBox prmt = new TMProvCityRegionBizPromptBox();
        prmt.setQueryInfo(queryInfo);
        prmt.setEditFormat("$number$");
        prmt.setDisplayFormat("$name$");
        prmt.setCommitFormat("$number$");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("provinceCityRegionNumber"));
        sic.add(new SelectorItemInfo("provinceCityRegionName"));
        sic.add(new SelectorItemInfo("provinceCityRegionId"));
        sic.add(new SelectorItemInfo("region.name"));
        sic.add(new SelectorItemInfo("region.number"));
        sic.add(new SelectorItemInfo("region.id"));
        sic.add(new SelectorItemInfo("city.name"));
        sic.add(new SelectorItemInfo("city.number"));
        sic.add(new SelectorItemInfo("city.id"));
        sic.add(new SelectorItemInfo("province.name"));
        sic.add(new SelectorItemInfo("province.number"));
        sic.add(new SelectorItemInfo("province.id"));
        prmt.setSelectorCollection(sic);
        prmt.setEnabledMultiSelection(false);
        if (isSupportText) {
            prmt.setCommitParser(null);
        }
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        table.getColumn(column).setRenderer((IBasicRender)avr);
        table.getColumn(column).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmt));
    }

    private void setPrmtEditor(KDTable table, String column, String queryInfo, boolean isSupportText) {
        KDBizPromptBox prmt = new KDBizPromptBox();
        prmt.setQueryInfo(queryInfo);
        prmt.setEditFormat("$number$");
        prmt.setDisplayFormat("$name$");
        prmt.setCommitFormat("$number$");
        if (isSupportText) {
            prmt.setCommitParser(null);
        }
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        table.getColumn(column).setRenderer((IBasicRender)avr);
        table.getColumn(column).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmt));
    }

    protected void addCustomerToolTip() {
        int i;
        ArrayList<SpecificServiceFieldProperties> specFieldList = new ArrayList<SpecificServiceFieldProperties>();
        ArrayList<SpecificServiceFieldProperties> specEntryFieldList = new ArrayList<SpecificServiceFieldProperties>();
        ArrayList<SpecificServiceFieldProperties> fields = SpecificServiceUtils.specServiceFieldMap.get(this.specServiceType);
        if (fields != null) {
            for (SpecificServiceFieldProperties fieldInfo : fields) {
                if ("kDPSpeInfo".equals(fieldInfo.getPanelName())) {
                    specFieldList.add(fieldInfo);
                    continue;
                }
                if (!"kDPSpeInfoEntries".equals(fieldInfo.getPanelName())) continue;
                specEntryFieldList.add(fieldInfo);
            }
        }
        ArrayList<TMToolTipInfo> infoList = new ArrayList<TMToolTipInfo>();
        for (i = 0; i < specFieldList.size(); ++i) {
            infoList.add(new TMToolTipInfo(((SpecificServiceFieldProperties)specFieldList.get(i)).getSystemName(), (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get(((SpecificServiceFieldProperties)specFieldList.get(i)).getToolTipFieldName()), ""));
        }
        if (infoList.size() > 0) {
            TMToolTipUtil.setToolTipInfo((JComponent)this.kdtSpecInfo, infoList);
            infoList.clear();
        }
        for (i = 0; i < specEntryFieldList.size(); ++i) {
            infoList.add(new TMToolTipInfo(((SpecificServiceFieldProperties)specEntryFieldList.get(i)).getSystemName(), (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get(((SpecificServiceFieldProperties)specEntryFieldList.get(i)).getToolTipFieldName()), ""));
        }
        if (infoList.size() > 0) {
            TMToolTipUtil.setToolTipInfo((JComponent)this.kdtSpecInfoEntries, infoList);
            infoList.clear();
        }
    }

    public String checkRequiredFields() {
        Object obj;
        SpecificServiceFieldProperties field;
        IRow row;
        StringBuffer sb = new StringBuffer();
        ArrayList<String> specFieldList = new ArrayList<String>();
        HashMap<String, SpecificServiceFieldProperties> specFieldMap = new HashMap<String, SpecificServiceFieldProperties>();
        ArrayList<String> specEntryFieldList = new ArrayList<String>();
        HashMap<String, SpecificServiceFieldProperties> specEntryFieldMap = new HashMap<String, SpecificServiceFieldProperties>();
        ArrayList<SpecificServiceFieldProperties> fields = SpecificServiceUtils.specServiceFieldMap.get(this.specServiceType);
        if (fields != null) {
            for (SpecificServiceFieldProperties fieldInfo : fields) {
                if ("kDPSpeInfo".equals(fieldInfo.getPanelName()) && fieldInfo.isRequired()) {
                    specFieldList.add(fieldInfo.getSystemName());
                    specFieldMap.put(fieldInfo.getSystemName(), fieldInfo);
                    continue;
                }
                if (!"kDPSpeInfoEntries".equals(fieldInfo.getPanelName()) || !fieldInfo.isRequired()) continue;
                specEntryFieldList.add(fieldInfo.getSystemName());
                specEntryFieldMap.put(fieldInfo.getSystemName(), fieldInfo);
            }
        }
        IMUtils.removeNullRow(this.kdtSpecInfoEntries, null);
        int size = specFieldList.size();
        for (int i = 0; i < size; ++i) {
            row = this.kdtSpecInfo.getRow(0);
            field = (SpecificServiceFieldProperties)specFieldMap.get(specFieldList.get(i));
            obj = row.getCell((String)specFieldList.get(i)).getValue();
            obj = SpecificServiceUtils.objTransformString(field.getDataType(), obj);
            if (obj != null) continue;
            sb.append("\u3001" + field.getDisplayName());
        }
        if (sb.length() > 0) {
            sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.tm.im.SpecificInformationResource", (String)"SpeInformation")).append(sb.substring(1)).append(EASResource.getString((String)"com.kingdee.eas.tm.im.SpecificInformationResource", (String)"NOTNULL"));
        }
        StringBuffer fieldNames = new StringBuffer();
        int rowCount = this.kdtSpecInfoEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            fieldNames.setLength(0);
            row = this.kdtSpecInfoEntries.getRow(i);
            int size2 = specEntryFieldList.size();
            for (int j = 0; j < size2; ++j) {
                field = (SpecificServiceFieldProperties)specEntryFieldMap.get(specEntryFieldList.get(j));
                obj = row.getCell((String)specEntryFieldList.get(j)).getValue();
                obj = SpecificServiceUtils.objTransformString(field.getDataType(), obj);
                if (obj != null) continue;
                fieldNames.append("\u3001" + field.getDisplayName());
            }
            if (fieldNames.length() <= 0) continue;
            sb.append(this.getEntryMsg(i + 1, fieldNames.substring(1)));
        }
        if (specEntryFieldList.size() > 0 && this.kdtSpecInfoEntries.getRowCount() == 0) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.SpecificInformationResource", (String)"SpeInformationEntry_NOTEMPTY"));
        }
        return sb.toString();
    }

    private String getEntryMsg(int i, String fields) {
        return EASResource.getString((String)"com.kingdee.eas.tm.im.SpecificInformationResource", (String)"ENTRYNULL_MSG", (Object[])new Object[]{i, fields});
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        SpecificInformationEntryInfo entry = new SpecificInformationEntryInfo();
        return entry;
    }

    protected IObjectValue createNewData() {
        Map uiCtx = this.getUIContext();
        if (OprtState.ADDNEW.equals(this.getOprtState()) && uiCtx.get("editData") != null) {
            return (SpecificInformationInfo)uiCtx.get("editData");
        }
        SpecificInformationInfo specInfo = new SpecificInformationInfo();
        IRow row = this.kdtSpecInfo.addRow();
        for (int i = 0; i < SPECINFO_BOOLEAN_FIELD.length; ++i) {
            row.getCell(SPECINFO_BOOLEAN_FIELD[i]).setValue((Object)false);
        }
        specInfo.getEntries().add((SpecificInformationEntryInfo)this.createNewDetailData(this.kdtSpecInfoEntries));
        specInfo.setId(BOSUuid.create((String)"5E6919D3"));
        return specInfo;
    }

    protected KDTable getDetailTable() {
        return this.kdtSpecInfoEntries;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SpecificInformationFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        return sic;
    }
}

