/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTipInfo;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipResourceUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipUtil;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.IFullElectricInvoice;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.im.IIncomeInvoice;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.ITaxTransfer;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.TaxTransferEntryCollection;
import com.kingdee.eas.tm.im.TaxTransferEntryInfo;
import com.kingdee.eas.tm.im.TaxTransferFactory;
import com.kingdee.eas.tm.im.TaxTransferInfo;
import com.kingdee.eas.tm.im.TaxTransferInvoiceType;
import com.kingdee.eas.tm.im.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.basedata.IncomeTypeInfo;
import com.kingdee.eas.tm.im.basedata.TaxTransferItemFactory;
import com.kingdee.eas.tm.im.basedata.TaxTransferItemInfo;
import com.kingdee.eas.tm.im.client.AbstractTaxTransferEditUI;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.im.common.print.IMPrintCommonDataProvider;
import com.kingdee.eas.tm.im.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.DateUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TaxTransferEditUI
extends AbstractTaxTransferEditUI
implements IPermSupport4EditUI {
    private static final String PROPORTION = "proportion";
    private static final String AMOUNT = "amount";
    private static final String TAX = "tax";
    private static final String INVOICETYPE = "invoiceType";
    private static final String INVOICECODE = "invoiceCode";
    private static final String INVOICENUMBER = "invoiceNumber";
    private static final Logger logger = CoreUIObject.getLogger(TaxTransferEditUI.class);
    private static final String INCOMETYPE_QUERY = "com.kingdee.eas.tm.im.basedata.F7IncomeTypeQuery";
    private static final String[] PRICE_FIELD = new String[]{"tax", "amount"};
    public static final Color FOOTROWCOLOR = new Color(252, 255, 206);
    private static final String NUMFORMAT = "###,##0.##########";
    private KDTEditAdapter entryTableChange = null;
    private DataChangeListener prmtCompanyChange = null;
    private EditUIHelper uiHelper = new EditUIHelper((EditUI)this);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtEntries.getActionMap().remove("Paste");
        this.initBtnStatus();
        this.initEntryTable();
        this.initEntries();
        this.initF7();
        this.handleLineOpt();
        this.addCustomerToolTip();
    }

    protected void addCustomerToolTip() {
        TMToolTipUtil.setToolTipInfo((JComponent)this.contTransferDate, (TMToolTipInfo)new TMToolTipInfo("contTransferDate", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("TAXTRANSFER_TransferDate"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.contTaxPeriod, (TMToolTipInfo)new TMToolTipInfo("contTaxPeriod", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("TAXTRANSFER_TaxPeriod"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.contTotalTaxAmount, (TMToolTipInfo)new TMToolTipInfo("contTotalTaxAmount", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("TAXTRANSFER_TotalTaxAmount"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.contTaxTransferItem, (TMToolTipInfo)new TMToolTipInfo("contTaxTransferItem", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("TAXTRANSFER_TaxTransferItem"), ""));
        ArrayList<TMToolTipInfo> infoList = new ArrayList<TMToolTipInfo>();
        infoList.add(new TMToolTipInfo("incomeType", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("TAXTRANSFER_incomeType"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.getDetailTable(), infoList);
    }

    private void handleLineOpt() {
        AbstractAction actionTable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TaxTransferEditUI.this.getDetailTable() != null) {
                    TaxTransferEditUI.this.getDetailTable().removeRow(TaxTransferEditUI.this.getDetailTable().getRowCount() - 1);
                    TaxTransferEditUI.this.addLine(TaxTransferEditUI.this.getDetailTable());
                }
            }
        };
        boolean tableKeyEnabled = this.actionAddLine.isEnabled();
        this.uiHelper.initTableKeyStroke(this.getDetailTable(), tableKeyEnabled, actionTable);
    }

    private void initEntryTable() {
        ArrayList ids = (ArrayList)this.getUIContext().get("ids");
        String invoiceBosType = (String)this.getUIContext().get("invoiceBosType");
        if (!CollectionUtil.isEmpty(ids)) {
            if ("AF83503C".equals(invoiceBosType)) {
                this.initFullElecInovice(ids);
            } else {
                this.initIncomeInovice(ids);
            }
            this.kdtEntries.getColumn(INVOICETYPE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TAX).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(INVOICECODE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(INVOICENUMBER).getStyleAttributes().setLocked(true);
            this.prmtCompany.setEnabled(false);
        }
    }

    private void initIncomeInovice(ArrayList ids) {
        HashSet set = new HashSet(ids);
        String companyId = (String)this.getUIContext().get("companyId");
        IncomeInvoiceInfo incomeInvoiceInfo = null;
        TaxTransferEntryInfo taxTransferEntryInfo = null;
        try {
            IIncomeInvoice incomeInvoice = IncomeInvoiceFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("incomeType.name"));
            sic.add(new SelectorItemInfo("taxTransferItem.id"));
            sic.add(new SelectorItemInfo("taxTransferItem.name"));
            sic.add(new SelectorItemInfo("taxTransferItem.number"));
            viewInfo.setSelector(sic);
            CoreBaseCollection coll = incomeInvoice.getCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                TaxTransferEntryCollection taxTransColl = new TaxTransferEntryCollection();
                BigDecimal totalTaxAmount = new BigDecimal("0.00");
                for (int i = 0; i < coll.size(); ++i) {
                    taxTransferEntryInfo = new TaxTransferEntryInfo();
                    incomeInvoiceInfo = (IncomeInvoiceInfo)coll.get(i);
                    if (PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)incomeInvoiceInfo.getInvoiceType())) {
                        taxTransferEntryInfo.setTaxTransferInvoiceType(TaxTransferInvoiceType.INVOICETYPE_SPECIAL_PAPER);
                    } else if (PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)incomeInvoiceInfo.getInvoiceType())) {
                        taxTransferEntryInfo.setTaxTransferInvoiceType(TaxTransferInvoiceType.INVOICETYPE_ELECTRONIC_SPECIAL);
                    }
                    taxTransferEntryInfo.setInvoiceCode(incomeInvoiceInfo.getInvoiceCode());
                    taxTransferEntryInfo.setInvoiceNumber(incomeInvoiceInfo.getInvoiceNumber());
                    taxTransferEntryInfo.setTax(incomeInvoiceInfo.getTax());
                    taxTransferEntryInfo.setIncomeType(incomeInvoiceInfo.getIncomeType());
                    BigDecimal unTransferTaxAmt = incomeInvoiceInfo.getUnTransferTaxAmt();
                    BigDecimal transferTaxAmt = null == incomeInvoiceInfo.getTransferTaxAmt() ? BigDecimal.ZERO : incomeInvoiceInfo.getTransferTaxAmt();
                    BigDecimal proportion = null;
                    if (unTransferTaxAmt != null && unTransferTaxAmt.compareTo(BigDecimal.ZERO) > 0) {
                        taxTransferEntryInfo.setAmount(unTransferTaxAmt.subtract(transferTaxAmt));
                        totalTaxAmount = totalTaxAmount.add(unTransferTaxAmt.subtract(transferTaxAmt));
                        proportion = unTransferTaxAmt.subtract(transferTaxAmt).divide(incomeInvoiceInfo.getTax(), 4, 4).multiply(new BigDecimal(100));
                    } else {
                        taxTransferEntryInfo.setAmount(incomeInvoiceInfo.getTax().subtract(transferTaxAmt));
                        totalTaxAmount = totalTaxAmount.add(incomeInvoiceInfo.getTax().subtract(transferTaxAmt));
                        proportion = transferTaxAmt != null ? incomeInvoiceInfo.getTax().subtract(transferTaxAmt).divide(incomeInvoiceInfo.getTax(), 4, 4).multiply(new BigDecimal(100)) : new BigDecimal(100);
                    }
                    taxTransferEntryInfo.setProportion(proportion);
                    taxTransColl.add(taxTransferEntryInfo);
                }
                this.editData.put("entries", (Object)taxTransColl);
                this.editData.setTotalTaxAmount(totalTaxAmount);
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                this.editData.setCompany(company);
                if (null != incomeInvoiceInfo.getTaxTransferItem()) {
                    TaxTransferItemInfo item = TaxTransferItemFactory.getRemoteInstance().getTaxTransferItemInfo((IObjectPK)new ObjectUuidPK(incomeInvoiceInfo.getTaxTransferItem().getId()));
                    this.editData.setTaxTransferItem(item);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.editData.setSrcType(TransSrcSystemEnum.SYSTEM);
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    private void initFullElecInovice(ArrayList ids) {
        HashSet set = new HashSet(ids);
        FullElectricInvoiceInfo fullElectricInvoice = null;
        TaxTransferEntryInfo taxTransferEntryInfo = null;
        try {
            IFullElectricInvoice iFullElectricInvoice = FullElectricInvoiceFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            viewInfo.setSelector(sic);
            CoreBaseCollection coll = iFullElectricInvoice.getCollection(viewInfo);
            TaxTransferItemInfo taxTransferItem = null;
            IncomeTypeInfo incomeType = null;
            if (coll != null && coll.size() > 0) {
                TaxTransferEntryCollection taxTransColl = new TaxTransferEntryCollection();
                BigDecimal totalTaxAmount = new BigDecimal("0.00");
                for (int i = 0; i < coll.size(); ++i) {
                    taxTransferEntryInfo = new TaxTransferEntryInfo();
                    fullElectricInvoice = (FullElectricInvoiceInfo)coll.get(i);
                    if (!TMInvoiceType.INVOICETYPE_FULL_ELEC_SPECIAL.equals((Object)fullElectricInvoice.getInvoiceType())) continue;
                    taxTransferEntryInfo.setTaxTransferInvoiceType(TaxTransferInvoiceType.INVOICETYPE_FULL_ELECTRONIC_SPECIAL);
                    taxTransferEntryInfo.setInvoiceNumber(fullElectricInvoice.getInvoiceNo());
                    taxTransferEntryInfo.setTax(fullElectricInvoice.getTotalTaxAmount());
                    if (!StringUtils.isEmpty((String)fullElectricInvoice.getIncomeTypeID())) {
                        incomeType = new IncomeTypeInfo();
                        incomeType.setId(BOSUuid.read((String)fullElectricInvoice.getIncomeTypeID()));
                        incomeType.setNumber(fullElectricInvoice.getIncomeTypeNumber());
                        incomeType.setName(fullElectricInvoice.getIncomeTypeName());
                        taxTransferEntryInfo.setIncomeType(incomeType);
                    }
                    BigDecimal unTransferTaxAmt = fullElectricInvoice.getUnTransferTaxAmt();
                    BigDecimal transferTaxAmt = null == fullElectricInvoice.getTransferTaxAmt() ? BigDecimal.ZERO : fullElectricInvoice.getTransferTaxAmt();
                    BigDecimal proportion = null;
                    if (unTransferTaxAmt != null && unTransferTaxAmt.compareTo(BigDecimal.ZERO) > 0) {
                        taxTransferEntryInfo.setAmount(unTransferTaxAmt.subtract(transferTaxAmt));
                        totalTaxAmount = totalTaxAmount.add(unTransferTaxAmt.subtract(transferTaxAmt));
                        proportion = unTransferTaxAmt.subtract(transferTaxAmt).divide(fullElectricInvoice.getTotalTaxAmount(), 4, 4).multiply(new BigDecimal(100));
                    } else {
                        taxTransferEntryInfo.setAmount(fullElectricInvoice.getTotalTaxAmount().subtract(transferTaxAmt));
                        totalTaxAmount = totalTaxAmount.add(fullElectricInvoice.getTotalTaxAmount().subtract(transferTaxAmt));
                        proportion = transferTaxAmt != null ? fullElectricInvoice.getTotalTaxAmount().subtract(transferTaxAmt).divide(fullElectricInvoice.getTotalTaxAmount(), 4, 4).multiply(new BigDecimal(100)) : new BigDecimal(100);
                    }
                    taxTransferEntryInfo.setProportion(proportion);
                    taxTransColl.add(taxTransferEntryInfo);
                }
                this.editData.put("entries", (Object)taxTransColl);
                this.editData.setTotalTaxAmount(totalTaxAmount);
                if (taxTransferItem == null && fullElectricInvoice != null && fullElectricInvoice.getTaxTransferItemID() != null) {
                    taxTransferItem = new TaxTransferItemInfo();
                    taxTransferItem.setId(BOSUuid.read((String)fullElectricInvoice.getTaxTransferItemID()));
                    taxTransferItem.setNumber(fullElectricInvoice.getTaxTransferItemNumber());
                    taxTransferItem.setName(fullElectricInvoice.getTaxTransferItemName());
                }
            }
            this.editData.setTaxTransferItem(taxTransferItem);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.editData.setSrcType(TransSrcSystemEnum.SYSTEM);
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    private void initF7() {
        CompanyOrgUnitInfo info = this.editData.getCompany();
        if (info == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)info.getAccountPeriodType().getId().toString()));
        view.setFilter(filter);
        this.prmtTaxPeriod.setEntityViewInfo(view);
        this.prmtTaxPeriod.setHasCUDefaultFilter(false);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        try {
            this.uiHelper.setMainBizOrgFilter();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.initBtnStatus();
        this.reDefinedButton();
        this.initTableEditable();
        this.appendFootRow(this.kdtEntries);
        this.initListeners();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.reDefinedButton();
    }

    private void reDefinedButton() {
        InvoiceBillStatus status;
        Object obj = this.comboSrcType.getSelectedItem();
        if (obj != null && obj instanceof TransSrcSystemEnum) {
            TransSrcSystemEnum srcSystem = (TransSrcSystemEnum)((Object)obj);
            if (srcSystem.equals((Object)TransSrcSystemEnum.SYSTEM)) {
                this.prmtCompany.setEnabled(false);
                this.prmtCompany.setEditable(false);
                this.actionAddLine.setEnabled(false);
                this.actionInsertLine.setEnabled(false);
                this.actionRemoveLine.setEnabled(false);
            } else {
                this.prmtCompany.setEnabled(true);
                this.prmtCompany.setEditable(true);
                this.actionAddLine.setEnabled(true);
                this.actionInsertLine.setEnabled(true);
                this.actionRemoveLine.setEnabled(true);
            }
        }
        if (this.comboStatus.getSelectedItem() != null && this.comboStatus.getSelectedItem() instanceof InvoiceBillStatus && (InvoiceBillStatus.AUDITED.equals((Object)(status = (InvoiceBillStatus)((Object)this.comboStatus.getSelectedItem()))) || OprtState.VIEW.equals(this.getOprtState())) && !TransSrcSystemEnum.SYSTEM.equals((Object)((TransSrcSystemEnum)((Object)this.comboSrcType.getSelectedItem())))) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        }
    }

    private void initListeners() {
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        TaxTransferEditUI.this.kdtEntries_ChangedStopped(e);
                    }
                    catch (Exception exc) {
                        TaxTransferEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtEntries.addKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.prmtCompanyChange == null) {
            this.prmtCompanyChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    TaxTransferEditUI.this.prmtCompanyChange_dataChanged(eventObj);
                }
            };
        }
        this.prmtCompany.addDataChangeListener(this.prmtCompanyChange);
    }

    protected void prmtCompanyChange_dataChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            this.prmtCompany.setDataNoNotify(e.getOldValue());
            return;
        }
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)e.getNewValue();
        if (e.getNewValue() != e.getOldValue()) {
            this.prmtTaxPeriod.setValue(null);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)info.getAccountPeriodType().getId().toString()));
        view.setFilter(filter);
        this.prmtTaxPeriod.setEntityViewInfo(view);
        this.prmtTaxPeriod.setHasCUDefaultFilter(false);
    }

    private void kdtEntries_ChangedStopped(KDTEditEvent e) throws BOSException {
        int rowIndex = e.getRowIndex();
        String colName = this.kdtEntries.getColumnKey(e.getColIndex());
        BigDecimal amount = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(AMOUNT).getValue();
        BigDecimal tax = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(TAX).getValue();
        BigDecimal proportion = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(PROPORTION).getValue();
        Object invoiceType = this.kdtEntries.getRow(rowIndex).getCell(INVOICETYPE).getValue();
        if (INVOICETYPE.equals(colName)) {
            if (invoiceType instanceof TaxTransferInvoiceType) {
                TaxTransferInvoiceType tInvoiceType = (TaxTransferInvoiceType)((Object)invoiceType);
                if (TaxTransferInvoiceType.INVOICETYPE_FULL_ELECTRONIC_SPECIAL.equals((Object)tInvoiceType) || TaxTransferInvoiceType.INVOICETYPE_PLANE.equals((Object)tInvoiceType) || TaxTransferInvoiceType.INVOICETYPE_TRAIN.equals((Object)tInvoiceType)) {
                    this.kdtEntries.getRow(rowIndex).getCell(INVOICECODE).getStyleAttributes().setLocked(true);
                    this.kdtEntries.getRow(rowIndex).getCell(INVOICECODE).setValue(null);
                } else {
                    this.kdtEntries.getRow(rowIndex).getCell(INVOICECODE).getStyleAttributes().setLocked(false);
                }
            }
        } else if (TAX.equals(colName)) {
            if (tax != null && amount != null) {
                if (amount.compareTo(tax) > 0) {
                    this.kdtEntries.getRow(rowIndex).getCell(TAX).setValue((Object)amount);
                }
                this.proportionEntryByAmount(rowIndex);
            } else if (tax != null && proportion != null) {
                amount = proportion.divide(new BigDecimal(100)).multiply(tax).setScale(2, 6);
                this.kdtEntries.getRow(rowIndex).getCell(AMOUNT).setValue((Object)amount);
            }
            this.calFoot();
            this.totalAmount();
        } else if (AMOUNT.equals(colName)) {
            if (amount != null && tax != null && amount.compareTo(tax) > 0) {
                this.kdtEntries.getRow(rowIndex).getCell(AMOUNT).setValue((Object)tax);
            }
            this.proportionEntryByAmount(rowIndex);
            this.calFoot();
            this.totalAmount();
        } else if (PROPORTION.equals(colName)) {
            if (proportion != null && proportion.compareTo(new BigDecimal(100)) > 0) {
                this.kdtEntries.getRow(rowIndex).getCell(PROPORTION).setValue(e.getOldValue());
                return;
            }
            if (tax != null && proportion != null) {
                amount = proportion.divide(new BigDecimal(100)).multiply(tax).setScale(2, 6);
                this.kdtEntries.getRow(rowIndex).getCell(AMOUNT).setValue((Object)amount);
            }
            this.autoBringProportion(rowIndex);
            this.totalAmount();
        }
    }

    private void autoBringProportion(int rowIndex) {
        int count = this.kdtEntries.getRowCount();
        BigDecimal srcProportion = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(PROPORTION).getValue();
        for (int i = rowIndex + 1; i < count; ++i) {
            BigDecimal proportion = (BigDecimal)this.kdtEntries.getRow(i).getCell(PROPORTION).getValue();
            BigDecimal tax = (BigDecimal)this.kdtEntries.getRow(i).getCell(TAX).getValue();
            if (proportion == null || proportion.compareTo(BigDecimal.ZERO) == 0) {
                this.kdtEntries.getRow(i).getCell(PROPORTION).setValue((Object)srcProportion);
                if (tax == null || srcProportion == null) continue;
                BigDecimal amount = srcProportion.divide(new BigDecimal(100)).multiply(tax).setScale(2, 6);
                this.kdtEntries.getRow(i).getCell(AMOUNT).setValue((Object)amount);
                continue;
            }
            return;
        }
    }

    private void proportionEntryByAmount(int rowIndex) {
        BigDecimal amount = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(AMOUNT).getValue();
        BigDecimal tax = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(TAX).getValue();
        if (tax == null || amount == null || tax != null && BigDecimal.ZERO.compareTo(tax) == 0) {
            return;
        }
        BigDecimal proportion = amount.divide(tax, 4, 6).multiply(new BigDecimal(100));
        this.kdtEntries.getRow(rowIndex).getCell(PROPORTION).setValue((Object)proportion);
        this.autoBringProportion(rowIndex);
    }

    private void totalAmount() {
        int rowCount = this.kdtEntries.getRowCount();
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (int i = 0; i < rowCount; ++i) {
            BigDecimal amount = (BigDecimal)this.kdtEntries.getRow(i).getCell(AMOUNT).getValue();
            if (amount == null) continue;
            totalAmount = totalAmount.add(amount).setScale(2, 6);
        }
        this.txtTotalTaxAmount.setValue((Object)totalAmount);
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        this.totalAmount();
        super.afterRemoveLine(table, lineData);
    }

    private void removeListener() {
        if (this.entryTableChange != null) {
            this.kdtEntries.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
        if (this.prmtCompanyChange != null) {
            this.prmtCompany.removeDataChangeListener(this.prmtCompanyChange);
        }
    }

    protected void appendFootRow(KDTable table) {
        super.appendFootRow(table);
        if (this.getDetailTable() != null) {
            IRow totolRow;
            KDTFootManager footRowManager = this.getDetailTable().getFootManager();
            if (footRowManager == null) {
                String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                footRowManager = new KDTFootManager(this.getDetailTable());
                footRowManager.addFootView();
                this.getDetailTable().setFootManager(footRowManager);
                totolRow = footRowManager.addFootRow(0);
                totolRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                totolRow.getStyleAttributes().setBackground(FOOTROWCOLOR);
                this.getDetailTable().getIndexColumn().setWidthAdjustMode((short)1);
                this.getDetailTable().getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, total);
            } else {
                totolRow = footRowManager.getFootRow(0);
            }
            if (totolRow == null) {
                return;
            }
            String[] colNames = this.getSumColNames();
            for (int i = 0; i < colNames.length; ++i) {
                if (totolRow.getCell(colNames[i]) == null) continue;
                totolRow.getCell(colNames[i]).getStyleAttributes().setNumberFormat(NUMFORMAT);
            }
        }
        this.calFoot();
    }

    protected String[] getSumColNames() {
        return new String[]{TAX, AMOUNT};
    }

    private void calFoot() {
        this.kdtEntries.getRowCount();
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            tax = tax.add(this.getBigDecimal4Cell(this.kdtEntries.getRow(i), TAX));
            amount = amount.add(this.getBigDecimal4Cell(this.kdtEntries.getRow(i), AMOUNT));
        }
        this.kdtEntries.getFootRow(0).getCell(TAX).setValue((Object)tax);
        this.kdtEntries.getFootRow(0).getCell(AMOUNT).setValue((Object)amount);
    }

    private BigDecimal getBigDecimal4Cell(IRow row, String column) {
        BigDecimal value = (BigDecimal)row.getCell(column).getValue();
        return value == null ? BigDecimal.ZERO : value;
    }

    private void initEntries() {
        if (this.getDetailTable() != null) {
            this.getDetailTable().getActionMap().remove("AddRow");
            this.getDetailTable().getActionMap().remove("RemoveRow");
            this.getDetailTable().getActionMap().remove("Delete");
            this.getDetailTable().getActionMap().remove("Paste");
        }
        KDComboBox invoiceType = new KDComboBox();
        invoiceType.addItems(TaxTransferInvoiceType.getEnumList().toArray());
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((JComboBox)invoiceType);
        this.kdtEntries.getColumn(INVOICETYPE).setEditor((ICellEditor)itemEditor);
        int priceDisplayPrecision = 2;
        KDFormattedTextField price = new KDFormattedTextField();
        price.setDataType(1);
        price.setPrecision(priceDisplayPrecision);
        price.setSupportedEmpty(true);
        price.setRemoveingZeroInDispaly(false);
        price.setNegatived(false);
        price.setHorizontalAlignment(4);
        KDTDefaultCellEditor priceEditor = new KDTDefaultCellEditor((JTextField)price);
        for (String field : PRICE_FIELD) {
            this.kdtEntries.getColumn(field).setEditor((ICellEditor)priceEditor);
            this.kdtEntries.getColumn(field).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)priceDisplayPrecision));
        }
        KDFormattedTextField proportionField = new KDFormattedTextField();
        proportionField.setDataType(1);
        proportionField.setPrecision(priceDisplayPrecision);
        proportionField.setSupportedEmpty(true);
        proportionField.setRemoveingZeroInDispaly(false);
        proportionField.setNegatived(false);
        proportionField.setHorizontalAlignment(2);
        KDTDefaultCellEditor proportionEditor = new KDTDefaultCellEditor((JTextField)proportionField);
        this.kdtEntries.getColumn(PROPORTION).setEditor((ICellEditor)proportionEditor);
        this.kdtEntries.getColumn(PROPORTION).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)priceDisplayPrecision));
        KDBizPromptBox prmtIncomeType = new KDBizPromptBox();
        prmtIncomeType.setQueryInfo(INCOMETYPE_QUERY);
        prmtIncomeType.setEditFormat("$number$");
        prmtIncomeType.setDisplayFormat("$name$");
        prmtIncomeType.setCommitFormat("$number$");
        KDTDefaultCellEditor itemEditor1 = new KDTDefaultCellEditor((IKDEditor)prmtIncomeType);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.getDetailTable().getColumn("incomeType").setRenderer((IBasicRender)avr);
        this.kdtEntries.getColumn("incomeType").setEditor((ICellEditor)itemEditor1);
        this.initRemare();
    }

    private void initTableEditable() {
        ArrayList ids = (ArrayList)this.getUIContext().get("ids");
        if (CollectionUtil.isEmpty(ids)) {
            if (TransSrcSystemEnum.SYSTEM == this.editData.getSrcType()) {
                this.kdtEntries.getColumn(INVOICETYPE).getStyleAttributes().setLocked(true);
                this.kdtEntries.getColumn(TAX).getStyleAttributes().setLocked(true);
                this.kdtEntries.getColumn(INVOICECODE).getStyleAttributes().setLocked(true);
                this.kdtEntries.getColumn(INVOICENUMBER).getStyleAttributes().setLocked(true);
                this.prmtCompany.setEnabled(false);
            } else {
                this.kdtEntries.getColumn(INVOICETYPE).getStyleAttributes().setLocked(false);
                this.kdtEntries.getColumn(TAX).getStyleAttributes().setLocked(false);
                this.kdtEntries.getColumn(INVOICECODE).getStyleAttributes().setLocked(false);
                this.kdtEntries.getColumn(INVOICENUMBER).getStyleAttributes().setLocked(false);
                this.prmtCompany.setEnabled(true);
            }
        }
        int count = this.kdtEntries.getRowCount();
        IRow row = null;
        Object value = null;
        for (int i = 0; i < count; ++i) {
            row = this.kdtEntries.getRow(i);
            value = row.getCell(INVOICETYPE).getValue();
            if (!(value instanceof TaxTransferInvoiceType)) continue;
            TaxTransferInvoiceType tInvoiceType = (TaxTransferInvoiceType)((Object)value);
            if (TaxTransferInvoiceType.INVOICETYPE_FULL_ELECTRONIC_SPECIAL.equals((Object)tInvoiceType) || TaxTransferInvoiceType.INVOICETYPE_PLANE.equals((Object)tInvoiceType) || TaxTransferInvoiceType.INVOICETYPE_TRAIN.equals((Object)tInvoiceType)) {
                row.getCell(INVOICECODE).getStyleAttributes().setLocked(true);
                continue;
            }
            row.getCell(INVOICECODE).getStyleAttributes().setLocked(false);
        }
    }

    private void initRemare() {
        KDTextField remare = new KDTextField();
        remare.setMaxLength(255);
        KDTDefaultCellEditor remakeEditor = new KDTDefaultCellEditor((JTextField)remare);
        this.kdtEntries.getColumn("costDepart").setEditor((ICellEditor)remakeEditor);
        this.kdtEntries.getColumn("costType").setEditor((ICellEditor)remakeEditor);
    }

    private void initBtnStatus() {
        this.updateButtonStatus();
        InvoiceBillStatus status = this.editData.getStatus();
        this.actionAudit.setEnabled(InvoiceBillStatus.SUBMITED.equals((Object)status));
        this.actionUnAudit.setEnabled(InvoiceBillStatus.AUDITED.equals((Object)status));
        this.actionCopyLine.setVisible(false);
        if (this.editData == null || this.getOprtState() == null || this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionCopy.setEnabled(false);
        } else {
            this.actionCopy.setEnabled(true);
        }
        if (InvoiceBillStatus.AUDITED.equals((Object)status)) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            CodingRuleInfo cr = iCodingRuleManager.getCodingRule((IObjectValue)this.editData, this.editData.getCompany().getId().toString());
            if (cr != null && !cr.isIsModifiable()) {
                this.txtNumber.setEditable(false);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        TaxTransferEntryInfo info = new TaxTransferEntryInfo();
        info.setTaxTransferInvoiceType(TaxTransferInvoiceType.INVOICETYPE_SPECIAL_PAPER);
        return info;
    }

    @Override
    protected IObjectValue createNewData() {
        TaxTransferInfo info = new TaxTransferInfo();
        info.setTransferDate(new Date());
        try {
            info.setCompany(IMUtils.getPermissionCompany("im_taxTransfer_new"));
            if (info.getCompany() == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"NewTaxTransferWithoutPerm"));
                SysUtil.abort();
            }
            String periodType = info.getCompany().getAccountPeriodType().getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)DateUtil.getCurrentPeriod(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodType, CompareType.EQUALS));
            view.setFilter(filter);
            CoreBaseCollection periodColl = PeriodFactory.getRemoteInstance().getCollection(view);
            PeriodInfo period = null;
            if (periodColl != null && periodColl.size() > 0) {
                period = (PeriodInfo)periodColl.get(0);
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"PeriodNotFound"));
                SysUtil.abort();
            }
            info.setTaxPeriod(period);
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            CodingRuleInfo cr = iCodingRuleManager.getCodingRule((IObjectValue)info, info.getCompany().getId().toString());
            if (cr != null && cr.isIsAddView()) {
                info.setNumber(iCodingRuleManager.getNumber((IObjectValue)info, info.getCompany().getId().toString()));
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setSrcType(TransSrcSystemEnum.MANUAL);
        info.setStatus(InvoiceBillStatus.TEMPSTROE);
        info.getEntries().add((TaxTransferEntryInfo)this.createNewDetailData(this.kdtEntries));
        return info;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        TaxTransferInfo info = (TaxTransferInfo)newData;
        info.setCreator(null);
        info.setCreateTime(null);
        info.setAuditor(null);
        info.setAudittime(null);
        info.setLastUpdateTime(null);
        info.setLastUpdateUser(null);
        info.setVoucher(null);
        info.setVoucherNumber(null);
        info.setVoucherType(null);
        info.setFiVouchered(false);
        info.setStatus(InvoiceBillStatus.TEMPSTROE);
        info.setSrcType(TransSrcSystemEnum.MANUAL);
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            CodingRuleInfo cr = iCodingRuleManager.getCodingRule((IObjectValue)info, info.getCompany().getId().toString());
            if (cr != null) {
                info.setNumber(iCodingRuleManager.getNumber((IObjectValue)info, info.getCompany().getId().toString()));
            }
            this.uiHelper.setMainBizOrgFilter();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.editData.getCompany().getId()), "im_taxTransfer_new");
        super.actionCopy_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TaxTransferFactory.getRemoteInstance();
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtCompany;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        IMUtils.removeNullRow(this.kdtEntries, new String[]{INVOICETYPE, AMOUNT});
        this.storeFields();
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        IMUtils.removeNullRow(this.kdtEntries, new String[]{INVOICETYPE, AMOUNT});
        this.storeFields();
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null && SCMClientUtils.checkAllBizObjInWfProcess((String[])new String[]{this.editData.getId().toString()})) {
            this.actionMultiapprove_actionPerformed(null);
            return;
        }
        if (this.isModify()) {
            throw new IMException(IMException.DATACHANGED);
        }
        Map result = IMFacadeFactory.getRemoteInstance().batchOperation("573282EF", "passAudit", new String[]{this.editData.getId().toString()});
        if (!"0".equals(result.get("ERROR_COUNT"))) {
            String errorMsg = null;
            for (Object cause : result.keySet()) {
                if ("ERROR_COUNT".equals(cause.toString())) continue;
                errorMsg = result.get(cause).toString();
            }
            if (!StringUtils.isEmpty(errorMsg)) {
                throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg});
            }
        }
        this.setOprtState("VIEW");
        this.refreshCurPage();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        ITaxTransfer iTaxTransfer = TaxTransferFactory.getRemoteInstance();
        iTaxTransfer.unpassAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBillBaseInfo)this.editData);
        this.setOprtState("VIEW");
        this.refreshCurPage();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getString("id"))) {
            idList.add(this.editData.getString("id"));
        }
        if (idList == null || idList.size() == 0) {
            return;
        }
        String tdFileName = "/TM/IM/IncomeInvoice/TaxTransferPrintList";
        KDNoteHelper appHlp = new KDNoteHelper();
        IMPrintCommonDataProvider data = new IMPrintCommonDataProvider(appHlp, BOSObjectType.create((String)"412A6F98"), idList);
        appHlp.print(tdFileName, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getString("id"))) {
            idList.add(this.editData.getString("id"));
        }
        if (idList == null || idList.size() == 0) {
            return;
        }
        String tdFileName = "/TM/IM/IncomeInvoice/TaxTransferPrintList";
        KDNoteHelper appHlp = new KDNoteHelper();
        IMPrintCommonDataProvider data = new IMPrintCommonDataProvider(appHlp, BOSObjectType.create((String)"412A6F98"), idList);
        appHlp.printPreview(tdFileName, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected void refreshCurPage() throws Exception {
        if (this.editData.getId() != null) {
            this.setInnerLoadFields(true);
            Map allTableListeners = this.removeAllTableListener(KDTPropertyChangeListener.class);
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            IObjectValue iObjectValue = this.getValue((IObjectPK)iObjectPk);
            this.setDataObject(iObjectValue);
            this.loadFields();
            this.setSave(true);
            this.setSaved(true);
            this.restoreAllTableListener(KDTPropertyChangeListener.class, allTableListeners);
            this.reSetDepTbListeners();
        }
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "company";
    }

    @Override
    public String getPermItem(String status) {
        return this.getPermissionItem(status);
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return this.prmtCompany;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    public BOTRelationCollection getMakeRelations() {
        return null;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return null;
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "im_taxTransfer_new";
        }
        return null;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (pk != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus() != InvoiceBillStatus.AUDITED) {
            throw new IMException(IMException.GENERATE_VOUCHER_CHECK);
        }
        super.actionVoucher_actionPerformed(e);
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }
}

