/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client.comp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.InvoiceProperty;
import com.kingdee.eas.tm.common.PoolInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.ExtendInvoiceCollection;
import com.kingdee.eas.tm.common.invoicePool.ExtendInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.ExtendInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.ExtendTMInvoiceTypeInfo;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.utils.TMPwyHelperUtils;
import com.kingdee.eas.tm.im.IIMFacade;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.client.comp.AbstractInvoiceHelperUI;
import com.kingdee.eas.tm.im.client.comp.IncomeInvoiceMutilSelectListUIPromptDialog;
import com.kingdee.eas.tm.im.client.comp.MutilSelectListUIPromptDialog;
import com.kingdee.eas.tm.im.client.comp.PwyInvoiceHelper;
import com.kingdee.eas.tm.im.client.util.IMClientUtils;
import com.kingdee.eas.tm.im.param.InvoiceHelperParam;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class InvoiceHelperUI
extends AbstractInvoiceHelperUI {
    private static final Logger logger = CoreUIObject.getLogger(InvoiceHelperUI.class);
    private static final String CONNECTOR = "_";
    private static final String TBL_INVOICETYPE = "invoiceType";
    private static final String TBL_INVOICECODE = "invoiceCode";
    private static final String TBL_INVOICENUMBER = "invoiceNumber";
    private static final String TBL_INVOICEAMOUNT = "invoiceAmount";
    private static final String TBL_INVOICETAX = "invoiceTax";
    private static final String TBL_INVOICEAMOUNTTAX = "invoiceAmountTax";
    private static final String TBL_INVOICEID = "ID";
    private static final String TBL_INVOICESERIAlNOS = "invoiceSerialNos";
    private static final String TBL_BILLINGCOMPANY = "billingCompany";
    public static final Color FOOTROWCOLOR = new Color(252, 255, 206);
    private static final String[] headList = new String[]{"invoiceCode", "invoiceNumber"};
    private HashMap tblDataMap = new HashMap();
    private HashMap resultMap = new HashMap();
    private InvoiceHelperParam helperParam = null;
    private DataChangeListener prmtIncomeInvoiceChange = null;
    private KDTEditAdapter entryTableChange = null;
    private PwyInvoiceHelper pwyinvoiceHelper = new PwyInvoiceHelper(this);
    private static final String[] LOCK_COLUMNS = new String[]{"invoiceType", "invoiceAmount", "invoiceTax", "invoiceAmountTax", "billingCompany"};
    private static final String[] AMT_COLUMNS = new String[]{"invoiceAmount", "invoiceTax", "invoiceAmountTax"};

    public InvoiceHelperParam getHelperParam() {
        return this.helperParam;
    }

    public void setHelperParam(InvoiceHelperParam helperParam) {
        this.helperParam = helperParam;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.actionAddLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionRemoveLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
        ArrayList<JButton> btnList = new ArrayList<JButton>();
        btnList.add(this.tableContainer.add((Action)((Object)this.actionAddLine)));
        btnList.add(this.tableContainer.add((Action)((Object)this.actionRemoveLine)));
        for (int i = 0; i < btnList.size(); ++i) {
            KDWorkButton btn = (KDWorkButton)btnList.get(i);
            btn.setText(null);
            btn.setSize(new Dimension(22, 19));
            btn.setEnabled(true);
        }
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.helperParam = (InvoiceHelperParam)this.getUIContext().get("InvoiceHelperParam");
        this.initIncomeInvoiceF7();
        this.resultMap.put("invoiceCodes", this.helperParam.getDefaultInvoiceCode());
        this.resultMap.put("invoiceNumbers", this.helperParam.getDefaultInvoiceNumber());
        super.onLoad();
        this.loadFields();
    }

    @Override
    public void loadFields() {
        this.removeLisener();
        super.loadFields();
        try {
            this.initData(this.helperParam);
            this.initControl();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.appendFootRow(this.tblMain);
        this.initListeners();
    }

    private void initData(InvoiceHelperParam helperParam) throws BOSException, EASBizException {
        Object[] invoiceNumbers = helperParam.getInvoiceNumber();
        String[] invoiceCodes = helperParam.getInvoiceCode();
        Map invoiceMap = this.getInvoiceMap(Arrays.asList((Object[])invoiceNumbers));
        IObjectValue value = null;
        ArrayList<PoolInvoiceInfo> invoiceList = new ArrayList<PoolInvoiceInfo>();
        PoolInvoiceInfo invoiceInfo = null;
        TMInvoiceType tmInvoiceType = null;
        for (int i = 0; i < invoiceNumbers.length; ++i) {
            value = (IObjectValue)invoiceMap.get(invoiceCodes[i] + CONNECTOR + (String)invoiceNumbers[i]);
            invoiceInfo = new PoolInvoiceInfo();
            invoiceInfo.setInvoiceCode(invoiceCodes[i]);
            invoiceInfo.setInvoiceNumber((String)invoiceNumbers[i]);
            if (value != null) {
                invoiceInfo.setId(value.get("id").toString());
                invoiceInfo.setSerialNo(value.getString("serialno"));
                if (value instanceof IncomeInvoiceInfo) {
                    invoiceInfo.setAmountTax(value.getBigDecimal("amountTax"));
                    invoiceInfo.setAmount(value.getBigDecimal("amount"));
                    invoiceInfo.setTax(value.getBigDecimal("tax"));
                    tmInvoiceType = this.getTmInvoiceType(PayInvoiceTypeEnum.getEnum((String)value.getString(TBL_INVOICETYPE)));
                    invoiceInfo.setInvoiceTypeAlias(tmInvoiceType == null ? null : tmInvoiceType.toString());
                    invoiceInfo.setBillingCompany(value.getString(TBL_BILLINGCOMPANY));
                } else if (value instanceof ExtendInvoiceInfo) {
                    invoiceInfo.setAmountTax(value.getBigDecimal("totalAmount"));
                    invoiceInfo.setAmount(value.getBigDecimal(TBL_INVOICEAMOUNT));
                    invoiceInfo.setTax(value.getBigDecimal("totalTaxAmount"));
                    invoiceInfo.setInvoiceTypeAlias(((ExtendTMInvoiceTypeInfo)value.getObjectValue("extendInvoiceType")).getName());
                    invoiceInfo.setBillingCompany(value.getString("salerName"));
                } else {
                    String id = value.get("id").toString();
                    InvoiceProperty invoiceProperty = TMPwyHelperUtils.getPropertyByBosType((String)String.valueOf(BOSUuid.read((String)id).getType()));
                    if (invoiceProperty == null) continue;
                    String amountTaxField = (String)invoiceProperty.getFieldsName().get("amountTax");
                    String amountField = (String)invoiceProperty.getFieldsName().get("amount");
                    String taxField = (String)invoiceProperty.getFieldsName().get("tax");
                    String invoiceTypeField = (String)invoiceProperty.getFieldsName().get(TBL_INVOICETYPE);
                    String billingCompanyField = (String)invoiceProperty.getFieldsName().get(TBL_BILLINGCOMPANY);
                    invoiceInfo.setAmountTax(StringUtils.isEmpty((String)amountTaxField) ? null : value.getBigDecimal(amountTaxField));
                    invoiceInfo.setAmount(StringUtils.isEmpty((String)amountField) ? null : value.getBigDecimal(amountField));
                    invoiceInfo.setTax(StringUtils.isEmpty((String)taxField) ? null : value.getBigDecimal(taxField));
                    tmInvoiceType = TMInvoiceType.getEnum((String)value.getString(invoiceTypeField));
                    invoiceInfo.setInvoiceTypeAlias(tmInvoiceType == null ? null : tmInvoiceType.toString());
                    invoiceInfo.setBillingCompany(StringUtils.isEmpty((String)billingCompanyField) ? null : value.getString(billingCompanyField));
                }
            } else {
                invoiceInfo.setAmountTax(null);
                invoiceInfo.setAmount(null);
                invoiceInfo.setTax(null);
                invoiceInfo.setId(null);
                invoiceInfo.setInvoiceTypeAlias(null);
                invoiceInfo.setBillingCompany(null);
            }
            invoiceList.add(invoiceInfo);
        }
        this.fillTable(invoiceList);
    }

    protected Map getInvoiceMap(List invoiceNumbers) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(TBL_INVOICENUMBER, new HashSet(invoiceNumbers), CompareType.INCLUDE));
        view.setFilter(filter);
        IncomeInvoiceCollection incomeInvoiceColl = IncomeInvoiceFactory.getRemoteInstance().getIncomeInvoiceCollection(view);
        IncomeInvoiceInfo incomeInvoiceInfo = null;
        HashMap<String, IncomeInvoiceInfo> invoiceMap = new HashMap<String, IncomeInvoiceInfo>();
        for (int i = 0; i < incomeInvoiceColl.size(); ++i) {
            incomeInvoiceInfo = incomeInvoiceColl.get(i);
            invoiceMap.put(incomeInvoiceInfo.getInvoiceCode() + CONNECTOR + incomeInvoiceInfo.getInvoiceNumber(), incomeInvoiceInfo);
        }
        HashSet<String> tableNameSet = new HashSet<String>();
        InvoiceProperty invoiceProperty = null;
        CoreBaseInfo coreBaseInfo = null;
        String invoiceCodeFieldName = null;
        String invoiceNumberFieldName = null;
        IIMFacade iIMFacade = IMFacadeFactory.getRemoteInstance();
        int size = TMPwyHelperUtils.APSUPPORT_INVOICEPROPERTIES.size();
        for (int i = 0; i < size; ++i) {
            invoiceProperty = (InvoiceProperty)TMPwyHelperUtils.APSUPPORT_INVOICEPROPERTIES.get(i);
            if (StringUtils.isEmpty((String)invoiceProperty.getTableName()) || StringUtils.isEmpty((String)invoiceProperty.getBosType()) || TMPwyHelperUtils.COMMON_PAPER.getTableName().equals(invoiceProperty.getTableName()) || !tableNameSet.add(invoiceProperty.getTableName())) continue;
            invoiceCodeFieldName = (String)invoiceProperty.getFieldsName().get(TBL_INVOICECODE);
            invoiceNumberFieldName = (String)invoiceProperty.getFieldsName().get(TBL_INVOICENUMBER);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(invoiceNumberFieldName, new HashSet(invoiceNumbers), CompareType.INCLUDE));
            CoreBaseCollection collection = iIMFacade.getCollectionByBosType(invoiceProperty.getBosType(), filter);
            for (int j = 0; j < collection.size(); ++j) {
                coreBaseInfo = collection.get(j);
                if (StringUtils.isEmpty((String)coreBaseInfo.getString(invoiceCodeFieldName))) {
                    coreBaseInfo.put(invoiceCodeFieldName, (Object)" ");
                }
                invoiceMap.put(coreBaseInfo.getString(invoiceCodeFieldName) + CONNECTOR + coreBaseInfo.getString(invoiceNumberFieldName), (IncomeInvoiceInfo)coreBaseInfo);
            }
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("extendInvoiceType.name"));
        view.setSelector(sic);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceNo", new HashSet(invoiceNumbers), CompareType.INCLUDE));
        view.setFilter(filter);
        ExtendInvoiceCollection extendInvoiceColl = ExtendInvoiceFactory.getRemoteInstance().getExtendInvoiceCollection(view);
        ExtendInvoiceInfo extendInvoiceInfo = null;
        for (int i = 0; i < extendInvoiceColl.size(); ++i) {
            extendInvoiceInfo = extendInvoiceColl.get(i);
            if (StringUtils.isEmpty((String)extendInvoiceInfo.getInvoiceCode())) {
                extendInvoiceInfo.setInvoiceCode(" ");
            }
            invoiceMap.put(extendInvoiceInfo.getInvoiceCode() + CONNECTOR + extendInvoiceInfo.getInvoiceNo(), (IncomeInvoiceInfo)extendInvoiceInfo);
        }
        return invoiceMap;
    }

    private void initControl() {
        int i;
        this.prmtIncomeInvoice.setEditable(false);
        int length = LOCK_COLUMNS.length;
        for (i = 0; i < length; ++i) {
            this.tblMain.getColumn(LOCK_COLUMNS[i]).getStyleAttributes().setLocked(true);
        }
        length = AMT_COLUMNS.length;
        for (i = 0; i < length; ++i) {
            this.tblMain.getColumn(AMT_COLUMNS[i]).setEditor((ICellEditor)this.getAmtCellEditor());
            this.tblMain.getColumn(AMT_COLUMNS[i]).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
            this.tblMain.getColumn(AMT_COLUMNS[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    private KDTDefaultCellEditor getAmtCellEditor() {
        KDFormattedTextField amtTextField = new KDFormattedTextField();
        amtTextField.setDataType(1);
        amtTextField.setPrecision(2);
        amtTextField.setSupportedEmpty(true);
        amtTextField.setRemoveingZeroInDispaly(false);
        amtTextField.setNegatived(false);
        amtTextField.setHorizontalAlignment(4);
        KDTDefaultCellEditor amtEditor = new KDTDefaultCellEditor((JTextField)amtTextField);
        return amtEditor;
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected void appendFootRow(KDTable table) {
        IRow totolRow;
        KDTFootManager footRowManager;
        if (this.tblMain.getRowCount() == 0 && this.tblMain.getFootManager() != null) {
            this.tblMain.getFootManager().getFoot().removeRows();
        }
        if ((footRowManager = this.tblMain.getFootManager()) == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(this.tblMain);
            footRowManager.addFootView();
            this.tblMain.setFootManager(footRowManager);
            totolRow = footRowManager.addFootRow(0);
            totolRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            totolRow.getStyleAttributes().setBackground(FOOTROWCOLOR);
            this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
            this.tblMain.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        } else {
            totolRow = footRowManager.getFootRow(0);
        }
        if (totolRow == null) {
            return;
        }
        String[] colNames = this.getSumColNames();
        for (int i = 0; i < colNames.length; ++i) {
            if (totolRow.getCell(colNames[i]) == null) continue;
            totolRow.getCell(colNames[i]).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        }
        this.calFoot();
    }

    protected String[] getSumColNames() {
        return AMT_COLUMNS;
    }

    private void calFoot() {
        if (this.tblMain.getFootRow(0) == null) {
            return;
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalAmountTax = BigDecimal.ZERO;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            totalAmount = totalAmount.add(this.getBigDecimal4Cell(this.tblMain.getRow(i), TBL_INVOICEAMOUNT));
            totalTax = totalTax.add(this.getBigDecimal4Cell(this.tblMain.getRow(i), TBL_INVOICETAX));
            totalAmountTax = totalAmountTax.add(this.getBigDecimal4Cell(this.tblMain.getRow(i), TBL_INVOICEAMOUNTTAX));
        }
        this.tblMain.getFootRow(0).getCell(TBL_INVOICEAMOUNT).setValue((Object)totalAmount);
        this.tblMain.getFootRow(0).getCell(TBL_INVOICETAX).setValue((Object)totalTax);
        this.tblMain.getFootRow(0).getCell(TBL_INVOICEAMOUNTTAX).setValue((Object)totalAmountTax);
    }

    private void removeLisener() {
        if (this.prmtIncomeInvoiceChange != null) {
            this.prmtIncomeInvoice.removeDataChangeListener(this.prmtIncomeInvoiceChange);
        }
    }

    private BigDecimal getBigDecimal4Cell(IRow row, String column) {
        BigDecimal value = (BigDecimal)row.getCell(column).getValue();
        return value == null ? BigDecimal.ZERO : value;
    }

    private void initListeners() {
        if (this.prmtIncomeInvoiceChange == null) {
            this.prmtIncomeInvoiceChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    InvoiceHelperUI.this.prmtIncomeInvoice_dataChanged(eventObj);
                }
            };
        }
        this.prmtIncomeInvoice.addDataChangeListener(this.prmtIncomeInvoiceChange);
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        if (IMUtils.objectEquals(e.getOldValue(), e.getValue())) {
                            return;
                        }
                        InvoiceHelperUI.this.kdtEntries_ChangedStopped(e);
                    }
                    catch (Exception exc) {
                        InvoiceHelperUI.this.handUIException(exc);
                    }
                }
            };
            this.tblMain.addKDTEditListener((KDTEditListener)this.entryTableChange);
        }
    }

    protected void prmtIncomeInvoice_dataChanged(DataChangeEvent eventObj) {
        List<CoreBaseInfo> invoices = IMClientUtils.getCoreBaseListFromF7(this.prmtIncomeInvoice.getValue());
        HashSet<String> newInvoiceIds = new HashSet<String>();
        Map<String, Set> oldInvoiceIds = this.getInvoiceIds();
        String bosType = ((MutilSelectListUIPromptDialog)this.prmtIncomeInvoice.getSelector()).containUI.getMultiSelectListUI().getSrcBosType();
        int size = invoices.size();
        ArrayList<PoolInvoiceInfo> invoiceList = new ArrayList<PoolInvoiceInfo>();
        PoolInvoiceInfo invoiceInfo = null;
        TMInvoiceType invoiceType = null;
        for (int i = 0; i < size; ++i) {
            IncomeInvoiceInfo info;
            if (invoices.get(i) instanceof IncomeInvoiceInfo) {
                info = (IncomeInvoiceInfo)invoices.get(i);
                if (oldInvoiceIds.get(bosType).contains(info.getId().toString())) {
                    newInvoiceIds.add(info.getId().toString());
                    continue;
                }
                invoiceInfo = new PoolInvoiceInfo();
                invoiceInfo.setId(info.getId().toString());
                invoiceType = this.getTmInvoiceType(info.getInvoiceType());
                invoiceInfo.setInvoiceTypeAlias(invoiceType == null ? null : invoiceType.toString());
                invoiceInfo.setInvoiceCode(info.getInvoiceCode());
                invoiceInfo.setInvoiceNumber(info.getInvoiceNumber());
                invoiceInfo.setAmountTax(info.getAmountTax());
                invoiceInfo.setAmount(info.getAmount());
                invoiceInfo.setTax(info.getTax());
                invoiceInfo.setBillingCompany(info.getBillingCompany());
                invoiceInfo.setSerialNo(info.getSerialNo());
                invoiceList.add(invoiceInfo);
                newInvoiceIds.add(info.getId().toString());
                continue;
            }
            if (!(invoices.get(i) instanceof CheckInvoiceBaseInfo)) continue;
            info = (CheckInvoiceBaseInfo)invoices.get(i);
            if (oldInvoiceIds.get(bosType).contains(info.getId().toString())) {
                newInvoiceIds.add(info.getId().toString());
                continue;
            }
            invoiceInfo = new PoolInvoiceInfo();
            invoiceInfo.setId(info.getId().toString());
            invoiceInfo.setInvoiceTypeAlias(info.getInvoiceType().getAlias());
            invoiceInfo.setInvoiceCode(info.getInvoiceCode());
            invoiceInfo.setInvoiceNumber(info.getInvoiceNo());
            invoiceInfo.setAmountTax(info.getTotalAmount());
            invoiceInfo.setAmount(info.getBigDecimal(TBL_INVOICEAMOUNT));
            invoiceInfo.setTax(info.getBigDecimal("totalTaxAmount"));
            invoiceInfo.setBillingCompany(info.getString("salerName"));
            invoiceInfo.setSerialNo(info.getSerialNo());
            invoiceList.add(invoiceInfo);
            newInvoiceIds.add(info.getId().toString());
        }
        this.fillTable(invoiceList);
        oldInvoiceIds.get(bosType).removeAll(newInvoiceIds);
        this.deleteRow(oldInvoiceIds.get(bosType));
        this.calFoot();
        this.prmtIncomeInvoice.setDataNoNotify(null);
        this.reBuildDataMap();
    }

    private TMInvoiceType getTmInvoiceType(PayInvoiceTypeEnum invoiceType) {
        TMInvoiceType tmInvoiceType = null;
        if (PayInvoiceTypeEnum.COMMONINVOICE.equals((Object)invoiceType)) {
            return TMInvoiceType.INVOICETYPE_COMMON_PAPER;
        }
        if (PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)invoiceType)) {
            return TMInvoiceType.INVOICETYPE_COMMON_ELECTRONIC;
        }
        if (PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)invoiceType)) {
            return TMInvoiceType.INVOICETYPE_SPECIAL_PAPER;
        }
        if (PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)invoiceType)) {
            return TMInvoiceType.INVOICETYPE_ELECTRONIC_SPECIAL;
        }
        return tmInvoiceType;
    }

    protected void kdtEntries_ChangedStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        String fieldName = this.tblMain.getColumnKey(colIndex);
        if (TBL_INVOICECODE.equals(fieldName) || TBL_INVOICENUMBER.equals(fieldName)) {
            this.loadInvoiceInfo(row);
        }
    }

    private void loadInvoiceInfo(IRow row) throws BOSException, EASBizException {
        String invoiceCode = (String)row.getCell(TBL_INVOICECODE).getValue();
        String invoiceNumber = (String)row.getCell(TBL_INVOICENUMBER).getValue();
        BigDecimal amountTax = null;
        BigDecimal amount = null;
        BigDecimal tax = null;
        String invoiceId = null;
        String invoiceTypeAlias = null;
        String salerName = null;
        TMInvoiceType tmInvoiceType = null;
        if (!StringUtils.isEmpty((String)invoiceNumber)) {
            Object[] invoiceNumbers = new String[]{invoiceNumber};
            Map invoiceMap = this.getInvoiceMap(Arrays.asList((Object[])invoiceNumbers));
            IObjectValue invoiceInfo = (IObjectValue)invoiceMap.get((StringUtils.isEmpty((String)invoiceCode) ? " " : invoiceCode) + CONNECTOR + invoiceNumber);
            if (invoiceInfo != null) {
                invoiceId = invoiceInfo.get("id").toString();
                if (invoiceInfo instanceof IncomeInvoiceInfo) {
                    amountTax = invoiceInfo.getBigDecimal("amountTax");
                    amount = invoiceInfo.getBigDecimal("amount");
                    tax = invoiceInfo.getBigDecimal("tax");
                    tmInvoiceType = this.getTmInvoiceType(PayInvoiceTypeEnum.getEnum((String)invoiceInfo.getString(TBL_INVOICETYPE)));
                    invoiceTypeAlias = tmInvoiceType == null ? null : tmInvoiceType.toString();
                    salerName = invoiceInfo.getString(TBL_BILLINGCOMPANY);
                } else if (invoiceInfo instanceof ExtendInvoiceInfo) {
                    amountTax = invoiceInfo.getBigDecimal("totalAmount");
                    amount = invoiceInfo.getBigDecimal(TBL_INVOICEAMOUNT);
                    tax = invoiceInfo.getBigDecimal("totalTaxAmount");
                    invoiceTypeAlias = ((ExtendTMInvoiceTypeInfo)invoiceInfo.getObjectValue("extendInvoiceType")).getName();
                    salerName = invoiceInfo.getString("salerName");
                } else {
                    InvoiceProperty invoiceProperty = TMPwyHelperUtils.getPropertyByBosType((String)String.valueOf(BOSUuid.read((String)invoiceId).getType()));
                    if (invoiceProperty == null) {
                        row.getCell(TBL_INVOICEAMOUNTTAX).setValue(null);
                        row.getCell(TBL_INVOICEAMOUNT).setValue(null);
                        row.getCell(TBL_INVOICETAX).setValue(null);
                        row.getCell(TBL_INVOICEID).setValue(null);
                        row.getCell(TBL_INVOICETYPE).setValue(null);
                        row.getCell(TBL_INVOICESERIAlNOS).setValue(null);
                        row.getCell(TBL_BILLINGCOMPANY).setValue(null);
                        this.calFoot();
                        return;
                    }
                    String amountTaxField = (String)invoiceProperty.getFieldsName().get("amountTax");
                    String amountField = (String)invoiceProperty.getFieldsName().get("amount");
                    String taxField = (String)invoiceProperty.getFieldsName().get("tax");
                    String invoiceTypeField = (String)invoiceProperty.getFieldsName().get(TBL_INVOICETYPE);
                    String billingCompanyField = (String)invoiceProperty.getFieldsName().get(TBL_BILLINGCOMPANY);
                    amountTax = StringUtils.isEmpty((String)amountTaxField) ? null : invoiceInfo.getBigDecimal(amountTaxField);
                    amount = StringUtils.isEmpty((String)amountField) ? null : invoiceInfo.getBigDecimal(amountField);
                    tax = StringUtils.isEmpty((String)taxField) ? null : invoiceInfo.getBigDecimal(taxField);
                    tmInvoiceType = TMInvoiceType.getEnum((String)invoiceInfo.getString(invoiceTypeField));
                    invoiceTypeAlias = tmInvoiceType == null ? null : tmInvoiceType.toString();
                    salerName = StringUtils.isEmpty((String)billingCompanyField) ? null : invoiceInfo.getString(billingCompanyField);
                }
                row.getCell(TBL_INVOICEAMOUNTTAX).setValue((Object)amountTax);
                row.getCell(TBL_INVOICEAMOUNT).setValue((Object)amount);
                row.getCell(TBL_INVOICETAX).setValue((Object)tax);
                row.getCell(TBL_INVOICEID).setValue((Object)invoiceId);
                row.getCell(TBL_INVOICETYPE).setValue((Object)invoiceTypeAlias);
                row.getCell(TBL_INVOICESERIAlNOS).setValue(invoiceInfo.get("serialNo"));
                row.getCell(TBL_BILLINGCOMPANY).setValue((Object)salerName);
            } else {
                row.getCell(TBL_INVOICEAMOUNTTAX).setValue(null);
                row.getCell(TBL_INVOICEAMOUNT).setValue(null);
                row.getCell(TBL_INVOICETAX).setValue(null);
                row.getCell(TBL_INVOICEID).setValue(null);
                row.getCell(TBL_INVOICETYPE).setValue(null);
                row.getCell(TBL_INVOICESERIAlNOS).setValue(null);
                row.getCell(TBL_BILLINGCOMPANY).setValue(null);
            }
            this.calFoot();
        }
    }

    private void deleteRow(Set<String> oldInvoiceIds) {
        IRow row = null;
        String invoiceId = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            invoiceId = (String)row.getCell(TBL_INVOICEID).getValue();
            if (StringUtils.isEmpty((String)invoiceId) || !oldInvoiceIds.contains(invoiceId) || !"1343913D".equals(BOSUuid.read((String)invoiceId).getType().toString()) && !"AF83503C".equals(BOSUuid.read((String)invoiceId).getType().toString())) continue;
            this.tblMain.removeRow(i);
            --i;
        }
    }

    private void initIncomeInvoiceF7() {
        EntityViewInfo view = this.getIncomeInvoiceF7Filter();
        this.prmtIncomeInvoice.setEnabledMultiSelection(true);
        IncomeInvoiceMutilSelectListUIPromptDialog uiPromptDialog = new IncomeInvoiceMutilSelectListUIPromptDialog((IUIObject)this);
        uiPromptDialog.setBOTPFilter(view);
        this.prmtIncomeInvoice.setSelector((KDPromptSelector)uiPromptDialog);
        this.prmtIncomeInvoice.setEditFormat("$number$");
        this.prmtIncomeInvoice.setDisplayFormat("$number$");
        this.prmtIncomeInvoice.setCommitFormat("$number$");
    }

    public EntityViewInfo getIncomeInvoiceF7Filter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizBillID", null, CompareType.IS));
        if (this.helperParam.getCompany() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.helperParam.getCompany().getId().toString()));
        }
        if (this.helperParam.getCurrAcct() != null && this.helperParam.getCurrAcct() instanceof SupplierInfo) {
            filter.getFilterItems().add(new FilterItemInfo("currAcctSupplier.id", (Object)this.helperParam.getCurrAcct().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("currAcctSupplier.id", null, CompareType.IS));
        }
        view.setFilter(filter);
        return view;
    }

    public void fillTable(List<PoolInvoiceInfo> invoiceList) {
        PoolInvoiceInfo invoiceInfo = null;
        for (int i = 0; i < invoiceList.size(); ++i) {
            String key;
            invoiceInfo = invoiceList.get(i);
            if (IMUtils.isEmpty(invoiceInfo.getInvoiceNumber()) || this.tblDataMap.containsKey(key = invoiceInfo.getInvoiceCode() + CONNECTOR + invoiceInfo.getInvoiceNumber())) continue;
            IRow row = this.tblMain.addRow();
            if (!StringUtils.isEmpty((String)invoiceInfo.getId())) {
                row.getStyleAttributes().setLocked(true);
            }
            row.getCell(TBL_INVOICETYPE).setValue((Object)invoiceInfo.getInvoiceTypeAlias());
            row.getCell(TBL_INVOICECODE).setValue((Object)invoiceInfo.getInvoiceCode());
            row.getCell(TBL_INVOICENUMBER).setValue((Object)invoiceInfo.getInvoiceNumber());
            row.getCell(TBL_INVOICEAMOUNTTAX).setValue((Object)invoiceInfo.getAmountTax());
            row.getCell(TBL_INVOICEAMOUNT).setValue((Object)invoiceInfo.getAmount());
            row.getCell(TBL_INVOICETAX).setValue((Object)invoiceInfo.getTax());
            row.getCell(TBL_INVOICEID).setValue((Object)invoiceInfo.getId());
            row.getCell(TBL_INVOICESERIAlNOS).setValue((Object)invoiceInfo.getSerialNo());
            row.getCell(TBL_BILLINGCOMPANY).setValue((Object)invoiceInfo.getBillingCompany());
            this.tblDataMap.put(key, i + 1);
        }
        this.calFoot();
    }

    public Map<String, Set> getInvoiceIds() {
        int rowCount = this.tblMain.getRowCount();
        IRow row = null;
        String invoiceId = null;
        HashMap<String, Set> idSet = new HashMap<String, Set>();
        HashSet<String> incomeSet = new HashSet<String>();
        HashSet<String> fullSet = new HashSet<String>();
        HashSet<String> allSet = new HashSet<String>();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            invoiceId = (String)row.getCell(TBL_INVOICEID).getValue();
            if (StringUtils.isEmpty((String)invoiceId)) continue;
            if ("1343913D".equals(BOSUuid.read((String)invoiceId).getType().toString())) {
                incomeSet.add(invoiceId);
                allSet.add(invoiceId);
                continue;
            }
            if (!"AF83503C".equals(BOSUuid.read((String)invoiceId).getType().toString())) continue;
            fullSet.add(invoiceId);
            allSet.add(invoiceId);
        }
        idSet.put("1343913D", incomeSet);
        idSet.put("AF83503C", fullSet);
        idSet.put("all", allSet);
        return idSet;
    }

    public Set<String> getInvoiceSerialNo() {
        int rowCount = this.tblMain.getRowCount();
        IRow row = null;
        String invoiceSerialNo = null;
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            invoiceSerialNo = (String)row.getCell(TBL_INVOICESERIAlNOS).getValue();
            if (StringUtils.isEmpty((String)invoiceSerialNo)) continue;
            idSet.add(invoiceSerialNo);
        }
        return idSet;
    }

    @Override
    public void actionPwyDownload_actionPerformed(ActionEvent e) throws Exception {
        Set<String> InvoiceSerialNo = this.getInvoiceSerialNo();
        this.helperParam.getParams().put(TBL_INVOICESERIAlNOS, StringUtils.arrayToString((Object[])InvoiceSerialNo.toArray(), (String)","));
        this.helperParam.setOperation(InvoiceHelperParam.OPR_DOWNLOAD);
        this.pwyinvoiceHelper.invoiceHelperAction(this.helperParam);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        Map ret = this.checkResult();
        boolean isRepeat = (Boolean)ret.get("isRepeat");
        if (isRepeat) {
            int showConfirm = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"AutoRemoveRepeatInvoice"));
            if (0 != showConfirm) return;
            this.resultMap.put("invoiceCodes", ret.get("invoiceCodes"));
            this.resultMap.put("invoiceNumbers", ret.get("invoiceNumbers"));
            this.resultMap.put("invoiceTypeAlias", ret.get("invoiceTypeAlias"));
        } else {
            this.resultMap.put("invoiceCodes", ret.get("invoiceCodes"));
            this.resultMap.put("invoiceNumbers", ret.get("invoiceNumbers"));
            this.resultMap.put("invoiceTypeAlias", ret.get("invoiceTypeAlias"));
        }
        this.getUIWindow().close();
    }

    public Map checkResult() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> invNumbers = new ArrayList<String>();
        ArrayList<String> invCodes = new ArrayList<String>();
        HashSet<String> invoiceTypeAlias = new HashSet<String>();
        LinkedHashSet<String> invCodeNumSet = new LinkedHashSet<String>();
        int count = this.tblMain.getRowCount();
        result.put("isRepeat", false);
        String invCode = "";
        String invNumber = "";
        String invoiceCodes = "";
        String invoiceNumbers = "";
        String invoiceType = "";
        for (int i = 0; i < count; ++i) {
            invNumber = (String)this.tblMain.getRow(i).getCell(TBL_INVOICENUMBER).getValue();
            if (StringUtils.isEmpty((String)invNumber)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"InvoiceNumberNotNull"));
                SysUtil.abort();
            }
            String string = invCode = StringUtils.isEmpty((String)(invCode = (String)this.tblMain.getRow(i).getCell(TBL_INVOICECODE).getValue())) ? "FULL" : invCode;
            if (!invCodeNumSet.contains(invCode + CONNECTOR + invNumber)) {
                invCodes.add(invCode);
                invNumbers.add(invNumber);
                invCodeNumSet.add(invCode + CONNECTOR + invNumber);
            } else {
                result.put("isRepeat", true);
            }
            invoiceType = (String)this.tblMain.getRow(i).getCell(TBL_INVOICETYPE).getValue();
            invoiceTypeAlias.add(invoiceType);
        }
        if (invNumbers.size() != 0) {
            for (String invoiceCode : invCodes) {
                invoiceCodes = invoiceCodes + invoiceCode + ";";
            }
            invoiceCodes = invoiceCodes.substring(0, invoiceCodes.length() - 1);
            for (String invoiceNumber : invNumbers) {
                invoiceNumbers = invoiceNumbers + invoiceNumber + ";";
            }
            invoiceNumbers = invoiceNumbers.substring(0, invoiceNumbers.length() - 1);
        }
        result.put("invoiceCodes", invoiceCodes);
        result.put("invoiceNumbers", invoiceNumbers);
        result.put("invoiceTypeAlias", IMUtils.getStringFromSet(invoiceTypeAlias));
        return result;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        logger.info((Object)"InvoiceHelperUI Cancel");
        this.getUIWindow().close();
    }

    public HashMap getResultMap() {
        return this.resultMap;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = rows.length - 1; i >= 0; --i) {
            int rowIndex = rows[i];
            this.tblMain.removeRow(rowIndex);
        }
        this.reBuildDataMap();
        this.calFoot();
    }

    private void reBuildDataMap() {
        int count = this.tblMain.getRowCount();
        this.tblDataMap.clear();
        for (int i = 0; i < count; ++i) {
            String invoiceCode = (String)this.tblMain.getRow(i).getCell(TBL_INVOICECODE).getValue();
            String invoiceNumber = (String)this.tblMain.getRow(i).getCell(TBL_INVOICENUMBER).getValue();
            String key = invoiceCode + CONNECTOR + invoiceNumber;
            this.tblDataMap.put(key, i + 1);
        }
    }
}

