/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client.comp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.common.help.msgHelp.client.util.TMMsgURLUtil;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.client.ElecTicketResendUI;
import com.kingdee.eas.tm.im.client.util.IMClientUtils;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoicePwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.common.uihelper.IAsyncJob;
import com.kingdee.eas.tm.im.common.uihelper.UIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MakeInvoiceHelper {
    private CoreUI comp = null;
    private UIHelper uiHelper = null;
    private int invoicePercent = 0;

    public MakeInvoiceHelper(CoreUI comp, int invoicePercent) {
        this.comp = comp;
        this.invoicePercent = invoicePercent;
        this.uiHelper = new UIHelper(comp);
    }

    public void doMakeInvoice(ActionEvent e, final ArrayList ids, final IAsyncJob job) {
        if (this.comp instanceof CoreBillListUI) {
            ((CoreBillListUI)this.comp).checkSelected();
        } else if (this.comp instanceof CoreBillEditUI) {
            ((CoreBillEditUI)this.comp).checkSelected();
        }
        if (ids == null || ids.size() == 0) {
            return;
        }
        this.invoicePercent = 0;
        String parentTxt = "";
        if (e.getSource() instanceof KDWorkButton) {
            KDWorkButton button = (KDWorkButton)e.getSource();
            parentTxt = button.getText();
        } else {
            KDMenuItem item = (KDMenuItem)e.getSource();
            item.getText();
            parentTxt = item.getText();
        }
        this.uiHelper.doInDeamon(e, new IAsyncJob(){

            @Override
            public CoreUI getOwner() {
                return MakeInvoiceHelper.this.comp;
            }

            @Override
            public int getProgress() {
                return MakeInvoiceHelper.this.invoicePercent;
            }

            @Override
            public Object execute() {
                try {
                    MakeInvoiceHelper.this.innerMakeInvoiceWithLock(ids);
                    job.execute();
                }
                catch (Exception e) {
                    MakeInvoiceHelper.this.comp.handUIException((Throwable)e);
                }
                return null;
            }
        });
    }

    private void innerMakeInvoiceWithLock(ArrayList ids) throws BOSException, EASBizException, JSONException {
        try {
            IMUtils.tryLock(ids);
            this.innerMakeInvoice(ids);
        }
        finally {
            IMUtils.releaseLock(ids);
        }
    }

    private void innerMakeInvoice(ArrayList ids) throws BOSException, EASBizException {
        Map resultMap;
        int i;
        if (ids == null || ids.isEmpty()) {
            return;
        }
        HashMap<String, String> numMap = new HashMap<String, String>();
        ArrayList<String> errorMsg = new ArrayList<String>();
        HashSet idSet = IMUtils.list2Set(ids);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        MakeInvoiceCollection makeInvoiceColl = MakeInvoiceFactory.getRemoteInstance().getMakeInvoiceCollection(ev);
        ArrayList<String> relectList = new ArrayList<String>();
        ArrayList<String> paperList = new ArrayList<String>();
        HashMap<String, MakeInvoiceInfo> invoiceMap = new HashMap<String, MakeInvoiceInfo>();
        MakeInvoiceInfo mkInfo = null;
        for (int i2 = 0; i2 < makeInvoiceColl.size(); ++i2) {
            mkInfo = makeInvoiceColl.get(i2);
            invoiceMap.put(mkInfo.getId().toString(), mkInfo);
            numMap.put(mkInfo.getId().toString(), mkInfo.getNumber());
        }
        String billID = null;
        for (int i3 = 0; i3 < ids.size(); ++i3) {
            billID = (String)ids.get(i3);
            mkInfo = (MakeInvoiceInfo)invoiceMap.get(billID);
            if ("2".equals(mkInfo.getInvoiceType().getValue()) || "4".equals(mkInfo.getInvoiceType().getValue()) || "5".equals(mkInfo.getInvoiceType().getValue())) {
                relectList.add(mkInfo.getId().toString());
                continue;
            }
            paperList.add(mkInfo.getId().toString());
        }
        HashMap<String, Map> allMap = new HashMap<String, Map>();
        ArrayList<Map> list = new ArrayList<Map>();
        if (!relectList.isEmpty()) {
            ArrayList list1 = IMInvoiceFacadeFactory.getRemoteInstance().buildPwyParam(relectList, PwyServiceType.OPR_INV_DISKELECT_MAKE, TransSrcSystemEnum.easgui);
            for (i = 0; i < list1.size(); ++i) {
                resultMap = (Map)list1.get(i);
                allMap.put(resultMap.get("billId").toString(), resultMap);
            }
        }
        if (!paperList.isEmpty()) {
            ArrayList list2 = IMInvoiceFacadeFactory.getRemoteInstance().buildPwyParam(paperList, PwyServiceType.OPR_INV_PAPER_MAKE, TransSrcSystemEnum.easgui);
            for (i = 0; i < list2.size(); ++i) {
                resultMap = (Map)list2.get(i);
                allMap.put(resultMap.get("billId").toString(), resultMap);
            }
        }
        for (int i4 = 0; i4 < ids.size(); ++i4) {
            String id = ids.get(i4).toString();
            Map tempMap = (Map)allMap.get(id);
            if (tempMap == null) continue;
            list.add(tempMap);
        }
        BigDecimal a = new BigDecimal(90);
        BigDecimal b = new BigDecimal(list.size());
        BigDecimal c = BigDecimal.ZERO;
        if (list.size() > 0) {
            c = a.divide(b, 2, RoundingMode.HALF_UP);
        }
        for (int i5 = 0; i5 < list.size(); ++i5) {
            this.invoicePercent = 10 + c.multiply(new BigDecimal(i5)).intValue();
            Map resultMap2 = (Map)list.get(i5);
            if (resultMap2.get("error") != null) {
                String id = resultMap2.get("error").toString();
                if (id.equals("exception")) {
                    errorMsg.add((String)resultMap2.get("exception"));
                    continue;
                }
                errorMsg.add(numMap.get(id) + ":" + resultMap2.get(id) + "\r\n");
                continue;
            }
            String invoiceNum = (String)resultMap2.get("number");
            PwyInvokeParam invokeParam = (PwyInvokeParam)resultMap2.get("invokeParam");
            MakeInvoicePwyService pwyService = (MakeInvoicePwyService)PwyServiceHelper.getPwyService(null, invokeParam);
            pwyService.invoke();
            if (pwyService.isSuccess()) continue;
            errorMsg.add(invoiceNum + ":" + pwyService.getInvokeParam().getDescription() + "\r\n");
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"MAKEINVOICE_MSG_BILL", (Object[])new Object[]{ids.size() - errorMsg.size(), errorMsg.size()});
        IMClientUtils.showMsgAfterCurrentThread((Component)this.comp, msg, IMUtils.buildErrorMsg(errorMsg), 1, TMMsgURLUtil.getMsgURL((String)"IMK"));
    }

    public void doInDeamonWithElecTicketResend(ActionEvent e, final ArrayList ids, final IAsyncJob job) {
        if (this.comp instanceof CoreBillListUI) {
            ((CoreBillListUI)this.comp).checkSelected();
        } else if (this.comp instanceof CoreBillEditUI) {
            ((CoreBillEditUI)this.comp).checkSelected();
        }
        if (ids == null || ids.size() == 0) {
            return;
        }
        this.invoicePercent = 0;
        this.uiHelper.doInDeamon(e, new IAsyncJob(){

            @Override
            public CoreUI getOwner() {
                return MakeInvoiceHelper.this.comp;
            }

            @Override
            public int getProgress() {
                return MakeInvoiceHelper.this.invoicePercent;
            }

            @Override
            public Object execute() {
                try {
                    MakeInvoiceHelper.this.innerElecTicketResendWithLock(ids);
                    job.execute();
                }
                catch (Exception e) {
                    MakeInvoiceHelper.this.comp.handUIException((Throwable)e);
                }
                return null;
            }
        });
    }

    private void innerElecTicketResendWithLock(ArrayList ids) throws BOSException, EASBizException, JSONException {
        try {
            IMUtils.tryLock(ids);
            this.doInvoiceElecTicketResend(ids);
        }
        catch (Exception e) {
            this.comp.handUIException((Throwable)e);
        }
        finally {
            IMUtils.releaseLock(ids);
        }
    }

    private void doInvoiceElecTicketResend(ArrayList invocieIds) throws Exception {
        ArrayList ids = new ArrayList();
        ArrayList retArray = null;
        for (int i = 0; i < invocieIds.size(); ++i) {
            ids.add(invocieIds.get(i));
        }
        Map retValue = IMInvoiceFacadeFactory.getRemoteInstance().checkBeforeElecTicketResend(ids);
        if (retValue.get("errorMsg") != null && !IMUtils.isEmpty((String)retValue.get("errorMsg"))) {
            String msg = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ElecTicketResend_ERROR", IMUtils.getLocale());
            MsgBox.showDetailAndOK((Component)this.comp, (String)msg, (String)retValue.get("errorMsg").toString(), (int)1);
            return;
        }
        if (retValue.get("isConsistent") != null && ((Boolean)retValue.get("isConsistent")).booleanValue()) {
            UIContext uiContext = new UIContext((Object)this.comp);
            uiContext.put((Object)"ids", ids);
            uiContext.put((Object)"recBillEmail", retValue.get("recBillEmail"));
            uiContext.put((Object)"cellphone", retValue.get("cellphone"));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ElecTicketResendUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            ElecTicketResendUI ui = (ElecTicketResendUI)uiWindow.getUIObject();
            if (!ui.isOk()) {
                return;
            }
        }
        retArray = IMInvoiceFacadeFactory.getRemoteInstance().buildElecTicketResend(ids, TransSrcSystemEnum.easgui);
        BigDecimal a = new BigDecimal(90);
        BigDecimal b = new BigDecimal(retArray.size());
        BigDecimal c = BigDecimal.ZERO;
        if (retArray.size() > 0) {
            c = a.divide(b, 2, RoundingMode.HALF_UP);
        }
        int invokeSuccessCount = 0;
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < retArray.size(); ++i) {
            this.invoicePercent = 10 + c.multiply(new BigDecimal(i)).intValue();
            HashMap map = (HashMap)retArray.get(i);
            MakeInvoiceInfo info = (MakeInvoiceInfo)map.get("info");
            String invoiceNum = (String)map.get("number");
            String id = (String)map.get("id");
            PwyInvokeParam invokeParam = (PwyInvokeParam)map.get("invokeParam");
            MakeInvoicePwyService pwyService = (MakeInvoicePwyService)PwyServiceHelper.getPwyService(null, invokeParam);
            pwyService.invoke();
            if (!pwyService.isSuccess()) {
                msg.append(invoiceNum).append(" : ").append(pwyService.getInvokeParam().getDescription()).append("\r\n");
                continue;
            }
            ++invokeSuccessCount;
            LogUtils.afterLog(null, (IObjectPK)retValue.get(id));
        }
        String elecTicketResendError = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ElecTicketResend_COMPLETE", IMUtils.getLocale(), new Object[]{invokeSuccessCount, retArray.size() - invokeSuccessCount});
        MsgBox.showDetailAndOK((Component)this.comp, (String)elecTicketResendError, (String)msg.toString(), (int)1);
    }

    public void doInDeamonWithPrint(ActionEvent e, final ArrayList ids, final boolean isPrintList, final boolean isRePrint, final IAsyncJob job) {
        if (this.comp instanceof CoreBillListUI) {
            ((CoreBillListUI)this.comp).checkSelected();
        } else if (this.comp instanceof CoreBillEditUI) {
            ((CoreBillEditUI)this.comp).checkSelected();
        }
        if (ids == null || ids.size() == 0) {
            return;
        }
        this.invoicePercent = 0;
        this.uiHelper.doInDeamon(e, new IAsyncJob(){

            @Override
            public CoreUI getOwner() {
                return MakeInvoiceHelper.this.comp;
            }

            @Override
            public int getProgress() {
                return MakeInvoiceHelper.this.invoicePercent;
            }

            @Override
            public Object execute() {
                try {
                    MakeInvoiceHelper.this.innerPrintInvoiceWithLock(ids, isPrintList, isRePrint);
                    job.execute();
                }
                catch (Exception e) {
                    MakeInvoiceHelper.this.comp.handUIException((Throwable)e);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerPrintInvoiceWithLock(ArrayList ids, boolean isPrintList, boolean isRePrint) throws BOSException, EASBizException, JSONException {
        try {
            IMUtils.tryLock(ids);
            this.doInvoicePrint(ids, isPrintList, isRePrint);
        }
        catch (Exception e) {
            this.comp.handUIException((Throwable)e);
        }
        finally {
            IMUtils.releaseLock(ids);
        }
    }

    private void doInvoicePrint(ArrayList invocieIds, boolean isPrintList, boolean isRePrint) throws Exception {
        String msg;
        HashSet idSet = new HashSet();
        for (int i = 0; i < invocieIds.size(); ++i) {
            idSet.add(invocieIds.get(i));
        }
        ArrayList retArray = null;
        Map retValue = null;
        String operName = "";
        String opType = "";
        String printList_alias = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "PrintList", IMUtils.getLocale());
        String rePrintInvoice_alias = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "RePrintInvoice", IMUtils.getLocale());
        String printInvoice_alias = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "PrintInvoice", IMUtils.getLocale());
        if (isPrintList) {
            retValue = IMInvoiceFacadeFactory.getRemoteInstance().checkBeforePrintList(idSet);
            operName = printList_alias;
            opType = "printList";
        } else if (isRePrint) {
            retValue = IMInvoiceFacadeFactory.getRemoteInstance().checkBeforeRePrint(idSet);
            operName = rePrintInvoice_alias;
            opType = "rePrintInvoice";
        } else {
            retValue = IMInvoiceFacadeFactory.getRemoteInstance().checkBeforePrint(idSet);
            operName = printInvoice_alias;
            opType = "printInvoice";
        }
        if (retValue.get("errorMsg") != null) {
            String msg2 = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"PRINT_ERROR");
            MsgBox.showDetailAndOK((Component)this.comp, (String)msg2, (String)retValue.get("errorMsg").toString(), (int)1);
            return;
        }
        if (retValue.get("successMsg") != null && !MsgBox.isYes((int)MsgBox.showConfirm2((Component)this.comp, (String)(msg = retValue.get("successMsg") + "\n" + IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ConfirmContinue", IMUtils.getLocale()) + operName + "\uff1f")))) {
            return;
        }
        Map logPkMap = IMInvoiceFacadeFactory.getRemoteInstance().beginPrintInvoiceLog(idSet, opType);
        ArrayList orderIds = (ArrayList)retValue.get("orderIds");
        retArray = isPrintList ? IMInvoiceFacadeFactory.getRemoteInstance().buildPwyPrintListParam(orderIds, TransSrcSystemEnum.easgui) : IMInvoiceFacadeFactory.getRemoteInstance().buildPwyPrintParam(orderIds, TransSrcSystemEnum.easgui);
        BigDecimal a = new BigDecimal(90);
        BigDecimal b = new BigDecimal(retArray.size());
        BigDecimal c = BigDecimal.ZERO;
        if (retArray.size() > 0) {
            c = a.divide(b, 2, RoundingMode.HALF_UP);
        }
        StringBuffer msg3 = new StringBuffer();
        for (int i = 0; i < retArray.size(); ++i) {
            this.invoicePercent = 10 + c.multiply(new BigDecimal(i)).intValue();
            HashMap map = (HashMap)retArray.get(i);
            String invoiceNum = (String)map.get("number");
            String id = (String)map.get("id");
            PwyInvokeParam invokeParam = (PwyInvokeParam)map.get("invokeParam");
            MakeInvoicePwyService pwyService = (MakeInvoicePwyService)PwyServiceHelper.getPwyService(null, invokeParam);
            pwyService.invoke();
            if (!pwyService.isSuccess()) {
                msg3.append(invoiceNum).append(" : ").append(pwyService.getInvokeParam().getDescription()).append("\r\n");
                break;
            }
            if (logPkMap == null || !logPkMap.containsKey(id)) continue;
            LogUtils.afterLog(null, (IObjectPK)logPkMap.get(id));
        }
        if (msg3.length() > 0) {
            String printError = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"PRINT_ERROR");
            MsgBox.showDetailAndOK((Component)this.comp, (String)printError, (String)msg3.toString(), (int)1);
        } else {
            String printSucess = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"PRINT_SUCESS");
            MsgBox.showInfo((String)printSucess);
        }
    }

    private IObjectPK beginLog(MakeInvoiceInfo info, String opType) {
        String methodName = "";
        String logItemName = "";
        String logDetail = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "LogDetail", IMUtils.getLocale(), new Object[]{info.getInvoiceNo(), info.getInvoiceNumber()});
        String printList_alias = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "PrintList", IMUtils.getLocale());
        String rePrintInvoice_alias = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "RePrintInvoice", IMUtils.getLocale());
        String printInvoice_alias = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "PrintInvoice", IMUtils.getLocale());
        if (opType.equals(printList_alias)) {
            methodName = "printList";
            logItemName = "im_mkInvoice_printInvoiceList";
        } else if (opType.equals(rePrintInvoice_alias)) {
            methodName = "rePrintInvoice";
            logItemName = "im_mkInvoice_rePrintInvoice";
        } else if (opType.equals(printInvoice_alias)) {
            methodName = "printInvoice";
            logItemName = "im_mkInvoice_printInvoice";
        }
        IObjectPK logPk = LogUtils.beginLog(null, methodName, BOSObjectType.create((String)"412A6F98"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), logDetail, logItemName, "");
        return logPk;
    }
}

