/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client.comp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.tm.common.help.msgHelp.client.util.TMMsgURLUtil;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.MakeVolumnInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingCollection;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.client.MakeInvoiceListUI;
import com.kingdee.eas.tm.im.client.MakeInvoiceReqEditUI;
import com.kingdee.eas.tm.im.client.MySwingWork;
import com.kingdee.eas.tm.im.client.MyThreadPool;
import com.kingdee.eas.tm.im.client.SelectVolumnInvoiceUI;
import com.kingdee.eas.tm.im.client.util.IMClientUtils;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.msg.parser.TaxCardParser;
import com.kingdee.eas.tm.im.common.comm.msg.result.TaxCardInfo;
import com.kingdee.eas.tm.im.common.comm.msg.result.TaxCardVolumnInfo;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoicePwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.util.IMSelectorFactory;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MakeVolumnInvoiceClientService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.client.comp.MakeVolumnInvoiceService");
    private CoreUI owner = null;
    private int invoiceCount = 0;
    private int unInvoiceCount = 0;
    private Map msgParam;
    private int billSize = 0;
    private List errorMsg = new ArrayList();
    private int errorCount = 0;
    private List<String> settingIds = new ArrayList<String>();
    private Map<String, List<Map>> setting2InvoiceMap = new HashMap<String, List<Map>>();
    private Map<String, TaxCardInfo> setting2TaxCardMap = new HashMap<String, TaxCardInfo>();
    private Map<String, PwySettingInfo> settingMap = new HashMap<String, PwySettingInfo>();

    public MakeVolumnInvoiceClientService(CoreUI owner) {
        this.owner = owner;
    }

    public MakeVolumnInvoiceClientService(CoreUI owner, Map msgParam) {
        this.owner = owner;
        this.msgParam = msgParam;
    }

    public void invoice(final ArrayList ids) throws BOSException, EASBizException {
        final ArrayList exceptionList = new ArrayList();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MakeVolumnInvoiceClientService.this.innerInvoice(ids);
                }
                catch (Exception e) {
                    exceptionList.add(e);
                }
            }
        }).start();
        if (exceptionList.size() > 0) {
            if (exceptionList.get(0) instanceof BOSException) {
                throw (BOSException)((Object)exceptionList.get(0));
            }
            if (exceptionList.get(0) instanceof EASBizException) {
                throw (BOSException)((Object)exceptionList.get(0));
            }
            throw new BOSException((Throwable)exceptionList.get(0));
        }
    }

    public void innerInvoice(ArrayList ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        this.billSize = ids.size();
        this.errorMsg = MakeVolumnInvoiceFacadeFactory.getRemoteInstance().checkBeforeInvoice(ids);
        if (this.errorMsg.size() > 0) {
            if (this.msgParam == null) {
                String msg = IMUtils.getString("com.kingdee.eas.tm.im.MakeVolumnInvoiceResource", "MSG_CHECKFAILURE_MAKEINVOICE", IMUtils.getLocale());
                IMClientUtils.showMsgAfterCurrentThread((Component)this.owner, msg, IMUtils.buildErrorMsg(this.errorMsg), 1, TMMsgURLUtil.getMsgURL((String)"IMK"));
            } else {
                this.dealMsg();
            }
            return;
        }
        this.openSelectVolumnInvoiceUI(ids);
        if (this.setting2TaxCardMap.size() == 0) {
            this.dealMsg();
        }
    }

    protected void openSelectVolumnInvoiceUI(ArrayList ids) throws BOSException, EASBizException {
        String settingID;
        HashMap<String, Boolean> otherParams = new HashMap<String, Boolean>();
        otherParams.put("isInvokeWriteLog", Boolean.FALSE);
        ArrayList list = IMInvoiceFacadeFactory.getRemoteInstance().buildPwyParamEx(ids, PwyServiceType.OPR_INV_PAPER_MAKE, TransSrcSystemEnum.easgui, otherParams);
        ArrayList<PwyActionParam> taxCardParamList = new ArrayList<PwyActionParam>();
        for (int i = 0; i < list.size(); ++i) {
            Map resultMap = (Map)list.get(i);
            if (resultMap.get("error") != null) {
                String id = resultMap.get("error").toString();
                if (id.equals("exception")) {
                    this.errorMsg.add(resultMap.get("exception"));
                } else {
                    this.errorMsg.add(resultMap.get("number") + ":" + resultMap.get(id) + "\r\n");
                }
                ++this.errorCount;
                continue;
            }
            PwyInvokeParam invokeParam = (PwyInvokeParam)resultMap.get("invokeParam");
            String billId = invokeParam.getBillId();
            settingID = invokeParam.getSetting().getId().toString();
            if (!this.setting2InvoiceMap.containsKey(settingID)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("isUpdateInvoiceInvMgr", false);
                params.put("pwyId", settingID);
                PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_PAPER_TAXCARD, TransSrcSystemEnum.easgui, invokeParam.getOrgId(), null, params);
                taxCardParamList.add(actionParam);
                this.settingIds.add(settingID);
                this.setting2InvoiceMap.put(settingID, new ArrayList());
            }
            this.setting2InvoiceMap.get(settingID).add(resultMap);
        }
        this.settingMap = this.loadPwySetting(this.settingIds);
        List taxCardResultList = PwyServiceFacadeFactory.getRemoteInstance().buildPwyParam(taxCardParamList);
        PwyInvokeParam invokeParam2 = null;
        for (PwyInvokeParam invokeParam2 : taxCardResultList) {
            MakeInvoicePwyService pwyService = (MakeInvoicePwyService)PwyServiceHelper.getPwyService(null, invokeParam2);
            pwyService.invoke();
            settingID = pwyService.getInvokeParam().getSetting().getId().toString();
            String orgName = this.settingMap.get(settingID).getCompany().getName();
            String getTaxCardFailure = IMUtils.getString("com.kingdee.eas.tm.im.MakeVolumnInvoiceResource", "MSG_GETTAXCARD_FAILURE", IMUtils.getLocale());
            boolean isFailure = false;
            if (!pwyService.isSuccess()) {
                this.errorMsg.add(orgName + "," + getTaxCardFailure + ":" + pwyService.getInvokeParam().getDescription() + "\r\n");
                isFailure = true;
            } else {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("retInfo", pwyService.getInvokeParam().getRevMsg());
                TaxCardParser parser = new TaxCardParser();
                try {
                    TaxCardInfo taxCardInfo = (TaxCardInfo)parser.parse(null, param);
                    if (taxCardInfo == null) {
                        this.errorMsg.add(orgName + "," + getTaxCardFailure + ":parse ERROR! \r\n");
                        isFailure = true;
                    } else {
                        this.setting2TaxCardMap.put(settingID, taxCardInfo);
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    this.errorMsg.add(orgName + "," + getTaxCardFailure + ":parse ERROR! \r\n");
                    isFailure = true;
                }
            }
            if (!isFailure) continue;
            List<Map> invoiceList = this.setting2InvoiceMap.get(settingID);
            this.errorCount += invoiceList.size();
            this.setting2InvoiceMap.remove(settingID);
        }
        if (this.setting2TaxCardMap.size() != 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"setting2TaxCardMap", this.setting2TaxCardMap);
            uiContext.put((Object)"settingIds", this.settingIds);
            uiContext.put((Object)"setting2InvoiceMap", this.setting2InvoiceMap);
            uiContext.put((Object)"errorMsg", (Object)this.errorMsg);
            String uiClass = "com.kingdee.eas.tm.im.client.SelectVolumnInvoiceUI";
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            SelectVolumnInvoiceUI ui = (SelectVolumnInvoiceUI)uiWindow.getUIObject();
            if (ui.isConfirm()) {
                this.asyncMakeInvoice();
            } else if (!(this.owner instanceof MakeInvoiceListUI)) {
                for (int i = 0; i < this.settingIds.size(); ++i) {
                    List<Map> invoiceList = this.setting2InvoiceMap.get(this.settingIds.get(i));
                    this.errorCount += invoiceList.size();
                }
                this.dealMsg();
            }
        }
    }

    private void dealMsg() throws UIException {
        String respErrorMsg;
        String msg;
        String fromSrc = "";
        if (this.msgParam != null && this.msgParam.get("fromSrc") != null) {
            fromSrc = (String)this.msgParam.get("fromSrc");
        }
        if (this.msgParam != null) {
            if (IMConstant.SRCTYPE_FI_AR.equals(fromSrc)) {
                Integer srcBillSize = (Integer)this.msgParam.get("billSize");
                ArrayList srcFailBills = (ArrayList)this.msgParam.get("srcFailBills");
                msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"ALL_MKINVOICE_MSG", (Object[])new Object[]{srcBillSize - srcFailBills.size(), srcFailBills.size(), this.billSize - this.errorCount, this.errorCount});
                respErrorMsg = (String)this.msgParam.get("respErrorMsg") + "\r\n" + IMUtils.buildErrorMsg(this.errorMsg);
            } else if (IMConstant.SRCTYPE_IM_INVOICEREQ.equals(fromSrc)) {
                Integer srcBillSize = (Integer)this.msgParam.get("billSize");
                ArrayList srcFailBills = (ArrayList)this.msgParam.get("srcFailBills");
                msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"ALL_MAKEINVOICE_REQ_MSG", (Object[])new Object[]{srcBillSize - srcFailBills.size(), srcFailBills.size(), this.billSize - this.errorCount, this.errorCount});
                respErrorMsg = IMUtils.buildErrorMsg(this.errorMsg);
            } else {
                msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"MAKEINVOICE_MSG_BILL", (Object[])new Object[]{this.billSize - this.errorCount, this.errorCount});
                respErrorMsg = IMUtils.buildErrorMsg(this.errorMsg);
            }
        } else {
            msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"MAKEINVOICE_MSG_BILL", (Object[])new Object[]{this.billSize - this.errorCount, this.errorCount});
            respErrorMsg = IMUtils.buildErrorMsg(this.errorMsg);
        }
        IMClientUtils.showMsgAfterCurrentThread((Component)this.owner, msg, respErrorMsg, 1, TMMsgURLUtil.getMsgURL((String)"IMK"));
    }

    private void asyncMakeInvoice() {
        String title = IMUtils.getString("com.kingdee.eas.tm.im.MakeVolumnInvoiceResource", "MSG_SETVOLUMN", IMUtils.getLocale());
        final MonitorInfo info = new MonitorInfo(title, null, (Object)this, true);
        MySwingWork worker = new MySwingWork(){

            public Object construct() {
                try {
                    Map msgMap = this.getMsgParam();
                    MakeVolumnInvoiceClientService.this.makeInvoiceWithLock(msgMap);
                    if (MakeVolumnInvoiceClientService.this.owner instanceof ListUI) {
                        ((ListUI)MakeVolumnInvoiceClientService.this.owner).refreshList();
                    } else if (MakeVolumnInvoiceClientService.this.owner instanceof MakeInvoiceReqEditUI) {
                        ((MakeInvoiceReqEditUI)MakeVolumnInvoiceClientService.this.owner).refreshCurPage();
                    }
                }
                catch (Exception ex) {
                    MakeVolumnInvoiceClientService.this.owner.handUIException((Throwable)ex);
                }
                catch (Throwable ex) {
                    MakeVolumnInvoiceClientService.this.owner.handUIException(ex);
                }
                return null;
            }

            public void finished() {
                this.timerStop();
                MyThreadPool.destroyMonitor(info);
                MyThreadPool.destroyPorgressDialog();
            }

            @Override
            public void refreshProgress() {
                MyThreadPool.refreshProgress(MakeVolumnInvoiceClientService.this.getInvoicePercent());
            }
        };
        worker.setMsgParam(this.msgParam);
        info.setWorker((SwingWorker)worker);
        MyThreadPool.getInstance();
        MyThreadPool.addActionThread(info);
        MyThreadPool.setBackgroundRunButtonEnabled(false);
    }

    protected Map makeInvoiceWithLock(Map msgMap) throws BOSException, EASBizException {
        List<String> invoiceIds = this.getInvoiceIds(this.setting2InvoiceMap);
        try {
            IMUtils.tryLock(invoiceIds);
            this.makeInvoice(msgMap);
        }
        finally {
            IMUtils.releaseLock(invoiceIds);
        }
        return msgMap;
    }

    private List<String> getInvoiceIds(Map<String, List<Map>> setting2InvoiceMap) {
        ArrayList<String> invoiceIds = new ArrayList<String>();
        this.unInvoiceCount = this.invoiceCount = invoiceIds.size();
        List<Map> list = null;
        Map resultMap = null;
        for (String settingID : setting2InvoiceMap.keySet()) {
            list = setting2InvoiceMap.get(settingID);
            for (int i = 0; i < list.size(); ++i) {
                resultMap = list.get(i);
                invoiceIds.add(resultMap.get("billId").toString());
            }
        }
        return invoiceIds;
    }

    protected int getInvoicePercent() {
        BigDecimal a = new BigDecimal(90);
        BigDecimal b = new BigDecimal(this.invoiceCount);
        BigDecimal c = BigDecimal.ZERO;
        if (this.invoiceCount > 0) {
            c = a.divide(b, 2, RoundingMode.HALF_UP);
        }
        int invoicePercent = 10 + c.multiply(new BigDecimal(this.invoiceCount - this.unInvoiceCount)).intValue();
        return invoicePercent;
    }

    protected void makeInvoice(Map msgMap) throws BOSException, EASBizException {
        for (String settingID : this.settingIds) {
            TaxCardInfo taxCardInfo = this.setting2TaxCardMap.get(settingID);
            if (taxCardInfo.isNeedSetVolumn()) {
                PwySettingInfo settingInfo = this.settingMap.get(settingID);
                TaxCardVolumnInfo taxCardVolumnInfo = taxCardInfo.getSelectedTaxCardVolumnInfo();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("taxCardVolumnInfo", taxCardVolumnInfo);
                params.put("pwyId", settingID);
                PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_PAPER_SETVOLUMN, TransSrcSystemEnum.easgui, settingInfo.getCompany().getId().toString(), null, params);
                PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getRemoteInstance().invoke(actionParam);
                MakeInvoicePwyService pwyService = (MakeInvoicePwyService)PwyServiceHelper.getPwyService(null, invokeParam);
                pwyService.invoke();
                if (!pwyService.isSuccess()) {
                    String setVolumnFailure = IMUtils.getString("com.kingdee.eas.tm.im.MakeVolumnInvoiceResource", "MSG_SETVOLUMN_FAILURE", IMUtils.getLocale(), new Object[]{taxCardInfo.getJsph(), taxCardInfo.getJspjh()}) + ":" + this.errorMsg.add(pwyService.getInvokeParam().getDescription() + "\r\n");
                    List<Map> invoiceList = this.setting2InvoiceMap.get(settingID);
                    this.errorCount += invoiceList.size();
                    this.setting2InvoiceMap.remove(settingID);
                    this.unInvoiceCount -= invoiceList.size();
                    continue;
                }
                this.innerMakeInvoice(this.setting2InvoiceMap.get(settingID));
                continue;
            }
            this.innerMakeInvoice(this.setting2InvoiceMap.get(settingID));
        }
        this.dealMsg();
    }

    protected Map<String, PwySettingInfo> loadPwySetting(List settingIds) throws BOSException {
        HashMap<String, PwySettingInfo> settingMap = new HashMap<String, PwySettingInfo>();
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(settingIds), CompareType.INCLUDE));
        viewinfo.setFilter(filterinfo);
        viewinfo.setSelector(IMSelectorFactory.getPwySettingSelector());
        PwySettingCollection settingColl = PwySettingFactory.getRemoteInstance().getPwySettingCollection(viewinfo);
        PwySettingInfo pwySettingInfo = null;
        for (int i = 0; i < settingColl.size(); ++i) {
            pwySettingInfo = settingColl.get(i);
            settingMap.put(pwySettingInfo.getId().toString(), pwySettingInfo);
        }
        return settingMap;
    }

    protected void innerMakeInvoice(List<Map> invoiceList) throws EASBizException, BOSException {
        int size = invoiceList.size();
        for (int i = 0; i < size; ++i) {
            Map resultMap = invoiceList.get(i);
            if (resultMap.get("error") != null) {
                String id = resultMap.get("error").toString();
                if (id.equals("exception")) {
                    this.errorMsg.add((String)resultMap.get("exception"));
                } else {
                    this.errorMsg.add(resultMap.get("number") + ":" + resultMap.get(id) + "\r\n");
                }
                ++this.errorCount;
                --this.unInvoiceCount;
                continue;
            }
            String invoiceNum = (String)resultMap.get("number");
            PwyInvokeParam invokeParam = (PwyInvokeParam)resultMap.get("invokeParam");
            MakeInvoicePwyService pwyService = (MakeInvoicePwyService)PwyServiceHelper.getPwyService(null, invokeParam);
            pwyService.invoke();
            if (!pwyService.isSuccess()) {
                this.errorMsg.add(invoiceNum + ":" + pwyService.getInvokeParam().getDescription() + "\r\n");
                ++this.errorCount;
            }
            --this.unInvoiceCount;
        }
    }
}

