/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client.comp;

import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.WindowMessage;
import com.kingdee.eas.tm.im.client.comp.IProgressMonitor;
import com.kingdee.eas.tm.im.client.comp.IRunnableWithProgress;
import com.kingdee.eas.tm.im.client.comp.ProgressDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;

public class ProgressDialogHelper {
    private static Set<MonitorInfo> monitors = new HashSet<MonitorInfo>();

    public static ProgressDialog createProgressDialog(CoreUI owner, boolean model) {
        Window ance = null;
        if (owner != null) {
            ance = SwingUtilities.getWindowAncestor((Component)owner);
        }
        ProgressDialog dialog = new ProgressDialog();
        if (ance instanceof Dialog) {
            dialog = new ProgressDialog((Dialog)ance, model);
        } else if (ance instanceof Frame) {
            dialog = new ProgressDialog((Frame)ance, model);
        }
        dialog.owner = owner;
        return dialog;
    }

    public static void run(final IRunnableWithProgress runable, ProgressDialog dialog, final IProgressMonitor monitor, boolean canBackRun) {
        if (!canBackRun) {
            Thread runner = new Thread(new Runnable(){

                @Override
                public void run() {
                    runable.run(monitor);
                }
            });
            runner.start();
            dialog.show();
        } else if (dialog.isSpecialShow()) {
            ProgressDialogHelper.runBack4New(runable, dialog, monitor);
        } else {
            ProgressDialogHelper.runBack(runable, dialog, monitor);
        }
    }

    private static void runBack(final IRunnableWithProgress runable, final ProgressDialog dialog, final IProgressMonitor monitor) {
        final MonitorInfo info = new MonitorInfo(dialog.getWindowMsgTitle() + ": " + dialog.getUiTitle(), null, (Object)dialog, false);
        final SwingWorker worker = new SwingWorker(){
            private boolean stop = false;

            public Object construct() {
                while (dialog.isLoading) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return null;
            }

            public void finished() {
                if (!this.stop) {
                    new WindowMessage("250", "150", dialog.getWindowMsgTitle(), dialog.getUiTitle() + " " + dialog.getMsg(), info);
                    ThreadPool.destroyMonitor((MonitorInfo)info);
                    info.setTitle("\u3010" + dialog.getUiTitle() + "\u3011");
                    ThreadPool.addActionThread((MonitorInfo)info);
                }
            }

            public void finishedLater() {
                ThreadPool.destroyMonitor((MonitorInfo)info);
                if (dialog.isShowing()) {
                    dialog.dispose();
                }
                try {
                    ProgressDialogHelper.hideWindow(dialog, false);
                    dialog.owner.onShow();
                }
                catch (Exception e) {
                    dialog.owner.handUIException((Throwable)e);
                }
            }
        };
        SwingWorker dataWorker = new SwingWorker(){

            public Object construct() {
                dialog.isLoading = true;
                runable.run(monitor);
                dialog.isLoading = false;
                return null;
            }

            public void finished() {
                if (dialog.isShowing()) {
                    dialog.dispose();
                }
            }
        };
        dataWorker.start();
        SwingWorker processBarWorker = new SwingWorker(){

            public Object construct() {
                if (monitor instanceof ProgressDialog.ProgressMonitor && ((ProgressDialog.ProgressMonitor)monitor).isEnd()) {
                    return null;
                }
                if (ProgressDialogHelper.show(dialog)) {
                    ProgressDialogHelper.hideWindow(dialog, true);
                    info.setWorker(worker);
                    ThreadPool.addActionThread((MonitorInfo)info);
                }
                return null;
            }
        };
        processBarWorker.start();
    }

    public static boolean addMonitor(MonitorInfo m) {
        return monitors.add(m);
    }

    public static boolean removeMonitor(MonitorInfo m) {
        return monitors.remove(m);
    }

    public static void destroyMonitorFromThreadPool(MonitorInfo m) {
        ThreadPool.destroyMonitor((MonitorInfo)m);
    }

    public static void destroyAllMonitorFromThreadPool() {
        if (monitors.size() > 0) {
            Iterator<MonitorInfo> it = monitors.iterator();
            while (it.hasNext()) {
                ProgressDialogHelper.destroyMonitorFromThreadPool(it.next());
            }
            monitors.clear();
        }
    }

    private static void runBack4New(final IRunnableWithProgress runable, final ProgressDialog dialog, final IProgressMonitor monitor) {
        final MonitorInfo info = new MonitorInfo(dialog.getWindowMsgTitle() + ": " + dialog.getUiTitle(), null, (Object)dialog, false);
        final SwingWorker worker = new SwingWorker(){
            private boolean stop = false;

            public Object construct() {
                while (dialog.isLoading) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return null;
            }

            public void finished() {
                if (!this.stop) {
                    new WindowMessage("250", "150", dialog.getWindowMsgTitle(), dialog.getUiTitle() + " " + dialog.getMsg(), info);
                    ThreadPool.destroyMonitor((MonitorInfo)info);
                    info.setTitle("\u3010" + dialog.getUiTitle() + "\u3011");
                    ThreadPool.addActionThread((MonitorInfo)info);
                }
            }

            public void finishedLater() {
                ProgressDialogHelper.removeMonitor(info);
                ThreadPool.destroyMonitor((MonitorInfo)info);
                if (dialog.isShowing()) {
                    dialog.dispose();
                }
                try {
                    dialog.showParentWindow();
                }
                catch (Exception e) {
                    dialog.owner.handUIException((Throwable)e);
                }
            }
        };
        SwingWorker processBarWorker = new SwingWorker(){

            public Object construct() {
                if (ProgressDialogHelper.show(dialog)) {
                    System.out.println("========processBarWorker runback and add to ThreadPool========");
                    dialog.hideParentWindow();
                    info.setWorker(worker);
                    ThreadPool.addActionThread((MonitorInfo)info);
                    ProgressDialogHelper.addMonitor(info);
                }
                return null;
            }
        };
        processBarWorker.start();
        SwingWorker dataWorker = new SwingWorker(){

            public Object construct() {
                dialog.isLoading = true;
                System.out.println("==============data worker isLoading============");
                runable.run(monitor);
                System.out.println("==============data worker isLoaded============");
                dialog.isLoading = false;
                return null;
            }

            public void finished() {
                if (dialog.isShowing()) {
                    dialog.dispose();
                    System.out.println("==============data worker dispose dialog============");
                }
            }
        };
        dataWorker.start();
    }

    private static boolean show(ProgressDialog dialog) {
        if (dialog != null) {
            dialog.show();
            return dialog.goBackRunning();
        }
        return false;
    }

    private static void hideWindow(ProgressDialog dialog, boolean hide) {
        if (hide) {
            dialog.owner.getUIWindow().hide();
        } else {
            dialog.owner.getUIWindow().show();
            dialog.owner.requestFocus();
        }
    }

    public static void setToScreenCenter(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = window.getSize();
        if (windowSize.height > screenSize.height) {
            windowSize.height = screenSize.height;
        }
        if (windowSize.width > screenSize.width) {
            windowSize.width = screenSize.width;
        }
        window.setLocation((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2);
    }

    public static String formatTime(long time) {
        StringBuffer sb = new StringBuffer();
        sb.append(ProgressDialogHelper.formatNumber((time /= 1000L) / 60L / 60L % 60L)).append(':').append(ProgressDialogHelper.formatNumber(time / 60L % 60L)).append(':').append(ProgressDialogHelper.formatNumber(time % 60L));
        return sb.toString();
    }

    private static String formatNumber(long t) {
        return t > 9L ? "" + t : "0" + t;
    }
}

