/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.uiframe.client.NewWinMainUI;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.eip.sso.SSOHandleFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.tm.common.help.msgHelp.client.TMMsgBox;
import com.kingdee.eas.tm.common.utils.LogCheckUtil;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.client.SelectCombinRuleSchemeUI;
import com.kingdee.eas.tm.im.client.comp.IProgressMonitor;
import com.kingdee.eas.tm.im.client.comp.IRunnableWithProgress;
import com.kingdee.eas.tm.im.client.comp.ProgressDialog;
import com.kingdee.eas.tm.im.client.comp.ProgressDialogHelper;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceCollection;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceFactory;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.util.AbstractHidedMenuItem;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class IMClientUtils {
    private static final Logger logger = CoreUIObject.getLogger(IMClientUtils.class);

    public static void addDataUpgradeListUI(CoreUIObject uiObject, KDMenu menu, String subsystem) {
        try {
            IMClientUtils.addHiddenMenu(uiObject, menu, null);
            IMClientUtils.autoDetectDataUpgrade(uiObject, subsystem);
        }
        catch (Exception e) {
            logger.error((Object)("addDataUpgradeListUI occur exception,e=" + e.getMessage()), (Throwable)e);
            MsgBox.showDetailAndOK((Component)uiObject, (String)EASResource.getString((String)"com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", (String)"OccurException"), (String)e.getMessage(), (int)1);
        }
    }

    public static void addHiddenMenu(final CoreUIObject uiObject, KDMenu menu, final String id) throws EASBizException, BOSException {
        menu.add((JMenuItem)((Object)new AbstractHidedMenuItem("ctrl shift alt L"){

            @Override
            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
                    UIContext uiContext = new UIContext((Object)uiObject);
                    uiContext.put((Object)"id", (Object)id);
                    IUIWindow wnd = fy.create("com.kingdee.eas.tm.im.upgrade.client.DataUpgradeTraceListUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    logger.error((Object)("addHiddenMenu occur exception,e=" + e.getMessage()), (Throwable)e);
                }
            }
        }));
    }

    public static void autoDetectDataUpgrade(final CoreUIObject uiObject, String subsystem) throws EASBizException, BOSException {
        DataUpgradeTraceCollection colls = DataUpgradeTraceFactory.getRemoteInstance().checkNeedDataUpgrade(subsystem);
        if (colls.size() > 0) {
            final ArrayList<String> ids = new ArrayList<String>();
            StringBuffer opr = new StringBuffer();
            for (int i = 0; i < colls.size(); ++i) {
                DataUpgradeTraceInfo info = colls.get(i);
                ids.add(info.getId().toString());
                if (opr.length() > 0) {
                    opr.append(";");
                }
                opr.append(info.getOperation());
            }
            if (MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"Msg_upgradeConfirm", (Object[])new Object[]{opr.toString()})))) {
                Map result;
                try {
                    result = DataUpgradeTraceFactory.getRemoteInstance().checkUseDefaultFilter(ids);
                    if (result != null && result.get("defultFilterMsg") != null && !MsgBox.isYes((int)MsgBox.showConfirm3a((Component)uiObject, (String)EASResource.getString((String)"com.kingdee.eas.tm.im.IMCommonResource", (String)"Msg_dataUpgrade_defultFilter"), (String)result.get("defultFilterMsg").toString()))) {
                        return;
                    }
                }
                catch (Exception e) {
                    uiObject.handUIException((Throwable)e);
                }
                if (uiObject instanceof CoreUI) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IMClientUtils.doDataUpgradeInProgress((CoreUI)uiObject, ids, false);
                        }
                    });
                } else {
                    result = DataUpgradeTraceFactory.getRemoteInstance().executeUpgrade(ids);
                    IMClientUtils.buildDataUpgradeMessage(uiObject, result);
                }
            } else {
                return;
            }
        }
    }

    public static void doDataUpgradeInProgress(final CoreUI owner, final List ids, boolean needCheckDefultFilter) {
        try {
            Map result;
            if (needCheckDefultFilter && (result = DataUpgradeTraceFactory.getRemoteInstance().checkUseDefaultFilter(ids)) != null && result.get("defultFilterMsg") != null && !MsgBox.isYes((int)MsgBox.showConfirm3a((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.tm.im.IMCommonResource", (String)"Msg_dataUpgrade_defultFilter"), (String)result.get("defultFilterMsg").toString()))) {
                return;
            }
        }
        catch (Exception e) {
            owner.handUIException((Throwable)e);
        }
        ProgressDialog progressDialog = ProgressDialogHelper.createProgressDialog(owner, true);
        progressDialog.run(false, true, new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(IProgressMonitor monitor) {
                block14: {
                    Map result = null;
                    try {
                        monitor.beginTask(EASResource.getString((String)"com.kingdee.eas.tm.im.IMCommonResource", (String)"Msg_doDataUpgrade"), -1);
                        result = DataUpgradeTraceFactory.getRemoteInstance().executeUpgrade(ids);
                        monitor.done();
                        if (result == null) break block14;
                    }
                    catch (Exception e1) {
                        block15: {
                            try {
                                owner.handUIException((Throwable)e1);
                                monitor.done();
                                if (result == null) break block15;
                            }
                            catch (Throwable throwable) {
                                monitor.done();
                                if (result != null) {
                                    IMClientUtils.buildDataUpgradeMessage((CoreUIObject)owner, result);
                                }
                                if (owner instanceof ListUI) {
                                    try {
                                        ((ListUI)owner).refreshList();
                                    }
                                    catch (Exception e) {
                                        logger.error((Object)e.getMessage(), (Throwable)e);
                                    }
                                }
                                throw throwable;
                            }
                            IMClientUtils.buildDataUpgradeMessage((CoreUIObject)owner, result);
                        }
                        if (owner instanceof ListUI) {
                            try {
                                ((ListUI)owner).refreshList();
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    IMClientUtils.buildDataUpgradeMessage((CoreUIObject)owner, result);
                }
                if (owner instanceof ListUI) {
                    try {
                        ((ListUI)owner).refreshList();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
    }

    private static void buildDataUpgradeMessage(CoreUIObject uiObject, Map result) {
        int doneCount = (Integer)result.get("doneCount");
        ArrayList errList = (ArrayList)result.get("errList");
        boolean hasTip = false;
        if (errList != null && errList.size() > 0) {
            String errorLine = null;
            String defineConfigError = IMUtils.getString("com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", "DefineConfig_NOT_NULLl", IMUtils.getLocale());
            int size = errList.size();
            for (int i = 0; i < size; ++i) {
                errorLine = (String)errList.get(i);
                if (StringUtils.isEmpty((String)errorLine) || !errorLine.contains(defineConfigError)) continue;
                hasTip = true;
                errList.add("------------------------------------------------------------------------------------------------");
                errList.add(ResourceBase.getString((String)"com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", (String)"DefineConfigTip", (Locale)IMUtils.getLocale()));
                break;
            }
        }
        MsgBox.showDetailAndOK((Component)uiObject, (String)EASResource.getString((String)"com.kingdee.eas.tm.im.IMCommonResource", (String)"Msg_dataUpgradeMessage", (Object[])new Object[]{doneCount, errList.size() - (hasTip ? 2 : 0)}), (String)IMUtils.buildErrorMsg(errList), (int)1);
    }

    public static List<CoreBaseInfo> getCoreBaseListFromF7(Object value) {
        ArrayList<CoreBaseInfo> coreBaseInfoList;
        block6: {
            block5: {
                coreBaseInfoList = new ArrayList<CoreBaseInfo>();
                if (!(value instanceof CoreBaseInfo)) break block5;
                CoreBaseInfo info = (CoreBaseInfo)value;
                if (info == null) break block6;
                coreBaseInfoList.add(info);
                break block6;
            }
            if (value instanceof List) {
                List list = (List)value;
                CoreBaseInfo info2 = null;
                for (CoreBaseInfo info2 : list) {
                    if (info2 == null) continue;
                    coreBaseInfoList.add(info2);
                }
            } else if (value instanceof Object[]) {
                Object[] objs = (Object[])value;
                CoreBaseInfo info = null;
                for (int i = 0; i < objs.length; ++i) {
                    info = (CoreBaseInfo)objs[i];
                    if (info == null) continue;
                    coreBaseInfoList.add(info);
                }
            }
        }
        return coreBaseInfoList;
    }

    public static void initCompanyTreeF7(KDBizPromptBox prmtCompany, IUIObject uiObject, String viewPermissionName) throws EASBizException, BOSException {
        int f7DisplayMode = IMClientUtils.getF7DisplayMode(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        if (f7DisplayMode == 0) {
            NewCompanyF7 newCompanyF7 = new NewCompanyF7(uiObject);
            newCompanyF7.setShowAssistantOrg(false);
            newCompanyF7.setIsCUFilter(false);
            newCompanyF7.setShowVirtual(true);
            newCompanyF7.setContainSealUp(false);
            newCompanyF7.setNeedAddAssistant(true);
            newCompanyF7.setMultiSelect(true);
            FilterInfo filter = new FilterInfo();
            String companyFilterSql = "select FID from T_ORG_Company where FIsBizUnit = 1 and FIsCompanyOrgUnit = 1";
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)companyFilterSql, CompareType.INNER));
            newCompanyF7.setOuterFilterInfo(filter);
            newCompanyF7.setPermissionItem(viewPermissionName);
            prmtCompany.setSelector((KDPromptSelector)newCompanyF7);
            prmtCompany.setHistoryRecordEnabled(false);
        } else {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            HashSet<String> idset = new HashSet<String>();
            idset.add("111111111111111111111111111=");
            OrgUnitCollection authorizedMainOrgs = IMFacadeFactory.getRemoteInstance().getAuthOrgsByType(OrgType.Company, viewPermissionName);
            FilterInfo filter = new FilterInfo();
            if (authorizedMainOrgs != null && authorizedMainOrgs.size() > 0) {
                for (int i = 0; i < authorizedMainOrgs.size(); ++i) {
                    OrgUnitInfo orgInfo = authorizedMainOrgs.get(i);
                    if (orgInfo == null || !orgInfo.isIsCompanyOrgUnit() || !orgInfo.getBoolean("isBizUnit")) continue;
                    idset.add(orgInfo.getId().toString());
                }
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
            ev.setFilter(filterInfo);
            prmtCompany.setEntityViewInfo(ev);
        }
    }

    public static int getF7DisplayMode(String cuId) throws BOSException, EASBizException {
        try {
            IParamControl ipc = ParamControlFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(cuId);
            return Integer.valueOf(ipc.getParamValue((IObjectPK)pk, "TM001"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static CommonQueryDialog showCombinRuleSchemeDialog(CoreUI ui, String classPath, String srcBosType, String destBosType, boolean iscache) {
        CommonQueryDialog downloadQueryDialog = new CommonQueryDialog();
        downloadQueryDialog.clearUserPanels();
        try {
            downloadQueryDialog.addUserPanel((KDPanel)new SelectCombinRuleSchemeUI(srcBosType, destBosType, iscache));
        }
        catch (Exception e) {
            logger.error((Object)("\u663e\u793a\u5408\u5e76\u89c4\u5219\u5bf9\u8bdd\u6846\u5bf9\u8c61\u4e0d\u5b58\u5728\uff1a" + e.getMessage()), (Throwable)e);
        }
        downloadQueryDialog.setOwner((Component)ui);
        downloadQueryDialog.setParentUIClassName(classPath);
        downloadQueryDialog.setShowFilter(true);
        downloadQueryDialog.setShowSorter(true);
        String title = EASResource.getString((String)"com.kingdee.eas.tm.im.IMCommonResource", (String)"ComBinRule");
        downloadQueryDialog.setTitle(title);
        downloadQueryDialog.setWidth(480);
        downloadQueryDialog.setHeight(220);
        MetaDataPK metaPk = new MetaDataPK("com.kingdee.eas.framework.report.app", "CommRptEmptyQuery");
        downloadQueryDialog.setQueryObjectPK((IMetaDataPK)metaPk);
        downloadQueryDialog.setShowFilter(false);
        downloadQueryDialog.setShowSorter(false);
        downloadQueryDialog.setShowDefaultSolution(false);
        downloadQueryDialog.setDisShowRowCount(true);
        downloadQueryDialog.setShowButton(false);
        downloadQueryDialog.show();
        return downloadQueryDialog;
    }

    public static void setSpinnerMaxMin(JSpinner spinner, int min, int max) {
        int month;
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            if (max >= min) {
                ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            }
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
        if ((month = ((Integer)spinner.getValue()).intValue()) > max) {
            spinner.setValue(new Integer(max));
        }
        if (month < min) {
            spinner.setValue(new Integer(min));
        }
    }

    public static void jumpWeb(String toUrl) throws BOSException, UnsupportedEncodingException {
        String serverURL = System.getProperty("EASPORTAL_ROOT");
        logger.error((Object)("IMClientUtils jumpWeb  serverURL:" + (serverURL == null ? "" : LogCheckUtil.validLog((String)serverURL))));
        if (StringUtils.isEmpty((String)serverURL)) {
            serverURL = "http://localhost:6888/portal";
        }
        serverURL = serverURL.replace("easportal", "portal");
        String url = SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(URLEncoder.encode(toUrl, "utf-8"), true, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
        url = serverURL + "/" + url;
        url = url.replace("ssoWelcome", "portal/index2sso.jsp");
        logger.error((Object)("IMClientUtils jumpWeb:" + LogCheckUtil.validLog((String)url)));
        NewWinMainUI.gotoSite((String)url);
    }

    private static String replaceAllStr(String strSource, String strFrom, String strTo) {
        int intPos;
        if (strFrom == null || strFrom.equals("")) {
            return strSource;
        }
        String strDest = "";
        int intFromLen = strFrom.length();
        while ((intPos = strSource.indexOf(strFrom)) != -1) {
            strDest = strDest + strSource.substring(0, intPos);
            strDest = strDest + strTo;
            strSource = strSource.substring(intPos + intFromLen);
        }
        strDest = strDest + strSource;
        return strDest;
    }

    public static void showMsgAfterCurrentThread(final Component ownerUI, final String msg, final String respErrorMsg, final int msgType) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MsgBox.showDetailAndOK((Component)ownerUI, (String)msg, (String)respErrorMsg, (int)msgType);
            }
        });
    }

    public static void showInfoAfterCurrentThread(final Component ownerUI, final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MsgBox.showInfo((Component)ownerUI, (String)msg);
            }
        });
    }

    public static void refreshListAfterCurrentThread(final ListUI listUI) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    listUI.refreshList();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public static void showMsgAfterCurrentThread(final Component ownerUI, final String msg, final String respErrorMsg, final int msgType, final Map<String, String> msgUrl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TMMsgBox.showDetailAndOK((Component)ownerUI, (String)msg, (String)respErrorMsg, (int)msgType, (Map)msgUrl);
            }
        });
    }
}

